/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/squareup/wire/internal/FloatArrayList;", "", "initialCapacity", "", "<init>", "(I)V", "data", "", "size", "toArray", "add", "", "float", "", "isNotEmpty", "", "ensureCapacity", "minCapacity", "toString", "", "Companion", "wire-runtime"})
public final class FloatArrayList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private float[] data;
    private int size;

    public FloatArrayList(int initialCapacity) {
        this.data = new float[initialCapacity];
    }

    @NotNull
    public final float[] toArray() {
        if (this.size < this.data.length) {
            float[] fArray = Arrays.copyOf(this.data, this.size);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
            this.data = fArray;
        }
        return this.data;
    }

    public final void add(float f) {
        this.ensureCapacity(this.size + 1);
        int n = this.size;
        this.size = n + 1;
        this.data[n] = f;
    }

    public final boolean isNotEmpty() {
        return this.size > 0;
    }

    private final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.data.length) {
            float[] fArray = Arrays.copyOf(this.data, Math.max(this.data.length * 3 / 2 + 1, minCapacity));
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
            this.data = fArray;
        }
    }

    @NotNull
    public String toString() {
        float[] fArray = Arrays.copyOf(this.data, this.size);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        String string = Arrays.toString(fArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/squareup/wire/internal/FloatArrayList$Companion;", "", "<init>", "()V", "forDecoding", "Lcom/squareup/wire/internal/FloatArrayList;", "minLengthInBytes", "", "minimumElementByteSize", "", "wire-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FloatArrayList forDecoding(long minLengthInBytes, long minimumElementByteSize) {
            int minElements = (int)RangesKt.coerceAtMost((long)(minLengthInBytes / minimumElementByteSize), (long)Integer.MAX_VALUE);
            return new FloatArrayList(minElements);
        }

        @NotNull
        public final FloatArrayList forDecoding(int minLengthInBytes, int minimumElementByteSize) {
            int minElements = minLengthInBytes / minimumElementByteSize;
            return new FloatArrayList(minElements);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

