/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.loader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.ksql.test.TestFrameworkException;
import io.confluent.ksql.test.loader.TestFile;
import io.confluent.ksql.test.model.TestFileContext;
import io.confluent.ksql.test.tools.TestJsonMapper;
import io.confluent.ksql.tools.test.TestLoader;
import io.confluent.ksql.tools.test.model.Test;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JsonTestLoader<T extends Test>
implements TestLoader<T> {
    public static final ObjectMapper OBJECT_MAPPER = TestJsonMapper.INSTANCE.get();
    private final Path testDir;
    private final Class<? extends TestFile<T>> testFileType;

    public static <T extends Test> JsonTestLoader<T> of(Path testDir, Class<? extends TestFile<T>> testFileType) {
        return new JsonTestLoader<T>(testDir, testFileType);
    }

    private JsonTestLoader(Path testDir, Class<? extends TestFile<T>> testFileType) {
        this.testDir = Objects.requireNonNull(testDir, "testDir");
        this.testFileType = Objects.requireNonNull(testFileType, "testFileType");
    }

    public Stream<T> load() {
        List whiteList = TestLoader.getWhiteList();
        List<Path> testPaths = whiteList.isEmpty() ? this.loadTestPathsFromDirectory() : this.getTestPathsFromWhiteList(whiteList);
        String testRegex = System.getProperty("ksql.functional.test.regex");
        List testCases = testPaths.stream().flatMap(testPath -> JsonTestLoader.buildTests(testPath, this.testFileType)).filter(testCase -> testRegex == null || testCase.getName().matches(testRegex)).collect(Collectors.toList());
        JsonTestLoader.throwOnDuplicateNames(testCases);
        return testCases.stream();
    }

    private List<Path> getTestPathsFromWhiteList(List<String> whiteList) {
        return whiteList.stream().map(name -> this.testDir.resolve(name.trim())).collect(Collectors.toList());
    }

    private List<Path> loadTestPathsFromDirectory() {
        ArrayList<Path> arrayList;
        InputStream s = JsonTestLoader.class.getClassLoader().getResourceAsStream(this.testDir.toString());
        if (s == null) {
            throw new TestFrameworkException("Test directory not found: " + String.valueOf(this.testDir));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(s, StandardCharsets.UTF_8));
        try {
            String test;
            ArrayList<Path> tests = new ArrayList<Path>();
            while ((test = reader.readLine()) != null) {
                if (!test.endsWith(".json")) continue;
                tests.add(this.testDir.resolve(test));
            }
            arrayList = tests;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TestFrameworkException("Failed to read test dir: " + String.valueOf(this.testDir), e);
            }
        }
        reader.close();
        return arrayList;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <TFT extends TestFile<T>, T extends Test> Stream<T> buildTests(Path testPath, Class<TFT> testFileType) {
        try (InputStream stream = JsonTestLoader.class.getClassLoader().getResourceAsStream(testPath.toString());){
            Stream stream2;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(JsonTestLoader.throwNotFoundIfNull(stream, testPath), StandardCharsets.UTF_8));){
                List<String> lines = reader.lines().collect(Collectors.toList());
                String content = lines.stream().collect(Collectors.joining(System.lineSeparator()));
                TestFile testFile = (TestFile)OBJECT_MAPPER.readValue(content, testFileType);
                stream2 = testFile.buildTests(new TestFileContext(testPath, lines));
            }
            return stream2;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load test at path " + String.valueOf(testPath), e);
        }
    }

    private static InputStream throwNotFoundIfNull(InputStream stream, Path testPath) {
        if (stream == null) {
            throw new TestFrameworkException("File not found: " + String.valueOf(testPath));
        }
        return stream;
    }

    private static void throwOnDuplicateNames(List<? extends Test> testCases) {
        String duplicates = testCases.stream().collect(Collectors.groupingBy(Test::getName)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> "test name: '" + (String)e.getKey() + "' found in file: " + ((Test)((List)e.getValue()).get(0)).getTestLocation().toString()).collect(Collectors.joining(System.lineSeparator()));
        if (!duplicates.isEmpty()) {
            throw new IllegalStateException("There are tests with duplicate names: " + System.lineSeparator() + duplicates);
        }
    }
}

