/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.test.tools.exceptions.InvalidFieldException;
import io.confluent.ksql.test.tools.exceptions.KsqlExpectedException;
import io.confluent.ksql.test.tools.exceptions.MissingFieldException;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class ExpectedExceptionNode {
    private final Optional<String> type;
    private final Optional<String> message;
    private final Optional<String> cause;
    private final Optional<String> causeMessage;

    ExpectedExceptionNode(@JsonProperty(value="type") String type, @JsonProperty(value="message") String message, @JsonProperty(value="cause") String cause, @JsonProperty(value="causeMessage") String causeMessage) {
        this.type = Optional.ofNullable(type);
        this.message = Optional.ofNullable(message);
        this.cause = Optional.ofNullable(cause);
        this.causeMessage = Optional.ofNullable(causeMessage);
        if (!this.type.isPresent() && !this.message.isPresent()) {
            throw new MissingFieldException("expectedException.type or expectedException.message");
        }
        if (this.causeMessage.isPresent() && !this.cause.isPresent()) {
            throw new MissingFieldException("expectedException.cause");
        }
    }

    public Matcher<Throwable> build() {
        KsqlExpectedException expectedException = KsqlExpectedException.none();
        this.type.map(ExpectedExceptionNode::parseThrowable).ifPresent(expectedException::expect);
        this.message.ifPresent(expectedException::expectMessage);
        this.cause.ifPresent(c -> expectedException.expectCause((Matcher<Throwable>)Matchers.instanceOf(ExpectedExceptionNode.parseThrowable(c))));
        this.causeMessage.ifPresent(expectedException::expectCauseMessage);
        return expectedException.build();
    }

    private static Class<? extends Throwable> parseThrowable(String className) {
        try {
            Class<?> theClass = Class.forName(className);
            if (!Throwable.class.isAssignableFrom(theClass)) {
                throw new InvalidFieldException("expectedException.type", "Type was not a Throwable");
            }
            return theClass;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidFieldException("expectedException.type", "Type was not found", e);
        }
    }
}

