/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.test.model.SourceNode;
import io.confluent.ksql.test.tools.TestJsonMapper;
import io.confluent.ksql.test.tools.conditions.PostConditions;
import io.confluent.ksql.test.tools.exceptions.InvalidFieldException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class PostConditionsNode {
    private final List<SourceNode> sources;
    private final Optional<PostTopicsNode> topics;

    public PostConditionsNode(@JsonProperty(value="sources") List<SourceNode> sources, @JsonProperty(value="topics") Optional<PostTopicsNode> topics) {
        this.sources = sources == null ? ImmutableList.of() : ImmutableList.copyOf(sources);
        this.topics = Objects.requireNonNull(topics, "topics");
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="sources is ImmutableList")
    public List<SourceNode> getSources() {
        return this.sources;
    }

    public Optional<PostTopicsNode> getTopics() {
        return this.topics;
    }

    public PostConditions build() {
        Matcher[] matchers = (Matcher[])this.sources.stream().map(SourceNode::build).toArray(Matcher[]::new);
        Matcher sourcesMatcher = Matchers.hasItems((Matcher[])matchers);
        PostTopicsNode topicsNode = this.topics.orElseGet(PostTopicsNode::new);
        Pattern blackListPattern = topicsNode.buildBlackList();
        Matcher<Iterable<PostTopicNode>> topicsMatcher = topicsNode.buildTopics();
        return new PostConditions((Matcher<Iterable<DataSource>>)sourcesMatcher, topicsMatcher, blackListPattern, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostConditionsNode that = (PostConditionsNode)o;
        return this.sources.equals(that.sources) && this.topics.equals(that.topics);
    }

    public int hashCode() {
        return Objects.hash(this.sources, this.topics);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class PostTopicsNode {
        private final Optional<String> blackList;
        private final ImmutableList<PostTopicNode> topics;

        public PostTopicsNode() {
            this(Optional.empty(), Optional.empty());
        }

        public PostTopicsNode(@JsonProperty(value="blacklist") Optional<String> blackList, @JsonProperty(value="topics") Optional<List<PostTopicNode>> topics) {
            this.blackList = Objects.requireNonNull(blackList, "blackList");
            this.topics = topics.isPresent() ? ImmutableList.copyOf((Collection)topics.get()) : ImmutableList.of();
            this.buildBlackList();
        }

        public Optional<String> getBlackList() {
            return this.blackList;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="topics is ImmutableList")
        public List<PostTopicNode> getTopics() {
            return this.topics;
        }

        Pattern buildBlackList() {
            try {
                return Pattern.compile(this.blackList.orElse("(?!)"));
            }
            catch (Exception e) {
                throw new InvalidFieldException("blacklist", "not valid regex", e);
            }
        }

        Matcher<Iterable<PostTopicNode>> buildTopics() {
            Matcher[] matchers = (Matcher[])this.topics.stream().map(PostTopicNode::build).toArray(Matcher[]::new);
            return Matchers.hasItems((Matcher[])matchers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PostTopicsNode that = (PostTopicsNode)o;
            return this.blackList.equals(that.blackList) && this.topics.equals(that.topics);
        }

        public int hashCode() {
            return Objects.hash(this.blackList, this.topics);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class PostTopicNode {
        private final String name;
        private final KeyFormat keyFormat;
        private final ValueFormat valueFormat;
        private final OptionalInt partitions;
        final Optional<Integer> keySchemaId;
        final Optional<Integer> valueSchemaId;
        private final JsonNode keySchema;
        private final JsonNode valueSchema;

        public PostTopicNode(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="keyFormat", required=true) KeyFormat keyFormat, @JsonProperty(value="valueFormat", required=true) ValueFormat valueFormat, @JsonProperty(value="partitions") OptionalInt partitions, @JsonProperty(value="keySchemaId") Optional<Integer> keySchemaId, @JsonProperty(value="valueSchemaId") Optional<Integer> valueSchemaId, @JsonProperty(value="keySchema") JsonNode keySchema, @JsonProperty(value="valueSchema") JsonNode valueSchema) {
            this.name = Objects.requireNonNull(name, "name");
            this.keyFormat = Objects.requireNonNull(keyFormat, "KeyFormat");
            this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
            this.partitions = Objects.requireNonNull(partitions, "partitions");
            this.keySchemaId = Objects.requireNonNull(keySchemaId, "keySchemaId");
            this.valueSchemaId = Objects.requireNonNull(valueSchemaId, "valueSchemaId");
            this.keySchema = keySchema;
            this.valueSchema = valueSchema;
            if (this.name.isEmpty()) {
                throw new InvalidFieldException("name", "empty or missing");
            }
            if (partitions.isPresent() && partitions.getAsInt() < 1) {
                throw new IllegalArgumentException("Partition count must be positive, but was: " + String.valueOf(partitions));
            }
        }

        public Matcher<PostTopicNode> build() {
            return new BaseMatcher<PostTopicNode>(){

                public void describeTo(Description description) {
                    try {
                        description.appendText(TestJsonMapper.INSTANCE.get().writeValueAsString((Object)this));
                    }
                    catch (JsonProcessingException e) {
                        throw new IllegalArgumentException(e);
                    }
                }

                public boolean matches(Object item) {
                    if (!(item instanceof PostTopicNode)) {
                        return false;
                    }
                    PostTopicNode that = (PostTopicNode)item;
                    return !(!Objects.equals(name, that.name) || !Objects.equals(keyFormat, that.keyFormat) || !Objects.equals(valueFormat, that.valueFormat) || partitions.isPresent() && !partitions.equals(that.partitions) || !Objects.equals(keySchemaId, that.keySchemaId) || !Objects.equals(valueSchemaId, that.valueSchemaId) || keySchema != null && !(keySchema instanceof NullNode) && !keySchema.equals((Object)that.keySchema) || valueSchema != null && !(valueSchema instanceof NullNode) && !valueSchema.equals((Object)that.valueSchema));
                }
            };
        }

        public String getName() {
            return this.name;
        }

        public KeyFormat getKeyFormat() {
            return this.keyFormat;
        }

        public ValueFormat getValueFormat() {
            return this.valueFormat;
        }

        public OptionalInt getPartitions() {
            return this.partitions;
        }

        public Optional<Integer> getKeySchemaId() {
            return this.keySchemaId;
        }

        public Optional<Integer> getValueSchemaId() {
            return this.valueSchemaId;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public JsonNode getKeySchema() {
            return this.keySchema instanceof NullNode ? null : this.keySchema;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public JsonNode getValueSchema() {
            return this.valueSchema instanceof NullNode ? null : this.valueSchema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PostTopicNode that = (PostTopicNode)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.keyFormat, that.keyFormat) && Objects.equals(this.valueFormat, that.valueFormat) && Objects.equals(this.partitions, that.partitions) && Objects.equals(this.keySchemaId, that.keySchemaId) && Objects.equals(this.valueSchemaId, that.valueSchemaId) && Objects.equals(this.keySchema, that.keySchema) && Objects.equals(this.valueSchema, that.valueSchema);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.keyFormat, this.valueFormat, this.partitions, this.keySchemaId, this.valueSchemaId, this.keySchema, this.valueSchema);
        }

        public String toString() {
            try {
                return TestJsonMapper.INSTANCE.get().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

