/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.test.TestFrameworkException;
import io.confluent.ksql.test.model.ExpectedExceptionNode;
import io.confluent.ksql.test.model.PostConditionsNode;
import io.confluent.ksql.test.model.RecordNode;
import io.confluent.ksql.test.model.TopicNode;
import io.confluent.ksql.test.model.VersionBoundsNode;
import io.confluent.ksql.test.tools.exceptions.InvalidFieldException;
import io.confluent.ksql.test.tools.exceptions.MissingFieldException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TestCaseNode {
    private final String name;
    private final VersionBoundsNode versionBounds;
    private final List<String> formats;
    private final List<String> config;
    private final List<RecordNode> inputs;
    private final List<RecordNode> outputs;
    private final List<TopicNode> topics;
    private final List<String> statements;
    private final Map<String, Object> properties;
    private final Optional<ExpectedExceptionNode> expectedException;
    private final Optional<PostConditionsNode> postConditions;
    private final boolean enabled;

    public TestCaseNode(TestCaseNode testCaseNode, Map<String, Object> properties) {
        this.name = testCaseNode.name;
        this.versionBounds = testCaseNode.versionBounds;
        this.formats = testCaseNode.formats;
        this.config = testCaseNode.config;
        this.inputs = testCaseNode.inputs;
        this.outputs = testCaseNode.outputs;
        this.topics = testCaseNode.topics;
        this.statements = testCaseNode.statements;
        this.properties = TestCaseNode.immutableCopyOf(properties);
        this.expectedException = testCaseNode.expectedException;
        this.postConditions = testCaseNode.postConditions;
        this.enabled = testCaseNode.enabled;
    }

    public TestCaseNode(@JsonProperty(value="name") String name, @JsonProperty(value="versions") Optional<VersionBoundsNode> versionBounds, @JsonProperty(value="format") List<String> formats, @JsonProperty(value="config") List<String> config, @JsonProperty(value="inputs") List<RecordNode> inputs, @JsonProperty(value="outputs") List<RecordNode> outputs, @JsonProperty(value="topics") List<TopicNode> topics, @JsonProperty(value="statements") List<String> statements, @JsonProperty(value="properties") Map<String, Object> properties, @JsonProperty(value="expectedException") ExpectedExceptionNode expectedException, @JsonProperty(value="post") PostConditionsNode postConditions, @JsonProperty(value="enabled") Boolean enabled) {
        this.name = name == null ? "" : name;
        this.formats = TestCaseNode.immutableCopyOf(formats);
        this.config = TestCaseNode.immutableCopyOf(config);
        this.versionBounds = Objects.requireNonNull(versionBounds).orElse(VersionBoundsNode.allVersions());
        this.statements = TestCaseNode.immutableCopyOf(statements);
        this.inputs = TestCaseNode.immutableCopyOf(inputs);
        this.outputs = TestCaseNode.immutableCopyOf(outputs);
        this.topics = TestCaseNode.immutableCopyOf(topics);
        this.properties = TestCaseNode.immutableCopyOf(properties);
        this.expectedException = Optional.ofNullable(expectedException);
        this.postConditions = Optional.ofNullable(postConditions);
        this.enabled = !Boolean.FALSE.equals(enabled);
        this.validate();
    }

    @JsonIgnore
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public VersionBoundsNode versionBounds() {
        return this.versionBounds;
    }

    @JsonIgnore
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="formats is ImmutableList")
    public List<String> formats() {
        return this.formats;
    }

    @JsonIgnore
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="configs is ImmutableList")
    public List<String> config() {
        return this.config;
    }

    @JsonProperty(value="statements")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="statements is ImmutableList")
    public List<String> statements() {
        return this.statements;
    }

    @JsonIgnore
    public Optional<ExpectedExceptionNode> expectedException() {
        return this.expectedException;
    }

    @JsonProperty(value="topics")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="topics is ImmutableList")
    public List<TopicNode> topics() {
        return this.topics;
    }

    @JsonProperty(value="inputs")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="inputs is ImmutableList")
    public List<RecordNode> inputs() {
        return this.inputs;
    }

    @JsonProperty(value="outputs")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="outputs is ImmutableList")
    public List<RecordNode> outputs() {
        return this.outputs;
    }

    @JsonProperty(value="post")
    public Optional<PostConditionsNode> postConditions() {
        return this.postConditions;
    }

    @JsonProperty(value="properties")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="properties is ImmutableMap")
    public Map<String, Object> properties() {
        return this.properties;
    }

    private void validate() {
        if (this.name.isEmpty()) {
            throw new MissingFieldException("name");
        }
        try {
            if (this.statements.isEmpty()) {
                throw new InvalidFieldException("statements", "was empty");
            }
            if (!this.expectedException.isPresent() && this.inputs.isEmpty() && this.outputs.isEmpty()) {
                throw new InvalidFieldException("outputs", "no inputs, outputs or expectedException provided");
            }
        }
        catch (Exception e) {
            throw new TestFrameworkException("Invalid test case: '" + this.name + "'. cause: " + e.getMessage(), e);
        }
    }

    private static <T> ImmutableList<T> immutableCopyOf(List<T> source) {
        return source == null ? ImmutableList.of() : ImmutableList.copyOf(source);
    }

    private static <K, V> ImmutableMap<K, V> immutableCopyOf(Map<K, V> source) {
        return source == null ? ImmutableMap.of() : ImmutableMap.copyOf(source);
    }
}

