/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.header.Header;

@JsonSerialize(using=Serializer.class)
public class TestHeader
implements Header {
    private final String key;
    private final byte[] value;

    public TestHeader(@JsonProperty(value="KEY") String key, @JsonProperty(value="VALUE") byte[] value) {
        this.key = Objects.requireNonNull(key, "key");
        this.value = value == null ? null : Arrays.copyOf(value, value.length);
    }

    public String key() {
        return this.key;
    }

    public byte[] value() {
        return this.value == null ? null : Arrays.copyOf(this.value, this.value.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestHeader that = (TestHeader)o;
        return this.key.equals(that.key) && Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public static class Serializer
    extends JsonSerializer<TestHeader> {
        public void serialize(TestHeader record, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("KEY", (Object)record.key);
            if (record.value == null) {
                jsonGenerator.writeNullField("VALUE");
            } else {
                jsonGenerator.writeBinaryField("VALUE", record.value);
            }
            jsonGenerator.writeEndObject();
        }
    }
}

