/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model.matchers;

import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import java.time.Duration;
import java.util.Optional;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

public final class FormatMatchers {
    private FormatMatchers() {
    }

    public static final class KeyFormatMatchers {
        private KeyFormatMatchers() {
        }

        public static Matcher<KeyFormat> hasFormat(Matcher<Format> matcher) {
            return new FeatureMatcher<KeyFormat, Format>(matcher, "key format of", "key format"){

                protected Format featureValueOf(KeyFormat actual) {
                    return FormatFactory.of((FormatInfo)actual.getFormatInfo());
                }
            };
        }

        public static Matcher<KeyFormat> hasWindowType(Matcher<Optional<WindowType>> matcher) {
            return new FeatureMatcher<KeyFormat, Optional<WindowType>>(matcher, "key window type", "window type"){

                protected Optional<WindowType> featureValueOf(KeyFormat actual) {
                    return actual.getWindowType();
                }
            };
        }

        public static Matcher<KeyFormat> hasWindowSize(Matcher<Optional<Duration>> matcher) {
            return new FeatureMatcher<KeyFormat, Optional<Duration>>(matcher, "key window size", "window size"){

                protected Optional<Duration> featureValueOf(KeyFormat actual) {
                    return actual.getWindowSize();
                }
            };
        }
    }
}

