/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.serde;

import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.test.TestFrameworkException;
import io.confluent.ksql.util.BytesUtils;
import io.confluent.ksql.util.DecimalUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;

public final class SpecToConnectConverter {
    private SpecToConnectConverter() {
    }

    public static Object specToConnect(Object spec, Schema schema) {
        if (spec == null) {
            return null;
        }
        switch (schema.type()) {
            case INT32: {
                Integer intVal = Integer.valueOf(spec.toString());
                if ("org.apache.kafka.connect.data.Time".equals(schema.name())) {
                    return new java.sql.Time(intVal.intValue());
                }
                if ("org.apache.kafka.connect.data.Date".equals(schema.name())) {
                    return SerdeUtils.getDateFromEpochDays((long)intVal.intValue());
                }
                return intVal;
            }
            case INT64: {
                Long longVal = Long.valueOf(spec.toString());
                if ("org.apache.kafka.connect.data.Timestamp".equals(schema.name())) {
                    return new Timestamp(longVal);
                }
                return longVal;
            }
            case FLOAT32: {
                return Float.valueOf(spec.toString());
            }
            case FLOAT64: {
                return Double.valueOf(spec.toString());
            }
            case BOOLEAN: {
                return Boolean.valueOf(spec.toString());
            }
            case STRING: {
                return spec.toString();
            }
            case ARRAY: {
                return ((List)spec).stream().map(el -> SpecToConnectConverter.specToConnect(el, schema.valueSchema())).collect(Collectors.toList());
            }
            case MAP: {
                return ((Map)spec).entrySet().stream().collect(HashMap::new, (map, v) -> map.put(SpecToConnectConverter.specToConnect(v.getKey(), schema.keySchema()), SpecToConnectConverter.specToConnect(v.getValue(), schema.valueSchema())), HashMap::putAll);
            }
            case STRUCT: {
                Map<String, String> caseInsensitiveFieldMap = schema.fields().stream().collect(Collectors.toMap(f -> f.name().toUpperCase(), Field::name));
                Struct struct = new Struct(schema);
                ((Map)spec).forEach((key, value) -> {
                    String realKey = (String)caseInsensitiveFieldMap.get(key.toString().toUpperCase());
                    if (realKey != null) {
                        struct.put(realKey, SpecToConnectConverter.specToConnect(value, schema.field(realKey).schema()));
                    }
                });
                return struct;
            }
            case BYTES: {
                if (DecimalUtil.isDecimal((Schema)schema)) {
                    if (spec instanceof BigDecimal) {
                        return DecimalUtil.ensureFit((BigDecimal)((BigDecimal)spec), (Schema)schema);
                    }
                    if (spec instanceof String) {
                        return DecimalUtil.cast((String)((String)spec), (int)DecimalUtil.precision((Schema)schema), (int)DecimalUtil.scale((Schema)schema));
                    }
                    throw new TestFrameworkException("DECIMAL type requires JSON number in test data");
                }
                if (spec instanceof String) {
                    return BytesUtils.decode((String)((String)spec), (BytesUtils.Encoding)BytesUtils.Encoding.BASE64);
                }
                return spec;
            }
        }
        throw new RuntimeException("This test does not support the data type yet: " + String.valueOf(schema.type()));
    }

    public static Object connectToSpec(Object data, Schema schema, boolean toUpper) {
        if (data == null) {
            return null;
        }
        switch (schema.type()) {
            case INT64: {
                if ("org.apache.kafka.connect.data.Timestamp".equals(schema.name())) {
                    return org.apache.kafka.connect.data.Timestamp.fromLogical((Schema)schema, (Date)((Date)data));
                }
                return data;
            }
            case INT32: {
                if ("org.apache.kafka.connect.data.Time".equals(schema.name())) {
                    return Time.fromLogical((Schema)schema, (Date)((Date)data));
                }
                if ("org.apache.kafka.connect.data.Date".equals(schema.name())) {
                    return org.apache.kafka.connect.data.Date.fromLogical((Schema)schema, (Date)((Date)data));
                }
                return data;
            }
            case FLOAT32: 
            case FLOAT64: 
            case BOOLEAN: {
                return data;
            }
            case STRING: {
                return data.toString();
            }
            case ARRAY: {
                return ((List)data).stream().map(v -> SpecToConnectConverter.connectToSpec(v, schema.valueSchema(), toUpper)).collect(Collectors.toList());
            }
            case MAP: {
                HashMap map = new HashMap();
                ((Map)data).forEach((k, v) -> map.put(k.toString(), SpecToConnectConverter.connectToSpec(v, schema.valueSchema(), toUpper)));
                return map;
            }
            case STRUCT: {
                HashMap recordSpec = new HashMap();
                schema.fields().forEach(f -> recordSpec.put(toUpper ? f.name().toUpperCase() : f.name(), SpecToConnectConverter.connectToSpec(((Struct)data).get(f.name()), f.schema(), toUpper)));
                return recordSpec;
            }
            case BYTES: {
                if (DecimalUtil.isDecimal((Schema)schema)) {
                    if (data instanceof BigDecimal) {
                        return data;
                    }
                    throw new RuntimeException("Unexpected BYTES type " + schema.name());
                }
                if (data instanceof byte[]) {
                    return ByteBuffer.wrap((byte[])data);
                }
                return data;
            }
        }
        throw new RuntimeException("Test cannot handle data of type: " + String.valueOf(schema.type()));
    }
}

