/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.serde.kafka;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.test.TestFrameworkException;
import io.confluent.ksql.test.serde.SerdeSupplier;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaSerdeSupplier
implements SerdeSupplier<Object> {
    private final LogicalSchema schema;

    public KafkaSerdeSupplier(LogicalSchema schema) {
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    @Override
    public Serializer<Object> getSerializer(SchemaRegistryClient schemaRegistryClient, boolean isKey) {
        return new RowSerializer();
    }

    @Override
    public Deserializer<Object> getDeserializer(SchemaRegistryClient schemaRegistryClient, boolean isKey) {
        return new RowDeserializer();
    }

    private Serde<?> getSerde(boolean isKey) {
        List columns;
        List list = columns = isKey ? this.schema.key() : this.schema.value();
        if (columns.isEmpty()) {
            return Serdes.String();
        }
        if (columns.size() != 1) {
            throw new IllegalStateException("KAFKA format only supports single column schemas.");
        }
        return KafkaSerdeSupplier.getSerde(((Column)columns.get(0)).type());
    }

    private static Serde<?> getSerde(SqlType sqlType) {
        switch (sqlType.baseType()) {
            case INTEGER: {
                return Serdes.Integer();
            }
            case BIGINT: {
                return Serdes.serdeFrom(new TestNumberSerializer<Long>(Serdes.Long().serializer(), Long.class, Number::longValue), (Deserializer)new TestBigIntDeserializer((Deserializer<Long>)Serdes.Long().deserializer()));
            }
            case DOUBLE: {
                return Serdes.serdeFrom(new TestNumberSerializer<Double>(Serdes.Double().serializer(), Double.class, Number::doubleValue), (Deserializer)new TestDoubleDeserializer((Deserializer<Double>)Serdes.Double().deserializer()));
            }
            case STRING: {
                return Serdes.String();
            }
            case BYTES: {
                return Serdes.serdeFrom((Serializer)new TestByteBufferSerializer((Serializer<ByteBuffer>)Serdes.ByteBuffer().serializer()), (Deserializer)new TestByteBufferDeserializer((Deserializer<ByteBuffer>)Serdes.ByteBuffer().deserializer()));
            }
        }
        throw new IllegalStateException("Unsupported type for KAFKA format");
    }

    private final class RowSerializer
    implements Serializer<Object> {
        private Serializer<Object> delegate;

        private RowSerializer() {
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.delegate = KafkaSerdeSupplier.this.getSerde(isKey).serializer();
            this.delegate.configure(configs, isKey);
        }

        public byte[] serialize(String topic, Object value) {
            return this.delegate.serialize(topic, value);
        }
    }

    private final class RowDeserializer
    implements Deserializer<Object> {
        private Deserializer<?> delegate;
        private String type;

        private RowDeserializer() {
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.type = isKey ? "key" : "value";
            this.delegate = KafkaSerdeSupplier.this.getSerde(isKey).deserializer();
            this.delegate.configure(configs, isKey);
        }

        public Object deserialize(String topic, byte[] bytes) {
            try {
                return this.delegate.deserialize(topic, bytes);
            }
            catch (Exception e) {
                throw new TestFrameworkException("Failed to deserialize " + this.type + ". " + e.getMessage(), e);
            }
        }
    }

    private static class TestNumberSerializer<T extends Number>
    implements Serializer<Object> {
        private final Class<T> type;
        private final Serializer<T> inner;
        private final Function<Number, T> coercer;

        TestNumberSerializer(Serializer<T> inner, Class<T> type, Function<Number, T> coercer) {
            this.inner = Objects.requireNonNull(inner, "inner");
            this.type = Objects.requireNonNull(type, "type");
            this.coercer = Objects.requireNonNull(coercer, "coercer");
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.inner.configure(configs, isKey);
        }

        public byte[] serialize(String topicName, Object value) {
            T coerced = this.coerce(value);
            return this.inner.serialize(topicName, coerced);
        }

        public void close() {
            this.inner.close();
        }

        private T coerce(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return (T)((Number)this.coercer.apply((Number)value));
            }
            throw new TestFrameworkException("Can't serialize " + String.valueOf(value) + " as " + this.type.getSimpleName());
        }
    }

    private static class TestBigIntDeserializer
    implements Deserializer<Object> {
        private final Deserializer<Long> inner;

        TestBigIntDeserializer(Deserializer<Long> inner) {
            this.inner = Objects.requireNonNull(inner, "inner");
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.inner.configure(configs, isKey);
        }

        public Number deserialize(String topicName, byte[] bytes) {
            Long deserialized = (Long)this.inner.deserialize(topicName, bytes);
            if (deserialized == null) {
                return null;
            }
            if (Integer.MIN_VALUE < deserialized && deserialized < Integer.MAX_VALUE) {
                return (int)deserialized.longValue();
            }
            return deserialized;
        }

        public void close() {
            this.inner.close();
        }
    }

    private static class TestDoubleDeserializer
    implements Deserializer<Object> {
        private final Deserializer<Double> inner;

        TestDoubleDeserializer(Deserializer<Double> inner) {
            this.inner = Objects.requireNonNull(inner, "inner");
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.inner.configure(configs, isKey);
        }

        public BigDecimal deserialize(String topicName, byte[] bytes) {
            Double deserialized = (Double)this.inner.deserialize(topicName, bytes);
            if (deserialized == null) {
                return null;
            }
            return BigDecimal.valueOf(deserialized);
        }

        public void close() {
            this.inner.close();
        }
    }

    private static class TestByteBufferSerializer
    implements Serializer<Object> {
        private final Serializer<ByteBuffer> inner;

        TestByteBufferSerializer(Serializer<ByteBuffer> inner) {
            this.inner = Objects.requireNonNull(inner, "inner");
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.inner.configure(configs, isKey);
        }

        public byte[] serialize(String topicName, Object value) {
            ByteBuffer coerced = this.coerce(value);
            return this.inner.serialize(topicName, (Object)coerced);
        }

        public void close() {
            this.inner.close();
        }

        private ByteBuffer coerce(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return ByteBuffer.wrap(((String)value).getBytes(StandardCharsets.UTF_8));
            }
            throw new TestFrameworkException("Can't serialize " + String.valueOf(value) + " as BYTEBUFFER");
        }
    }

    private static class TestByteBufferDeserializer
    implements Deserializer<Object> {
        private final Deserializer<ByteBuffer> inner;

        TestByteBufferDeserializer(Deserializer<ByteBuffer> inner) {
            this.inner = Objects.requireNonNull(inner, "inner");
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.inner.configure(configs, isKey);
        }

        public String deserialize(String topicName, byte[] bytes) {
            ByteBuffer deserialized = (ByteBuffer)this.inner.deserialize(topicName, bytes);
            if (deserialized == null) {
                return null;
            }
            return new String(deserialized.array(), StandardCharsets.UTF_8);
        }

        public Object deserialize(String topic, Headers headers, byte[] data) {
            return super.deserialize(topic, headers, data);
        }

        public void close() {
            this.inner.close();
        }
    }
}

