/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.test.model.TestHeader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.connect.data.Struct;

public final class ExpectedRecordComparator {
    private static final Map<JsonNodeType, BiPredicate<Object, JsonNode>> COMPARATORS = ImmutableMap.builder().put((Object)JsonNodeType.OBJECT, ExpectedRecordComparator::compareStruct).put((Object)JsonNodeType.ARRAY, ExpectedRecordComparator::compareArray).put((Object)JsonNodeType.NUMBER, ExpectedRecordComparator::compareNumber).put((Object)JsonNodeType.STRING, ExpectedRecordComparator::compareText).put((Object)JsonNodeType.BOOLEAN, ExpectedRecordComparator::compareBoolean).put((Object)JsonNodeType.NULL, ExpectedRecordComparator::compareNull).build();

    private ExpectedRecordComparator() {
    }

    public static boolean matches(Header[] actualHeaders, List<TestHeader> expectedHeaders) {
        if (actualHeaders.length != expectedHeaders.size()) {
            return false;
        }
        for (int i = 0; i < actualHeaders.length; ++i) {
            if (actualHeaders[i].key().equals(expectedHeaders.get(i).key()) && Arrays.equals(actualHeaders[i].value(), expectedHeaders.get(i).value())) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(Object actualValue, JsonNode expectedValue) {
        return ExpectedRecordComparator.comparator(expectedValue).test(actualValue, expectedValue);
    }

    private static boolean compareStruct(Object actualValue, JsonNode expectedValue) {
        int numFields;
        Function<String, Object> getter;
        ObjectNode expected = (ObjectNode)expectedValue;
        if (actualValue instanceof Struct) {
            getter = arg_0 -> ((Struct)((Struct)actualValue)).get(arg_0);
            numFields = ((Struct)actualValue).schema().fields().size();
        } else if (actualValue instanceof Map) {
            getter = ((Map)actualValue)::get;
            numFields = ((Map)actualValue).size();
        } else {
            return false;
        }
        if (numFields != expected.size()) {
            return false;
        }
        Iterator fields = expected.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            Object key = getter.apply((String)field.getKey());
            if (key == null) {
                key = getter.apply(((String)field.getKey()).toUpperCase());
            }
            if (ExpectedRecordComparator.comparator((JsonNode)field.getValue()).test(key, (JsonNode)field.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareArray(Object actualValue, JsonNode expectedValue) {
        ArrayNode expected = (ArrayNode)expectedValue;
        if (!(actualValue instanceof List)) {
            return false;
        }
        List actual = (List)actualValue;
        if (actual.size() != expected.size()) {
            return false;
        }
        Iterator elements = expected.elements();
        int i = 0;
        while (elements.hasNext()) {
            JsonNode el = (JsonNode)elements.next();
            if (!ExpectedRecordComparator.comparator(el).test(actual.get(i), el)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean compareNumber(Object actualValue, JsonNode expectedValue) {
        NumericNode expected = (NumericNode)expectedValue;
        if (actualValue instanceof Integer) {
            return expected.intValue() == ((Integer)actualValue).intValue();
        }
        if (actualValue instanceof Long) {
            return expected.longValue() == ((Long)actualValue).longValue();
        }
        if (actualValue instanceof Double) {
            return Math.abs(expected.doubleValue() - (Double)actualValue) < 1.0E-6;
        }
        if (actualValue instanceof BigDecimal) {
            return ExpectedRecordComparator.compareDecimal((BigDecimal)actualValue, expected);
        }
        return false;
    }

    private static boolean compareDecimal(BigDecimal actualValue, NumericNode expected) {
        if (expected.isInt() || expected.isLong()) {
            if (actualValue.scale() > 0) {
                return false;
            }
            return expected.longValue() == actualValue.longValueExact();
        }
        if (!expected.isBigDecimal()) {
            return false;
        }
        try {
            return expected.decimalValue().equals(actualValue);
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    private static boolean compareText(Object actualValue, JsonNode expectedValue) {
        TextNode expected = (TextNode)expectedValue;
        if (actualValue instanceof String) {
            return expected.asText().equals(actualValue);
        }
        if (actualValue instanceof BigDecimal) {
            return new BigDecimal(expected.asText()).equals(actualValue);
        }
        if (actualValue instanceof ByteBuffer) {
            return expected.asText().equals(Base64.getEncoder().encodeToString(((ByteBuffer)actualValue).array()));
        }
        return false;
    }

    private static boolean compareBoolean(Object actualValue, JsonNode expectedValue) {
        return actualValue instanceof Boolean && expectedValue.asBoolean() == ((Boolean)actualValue).booleanValue();
    }

    private static boolean compareNull(Object actualValue, JsonNode expectedValue) {
        return actualValue == null;
    }

    private static BiPredicate<Object, JsonNode> comparator(JsonNode node) {
        JsonNodeType type = node == null ? JsonNodeType.NULL : node.getNodeType();
        BiPredicate<Object, JsonNode> predicate = COMPARATORS.get(type);
        if (predicate == null) {
            throw new IllegalArgumentException("KSQL Testing Tool cannot expect JSON node type: " + String.valueOf(type));
        }
        return predicate;
    }
}

