/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.ksql.parser.DefaultKsqlParser;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.test.model.InputRecordsNode;
import io.confluent.ksql.test.model.OutputRecordsNode;
import io.confluent.ksql.test.model.PathLocation;
import io.confluent.ksql.test.model.TestCaseNode;
import io.confluent.ksql.test.tools.TestCase;
import io.confluent.ksql.test.tools.TestCaseBuilder;
import io.confluent.ksql.test.tools.TestExecutionListener;
import io.confluent.ksql.test.tools.TestExecutor;
import io.confluent.ksql.test.tools.TestJsonMapper;
import io.confluent.ksql.test.tools.command.TestOptions;
import io.confluent.ksql.util.KsqlException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class KsqlTestingTool {
    private static final ObjectMapper OBJECT_MAPPER = TestJsonMapper.INSTANCE.get();

    private KsqlTestingTool() {
    }

    public static void main(String[] args) {
        try {
            TestOptions testOptions = TestOptions.parse(args);
            if (testOptions == null) {
                return;
            }
            if (testOptions.getStatementsFile() != null && testOptions.getOutputFile() != null) {
                int resultCode = KsqlTestingTool.runWithTripleFiles(testOptions.getStatementsFile(), testOptions.getInputFile(), testOptions.getOutputFile(), testOptions.getExtensionDir());
                System.exit(resultCode);
            }
        }
        catch (Exception e) {
            System.err.println("Invalid arguments: " + e.getMessage());
            System.exit(1);
        }
    }

    private static List<String> getSqlStatements(Path queryFilePath) {
        try {
            String sqlStatements = new String(Files.readAllBytes(queryFilePath), StandardCharsets.UTF_8);
            DefaultKsqlParser ksqlParser = new DefaultKsqlParser();
            List parsedStatements = ksqlParser.parse(sqlStatements);
            return parsedStatements.stream().map(KsqlParser.ParsedStatement::getUnMaskedStatementText).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new KsqlException(String.format("Could not read the query file: %s. Details: %s", queryFilePath, e.getMessage()), (Throwable)e);
        }
    }

    static int runWithTripleFiles(String statementFile, String inputFile, String outputFile, Optional<String> extensionDir) throws Exception {
        OutputRecordsNode outRecordNodes;
        InputRecordsNode inputRecordNodes;
        try {
            inputRecordNodes = inputFile == null ? null : (InputRecordsNode)OBJECT_MAPPER.readValue(new File(inputFile), InputRecordsNode.class);
        }
        catch (Exception inputException) {
            throw new Exception("File name: " + inputFile + " Message: " + inputException.getMessage());
        }
        try {
            outRecordNodes = (OutputRecordsNode)OBJECT_MAPPER.readValue(new File(outputFile), OutputRecordsNode.class);
        }
        catch (Exception outputException) {
            throw new Exception("File name: " + outputFile + " Message: " + outputException.getMessage());
        }
        Path stmtsPath = Paths.get(statementFile, new String[0]);
        List<String> statements = KsqlTestingTool.getSqlStatements(stmtsPath);
        TestCaseNode testCaseNode = new TestCaseNode("KSQL_Test", Optional.empty(), null, null, inputFile == null ? null : inputRecordNodes.getInputRecords(), outRecordNodes.getOutputRecords(), Collections.emptyList(), statements, null, null, null, true);
        PathLocation location = new PathLocation(stmtsPath.toAbsolutePath());
        TestCase testCase = TestCaseBuilder.buildTests(testCaseNode, location.getTestPath(), name -> location).get(0);
        return KsqlTestingTool.executeTestCase(testCase, TestExecutor.create(true, extensionDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int executeTestCase(TestCase testCase, TestExecutor testExecutor) {
        try {
            testExecutor.buildAndExecuteQuery(testCase, TestExecutionListener.noOp());
            System.out.println("\t >>> Test passed!");
        }
        catch (AssertionError | Exception e) {
            System.err.println("\t>>>>> Test failed: " + ((Throwable)e).getMessage());
            int n = 1;
            return n;
        }
        finally {
            testExecutor.close();
        }
        return 0;
    }
}

