/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.parser.DurationParser;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.query.QuerySchemas;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.test.TestFrameworkException;
import io.confluent.ksql.test.serde.SerdeSupplier;
import io.confluent.ksql.test.utils.SerdeUtil;
import io.confluent.ksql.util.PersistentQueryMetadata;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;

public class TopicInfoCache {
    private static final String TOPIC_PATTERN_PREFIX = "_confluent.*query_(?<queryId>.*_\\d+)-";
    private static final List<InternalTopicPattern> INTERNAL_TOPIC_PATTERNS = ImmutableList.of((Object)new InternalTopicPattern(Pattern.compile("_confluent.*query_(?<queryId>.*_\\d+)-Aggregate-.*-changelog"), GroupByChangeLogPattern::new), (Object)new InternalTopicPattern(Pattern.compile("_confluent.*query_(?<queryId>.*_\\d+)-KSTREAM-\\w+-\\d+-store-changelog"), StreamStreamJoinChangeLogPattern::new), (Object)new InternalTopicPattern(Pattern.compile("_confluent.*query_(?<queryId>.*_\\d+)-.*-(changelog|repartition)"), InternalTopic::new));
    private static final Set<Pattern> IGNORE_INTERNAL_TOPIC_NAMES_PATTERNS = ImmutableSet.of((Object)Pattern.compile("_confluent.*query_(?<queryId>.*_\\d+)-.*-FK-JOIN-SUBSCRIPTION-REGISTRATION-\\d+-topic"), (Object)Pattern.compile("_confluent.*query_(?<queryId>.*_\\d+)-.*-FK-JOIN-SUBSCRIPTION-RESPONSE-\\d+-topic"), (Object)Pattern.compile("_confluent.*query_(?<queryId>.*_\\d+)-.*-FK-JOIN-SUBSCRIPTION-STATE-STORE-\\d+-changelog"));
    private static final ValueFormat NONE_VALUE_FORMAT = ValueFormat.of((FormatInfo)FormatInfo.of((String)FormatFactory.NONE.name()), (SerdeFeatures)SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]));
    private final KsqlExecutionContext ksqlEngine;
    private final SchemaRegistryClient srClient;
    private final LoadingCache<String, TopicInfo> cache;

    public TopicInfoCache(KsqlExecutionContext ksqlEngine, SchemaRegistryClient srClient) {
        this.ksqlEngine = Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.srClient = Objects.requireNonNull(srClient, "srClient");
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.from(this::load));
    }

    public Optional<TopicInfo> get(String topicName) {
        if (this.ignoreInternalTopic(topicName)) {
            return Optional.empty();
        }
        return Optional.of((TopicInfo)this.cache.getUnchecked((Object)topicName));
    }

    public List<TopicInfo> all() {
        return ImmutableList.copyOf(this.cache.asMap().values());
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    private boolean ignoreInternalTopic(String topicName) {
        for (Pattern p : IGNORE_INTERNAL_TOPIC_NAMES_PATTERNS) {
            if (!p.matcher(topicName).matches()) continue;
            return true;
        }
        return false;
    }

    private TopicInfo load(String topicName) {
        try {
            Optional<InternalTopic> internalTopic = INTERNAL_TOPIC_PATTERNS.stream().map(e -> e.match(topicName)).filter(Optional::isPresent).map(Optional::get).findFirst();
            if (internalTopic.isPresent()) {
                QueryId queryId = internalTopic.get().queryId();
                PersistentQueryMetadata query = (PersistentQueryMetadata)this.ksqlEngine.getPersistentQuery(queryId).orElseThrow(() -> new TestFrameworkException("Unknown queryId for internal topic: " + String.valueOf(queryId)));
                QuerySchemas.MultiSchemaInfo schemasInfo = query.getQuerySchemas().getTopicInfo(topicName);
                Set keyFormats = schemasInfo.getKeyFormats();
                Set valueFormats = schemasInfo.getValueFormats();
                if (keyFormats.size() != 1) {
                    String result = keyFormats.size() == 0 ? "Zero" : "Multiple";
                    throw new Exception(result + " key formats registered for topic." + System.lineSeparator() + "topic: " + topicName + "formats: " + String.valueOf(keyFormats.stream().map(KeyFormat::getFormat).sorted().collect(Collectors.toList())));
                }
                if (valueFormats.size() > 1) {
                    throw new Exception("Multiple value formats registered for topic." + System.lineSeparator() + "topic: " + topicName + "formats: " + String.valueOf(valueFormats.stream().map(ValueFormat::getFormat).sorted().collect(Collectors.toList())));
                }
                return new TopicInfo(topicName, query.getLogicalSchema(), internalTopic.get().keyFormat((KeyFormat)Iterables.getOnlyElement((Iterable)keyFormats), query), (ValueFormat)Iterables.getOnlyElement((Iterable)valueFormats, (Object)NONE_VALUE_FORMAT), internalTopic.get().changeLogWindowSize(query));
            }
            Set keyTypes = this.ksqlEngine.getMetaStore().getAllDataSources().values().stream().filter(source -> source.getKafkaTopicName().equals(topicName)).map(source -> new TopicInfo(topicName, source.getSchema(), source.getKsqlTopic().getKeyFormat(), source.getKsqlTopic().getValueFormat(), OptionalLong.empty())).collect(Collectors.toSet());
            if (keyTypes.isEmpty()) {
                throw new TestFrameworkException("No information found for topic '" + topicName + "'. Available topics: " + String.valueOf(this.cache.asMap().keySet()));
            }
            return (TopicInfo)Iterables.get(keyTypes, (int)0);
        }
        catch (Exception e2) {
            throw new TestFrameworkException("Failed to determine key type for" + System.lineSeparator() + "topic: " + topicName + System.lineSeparator() + "reason: " + e2.getMessage(), e2);
        }
    }

    public final class TopicInfo {
        private final String topicName;
        private final LogicalSchema schema;
        private final KeyFormat keyFormat;
        private final ValueFormat valueFormat;
        private final OptionalLong changeLogWindowSize;

        private TopicInfo(String topicName, LogicalSchema schema, KeyFormat keyFormat, ValueFormat valueFormat, OptionalLong changeLogWindowSize) {
            this.topicName = Objects.requireNonNull(topicName, "topicName");
            this.schema = Objects.requireNonNull(schema, "schema");
            this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
            this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
            this.changeLogWindowSize = Objects.requireNonNull(changeLogWindowSize, "changeLogWindowSize");
        }

        public String getTopicName() {
            return this.topicName;
        }

        public LogicalSchema getSchema() {
            return this.schema;
        }

        public KeyFormat getKeyFormat() {
            return this.keyFormat;
        }

        public ValueFormat getValueFormat() {
            return this.valueFormat;
        }

        public Serializer<Object> getKeySerializer(Map<String, Object> properties) {
            SerdeSupplier<?> keySerdeSupplier = SerdeUtil.getKeySerdeSupplier(this.keyFormat, this.schema, properties);
            Serializer<?> serializer = keySerdeSupplier.getSerializer(TopicInfoCache.this.srClient, true);
            serializer.configure((Map)ImmutableMap.of((Object)"schema.registry.url", (Object)"something"), true);
            return serializer;
        }

        public Serializer<Object> getValueSerializer(Map<String, Object> properties) {
            SerdeSupplier<?> valueSerdeSupplier = SerdeUtil.getSerdeSupplier(this.valueFormat.getFormatInfo(), this.schema, properties, this.valueFormat.getFeatures());
            Serializer<?> serializer = valueSerdeSupplier.getSerializer(TopicInfoCache.this.srClient, false);
            serializer.configure((Map)ImmutableMap.of((Object)"schema.registry.url", (Object)"something"), false);
            return serializer;
        }

        public Deserializer<?> getKeyDeserializer(Map<String, Object> properties) {
            SerdeSupplier<?> keySerdeSupplier = SerdeUtil.getKeySerdeSupplier(this.keyFormat, this.schema, properties);
            Deserializer<?> deserializer = keySerdeSupplier.getDeserializer(TopicInfoCache.this.srClient, true);
            deserializer.configure((Map)ImmutableMap.of(), true);
            if (!this.changeLogWindowSize.isPresent()) {
                return deserializer;
            }
            TimeWindowedDeserializer changeLogDeserializer = new TimeWindowedDeserializer(deserializer, Long.valueOf(this.changeLogWindowSize.getAsLong()));
            changeLogDeserializer.setIsChangelogTopic(true);
            return changeLogDeserializer;
        }

        public Deserializer<?> getValueDeserializer(Map<String, Object> properties) {
            SerdeSupplier<?> valueSerdeSupplier = SerdeUtil.getSerdeSupplier(this.valueFormat.getFormatInfo(), this.schema, properties, this.valueFormat.getFeatures());
            Deserializer<?> deserializer = valueSerdeSupplier.getDeserializer(TopicInfoCache.this.srClient, false);
            deserializer.configure((Map)ImmutableMap.of(), false);
            return deserializer;
        }
    }

    private static class InternalTopic {
        private final QueryId queryId;

        InternalTopic(Matcher matcher) {
            this.queryId = new QueryId(matcher.group("queryId"));
        }

        QueryId queryId() {
            return this.queryId;
        }

        KeyFormat keyFormat(KeyFormat baseFormat, PersistentQueryMetadata query) {
            return baseFormat;
        }

        OptionalLong changeLogWindowSize(PersistentQueryMetadata query) {
            return OptionalLong.empty();
        }
    }

    private static class InternalTopicPattern {
        private final Pattern pattern;
        private final Function<Matcher, InternalTopic> topicFactory;

        InternalTopicPattern(Pattern pattern, Function<Matcher, InternalTopic> topicFactory) {
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            this.topicFactory = Objects.requireNonNull(topicFactory, "topicFactory");
        }

        Optional<InternalTopic> match(String topicName) {
            Matcher matcher = this.pattern.matcher(topicName);
            if (!matcher.matches()) {
                return Optional.empty();
            }
            return Optional.of(this.topicFactory.apply(matcher));
        }
    }

    private static class StreamStreamJoinChangeLogPattern
    extends InternalTopic {
        private static final Pattern WINDOWED_JOIN_PATTERN = Pattern.compile(".*\\bSELECT\\b.*\\bJOIN\\b.*\\bWITHIN\\b\\s*(?<duration>\\d+\\s+\\w+)\\s*\\bON\\b.*", 34);
        private final String topicName;

        StreamStreamJoinChangeLogPattern(Matcher matcher) {
            super(matcher);
            this.topicName = matcher.group(0);
        }

        @Override
        OptionalLong changeLogWindowSize(PersistentQueryMetadata query) {
            if (!this.topicName.endsWith("-changelog")) {
                return OptionalLong.empty();
            }
            Matcher windowedJoinMatcher = WINDOWED_JOIN_PATTERN.matcher(query.getStatementString());
            if (!windowedJoinMatcher.matches()) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(DurationParser.parse((String)windowedJoinMatcher.group("duration")).toMillis());
        }
    }

    private static class GroupByChangeLogPattern
    extends InternalTopic {
        private static final Pattern WINDOWED_GROUP_BY_PATTERN = Pattern.compile(".*\\b+WINDOW\\s+(?<windowType>\\w+)\\s+\\(\\s+(:?SIZE\\s+)?(?<duration>\\d+\\s+\\w+)[^)]*\\).*\\bGROUP\\s+BY.*", 34);

        GroupByChangeLogPattern(Matcher matcher) {
            super(matcher);
        }

        @Override
        public KeyFormat keyFormat(KeyFormat keyFormat, PersistentQueryMetadata query) {
            Matcher matcher = WINDOWED_GROUP_BY_PATTERN.matcher(query.getStatementString());
            if (!matcher.matches()) {
                return keyFormat;
            }
            WindowType windowType = WindowType.of((String)matcher.group("windowType"));
            Optional duration = windowType.requiresWindowSize() ? Optional.of(DurationParser.parse((String)matcher.group("duration"))) : Optional.empty();
            return KeyFormat.windowed((FormatInfo)keyFormat.getFormatInfo(), (SerdeFeatures)keyFormat.getFeatures(), (WindowInfo)WindowInfo.of((WindowType)windowType, duration, Optional.empty()));
        }
    }
}

