/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.protobuf.ProtobufNoSRProperties;
import io.confluent.ksql.serde.protobuf.ProtobufProperties;
import io.confluent.ksql.test.serde.SerdeSupplier;
import io.confluent.ksql.test.serde.avro.ValueSpecAvroSerdeSupplier;
import io.confluent.ksql.test.serde.json.ValueSpecJsonSchemaSerdeSupplier;
import io.confluent.ksql.test.serde.json.ValueSpecJsonSerdeSupplier;
import io.confluent.ksql.test.serde.kafka.KafkaSerdeSupplier;
import io.confluent.ksql.test.serde.none.NoneSerdeSupplier;
import io.confluent.ksql.test.serde.protobuf.ValueSpecProtobufNoSRSerdeSupplier;
import io.confluent.ksql.test.serde.protobuf.ValueSpecProtobufSerdeSupplier;
import io.confluent.ksql.test.serde.string.StringSerdeSupplier;
import io.confluent.ksql.test.tools.exceptions.InvalidFieldException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.SessionWindowedDeserializer;
import org.apache.kafka.streams.kstream.SessionWindowedSerializer;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;
import org.apache.kafka.streams.kstream.TimeWindowedSerializer;
import org.apache.kafka.streams.kstream.Windowed;

public final class SerdeUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private SerdeUtil() {
    }

    public static SerdeSupplier<?> getSerdeSupplier(FormatInfo formatInfo, LogicalSchema schema, Map<String, Object> properties, SerdeFeatures serdeFeatures) {
        Format format = FormatFactory.of((FormatInfo)formatInfo);
        switch (format.name()) {
            case "AVRO": {
                return new ValueSpecAvroSerdeSupplier();
            }
            case "PROTOBUF": {
                return new ValueSpecProtobufSerdeSupplier(new ProtobufProperties(formatInfo.getProperties()));
            }
            case "PROTOBUF_NOSR": {
                return new ValueSpecProtobufNoSRSerdeSupplier(schema, new ProtobufNoSRProperties(formatInfo.getProperties()));
            }
            case "JSON": {
                return new ValueSpecJsonSerdeSupplier(properties);
            }
            case "JSON_SR": {
                return new ValueSpecJsonSchemaSerdeSupplier();
            }
            case "DELIMITED": {
                return new StringSerdeSupplier();
            }
            case "KAFKA": {
                return new KafkaSerdeSupplier(schema);
            }
            case "NONE": {
                return new NoneSerdeSupplier();
            }
        }
        throw new InvalidFieldException("format", "unsupported value: " + String.valueOf(format));
    }

    public static Optional<ParsedSchema> buildSchema(JsonNode schema, String format) {
        String schemaString;
        String useFormat;
        if (schema == null || schema instanceof NullNode) {
            return Optional.empty();
        }
        switch (useFormat = format == null ? "AVRO" : format.toUpperCase()) {
            case "PROTOBUF": {
                schemaString = schema.textValue();
                break;
            }
            case "AVRO": 
            case "JSON_SR": 
            case "JSON": {
                try {
                    schemaString = OBJECT_MAPPER.writeValueAsString((Object)schema);
                    break;
                }
                catch (Exception e) {
                    throw new InvalidFieldException("schema", "failed to parse", e);
                }
            }
            default: {
                throw new InvalidFieldException("schema", "not supported with format: " + format);
            }
        }
        return Optional.of(SerdeUtil.buildSchema(schemaString, useFormat));
    }

    public static ParsedSchema buildSchema(String schemaString, String format) {
        switch (format.toUpperCase()) {
            case "AVRO": {
                Schema avroSchema = new Schema.Parser().parse(schemaString);
                return new AvroSchema(avroSchema);
            }
            case "PROTOBUF": {
                return new ProtobufSchema(schemaString);
            }
            case "JSON_SR": 
            case "JSON": {
                return new JsonSchema(schemaString);
            }
        }
        throw new InvalidFieldException("schema", "not supported with format: " + format);
    }

    public static ParsedSchema withSchemaReferences(ParsedSchema schema, List<io.confluent.ksql.tools.test.model.SchemaReference> references) {
        if (references.isEmpty()) {
            return schema;
        }
        boolean firstVersion = true;
        Map<String, String> resolvedReferences = references.stream().collect(Collectors.toMap(ref -> ref.getName(), ref -> ref.getSchema().canonicalString()));
        List schemaReferences = references.stream().map(qttSchemaRef -> new SchemaReference(qttSchemaRef.getName(), qttSchemaRef.getName(), Integer.valueOf(1))).collect(Collectors.toList());
        switch (schema.schemaType()) {
            case "PROTOBUF": {
                return new ProtobufSchema(schema.canonicalString(), schemaReferences, resolvedReferences, Integer.valueOf(1), schema.name());
            }
            case "AVRO": {
                return new AvroSchema(schema.canonicalString(), schemaReferences, resolvedReferences, Integer.valueOf(1));
            }
            case "JSON_SR": {
                return new JsonSchema(schema.canonicalString(), schemaReferences, resolvedReferences, Integer.valueOf(1));
            }
        }
        return schema;
    }

    public static <T> SerdeSupplier<?> getKeySerdeSupplier(final KeyFormat keyFormat, LogicalSchema schema, Map<String, Object> properties) {
        final SerdeSupplier<?> inner = SerdeUtil.getSerdeSupplier(keyFormat.getFormatInfo(), schema, properties, keyFormat.getFeatures());
        if (!keyFormat.getWindowType().isPresent()) {
            return inner;
        }
        WindowType windowType = (WindowType)keyFormat.getWindowType().get();
        if (windowType == WindowType.SESSION) {
            return new SerdeSupplier<Windowed<T>>(){

                @Override
                public Serializer<Windowed<T>> getSerializer(SchemaRegistryClient srClient, boolean isKey) {
                    Serializer serializer = inner.getSerializer(srClient, isKey);
                    serializer.configure((Map)ImmutableMap.of((Object)"schema.registry.url", (Object)"something"), true);
                    return new SessionWindowedSerializer(serializer);
                }

                @Override
                public Deserializer<Windowed<T>> getDeserializer(SchemaRegistryClient srClient, boolean isKey) {
                    Deserializer deserializer = inner.getDeserializer(srClient, isKey);
                    deserializer.configure((Map)ImmutableMap.of(), true);
                    return new SessionWindowedDeserializer(deserializer);
                }
            };
        }
        return new SerdeSupplier<Windowed<T>>(){

            @Override
            public Serializer<Windowed<T>> getSerializer(SchemaRegistryClient srClient, boolean isKey) {
                Serializer serializer = inner.getSerializer(srClient, isKey);
                serializer.configure((Map)ImmutableMap.of((Object)"schema.registry.url", (Object)"something"), true);
                return new TimeWindowedSerializer(serializer);
            }

            @Override
            public Deserializer<Windowed<T>> getDeserializer(SchemaRegistryClient srClient, boolean isKey) {
                Deserializer deserializer = inner.getDeserializer(srClient, isKey);
                deserializer.configure((Map)ImmutableMap.of(), true);
                return new TimeWindowedDeserializer(deserializer, Long.valueOf(((Duration)keyFormat.getWindowSize().get()).toMillis()));
            }
        };
    }
}

