/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ShareGroupDescribeRequestData
implements ApiMessage {
    List<String> groupIds;
    boolean includeAuthorizedOperations;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("group_ids", new CompactArrayOf(Type.COMPACT_STRING), "The ids of the groups to describe."), new Field("include_authorized_operations", Type.BOOLEAN, "Whether to include authorized operations."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ShareGroupDescribeRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ShareGroupDescribeRequestData() {
        this.groupIds = new ArrayList<String>(0);
        this.includeAuthorizedOperations = false;
    }

    @Override
    public short apiKey() {
        return 77;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field groupIds was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupIds element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupIds element had invalid length " + length);
            }
            newCollection.add(_context.read(EntityType.GROUP_ID, _readable.readString(length)));
        }
        this.groupIds = newCollection;
        this.includeAuthorizedOperations = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.groupIds.size() + 1);
        for (String groupIdsElement : this.groupIds) {
            byte[] _stringBytes = _cache.getSerializedValue(groupIdsElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeByte(this.includeAuthorizedOperations ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.groupIds.size() + 1));
        for (String groupIdsElement : this.groupIds) {
            byte[] _stringBytes = _context.write(EntityType.GROUP_ID, groupIdsElement).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupIdsElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(groupIdsElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShareGroupDescribeRequestData)) {
            return false;
        }
        ShareGroupDescribeRequestData other = (ShareGroupDescribeRequestData)obj;
        if (this.groupIds == null ? other.groupIds != null : !this.groupIds.equals(other.groupIds)) {
            return false;
        }
        if (this.includeAuthorizedOperations != other.includeAuthorizedOperations) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupIds == null ? 0 : this.groupIds.hashCode());
        hashCode = 31 * hashCode + (this.includeAuthorizedOperations ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public ShareGroupDescribeRequestData duplicate() {
        ShareGroupDescribeRequestData _duplicate = new ShareGroupDescribeRequestData();
        ArrayList<String> newGroupIds = new ArrayList<String>(this.groupIds.size());
        for (String _element : this.groupIds) {
            newGroupIds.add(_element);
        }
        _duplicate.groupIds = newGroupIds;
        _duplicate.includeAuthorizedOperations = this.includeAuthorizedOperations;
        return _duplicate;
    }

    public String toString() {
        return "ShareGroupDescribeRequestData(groupIds=" + MessageUtil.deepToString(this.groupIds.iterator()) + ", includeAuthorizedOperations=" + (this.includeAuthorizedOperations ? "true" : "false") + ")";
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    public boolean includeAuthorizedOperations() {
        return this.includeAuthorizedOperations;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ShareGroupDescribeRequestData setGroupIds(List<String> v) {
        this.groupIds = v;
        return this;
    }

    public ShareGroupDescribeRequestData setIncludeAuthorizedOperations(boolean v) {
        this.includeAuthorizedOperations = v;
        return this;
    }
}

