/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules.cel;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.expr.v1alpha1.Decl;
import com.google.api.expr.v1alpha1.Type;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.rules.RuleExecutor;
import io.confluent.kafka.schemaregistry.rules.cel.avro.AvroRegistry;
import io.confluent.kafka.schemaregistry.rules.cel.avro.AvroTypeDescription;
import io.confluent.kafka.schemaregistry.rules.cel.builtin.BuiltinLibrary;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.projectnessie.cel.Library;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.common.types.pb.Checked;
import org.projectnessie.cel.extension.StringsLib;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.cel.tools.ScriptHost;
import org.projectnessie.cel.types.jackson.JacksonRegistry;

public class CelExecutor
implements RuleExecutor {
    public static final String TYPE = "CEL";
    public static final String CEL_IGNORE_GUARD_SEPARATOR = "cel.ignore.guard.separator";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final int DEFAULT_CACHE_SIZE = 100;
    private final LoadingCache<RuleWithArgs, Script> cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<RuleWithArgs, Script>(){

        public Script load(RuleWithArgs ruleWithArgs) throws Exception {
            ScriptHost.Builder scriptHostBuilder = ScriptHost.newBuilder();
            switch (ruleWithArgs.getType()) {
                case AVRO: {
                    scriptHostBuilder = scriptHostBuilder.registry(AvroRegistry.newRegistry());
                    break;
                }
                case JSON: {
                    scriptHostBuilder = scriptHostBuilder.registry(JacksonRegistry.newRegistry());
                    break;
                }
                case PROTOBUF: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type " + String.valueOf((Object)ruleWithArgs.getType()));
                }
            }
            ScriptHost scriptHost = scriptHostBuilder.build();
            ScriptHost.ScriptBuilder scriptBuilder = scriptHost.buildScript(ruleWithArgs.getRule()).withDeclarations(new ArrayList<Decl>(ruleWithArgs.getDecls().values()));
            switch (ruleWithArgs.getType()) {
                case AVRO: {
                    scriptBuilder = scriptBuilder.withTypes(new Object[]{ruleWithArgs.getAvroSchema()});
                    break;
                }
                case JSON: {
                    scriptBuilder = scriptBuilder.withTypes(new Object[]{ruleWithArgs.getJsonClass()});
                    break;
                }
                case PROTOBUF: {
                    scriptBuilder = scriptBuilder.withTypes(new Object[]{DynamicMessage.newBuilder((Descriptors.Descriptor)ruleWithArgs.getProtobufDesc()).buildPartial()});
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type " + String.valueOf((Object)ruleWithArgs.getType()));
                }
            }
            scriptBuilder = scriptBuilder.withLibraries(new Library[]{new StringsLib(), new BuiltinLibrary()});
            return scriptBuilder.build();
        }
    });

    public String type() {
        return TYPE;
    }

    public Object transform(RuleContext ctx, Object message) throws RuleException {
        Object input = message instanceof JsonNode ? mapper.convertValue(message, (TypeReference)new TypeReference<Map<String, Object>>(){}) : message;
        Object result = this.execute(ctx, input, (Map<String, Object>)ImmutableMap.of((Object)"message", (Object)input));
        if (result instanceof Map) {
            try {
                JsonNode jsonNode = mapper.valueToTree(result);
                result = ctx.target().fromJson(jsonNode);
            }
            catch (IOException e) {
                throw new RuleException((Throwable)e);
            }
        }
        return result;
    }

    protected Object execute(RuleContext ctx, Object obj, Map<String, Object> args) throws RuleException {
        int index;
        String expr = ctx.rule().getExpr();
        String ignoreGuardStr = ctx.getParameter(CEL_IGNORE_GUARD_SEPARATOR);
        boolean ignoreGuard = Boolean.parseBoolean(ignoreGuardStr);
        if (!ignoreGuard && (index = expr.indexOf(59)) >= 0) {
            String guard = expr.substring(0, index);
            if (!guard.trim().isEmpty()) {
                Object guardResult = Boolean.FALSE;
                try {
                    guardResult = this.execute(guard, obj, args);
                }
                catch (RuleException ruleException) {
                    // empty catch block
                }
                if (Boolean.FALSE.equals(guardResult)) {
                    return ctx.rule().getKind() == RuleKind.CONDITION ? Boolean.TRUE : obj;
                }
            }
            expr = expr.substring(index + 1);
        }
        return this.execute(expr, obj, args);
    }

    private Object execute(String rule, Object obj, Map<String, Object> args) throws RuleException {
        try {
            Object msg = args.get("message");
            if (msg == null) {
                msg = obj;
            }
            ScriptType type = ScriptType.JSON;
            if (msg instanceof GenericContainer) {
                type = ScriptType.AVRO;
            } else if (msg instanceof Message) {
                type = ScriptType.PROTOBUF;
            } else if (msg instanceof List) {
                return obj;
            }
            Map<String, Decl> decls = CelExecutor.toDecls(args);
            RuleWithArgs ruleWithArgs = null;
            switch (type) {
                case AVRO: {
                    ruleWithArgs = new RuleWithArgs(rule, type, decls, ((GenericContainer)msg).getSchema());
                    break;
                }
                case JSON: {
                    ruleWithArgs = new RuleWithArgs(rule, type, decls, msg.getClass());
                    break;
                }
                case PROTOBUF: {
                    ruleWithArgs = new RuleWithArgs(rule, type, decls, ((Message)msg).getDescriptorForType());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type " + String.valueOf((Object)type));
                }
            }
            Script script = (Script)this.cache.get((Object)ruleWithArgs);
            return script.execute(Object.class, args);
        }
        catch (ScriptException e) {
            throw new RuleException("Could not execute CEL script", (Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuleException) {
                throw (RuleException)e.getCause();
            }
            throw new RuleException("Could not get expression", e.getCause());
        }
    }

    private static Map<String, Decl> toDecls(Map<String, Object> args) {
        return args.entrySet().stream().map(e -> Decls.newVar((String)((String)e.getKey()), (Type)CelExecutor.findType(e.getValue()))).collect(Collectors.toMap(Decl::getName, e -> e));
    }

    private static Type findType(Object arg) {
        if (arg == null) {
            return Checked.checkedNull;
        }
        if (arg instanceof GenericContainer) {
            return CelExecutor.findTypeForAvroType(((GenericContainer)arg).getSchema());
        }
        if (arg instanceof Message) {
            return Decls.newObjectType((String)((Message)arg).getDescriptorForType().getFullName());
        }
        return CelExecutor.findTypeForClass(arg.getClass());
    }

    private static Type findTypeForAvroType(Schema schema) {
        Schema.Type type = schema.getType();
        switch (type) {
            case BOOLEAN: {
                return Checked.checkedBool;
            }
            case INT: 
            case LONG: {
                return Checked.checkedInt;
            }
            case BYTES: 
            case FIXED: {
                return Checked.checkedBytes;
            }
            case FLOAT: 
            case DOUBLE: {
                return Checked.checkedDouble;
            }
            case STRING: {
                return Checked.checkedString;
            }
            case ARRAY: {
                return Checked.checkedListDyn;
            }
            case MAP: {
                return Checked.checkedMapStringDyn;
            }
            case ENUM: {
                return Decls.newObjectType((String)schema.getFullName());
            }
            case NULL: {
                return Checked.checkedNull;
            }
            case RECORD: {
                return Decls.newObjectType((String)schema.getFullName());
            }
            case UNION: {
                if (schema.getTypes().size() == 2 && schema.getTypes().contains(AvroTypeDescription.NULL_AVRO_SCHEMA)) {
                    for (Schema memberSchema : schema.getTypes()) {
                        if (memberSchema.equals((Object)AvroTypeDescription.NULL_AVRO_SCHEMA)) continue;
                        return CelExecutor.findTypeForAvroType(memberSchema);
                    }
                }
                throw new IllegalArgumentException("Unsupported union type");
            }
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(type));
    }

    private static Type findTypeForClass(Class<?> type) {
        Class<?> rawClass = type;
        if (rawClass == Boolean.TYPE || rawClass == Boolean.class) {
            return Checked.checkedBool;
        }
        if (rawClass == Long.TYPE || rawClass == Long.class || rawClass == Integer.TYPE || rawClass == Integer.class || rawClass == Short.TYPE || rawClass == Short.class || rawClass == Byte.TYPE || rawClass == Byte.class) {
            return Checked.checkedInt;
        }
        if (rawClass == byte[].class || rawClass == ByteString.class) {
            return Checked.checkedBytes;
        }
        if (rawClass == Double.TYPE || rawClass == Double.class || rawClass == Float.TYPE || rawClass == Float.class) {
            return Checked.checkedDouble;
        }
        if (rawClass == String.class) {
            return Checked.checkedString;
        }
        if (rawClass == Duration.class || rawClass == java.time.Duration.class) {
            return Checked.checkedDuration;
        }
        if (rawClass == Timestamp.class || Instant.class.isAssignableFrom(rawClass) || ZonedDateTime.class.isAssignableFrom(rawClass)) {
            return Checked.checkedTimestamp;
        }
        if (Map.class.isAssignableFrom(rawClass)) {
            return Checked.checkedMapStringDyn;
        }
        if (List.class.isAssignableFrom(rawClass)) {
            return Checked.checkedListDyn;
        }
        return Decls.newObjectType((String)rawClass.getName());
    }

    static {
        mapper.registerModule((Module)new ProtobufModule());
    }

    static enum ScriptType {
        AVRO,
        JSON,
        PROTOBUF;

    }

    static class RuleWithArgs {
        private final String rule;
        private final ScriptType type;
        private final Map<String, Decl> decls;
        private Schema avroSchema;
        private Class<?> jsonClass;
        private Descriptors.Descriptor protobufDesc;

        public RuleWithArgs(String rule, ScriptType type, Map<String, Decl> decls, Schema avroSchema) {
            this.rule = rule;
            this.type = type;
            this.decls = decls;
            this.avroSchema = avroSchema;
        }

        public RuleWithArgs(String rule, ScriptType type, Map<String, Decl> decls, Class<?> jsonClass) {
            this.rule = rule;
            this.type = type;
            this.decls = decls;
            this.jsonClass = jsonClass;
        }

        public RuleWithArgs(String rule, ScriptType type, Map<String, Decl> decls, Descriptors.Descriptor protobufDesc) {
            this.rule = rule;
            this.type = type;
            this.decls = decls;
            this.protobufDesc = protobufDesc;
        }

        public String getRule() {
            return this.rule;
        }

        public ScriptType getType() {
            return this.type;
        }

        public Map<String, Decl> getDecls() {
            return this.decls;
        }

        public Schema getAvroSchema() {
            return this.avroSchema;
        }

        public Class<?> getJsonClass() {
            return this.jsonClass;
        }

        public Descriptors.Descriptor getProtobufDesc() {
            return this.protobufDesc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleWithArgs that = (RuleWithArgs)o;
            return Objects.equals(this.rule, that.rule) && this.type == that.type && Objects.equals(this.decls, that.decls) && Objects.equals(this.avroSchema, that.avroSchema) && Objects.equals(this.jsonClass, that.jsonClass) && Objects.equals(this.protobufDesc, that.protobufDesc);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.rule, this.type, this.decls, this.avroSchema, this.jsonClass, this.protobufDesc});
        }
    }
}

