/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.cli;

import com.github.rvesse.airline.annotations.Cli;
import com.github.rvesse.airline.help.Help;
import io.confluent.connect.hub.cli.ExitCode;
import io.confluent.connect.hub.cli.commands.InstallCommand;
import io.confluent.connect.hub.exceptions.ConfluentHubClientException;
import io.confluent.connect.hub.utils.IOUtils;
import java.util.concurrent.Callable;

@Cli(description="Confluent Hub Client", name="confluent-hub", commands={InstallCommand.class, Help.class}, defaultCommand=Help.class)
public class ConfluentHubClient {
    public static void main(String[] args) {
        try {
            com.github.rvesse.airline.Cli cli = new com.github.rvesse.airline.Cli(ConfluentHubClient.class);
            Callable cmd = (Callable)cli.parse(args);
            ExitCode exitCode = (ExitCode)((Object)cmd.call());
            if (null == exitCode) {
                System.exit(ExitCode.SUCCESSFUL_COMPLETION.getCode());
            } else {
                System.exit(exitCode.getCode());
            }
        }
        catch (ConfluentHubClientException e) {
            IOUtils.error(e.getMessage(), new Object[0]);
            IOUtils.error(e.getCause().getMessage(), new Object[0]);
            System.exit(e.getExitCode().getCode());
        }
        catch (Exception e) {
            IOUtils.error(e.getMessage(), new Object[0]);
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                IOUtils.error(e.getCause().getMessage(), new Object[0]);
            }
            System.exit(ExitCode.UNKNOWN_ERROR.getCode());
        }
    }
}

