/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.cli;

public enum ExitCode {
    SUCCESSFUL_COMPLETION(0, "Successful completion"),
    COMPONENT_NOT_FOUND(1, "Component not found, specify either valid name from Confluent Hub in format: <owner>/<name>:<version:latest> or path to a local file"),
    INVALID_OPTS_OR_ARGS(2, "Invalid options or arguments"),
    NETWORK_PROBLEMS(3, "Network problems"),
    FS_RW(4, "Error while reading from/writing to filesystem"),
    SECURITY_ISSUES(5, "Security issues"),
    ALREADY_INSTALLED(6, "Component is already installed"),
    IS_NOT_AVAILABLE_FOR_INSTALLATION(8, "Component is not available for installation yet"),
    CANCELLED_BY_USER(9, "Action was cancelled by user"),
    ENTRY_OUTSIDE_TARGET_DIR(10, "Entry is outside the target directory."),
    UNKNOWN_ERROR(7, "Unknown error");

    private final int code;
    private final String description;

    private ExitCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static class Constants {
        public static final String SUCCESSFUL_COMPLETION_DESC = "Successful completion";
        public static final int SUCCESSFUL_COMPLETION_CODE = 0;
        public static final String COMPONENT_NOT_FOUND_DESC = "Component not found, specify either valid name from Confluent Hub in format: <owner>/<name>:<version:latest> or path to a local file";
        public static final int COMPONENT_NOT_FOUND_CODE = 1;
        public static final String INVALID_OPTS_OR_ARGS_DESC = "Invalid options or arguments";
        public static final int INVALID_OPTS_OR_ARGS_CODE = 2;
        public static final String NETWORK_PROBLEMS_DESC = "Network problems";
        public static final int NETWORK_PROBLEMS_CODE = 3;
        public static final String FS_RW_DESC = "Error while reading from/writing to filesystem";
        public static final int FS_RW_CODE = 4;
        public static final String SECURITY_ISSUES_DESC = "Security issues";
        public static final int SECURITY_ISSUES_CODE = 5;
        public static final String ALREADY_INSTALLED_DESC = "Component is already installed";
        public static final int ALREADY_INSTALLED_CODE = 6;
        public static final String UNKNOWN_ERROR_DESC = "Unknown error";
        public static final int UNKNOWN_ERROR_CODE = 7;
        public static final int IS_NOT_AVAILABLE_FOR_INSTALLATION_CODE = 8;
        public static final String IS_NOT_AVAILABLE_FOR_INSTALLATION_DESC = "Component is not available for installation yet";
        public static final int CANCELLED_BY_USER_CODE = 9;
        public static final String CANCELLED_BY_USER_DESC = "Action was cancelled by user";
        public static final int ENTRY_OUTSIDE_TARGET_DIR_CODE = 10;
        public static final String ENTRY_OUTSIDE_TARGET_DIR_DESC = "Entry is outside the target directory.";
    }
}

