/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.rest;

import io.confluent.connect.hub.cli.ExitCode;
import io.confluent.connect.hub.exceptions.ConfluentHubClientException;
import io.confluent.connect.hub.rest.Repository;
import io.confluent.pluginregistry.rest.entities.PluginManifest;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.net.ssl.SSLHandshakeException;

public class PluginRegistryRepository
implements Repository {
    private static final String UNABLE_TO_FIND_COMPONENT = "Unable to find a component";
    private static final String UNABLE_TO_VERIFY_HUB_IDENTITY = "Unable to verify Confluent Hub's identity";
    private final WebTarget pluginRegistryTarget;

    public PluginRegistryRepository(String pluginRegistryUrl) {
        this.pluginRegistryTarget = ClientBuilder.newBuilder().build().target(pluginRegistryUrl);
    }

    private Response processResource(Response response) {
        try {
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                    throw new ConfluentHubClientException(UNABLE_TO_FIND_COMPONENT, ExitCode.COMPONENT_NOT_FOUND);
                }
                throw new ConfluentHubClientException("Unable to read resource from Web", ExitCode.UNKNOWN_ERROR);
            }
        }
        catch (ConfluentHubClientException e) {
            throw e;
        }
        catch (ProcessingException e) {
            this.processingFailed(e);
        }
        catch (Exception e) {
            throw new ConfluentHubClientException("Unable to read resource from Web", e, ExitCode.NETWORK_PROBLEMS);
        }
        return response;
    }

    private void processingFailed(ProcessingException e) {
        if (e.getCause() instanceof SSLHandshakeException) {
            throw new ConfluentHubClientException(UNABLE_TO_VERIFY_HUB_IDENTITY, ExitCode.SECURITY_ISSUES);
        }
        throw e;
    }

    private InputStream getResourceAsStream(Response response) {
        Response resource = this.processResource(response);
        InputStream is = (InputStream)resource.readEntity(InputStream.class);
        return is;
    }

    @Override
    public PluginManifest getManifest(String path) {
        PluginManifest pluginManifest;
        block8: {
            Response response = this.pluginRegistryTarget.path(path).request().get();
            InputStream is = this.getResourceAsStream(response);
            try {
                PluginManifest manifest;
                pluginManifest = manifest = PluginManifest.fromJson(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfluentHubClientException("Unable to parse manifest", ExitCode.UNKNOWN_ERROR);
                }
            }
            is.close();
        }
        return pluginManifest;
    }

    @Override
    public InputStream getArchiveContent(URI uri) {
        WebTarget archiveTarget = ClientBuilder.newBuilder().build().target(uri);
        Response response = archiveTarget.request().get();
        return this.getResourceAsStream(response);
    }
}

