/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry;

import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.Serializable;
import java.util.Objects;

public class PluginId
implements Comparable<PluginId>,
Serializable {
    private final String owner;
    private final String name;
    private final String version;

    public PluginId(String owner, String name, String version) {
        Objects.requireNonNull(owner, "Plugin owner cannot be null");
        Objects.requireNonNull(owner, "Plugin name cannot be null");
        this.owner = owner.trim();
        this.name = name.trim();
        if (version != null && (version = version.trim()).isEmpty()) {
            version = null;
        }
        this.version = version;
    }

    public String owner() {
        return this.owner;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.name, this.version);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PluginId that = (PluginId)obj;
        return ObjectUtil.equals(this.owner, that.owner) && ObjectUtil.equals(this.name, that.name) && ObjectUtil.equals(this.version, that.version);
    }

    @Override
    public int compareTo(PluginId that) {
        if (that == null) {
            return 1;
        }
        int diff = ObjectUtil.compareTo(this.owner, that.owner);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.name, that.name);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.version, that.version);
        return diff;
    }

    public String toString() {
        return this.owner + "/" + this.name + (String)(this.version != null ? "/" + this.version : "");
    }
}

