/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.pluginregistry.PluginId;
import io.confluent.pluginregistry.rest.entities.DynamicPluginAttributesMetadata;
import io.confluent.pluginregistry.rest.entities.PluginStatistics;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DynamicPluginAttributes
implements Comparable<DynamicPluginAttributes> {
    @JsonProperty(value="metadata")
    private DynamicPluginAttributesMetadata metadata;
    private Map<PluginId, PluginStatistics> pluginAttributes;

    public static DynamicPluginAttributes fromJson(String json) throws IOException {
        return (DynamicPluginAttributes)JsonUtil.newObjectMapper().readValue(json, DynamicPluginAttributes.class);
    }

    public static DynamicPluginAttributes fromJson(InputStream json) throws IOException {
        return (DynamicPluginAttributes)JsonUtil.newObjectMapper().readValue(json, DynamicPluginAttributes.class);
    }

    public DynamicPluginAttributes() {
    }

    public DynamicPluginAttributes(DynamicPluginAttributesMetadata metadata, Map<String, Map<String, Map<String, PluginStatistics>>> pluginAttributes) {
        this.metadata = metadata;
        this.setPluginAttributes(pluginAttributes);
    }

    public DynamicPluginAttributes(DynamicPluginAttributes original) {
        this.metadata = original.metadata;
        this.pluginAttributes = new HashMap<PluginId, PluginStatistics>(original.pluginAttributes);
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public DynamicPluginAttributesMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(DynamicPluginAttributesMetadata metadata) {
        this.metadata = metadata;
    }

    public Map<PluginId, PluginStatistics> getPluginAttributes() {
        return new HashMap<PluginId, PluginStatistics>(this.pluginAttributes);
    }

    @JsonProperty(value="plugins")
    public Map<String, Map<String, Map<String, PluginStatistics>>> getOriginalPluginAttributes() {
        HashMap<String, Map<String, Map<String, PluginStatistics>>> result = new HashMap<String, Map<String, Map<String, PluginStatistics>>>();
        this.pluginAttributes.forEach((id, attributes) -> result.computeIfAbsent(id.owner(), owner -> new HashMap()).computeIfAbsent(id.name(), name -> new HashMap()).put(id.version(), attributes));
        return result;
    }

    @JsonProperty(value="plugins")
    public void setPluginAttributes(Map<String, Map<String, Map<String, PluginStatistics>>> pluginAttributes) {
        this.pluginAttributes = new HashMap<PluginId, PluginStatistics>();
        pluginAttributes.forEach((owner, byVersionByName) -> byVersionByName.forEach((pluginName, byVersion) -> byVersion.forEach((version, attributes) -> this.pluginAttributes.put(new PluginId((String)owner, (String)pluginName, (String)version), (PluginStatistics)attributes))));
    }

    public PluginStatistics getInjectablePluginAttributes(PluginId pluginId) {
        return this.pluginAttributes.get(pluginId);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.pluginAttributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicPluginAttributes that = (DynamicPluginAttributes)o;
        return ObjectUtil.equals(this.metadata, that.metadata) && ObjectUtil.equals(this.pluginAttributes, that.pluginAttributes);
    }

    @Override
    public int compareTo(DynamicPluginAttributes that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int diff = ObjectUtil.compareTo(this.metadata, that.metadata);
        if (diff != 0) {
            return diff;
        }
        diff = this.pluginAttributes.size() - that.pluginAttributes.size();
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{metadata=" + String.valueOf(this.metadata) + "}");
        return sb.toString();
    }
}

