/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonPropertyOrder(value={"namespace", "name", "tag", "registries"})
public class PluginDockerImage
implements Comparable<PluginDockerImage> {
    @JsonProperty
    private String namespace;
    @JsonProperty
    private String name;
    @JsonProperty
    private String tag;
    private List<String> registries;

    public static PluginDockerImage fromJson(String json) throws IOException {
        return (PluginDockerImage)JsonUtil.newObjectMapper().readValue(json, PluginDockerImage.class);
    }

    public PluginDockerImage() {
    }

    public PluginDockerImage(String namespace, String name, String tag, List<String> registries) {
        this.namespace = namespace;
        this.name = name;
        this.tag = tag;
        this.registries = registries;
    }

    public PluginDockerImage(PluginDockerImage original) {
        this.namespace = original.namespace;
        this.name = original.name;
        this.tag = original.tag;
        this.setRegistries(original.registries);
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    @JsonSetter(value="label")
    public void setLabel(String label) {
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @JsonProperty(value="registry")
    public List<String> getRegistries() {
        return this.registries;
    }

    @JsonProperty(value="registry")
    public void setRegistries(List<String> registries) {
        this.registries = registries != null ? new ArrayList<String>(registries) : null;
    }

    public void setRegistries(String ... registries) {
        this.setRegistries(Arrays.asList(registries));
    }

    public int hashCode() {
        int result = this.namespace != null ? this.namespace.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginDockerImage that = (PluginDockerImage)o;
        return ObjectUtil.equals(this.namespace, that.namespace) && ObjectUtil.equals(this.name, that.name) && ObjectUtil.equals(this.tag, that.tag) && ObjectUtil.equals(this.registries, that.registries);
    }

    @Override
    public int compareTo(PluginDockerImage that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int diff = ObjectUtil.compareTo(this.namespace, that.namespace);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.name, that.name);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.tag, that.tag);
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{namespace=" + this.namespace + ",");
        sb.append("name=" + this.name + ",");
        sb.append("tag=" + this.tag + ",");
        sb.append("registry=" + String.valueOf(this.registries) + "}");
        return sb.toString();
    }
}

