/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class ObjectUtil {
    public static <T extends Comparable<T>, V extends Comparable<V>> int compareTo(Map<T, V> o1, Map<T, V> o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (!o2.keySet().containsAll(o1.keySet())) {
            return 1;
        }
        if (!o1.keySet().containsAll(o2.keySet())) {
            return -1;
        }
        ArrayList<T> orderedKeys = new ArrayList<T>(o1.keySet());
        Collections.sort(orderedKeys);
        for (Comparable key : orderedKeys) {
            Comparable v2;
            Comparable v1 = (Comparable)o1.get(key);
            int diff = ObjectUtil.compareTo(v1, v2 = (Comparable)o2.get(key));
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public static <T extends Comparable<T>> int compareTo(Collection<T> o1, Collection<T> o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        Iterator<T> iter1 = o1.iterator();
        Iterator<T> iter2 = o2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            Comparable v2;
            Comparable v1 = (Comparable)iter1.next();
            int diff = ObjectUtil.compareTo(v1, v2 = (Comparable)iter2.next());
            if (diff == 0) continue;
            return diff;
        }
        if (iter1.hasNext()) {
            return 1;
        }
        if (iter2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T extends Comparable<T>> int compareTo(T o1, T o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    public static <T> int compareTo(T o1, T o2, Comparator<T> comparator) {
        return Objects.compare(o1, o2, comparator);
    }

    public static boolean equals(Object o1, Object o2) {
        return Objects.equals(o1, o2);
    }
}

