/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import com.google.common.collect.ImmutableMap;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.TenantUtils;
import io.confluent.kafka.multitenant.TopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.multitenant.quota.TenantQuotaCallback;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaEntity;
import kafka.server.DynamicQuotaChannelManager;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.jdk.CollectionConverters;

@Tag(value="integration")
public class MultiTenantQuotaIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    private final double defaultControllerMutationRateQuota = 100.0;
    private final double defaultProducerIdRateQuota = 10.0;
    private final double defaultProduceQuotaMultiplier = 2.0;
    private final String topicName = "_confluent-logical_clusters";

    @Override
    protected Properties nodeProps() {
        Properties props = super.nodeProps();
        props.put("client.quota.callback.class", TenantQuotaCallback.class.getName());
        return props;
    }

    @Override
    protected void createPhysicalAndLogicalClusters(Properties brokerProperties) {
        brokerProperties.put("confluent.cluster.link.replication.quota.mode", ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND.name());
        try {
            this.physicalCluster = this.testHarness.startWithTopic("_confluent-logical_clusters", 1, 1, 60000L, brokerProperties, brokerProperties, Optional.of(Time.SYSTEM));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.logicalCluster1 = this.physicalCluster.createLogicalCluster("lkc-tenant1", 100, 9, 11, 12);
        this.logicalCluster2 = this.physicalCluster.createLogicalCluster("lkc-tenant2", 200, 9, 21, 22);
    }

    protected void createPhysicalAndLogicalClustersWithControllerProperties(Properties brokerProperties, Properties controllerProperties) throws Exception {
        brokerProperties.put("confluent.cluster.link.replication.quota.mode", ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND.name());
        this.physicalCluster = this.testHarness.startWithTopic("_confluent-logical_clusters", 1, 1, 15000L, brokerProperties, controllerProperties, Optional.of(Time.SYSTEM));
        this.logicalCluster1 = this.physicalCluster.createLogicalCluster("lkc-tenant1", 100, 9, 11, 12);
        this.logicalCluster2 = this.physicalCluster.createLogicalCluster("lkc-tenant2", 200, 9, 21, 22);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDynamicTenantControllerQuota(String quorum) throws Exception {
        this.setUp();
        Properties props = this.nodeProps();
        props.put("confluent.quota.tenant.default.controller.mutation.rate", String.valueOf(100.0));
        props.put("confluent.quota.tenant.produce.multiplier", String.valueOf(2.0));
        this.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("test_topic", Optional.of(5), Optional.empty()))).all().get();
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, quotaTags, 100.0);
        double updatedControllerMutationRateQuota = 200.0;
        this.updateBrokerConfig(new ConfigEntry("confluent.quota.tenant.default.controller.mutation.rate", String.valueOf(updatedControllerMutationRateQuota)));
        this.verifyQuotaCallbackLimit(ClientQuotaType.CONTROLLER_MUTATION, quotaTags, updatedControllerMutationRateQuota);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("test_topic2", Optional.of(5), Optional.empty()))).all().get();
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, quotaTags, updatedControllerMutationRateQuota);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDynamicTenantProducerIdQuota(String quorum) throws Throwable {
        this.setUp();
        Properties props = this.nodeProps();
        props.put("confluent.producer.id.quota.manager.enable", String.valueOf(true));
        props.put("confluent.quota.tenant.default.producer.id.rate", String.valueOf(10.0));
        this.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("test_topic", Optional.of(5), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "test_topic", "group1", 0, false);
        this.verifyQuota(ClientQuotaType.PRODUCER_ID, quotaTags, 10.0);
        double updatedProducerIdRateQuota = 20.0;
        this.updateBrokerConfig(new ConfigEntry("confluent.quota.tenant.default.producer.id.rate", String.valueOf(updatedProducerIdRateQuota)));
        this.verifyQuotaCallbackLimit(ClientQuotaType.PRODUCER_ID, quotaTags, updatedProducerIdRateQuota);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("test_topic2", Optional.of(5), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "test_topic2", "group1", 0, false);
        this.verifyQuota(ClientQuotaType.PRODUCER_ID, quotaTags, updatedProducerIdRateQuota);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDynamicQuotaMultiplier(String quorum) throws Throwable {
        this.setUp();
        Properties props = this.nodeProps();
        props.put("confluent.quota.tenant.default.controller.mutation.rate", String.valueOf(100.0));
        props.put("confluent.quota.tenant.produce.multiplier", String.valueOf(2.0));
        this.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        this.addLkcFileAndSyncMetadata(KafkaLogicalClusterUtils.LC_META_1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic", Optional.of(5), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0, false);
        double expectedProduceQuota = 2.0 * (double)KafkaLogicalClusterUtils.LC_META_1.producerByteRate().longValue() / 2.0;
        double expectedFetchQuota = (double)KafkaLogicalClusterUtils.LC_META_1.consumerByteRate().longValue() / 2.0;
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, expectedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, expectedFetchQuota);
        double updatedFetchMultiplier = 3.0;
        double updatedProduceMultiplier = 1.0;
        this.updateBrokerConfig(new ConfigEntry("confluent.quota.tenant.fetch.multiplier", String.valueOf(updatedFetchMultiplier)));
        this.updateBrokerConfig(new ConfigEntry("confluent.quota.tenant.produce.multiplier", String.valueOf(updatedProduceMultiplier)));
        double updatedProduceQuota = updatedProduceMultiplier * (double)KafkaLogicalClusterUtils.LC_META_1.producerByteRate().longValue() / 2.0;
        double updatedFetchQuota = updatedFetchMultiplier * (double)KafkaLogicalClusterUtils.LC_META_1.consumerByteRate().longValue() / 2.0;
        this.verifyQuotaCallbackLimit(ClientQuotaType.PRODUCE, quotaTags, updatedProduceQuota);
        this.verifyQuotaCallbackLimit(ClientQuotaType.FETCH, quotaTags, updatedFetchQuota);
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0, false);
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, updatedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, updatedFetchQuota);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDynamicQuotaPipeline(String quorum) throws Throwable {
        this.setUp();
        Properties props = this.nodeProps();
        props.put(KafkaConfig.DynamicQuotaEnabledProp(), String.valueOf(true));
        props.put(KafkaConfig.QuotasTopicReplicationFactorProp(), (Object)2);
        props.put("confluent.quota.dynamic.reporting.interval.ms", (Object)1000);
        props.put("confluent.quota.dynamic.publishing.interval.ms", (Object)4000);
        props.put("confluent.enable.broker.reporting.min.usage.mode", (Object)false);
        this.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
        List channelManagers = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (DynamicQuotaChannelManager)kafkaServer.dynamicQuotaChannelManager().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> channelManagers.stream().allMatch(channelManager -> channelManager.getPublishRequestThread().started() && channelManager.getReportRequestThread().started()), (String)"Dynamic quota channel manager should have been started");
        List quotaCoordinators = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (QuotaCoordinator)kafkaServer.quotaCoordinatorOpt().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> quotaCoordinators.stream().allMatch(quotaCoordinator -> quotaCoordinator.isActive().get()), (String)"Quota coordinator should have been started");
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        this.addLkcFileAndSyncMetadata(KafkaLogicalClusterUtils.LC_META_1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic", Optional.of(5), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0, false);
        double expectedProduceQuota = (double)KafkaLogicalClusterUtils.LC_META_1.producerByteRate().longValue() / 2.0;
        double expectedFetchQuota = (double)KafkaLogicalClusterUtils.LC_META_1.consumerByteRate().longValue() / 2.0;
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, expectedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, expectedFetchQuota);
        TestUtils.waitForCondition(() -> channelManagers.stream().anyMatch(channelManager -> channelManager.getReportRequestThread().queuePerNode().nonEmpty()), (String)"Dynamic quota channel manager should have received a Reporting request");
        TestUtils.waitForCondition(() -> quotaCoordinators.stream().anyMatch(quotaCoordinator -> quotaCoordinator.quotaStateManager().getQuota(new QuotaEntity(this.toScalaMap(quotaTags))).nonEmpty()), (String)"Quota coordinator should have recomputed the quota");
        TestUtils.waitForCondition(() -> channelManagers.stream().anyMatch(channelManager -> channelManager.getPublishRequestThread().queuePerNode().nonEmpty()), (String)"Dynamic quota channel manager should send a Publishing request");
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, quota -> quota != expectedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, quota -> quota != expectedFetchQuota);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDynamicQuotaPipelineTopicBased(String quorum) throws Throwable {
        this.topicBasedClusterSetup(true, false);
        List channelManagers = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (DynamicQuotaChannelManager)kafkaServer.dynamicQuotaChannelManager().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> channelManagers.stream().allMatch(channelManager -> channelManager.getPublishRequestThread().started() && channelManager.getReportRequestThread().started()), (String)"Dynamic quota channel manager should have been started");
        List quotaCoordinators = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (QuotaCoordinator)kafkaServer.quotaCoordinatorOpt().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> quotaCoordinators.stream().allMatch(quotaCoordinator -> quotaCoordinator.isActive().get()), (String)"Quota coordinator should have been started");
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        this.addLkcMsgsAndSyncMetadata(1000);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic", Optional.of(5), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0, false);
        double expectedProduceQuota = (double)KafkaLogicalClusterUtils.LC_META_1.producerByteRate().longValue() / 2.0;
        double expectedFetchQuota = (double)KafkaLogicalClusterUtils.LC_META_1.consumerByteRate().longValue() / 2.0;
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, expectedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, expectedFetchQuota);
        TestUtils.waitForCondition(() -> channelManagers.stream().anyMatch(channelManager -> channelManager.getReportRequestThread().queuePerNode().nonEmpty()), (String)"Dynamic quota channel manager should have received a Reporting request");
        TestUtils.waitForCondition(() -> quotaCoordinators.stream().anyMatch(quotaCoordinator -> quotaCoordinator.quotaStateManager().getQuota(new QuotaEntity(this.toScalaMap(quotaTags))).nonEmpty()), (String)"Quota coordinator should have recomputed the quota");
        TestUtils.waitForCondition(() -> channelManagers.stream().anyMatch(channelManager -> channelManager.getPublishRequestThread().queuePerNode().nonEmpty()), (String)"Dynamic quota channel manager should send a Publishing request");
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, quota -> quota != expectedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, quota -> quota != expectedFetchQuota);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDynamicQuotaPipelineTopicBasedWithMaxElasticCKU(String quorum) throws Throwable {
        this.topicBasedClusterSetup(false, true);
        List quotaCoordinators = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (QuotaCoordinator)kafkaServer.quotaCoordinatorOpt().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> quotaCoordinators.stream().allMatch(quotaCoordinator -> quotaCoordinator.isActive().get()), (String)"Quota coordinator should have been started");
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster3.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster3);
        double expectedProduceQuota = 2621440.0;
        double expectedFetchQuota = 2621440.0;
        this.addLkcMsgsAndSyncMetadata(1000);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic1", Optional.of(2), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster3.user(31), this.logicalCluster3.user(31), "testtopic1", "group1", 0, false);
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, expectedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, expectedFetchQuota);
        this.updateMaxECKUTo3Fortenant(1100);
        this.testHarness.produce(this.logicalCluster3.user(31), "testtopic1", 0, false);
        expectedProduceQuota = 7864320.0;
        expectedFetchQuota = 7864320.0;
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, expectedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, expectedFetchQuota);
        this.updateMaxECKUTo2Fortenant(1200);
        this.testHarness.produce(this.logicalCluster3.user(31), "testtopic1", 0, false);
        expectedProduceQuota = 5242880.0;
        expectedFetchQuota = 5242880.0;
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, expectedFetchQuota);
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, expectedProduceQuota);
        this.updateInvalidEckuFortenant(1300);
        this.testHarness.produce(this.logicalCluster3.user(31), "testtopic1", 0, false);
        expectedProduceQuota = 1.31072E7;
        expectedFetchQuota = 1.31072E7;
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, expectedFetchQuota);
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, expectedProduceQuota);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testProducerIdThrottling(String quorum) throws Throwable {
        this.setUp(1, Collections.emptyList());
        Properties props = this.nodeProps();
        int producerIdQuotaRate = 1;
        props.put("confluent.producer.id.quota.manager.enable", String.valueOf(true));
        props.put("confluent.producer.id.throttle.enable", String.valueOf(true));
        props.put("confluent.producer.id.cache.limit", (Object)100);
        props.put("confluent.producer.id.throttle.enable.threshold.percentage", (Object)0);
        props.put("confluent.quota.tenant.default.producer.id.rate", (Object)producerIdQuotaRate);
        this.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        this.addLkcFileAndSyncMetadata(KafkaLogicalClusterUtils.LC_META_1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic", Optional.of(1), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0, false);
        this.verifyQuota(ClientQuotaType.PRODUCER_ID, quotaTags, producerIdQuotaRate);
        int producersCreated = this.createProducersUntilProduceIdThrottled(this.logicalCluster1.user(12), "testtopic");
        this.verifyThrottle(ClientQuotaType.PRODUCER_ID, quotaTags, true);
        this.verifyCount(ClientQuotaType.PRODUCER_ID, quotaTags, producersCreated + 1);
    }

    protected void createPhysicalAndLogicalClustersWithTopic(Properties brokerProps, Properties controllerProps) throws ExecutionException, InterruptedException {
        this.physicalCluster = this.testHarness.startWithTopic("_confluent-logical_clusters", 1, 1, 15000L, brokerProps, controllerProps);
        String lkcId = KafkaLogicalClusterUtils.LC_META_1.logicalClusterId();
        String xyzId = KafkaLogicalClusterUtils.LC_META_XYZ.logicalClusterId();
        String lkc11Id = KafkaLogicalClusterUtils.LC_TENANT_WITH_1_MAX_ECKU.logicalClusterId();
        this.logicalCluster1 = this.physicalCluster.createLogicalCluster(lkcId, 100, 9, 11, 12);
        this.logicalCluster2 = this.physicalCluster.createLogicalCluster(xyzId, 200, 9, 21, 22);
        this.logicalCluster3 = this.physicalCluster.createLogicalCluster(lkc11Id, 300, 9, 31, 32);
    }

    protected void addLkcMsgsAndSyncMetadata(int baseSequenceId) throws InterruptedException {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkcId = KafkaLogicalClusterUtils.LC_META_1.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1, lkcId, KafkaLogicalClusterUtils.LC_META_1);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) != null), (String)"Expected metadata to get consumed");
        String xyzId = KafkaLogicalClusterUtils.LC_META_XYZ.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 2, xyzId, KafkaLogicalClusterUtils.LC_META_XYZ);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(xyzId) != null), (String)"Expected metadata to get consumed");
        String lkc11Id = KafkaLogicalClusterUtils.LC_TENANT_WITH_1_MAX_ECKU.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 3, lkc11Id, KafkaLogicalClusterUtils.LC_TENANT_WITH_1_MAX_ECKU);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkc11Id) != null), (String)"Expected metadata to get consumed");
    }

    protected void updateLkcMeta1WithEckuMetadata(int baseSequenceId) throws InterruptedException {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkcId = KafkaLogicalClusterUtils.LC_META_1_WITH_1_ECKU.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1, lkcId, KafkaLogicalClusterUtils.LC_META_1_WITH_1_ECKU);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) != null), (String)"Expected metadata to get consumed");
    }

    protected void updateActiveLkcWithNullEckuMetadata(int baseSequenceId) throws InterruptedException {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkcId = KafkaLogicalClusterUtils.LC_WITH_NULL_ECKU_DEFN.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1, lkcId, KafkaLogicalClusterUtils.LC_WITH_NULL_ECKU_DEFN);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) != null), (String)"Expected metadata to get consumed");
    }

    protected void updateActiveLkcWithInvalidEckuMetadata(int baseSequenceId) throws InterruptedException {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkcId = KafkaLogicalClusterUtils.LC_WITH_INVALID_ECKU_DEFN.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1, lkcId, KafkaLogicalClusterUtils.LC_WITH_INVALID_ECKU_DEFN);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) != null), (String)"Expected metadata to get consumed");
    }

    protected void updateInActiveLkcWithInvalidEckuMetadata(int baseSequenceId) throws InterruptedException {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkcId = KafkaLogicalClusterUtils.DEACTIVATED_LC_WITH_INVALID_ECKU_DEFN.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1, lkcId, KafkaLogicalClusterUtils.DEACTIVATED_LC_WITH_INVALID_ECKU_DEFN);
    }

    protected void updateLkcMeta1WithoutEckuMetadata(int baseSequenceId) throws InterruptedException {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkcId = KafkaLogicalClusterUtils.LC_META_1_WITH_1_ECKU.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1, lkcId, KafkaLogicalClusterUtils.LC_META_1);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) != null), (String)"Expected metadata to get consumed");
    }

    protected void updateMaxECKUTo3Fortenant(int baseSequenceId) throws InterruptedException {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkc11Id = KafkaLogicalClusterUtils.LC_TENANT_WITH_3_MAX_ECKU.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 5, lkc11Id, KafkaLogicalClusterUtils.LC_TENANT_WITH_3_MAX_ECKU);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkc11Id) != null), (String)"Expected metadata to get consumed");
    }

    protected void updateMaxECKUTo2Fortenant(int baseSequenceId) throws InterruptedException {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkc11Id = KafkaLogicalClusterUtils.LC_TENANT_WITH_2_MAX_ECKU.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 7, lkc11Id, KafkaLogicalClusterUtils.LC_TENANT_WITH_2_MAX_ECKU);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkc11Id) != null), (String)"Expected metadata to get consumed");
    }

    protected void updateInvalidEckuFortenant(int baseSequenceId) throws InterruptedException {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkc11Id = KafkaLogicalClusterUtils.LC_TENANT_WITH_INVALID_ECKU.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 9, lkc11Id, KafkaLogicalClusterUtils.LC_TENANT_WITH_INVALID_ECKU);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkc11Id) != null), (String)"Expected metadata to get consumed");
    }

    protected void deleteLogicalClusters(int baseSequenceId) throws InterruptedException {
        String lkcid = KafkaLogicalClusterUtils.LC_META_TENANT1_DELETED.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 2, lkcid, KafkaLogicalClusterUtils.LC_META_TENANT1_DELETED);
        lkcid = KafkaLogicalClusterUtils.LC_META_XYZ_DELETED.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 2, lkcid, KafkaLogicalClusterUtils.LC_META_XYZ_DELETED);
        lkcid = KafkaLogicalClusterUtils.LC_META_1_WITH_1_MAX_ECKU_WITH_DELETED.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1, lkcid, KafkaLogicalClusterUtils.LC_META_1_WITH_1_MAX_ECKU_WITH_DELETED);
    }

    public Map<String, Object> eckuNodeProps() {
        return Stream.of({"client.quota.callback.class", TenantQuotaCallback.class.getName()}, {"confluent.cdc.lkc.metadata.topic", "_confluent-logical_clusters"}, {"multitenant.metadata.class", TopicBasedPhysicalClusterMetadata.class.getName()}).collect(Collectors.toMap(prop -> prop[0].toString(), prop -> prop[1]));
    }

    public void topicBasedClusterSetup(boolean enableDynamicQuota, boolean enableElasticCKU) throws Exception {
        Properties props = new Properties();
        props.put(KafkaConfig.DynamicQuotaEnabledProp(), String.valueOf(enableDynamicQuota));
        props.put(KafkaConfig.QuotasTopicReplicationFactorProp(), (Object)2);
        props.put(KafkaConfig.ElasticCkuEnabledProp(), (Object)enableElasticCKU);
        props.put("confluent.quota.dynamic.reporting.interval.ms", (Object)1000);
        props.put("confluent.quota.dynamic.publishing.interval.ms", (Object)4000);
        props.put("confluent.enable.broker.reporting.min.usage.mode", (Object)false);
        props.putAll(this.eckuNodeProps());
        Properties controllerProps = new Properties();
        controllerProps.putAll(this.eckuNodeProps());
        this.testHarness = new IntegrationTestHarness(this.testInfo, 2);
        this.createPhysicalAndLogicalClustersWithTopic(props, controllerProps);
        this.awaitMetadataPropagation();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testElasticCkuCount(String quorum) throws Throwable {
        this.topicBasedClusterSetup(true, true);
        List channelManagers = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (DynamicQuotaChannelManager)kafkaServer.dynamicQuotaChannelManager().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> channelManagers.stream().allMatch(channelManager -> channelManager.getPublishRequestThread().started() && channelManager.getReportRequestThread().started()), (String)"Dynamic quota channel manager should have been started");
        List quotaCoordinators = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (QuotaCoordinator)kafkaServer.quotaCoordinatorOpt().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> quotaCoordinators.stream().allMatch(quotaCoordinator -> quotaCoordinator.isActive().get()), (String)"Quota coordinator should have been started");
        this.addLkcMsgsAndSyncMetadata(1000);
        this.verifyElasticCkuMetric(KafkaLogicalClusterUtils.LC_TENANT_WITH_1_MAX_ECKU.logicalClusterId());
        this.verifyElasticCkuMetricNotPresent(KafkaLogicalClusterUtils.LC_META_1.logicalClusterId());
        this.verifyElasticCkuMetricNotPresent(KafkaLogicalClusterUtils.LC_META_XYZ.logicalClusterId());
        this.updateLkcMeta1WithEckuMetadata(1500);
        this.verifyElasticCkuMetric(KafkaLogicalClusterUtils.LC_META_1.logicalClusterId());
        this.updateLkcMeta1WithoutEckuMetadata(2000);
        this.verifyElasticCkuMetricNotPresent(KafkaLogicalClusterUtils.LC_META_1.logicalClusterId());
        this.deleteLogicalClusters(2500);
        this.awaitMetadataPropagation();
        this.verifyElasticCkuMetricNotPresent(KafkaLogicalClusterUtils.LC_META_1.logicalClusterId());
        this.verifyElasticCkuMetricNotPresent(KafkaLogicalClusterUtils.LC_TENANT_WITH_1_MAX_ECKU.logicalClusterId());
        this.verifyElasticCkuMetricNotPresent(KafkaLogicalClusterUtils.LC_META_XYZ.logicalClusterId());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testInvalidElasticCkuMetadataMetric(String quorum) throws Throwable {
        this.topicBasedClusterSetup(true, true);
        List channelManagers = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (DynamicQuotaChannelManager)kafkaServer.dynamicQuotaChannelManager().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> channelManagers.stream().allMatch(channelManager -> channelManager.getPublishRequestThread().started() && channelManager.getReportRequestThread().started()), (String)"Dynamic quota channel manager should have been started");
        List quotaCoordinators = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (QuotaCoordinator)kafkaServer.quotaCoordinatorOpt().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> quotaCoordinators.stream().allMatch(quotaCoordinator -> quotaCoordinator.isActive().get()), (String)"Quota coordinator should have been started");
        this.addLkcMsgsAndSyncMetadata(1000);
        this.verifyElasticCkuMetric(KafkaLogicalClusterUtils.LC_TENANT_WITH_1_MAX_ECKU.logicalClusterId());
        Utils.verifyInvalidECkuMetadataMetricNotPresent(KafkaLogicalClusterUtils.LC_TENANT_WITH_1_MAX_ECKU.logicalClusterId());
        this.updateActiveLkcWithNullEckuMetadata(1500);
        this.verifyElasticCkuMetricNotPresent(KafkaLogicalClusterUtils.LC_WITH_NULL_ECKU_DEFN.logicalClusterId());
        Utils.verifyInvalidECkuMetadataMetricNotPresent(KafkaLogicalClusterUtils.LC_WITH_NULL_ECKU_DEFN.logicalClusterId());
        this.updateActiveLkcWithInvalidEckuMetadata(1600);
        this.verifyElasticCkuMetric(KafkaLogicalClusterUtils.LC_WITH_INVALID_ECKU_DEFN.logicalClusterId());
        Utils.verifyInvalidECkuMetadataMetricPresent(KafkaLogicalClusterUtils.LC_WITH_INVALID_ECKU_DEFN.logicalClusterId());
        this.updateInActiveLkcWithInvalidEckuMetadata(1610);
        this.awaitMetadataPropagation();
        this.verifyElasticCkuMetricNotPresent(KafkaLogicalClusterUtils.DEACTIVATED_LC_WITH_INVALID_ECKU_DEFN.logicalClusterId());
        Utils.verifyInvalidECkuMetadataMetricNotPresent(KafkaLogicalClusterUtils.DEACTIVATED_LC_WITH_INVALID_ECKU_DEFN.logicalClusterId());
    }

    private void verifyElasticCkuMetricNotPresent(String lkcId) throws InterruptedException {
        String name = "ElasticCku";
        String type = "QuotaStateManager";
        Map metricsMap = KafkaYammerMetrics.defaultRegistry().allMetrics();
        TestCondition condition = () -> metricsMap.entrySet().stream().filter(e -> {
            MetricName metricName = (MetricName)e.getKey();
            return metricName.getName().equals(name) && metricName.getType().equals(type) && metricName.getMBeanName().contains(String.format("%s=%s", "tenant", lkcId));
        }).count() == 0L;
        TestUtils.waitForCondition((TestCondition)condition, (String)("E-CKU metric should not be present for " + lkcId));
    }

    private void verifyElasticCkuMetric(String lkcId) throws InterruptedException {
        String name = "ElasticCku";
        String type = "QuotaStateManager";
        Map metricsMap = KafkaYammerMetrics.defaultRegistry().allMetrics();
        TestCondition condition = () -> metricsMap.entrySet().stream().filter(e -> {
            MetricName metricName = (MetricName)e.getKey();
            return metricName.getName().equals(name) && metricName.getType().equals(type) && metricName.getMBeanName().contains(String.format("%s=%s", "tenant", lkcId));
        }).filter(e -> {
            Gauge metricValue = (Gauge)e.getValue();
            return metricValue != null && (Double)metricValue.value() >= 0.0;
        }).count() > 0L;
        TestUtils.waitForCondition((TestCondition)condition, (String)("E-CKU metric is not present for " + lkcId));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testNonCompactedTenantPartitionCountMetric(String quorum) throws Throwable {
        this.setUp();
        Properties props = this.nodeProps();
        TenantUtils.setTenantPartitionCountUpdateThresholdInMs((Long)0L);
        props.put(KafkaConfig.ElasticCkuEnabledProp(), (Object)true);
        this.createPhysicalAndLogicalClustersWithControllerProperties(props, props);
        this.awaitMetadataPropagation();
        String nonCompactedMetricName = "PartitionCountNonCompacted";
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        this.addLkcFileAndSyncMetadata(KafkaLogicalClusterUtils.LC_META_1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic1", Optional.of(5), Optional.empty()))).all().get();
        this.verifyPartitionCountMetric(this.logicalCluster1.logicalClusterId(), 5L, nonCompactedMetricName);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic2", Optional.of(5), Optional.empty()))).all().get();
        this.verifyPartitionCountMetric(this.logicalCluster1.logicalClusterId(), 10L, nonCompactedMetricName);
        tenantAdminClient.deleteTopics(Collections.singleton("testtopic1")).all().get();
        this.verifyPartitionCountMetric(this.logicalCluster1.logicalClusterId(), 5L, nonCompactedMetricName);
        tenantAdminClient.deleteTopics(Collections.singleton("testtopic2")).all().get();
        this.verifyPartitionCountMetric(this.logicalCluster1.logicalClusterId(), 0L, nonCompactedMetricName);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testCompactedTenantPartitionCountMetric(String quorum) throws Throwable {
        this.setUp();
        Properties props = this.nodeProps();
        TenantUtils.setTenantPartitionCountUpdateThresholdInMs((Long)0L);
        props.put(KafkaConfig.ElasticCkuEnabledProp(), (Object)true);
        this.createPhysicalAndLogicalClustersWithControllerProperties(props, props);
        this.awaitMetadataPropagation();
        String compactedMetricName = "PartitionCountCompacted";
        ImmutableMap compactedPartitionConfig = ImmutableMap.of((Object)"cleanup.policy", (Object)"compact");
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        this.addLkcFileAndSyncMetadata(KafkaLogicalClusterUtils.LC_META_1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic1", Optional.of(5), Optional.empty()).configs((Map)compactedPartitionConfig))).all().get();
        this.verifyPartitionCountMetric(this.logicalCluster1.logicalClusterId(), 5L, compactedMetricName);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic2", Optional.of(5), Optional.empty()).configs((Map)compactedPartitionConfig))).all().get();
        this.verifyPartitionCountMetric(this.logicalCluster1.logicalClusterId(), 10L, compactedMetricName);
        tenantAdminClient.deleteTopics(Collections.singleton("testtopic1")).all().get();
        this.verifyPartitionCountMetric(this.logicalCluster1.logicalClusterId(), 5L, compactedMetricName);
        tenantAdminClient.deleteTopics(Collections.singleton("testtopic2")).all().get();
        this.verifyPartitionCountMetric(this.logicalCluster1.logicalClusterId(), 0L, compactedMetricName);
    }

    private void verifyPartitionCountMetric(String lkcId, Long expectedPartitionCount, String partitionCountMetricName) throws InterruptedException {
        String type = "TenantMetricsPublisher";
        Map metricsMap = KafkaYammerMetrics.defaultRegistry().allMetrics();
        TestCondition condition = () -> metricsMap.entrySet().stream().filter(e -> {
            MetricName metricName = (MetricName)e.getKey();
            return metricName.getName().equals(partitionCountMetricName) && metricName.getType().equals(type) && metricName.getMBeanName().endsWith(String.format("%s=%s", "tenant", lkcId));
        }).filter(e -> {
            Gauge metricValue = (Gauge)e.getValue();
            return metricValue != null && (Long)metricValue.value() >= 0L && ((Long)metricValue.value()).longValue() == expectedPartitionCount.longValue();
        }).count() > 0L;
        TestUtils.waitForCondition((TestCondition)condition, (String)("Partition count metric is not present for " + lkcId));
    }

    private int createProducersUntilProduceIdThrottled(LogicalClusterUser user, String topic) {
        boolean throttled;
        int numCreated = 0;
        do {
            try (KafkaProducer<String, String> producer = this.createProducer(user);){
                String payload = String.valueOf(++numCreated);
                Future future = producer.send(new ProducerRecord(topic, null, (Object)payload, (Object)payload), (Callback)new ErrorLoggingCallback(topic, null, null, true));
                do {
                    throttled = this.isProducerIdThrottled();
                } while (!future.isDone() && !throttled);
            }
        } while (!throttled);
        return numCreated;
    }

    private boolean isProducerIdThrottled() {
        Map<String, String> tags = this.quotaTags(this.logicalCluster1);
        Map<Integer, Metrics> metricsByNodeId = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().collect(Collectors.toMap(broker -> broker.config().brokerId(), broker -> broker.metrics()));
        Predicate<KafkaMetric> isThrottled = metric -> metric != null && (Double)metric.metricValue() > 0.0;
        Predicate<Map> predicate = d -> d.values().stream().anyMatch(isThrottled);
        TestCondition condition = () -> predicate.test(metricsByNodeId.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> this.quotaMetric((Metrics)entry.getValue(), "throttle-time", ClientQuotaType.PRODUCER_ID, tags))));
        try {
            return condition.conditionMet();
        }
        catch (Exception err) {
            return false;
        }
    }

    private KafkaProducer<String, String> createProducer(LogicalClusterUser logicalCluster) {
        Properties overrideProps = new Properties();
        overrideProps.put("client.id", logicalCluster.logicalClusterId);
        return KafkaTestUtils.createProducer(this.physicalCluster.bootstrapServers(), SecurityProtocol.SASL_PLAINTEXT, ScramMechanism.SCRAM_SHA_256.mechanismName(), logicalCluster.saslJaasConfig(), overrideProps);
    }

    private void updateBrokerConfig(ConfigEntry configToSet) throws Exception {
        AdminClient internalAdminClient = this.physicalCluster.superAdminClient();
        internalAdminClient.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(configToSet, AlterConfigOp.OpType.SET)))).all().get();
    }

    private Map<String, String> quotaTags(LogicalCluster logicalCluster) {
        return Collections.singletonMap("tenant", logicalCluster.logicalClusterId());
    }

    private <T> scala.collection.mutable.Map<T, T> toScalaMap(Map<T, T> map) {
        return CollectionConverters.MapHasAsScala(map).asScala();
    }
}

