/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.token;

import io.confluent.kafka.server.plugins.auth.token.CompositeBearerValidatorCallbackHandler;
import io.confluent.kafka.server.plugins.auth.token.IdentityProviderService;
import io.confluent.kafka.test.utils.TokenTestUtils;
import io.confluent.security.authentication.http.HttpClient;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Form;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CompositeBearerValidatorCallbackHandlerTest {
    private TokenTestUtils.JwsContainer jwsContainer;
    private final String defaultIssuer = "Confluent";
    private String defaultSubject = "Customer";
    private static final String CONFLUENT_VALIDATOR_ERROR_MESSAGE = "Authentication failed";
    private static final String IDP_VALIDATOR_ERROR_MESSAGE = "invalid_token";
    private static final String REALM_CONFIG_PATH = "/CompositeBearerValidatorRealm.json";
    private Map<String, Object> configs;
    private static final IdentityProviderService IDP_SERVICE = new IdentityProviderService("/CompositeBearerValidatorRealm.json");

    @BeforeAll
    public static void beforeAll() {
        IDP_SERVICE.setStartupTimeout(Duration.ofMinutes(20L));
        IDP_SERVICE.start();
    }

    @AfterAll
    public static void afterAll() {
        IDP_SERVICE.shutdown();
        System.clearProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls");
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.configs = new HashMap<String, Object>();
        this.configs.put("sasl.oauthbearer.jwks.endpoint.url", IDP_SERVICE.getJwksEndpoint());
        this.configs.put("sasl.oauthbearer.expected.audience", "account");
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", IDP_SERVICE.getJwksEndpoint());
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testAttachesConfluentJws() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, "Confluent", this.defaultSubject);
        CompositeBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.token());
        Assertions.assertEquals((Object)this.jwsContainer.getJwsToken(), (Object)callback.token().value());
        Assertions.assertNull((Object)callback.errorStatus());
    }

    @Test
    public void testAttachesIdpJws() throws Exception {
        CompositeBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        String idpJwt = this.getJwtFromIdp("clusterAdmin1", "clusterAdmin1");
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(idpJwt);
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.token());
        Assertions.assertEquals((Object)idpJwt, (Object)callback.token().value());
        Assertions.assertNull((Object)callback.errorStatus());
    }

    @Test
    public void testConfigureRaisesExceptionWhenInvalidKeyPath() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, "Confluent", this.defaultSubject);
        Map<String, String> options = this.baseOptions();
        options.put("publicKeyPath", this.jwsContainer.getPublicKeyFile().getAbsolutePath() + "/invalid!");
        Assertions.assertThrows(ConfigException.class, () -> this.createCallbackHandler(options));
    }

    @Test
    public void testConfigureRaisesExceptionWhenInvalidJWKSUrl() throws Exception {
        Map<String, String> options = this.baseOptions();
        this.configs.put("sasl.oauthbearer.jwks.endpoint.url", "xyz");
        Assertions.assertThrows(ConfigException.class, () -> this.createCallbackHandler(options));
    }

    @Test
    public void testErrorWhenInvalidConfluentJws() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, "Confluent", this.defaultSubject);
        TokenTestUtils.writePemFile(this.jwsContainer.getPublicKeyFile(), TokenTestUtils.generateKeyPair().getPublic());
        CompositeBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.errorStatus());
        Assertions.assertEquals((Object)CONFLUENT_VALIDATOR_ERROR_MESSAGE, (Object)callback.errorStatus());
    }

    @Test
    public void testErrorWhenInvalidIdpJws() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, "AWS", this.defaultSubject);
        CompositeBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.errorStatus());
        Assertions.assertEquals((Object)IDP_VALIDATOR_ERROR_MESSAGE, (Object)callback.errorStatus());
    }

    @Test
    public void testErrorWhenExpiredConfluentJws() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(50, "Confluent", this.defaultSubject);
        Thread.sleep(100L);
        CompositeBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.errorStatus());
        Assertions.assertEquals((Object)CONFLUENT_VALIDATOR_ERROR_MESSAGE, (Object)callback.errorStatus());
    }

    @Test
    public void testErrorWhenExpiredIdpJws() throws Exception {
        String idpJwt = this.getJwtFromIdp("clusterAdmin1", "clusterAdmin1");
        System.out.println(idpJwt);
        Thread.sleep(40000L);
        CompositeBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(idpJwt);
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.errorStatus());
        Assertions.assertEquals((Object)IDP_VALIDATOR_ERROR_MESSAGE, (Object)callback.errorStatus());
    }

    @Test
    public void testErrorIfMissingSubject() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, "Confluent", null);
        CompositeBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.errorStatus());
        Assertions.assertEquals((Object)CONFLUENT_VALIDATOR_ERROR_MESSAGE, (Object)callback.errorStatus());
    }

    @Test
    public void testErrorIfNoExpirationTime() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(null, "Confluent", this.defaultSubject);
        CompositeBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.errorStatus());
        Assertions.assertEquals((Object)CONFLUENT_VALIDATOR_ERROR_MESSAGE, (Object)callback.errorStatus());
    }

    private CompositeBearerValidatorCallbackHandler createCallbackHandler(Map<String, ?> options) {
        TestJaasConfig config = new TestJaasConfig();
        config.createOrUpdateEntry("Kafka", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule", options);
        ConfigDef configDef = new ConfigDef();
        SaslConfigs.addClientSaslSupport((ConfigDef)configDef);
        AbstractConfig configsWithDefaults = new AbstractConfig(configDef, this.configs);
        CompositeBearerValidatorCallbackHandler callbackHandler = new CompositeBearerValidatorCallbackHandler();
        callbackHandler.configure(configsWithDefaults.values(), "OAUTHBEARER", Collections.singletonList(config.getAppConfigurationEntry("Kafka")[0]));
        return callbackHandler;
    }

    private Map<String, String> baseOptions() throws Exception {
        if (this.jwsContainer == null) {
            this.jwsContainer = TokenTestUtils.setUpJws(36000, "Confluent", this.defaultSubject);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("publicKeyPath", this.jwsContainer.getPublicKeyFile().getAbsolutePath());
        options.put("audience", String.join((CharSequence)",", new CharSequence[0]));
        return options;
    }

    private String getJwtFromIdp(String clientId, String clientSecret) throws Exception {
        String encodedCredentials = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8));
        Form payload = new Form().param("grant_type", "client_credentials");
        HttpClient httpClient = HttpClient.builder().build();
        return httpClient.target(URI.create(IDP_SERVICE.getTokenEndpoint())).request().header("Authorization", (Object)("Basic " + encodedCredentials)).accept(new String[]{"application/json"}).rx().post(Entity.entity((Object)payload, (String)"application/x-www-form-urlencoded")).thenApply(response -> (Map)response.readEntity(Map.class)).thenApply(map -> (String)map.get("access_token")).toCompletableFuture().get();
    }
}

