/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.ssl;

import io.confluent.kafka.server.plugins.ssl.ConfluentTrustManager;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kafka.server.ssl.CertificateIdsJsonConfig;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfluentTrustManagerTest {
    protected static final String CN = "*.us-west-2.aws.confluent.cloud";
    protected static final String OTHER_CN = "*.us-west-1.aws.confluent.cloud";
    protected static final String[] SUBJECT_ALT_DNS_NAMES = new String[]{"*.us-west-1.aws.devel.cpdev.cloud", "*.us-west-2.aws.devel.cpdev.cloud"};
    protected Map<String, String> brokerConfigs = new HashMap<String, String>();
    protected ConfluentTrustManager trustManager;
    private X509Certificate revokedCert1;
    private X509Certificate revokedCert2;
    private X509Certificate revokedCert3;

    @BeforeEach
    public void setUp() throws Exception {
        this.revokedCert1 = this.buildCert(CN, SUBJECT_ALT_DNS_NAMES);
        this.revokedCert2 = this.buildCert(CN, SUBJECT_ALT_DNS_NAMES);
        this.revokedCert3 = this.buildCert(OTHER_CN, SUBJECT_ALT_DNS_NAMES);
        CertificateIdsJsonConfig[] certificateIdsJsonConfigs = new CertificateIdsJsonConfig[]{new CertificateIdsJsonConfig(this.revokedCert1.getIssuerX500Principal().getName(), Arrays.asList(this.revokedCert1.getSerialNumber().toString(16), this.revokedCert2.getSerialNumber().toString(16))), new CertificateIdsJsonConfig(this.revokedCert3.getIssuerX500Principal().getName().toLowerCase(Locale.ROOT), Collections.singletonList(this.revokedCert3.getSerialNumber().toString(16)))};
        String revokedCertificateIdsAsString = CertificateIdsJsonConfig.toJson((CertificateIdsJsonConfig[])certificateIdsJsonConfigs);
        this.brokerConfigs.put("confluent.security.revoked.certificate.ids", revokedCertificateIdsAsString);
        this.createTrustManager();
    }

    protected void createTrustManager() {
        this.trustManager = new ConfluentTrustManager(this.brokerConfigs, null);
    }

    @Test
    public void testEmptySubjectAltNames() throws Exception {
        X509Certificate certificate = this.buildCert(CN, new String[0]);
        Assertions.assertTrue((boolean)this.trustManager.getSubjectAltNames(certificate).isEmpty());
    }

    @Test
    public void testGetSubjectAltNames() throws Exception {
        X509Certificate certificate = this.buildCert(CN, SUBJECT_ALT_DNS_NAMES);
        List expectedSubjectAltNames = this.trustManager.getSubjectAltNames(certificate);
        Arrays.stream(SUBJECT_ALT_DNS_NAMES).forEach(s -> Assertions.assertTrue((boolean)expectedSubjectAltNames.contains(s)));
    }

    @Test
    public void testIsConfluentCert() throws Exception {
        Assertions.assertTrue((boolean)this.trustManager.isConfluentCert(this.buildCert(CN, SUBJECT_ALT_DNS_NAMES)));
        Assertions.assertTrue((boolean)this.trustManager.isConfluentCert(this.buildCert(CN, "localhost", SUBJECT_ALT_DNS_NAMES[0])));
        Assertions.assertFalse((boolean)this.trustManager.isConfluentCert(this.buildCert(CN, new String[0])));
        Assertions.assertFalse((boolean)this.trustManager.isConfluentCert(this.buildCert(CN, "localhost")));
    }

    @Test
    public void testVerifyCerts() throws Exception {
        Assertions.assertTrue((boolean)this.trustManager.verifyClientCerts(new X509Certificate[]{this.buildCert(CN, SUBJECT_ALT_DNS_NAMES)}));
        Assertions.assertTrue((boolean)this.trustManager.verifyClientCerts(new X509Certificate[]{this.buildCert("localhost", new String[0]), this.buildCert(CN, SUBJECT_ALT_DNS_NAMES)}));
        Assertions.assertTrue((boolean)this.trustManager.verifyClientCerts(new X509Certificate[]{this.buildCert("localhost", "localhost"), this.buildCert(CN, SUBJECT_ALT_DNS_NAMES), this.buildCert("localhost", new String[0])}));
    }

    @Test
    public void testVerifyCertsFails() throws Exception {
        this.verifyCertsFailure(new X509Certificate[]{this.buildCert("localhost", new String[0])});
        this.verifyCertsFailure(new X509Certificate[0]);
        this.verifyCertsFailure(new X509Certificate[]{this.buildCert(CN, new String[0])});
        this.verifyCertsFailure(new X509Certificate[]{this.buildCert(CN, "localhost")});
        this.verifyCertsFailure(new X509Certificate[]{this.revokedCert1});
        this.verifyCertsFailure(new X509Certificate[]{this.revokedCert2});
        this.verifyCertsFailure(new X509Certificate[]{this.revokedCert3});
    }

    @Test
    public void testRevokedCertIds() {
        this.brokerConfigs.put("confluent.security.revoked.certificate.ids", "");
        Assertions.assertTrue((boolean)this.trustManager.revokedCertificateIds(this.brokerConfigs).isEmpty());
        this.brokerConfigs.put("confluent.security.revoked.certificate.ids", " ");
        Assertions.assertTrue((boolean)this.trustManager.revokedCertificateIds(this.brokerConfigs).isEmpty());
        this.brokerConfigs.put("confluent.security.revoked.certificate.ids", "[]");
        Assertions.assertTrue((boolean)this.trustManager.revokedCertificateIds(this.brokerConfigs).isEmpty());
    }

    protected void verifyCertsFailure(X509Certificate[] certs) {
        CertificateException ce = (CertificateException)Assertions.assertThrows(CertificateException.class, () -> this.trustManager.verifyClientCerts(certs));
        Assertions.assertTrue((boolean)ce.getMessage().equals("A trusted client certificate not found"));
    }

    protected X509Certificate buildCert(String subject, String ... subjectAltDnsNames) throws Exception {
        KeyPair keyPair = TestSslUtils.generateKeyPair((String)"RSA");
        TestSslUtils.CertificateBuilder certBuilder = new TestSslUtils.CertificateBuilder().sanDnsNames(subjectAltDnsNames);
        X509Certificate certificate = certBuilder.generate("CN=" + subject + ", O=A client", keyPair);
        return certificate;
    }
}

