/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.common;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.security.auth.oauth.mockserver.common.HttpUtil;
import io.confluent.security.auth.oauth.mockserver.common.LogUtil;
import io.confluent.security.auth.oauth.mockserver.common.MetricsHandler;
import io.confluent.security.auth.oauth.mockserver.common.PrincipalExtractor;
import io.confluent.security.auth.oauth.mockserver.common.TokenInfo;
import io.confluent.security.auth.oauth.mockserver.common.TokenIntrospection;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(OAuthAuthenticator.class);

    public static TokenInfo loginWithClientSecret(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String clientId, String clientSecret, boolean isJwt, PrincipalExtractor principalExtractor, String scope) throws IOException {
        return OAuthAuthenticator.loginWithClientSecret(tokenEndpointUrl, socketFactory, hostnameVerifier, clientId, clientSecret, isJwt, null, principalExtractor, scope, null, HttpUtil.DEFAULT_CONNECT_TIMEOUT, HttpUtil.DEFAULT_READ_TIMEOUT, null, 0, 0L);
    }

    public static TokenInfo loginWithClientSecret(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String clientId, String clientSecret, boolean isJwt, Map<String, Object> claims, PrincipalExtractor principalExtractor, String scope, String audience) throws IOException {
        return OAuthAuthenticator.loginWithClientSecret(tokenEndpointUrl, socketFactory, hostnameVerifier, clientId, clientSecret, isJwt, claims, principalExtractor, scope, audience, HttpUtil.DEFAULT_CONNECT_TIMEOUT, HttpUtil.DEFAULT_READ_TIMEOUT, null, 0, 0L);
    }

    public static TokenInfo loginWithClientSecret(URI tokenEndpointUrl, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String clientId, String clientSecret, boolean isJwt, Map<String, Object> claims, PrincipalExtractor principalExtractor, String scope, String audience, int connectTimeout, int readTimeout, MetricsHandler metrics, int retries, long retryPauseMillis) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("loginWithClientSecret() - tokenEndpointUrl: {}, clientId: {}, clientSecret: {}, scope: {}, audience: {}, connectTimeout: {}, readTimeout: {}, retries: {}, retryPauseMillis: {}", new Object[]{tokenEndpointUrl, clientId, LogUtil.mask(clientSecret), scope, audience, connectTimeout, readTimeout, retries, retryPauseMillis});
        }
        if (clientId == null) {
            throw new IllegalArgumentException("No clientId specified");
        }
        if (clientSecret == null) {
            clientSecret = "";
        }
        String authorization = "Basic " + OAuthAuthenticator.base64encode(clientId + ":" + clientSecret);
        StringBuilder body = new StringBuilder("grant_type=client_credentials");
        claims.forEach((k, v) -> body.append("&" + k + "=").append(v));
        if (scope != null) {
            body.append("&scope=").append(OAuthAuthenticator.urlencode(scope));
        }
        if (audience != null) {
            body.append("&audience=").append(OAuthAuthenticator.urlencode(audience));
        }
        return OAuthAuthenticator.post(tokenEndpointUrl, socketFactory, hostnameVerifier, authorization, body.toString(), isJwt, principalExtractor, connectTimeout, readTimeout, metrics, retries, retryPauseMillis);
    }

    private static TokenInfo post(URI tokenEndpointUri, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String authorization, String body, boolean isJwt, PrincipalExtractor principalExtractor, int connectTimeout, int readTimeout, MetricsHandler metrics, int retries, long retryPauseMillis) throws IOException {
        JsonNode result;
        try {
            result = HttpUtil.doWithRetries(retries, retryPauseMillis, metrics, () -> HttpUtil.post(tokenEndpointUri, socketFactory, hostnameVerifier, authorization, "application/x-www-form-urlencoded", body, JsonNode.class, connectTimeout, readTimeout));
        }
        catch (Throwable e) {
            Throwable cause = e;
            if (e instanceof ExecutionException) {
                cause = e.getCause();
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IllegalStateException("Unexpected exception while sending HTTP POST request", cause);
        }
        JsonNode token = result.get("access_token");
        if (token == null) {
            throw new IllegalStateException("Invalid response from authorization server: no access_token");
        }
        JsonNode expiresIn = result.get("expires_in");
        if (expiresIn == null) {
            throw new IllegalStateException("Invalid response from authorization server: no expires_in");
        }
        JsonNode scope = result.get("scope");
        if (isJwt) {
            try {
                return TokenIntrospection.introspectAccessToken(token.asText(), principalExtractor);
            }
            catch (Exception e) {
                log.debug("[IGNORED] Could not parse token as JWT access token. Could not extract subject.", (Throwable)e);
            }
        }
        long now = System.currentTimeMillis();
        return new TokenInfo(token.asText(), scope != null ? scope.asText() : null, "undefined", null, now, now + expiresIn.asLong() * 1000L);
    }

    public static String base64encode(String value) {
        return Base64.getUrlEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
    }

    public static String urlencode(String value) {
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected: Encoding utf-8 not supported");
        }
    }
}

