/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.provider.oauth;

import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.security.auth.provider.oauth.EnhancedOAuthBearerValidatorCallbackHandler;
import io.confluent.security.auth.provider.oauth.EnhancedOAuthBearerValidatorCallbackHandlerTest;
import io.confluent.security.store.KeyValueStore;
import io.confluent.security.test.utils.JwtTestUtils;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.callback.CallbackHandler;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="integration")
public class SaslOAuthIntegrationTest
extends EnhancedOAuthBearerValidatorCallbackHandlerTest {
    private static final Logger LOG = LoggerFactory.getLogger(SaslOAuthIntegrationTest.class);
    private final String keyId = "key-12345";
    private final String subject = "123456789";
    private final String testIssuerA = "https://test-issuer-a.com";
    private final String testIssuerB = "https://test-issuer-b.com";
    private final String jwksEndpointA = "https://test-issuer-a.com/json.jwks";
    private final String jwksEndpointB = "https://test-issuer-b.com/json.jwks";
    private static final String LKC_ID = KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId();
    private static final String ORG_RESOURCE_ID = KafkaLogicalClusterUtils.LC_META_ABC.organizationId();

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    public void testUnionOfPoolsEnabled_NoProvidedPools_Passes() throws Exception {
        String providerId = "op-abc";
        String poolA = "pool-a";
        String poolB = "pool-b";
        String poolC = "pool-c";
        PublicJsonWebKey key = this.generateKey("key-12345");
        String token = this.generateToken(key, "https://test-issuer-a.com", "123456789");
        this.configs.put("confluent.oauth.union.of.pools.enable", true);
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        OAuthBearerSaslServer saslServer = new OAuthBearerSaslServer((CallbackHandler)callbackHandler);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)new JsonWebKeySet(new JsonWebKey[]{key}));
        JwtTestUtils.updateIdentityProvider((KeyValueStore)this.authCache, (String)ORG_RESOURCE_ID, (String)providerId, (String)"sub", (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks");
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolA, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolA, (String)"true", (String)ORG_RESOURCE_ID);
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolB, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolB, (String)"false", (String)ORG_RESOURCE_ID);
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolC, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolC, (String)"true", (String)ORG_RESOURCE_ID);
        String authenticateRequest = this.getAuthenticateRequest(null, token);
        byte[] response = saslServer.evaluateResponse(authenticateRequest.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((int)response.length, (int)0);
        Assertions.assertEquals((Object)"OAuth-ClientCredentials", (Object)saslServer.getNegotiatedProperty("identityPoolId"));
        Assertions.assertEquals((Object)"123456789", (Object)saslServer.getNegotiatedProperty("identityPoolId-azp"));
        Assertions.assertEquals((Object)"OAuth-ClientCredentials", (Object)saslServer.getNegotiatedProperty("identityPoolId-sub"));
        Assertions.assertEquals((Object)"pool-c,pool-a", (Object)saslServer.getNegotiatedProperty("identityPoolId-identityPoolId"));
    }

    @Test
    public void testUnionOfPoolsEnabled_SingleProvidedPool_Passes() throws Exception {
        String providerId = "op-abc";
        String poolId = "pool-abc";
        PublicJsonWebKey key = this.generateKey("key-12345");
        String token = this.generateToken(key, "https://test-issuer-a.com", "123456789");
        this.configs.put("confluent.oauth.union.of.pools.enable", true);
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        OAuthBearerSaslServer saslServer = new OAuthBearerSaslServer((CallbackHandler)callbackHandler);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)new JsonWebKeySet(new JsonWebKey[]{key}));
        JwtTestUtils.updateIdentityProvider((KeyValueStore)this.authCache, (String)ORG_RESOURCE_ID, (String)providerId, (String)"sub", (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks");
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolId, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolId, (String)"true", (String)ORG_RESOURCE_ID);
        String authenticateRequest = this.getAuthenticateRequest(poolId, token);
        byte[] response = saslServer.evaluateResponse(authenticateRequest.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((int)response.length, (int)0);
        Assertions.assertEquals((Object)poolId, (Object)saslServer.getNegotiatedProperty("identityPoolId"));
        Assertions.assertEquals((Object)"123456789", (Object)saslServer.getNegotiatedProperty("identityPoolId-azp"));
        Assertions.assertEquals((Object)poolId, (Object)saslServer.getNegotiatedProperty("identityPoolId-sub"));
        Assertions.assertNull((Object)saslServer.getNegotiatedProperty("identityPoolId-identityPoolId"));
    }

    @Test
    public void testUnionOfPoolsEnabled_ExplicitProvidedPools_Passes() throws Exception {
        String providerId = "op-abc";
        String poolA = "pool-a";
        String poolB = "pool-b";
        String poolC = "pool-c";
        PublicJsonWebKey key = this.generateKey("key-12345");
        String token = this.generateToken(key, "https://test-issuer-a.com", "123456789");
        this.configs.put("confluent.oauth.union.of.pools.enable", true);
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        OAuthBearerSaslServer saslServer = new OAuthBearerSaslServer((CallbackHandler)callbackHandler);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)new JsonWebKeySet(new JsonWebKey[]{key}));
        JwtTestUtils.updateIdentityProvider((KeyValueStore)this.authCache, (String)ORG_RESOURCE_ID, (String)providerId, (String)"sub", (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks");
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolA, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolA, (String)"true", (String)ORG_RESOURCE_ID);
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolB, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolB, (String)"false", (String)ORG_RESOURCE_ID);
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolC, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolC, (String)"true", (String)ORG_RESOURCE_ID);
        String authenticateRequest = this.getAuthenticateRequest(String.format("%s,%s", poolB, poolC), token);
        byte[] response = saslServer.evaluateResponse(authenticateRequest.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((int)response.length, (int)0);
        Assertions.assertEquals((Object)"OAuth-ClientCredentials", (Object)saslServer.getNegotiatedProperty("identityPoolId"));
        Assertions.assertEquals((Object)"123456789", (Object)saslServer.getNegotiatedProperty("identityPoolId-azp"));
        Assertions.assertEquals((Object)"OAuth-ClientCredentials", (Object)saslServer.getNegotiatedProperty("identityPoolId-sub"));
        Assertions.assertEquals((Object)"pool-c", (Object)saslServer.getNegotiatedProperty("identityPoolId-identityPoolId"));
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolB, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolB, (String)"true", (String)ORG_RESOURCE_ID);
        response = saslServer.evaluateResponse(authenticateRequest.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((int)response.length, (int)0);
        Assertions.assertEquals((Object)"OAuth-ClientCredentials", (Object)saslServer.getNegotiatedProperty("identityPoolId"));
        Assertions.assertEquals((Object)"123456789", (Object)saslServer.getNegotiatedProperty("identityPoolId-azp"));
        Assertions.assertEquals((Object)"OAuth-ClientCredentials", (Object)saslServer.getNegotiatedProperty("identityPoolId-sub"));
        Assertions.assertEquals((Object)"pool-b,pool-c", (Object)saslServer.getNegotiatedProperty("identityPoolId-identityPoolId"));
    }

    @Test
    public void testUnionOfPoolsEnabled_ExplicitProvidedPoolsFromDifferentProviders_Fails() throws Exception {
        String providerA = "op-a";
        String providerB = "op-b";
        String poolA = "pool-a";
        String poolB = "pool-b";
        String poolC = "pool-c";
        PublicJsonWebKey key = this.generateKey("key-12345");
        String token = this.generateToken(key, "https://test-issuer-a.com", "123456789");
        this.configs.put("confluent.oauth.union.of.pools.enable", true);
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        OAuthBearerSaslServer saslServer = new OAuthBearerSaslServer((CallbackHandler)callbackHandler);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)new JsonWebKeySet(new JsonWebKey[]{key}));
        JwtTestUtils.updateIdentityProvider((KeyValueStore)this.authCache, (String)ORG_RESOURCE_ID, (String)providerA, (String)"sub", (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks");
        JwtTestUtils.updateIdentityProvider((KeyValueStore)this.authCache, (String)ORG_RESOURCE_ID, (String)providerB, (String)"sub", (String)"https://test-issuer-b.com", (String)"https://test-issuer-b.com/json.jwks");
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolA, (int)1, (String)"https://test-issuer-a.com", (String)providerA, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolA, (String)"true", (String)ORG_RESOURCE_ID);
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolB, (int)1, (String)"https://test-issuer-a.com", (String)providerA, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolB, (String)"false", (String)ORG_RESOURCE_ID);
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolC, (int)1, (String)"https://test-issuer-a.com", (String)providerB, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolC, (String)"true", (String)ORG_RESOURCE_ID);
        String authenticateRequest = this.getAuthenticateRequest(String.format("%s,%s,%s", poolA, poolB, poolC), token);
        SaslAuthenticationException exception = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> saslServer.evaluateResponse(authenticateRequest.getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((Object)exception.errorInfo().errorMessage(), (Object)"List of pools provided in sasl extension contains multiple providers");
    }

    @Test
    public void testUnionOfPoolsDisabled_ExplicitProvidedPools_Fails() throws Exception {
        String providerId = "op-abc";
        String poolA = "pool-a";
        String poolB = "pool-b";
        String poolC = "pool-c";
        PublicJsonWebKey key = this.generateKey("key-12345");
        String token = this.generateToken(key, "https://test-issuer-a.com", "123456789");
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        OAuthBearerSaslServer saslServer = new OAuthBearerSaslServer((CallbackHandler)callbackHandler);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)new JsonWebKeySet(new JsonWebKey[]{key}));
        JwtTestUtils.updateIdentityProvider((KeyValueStore)this.authCache, (String)ORG_RESOURCE_ID, (String)providerId, (String)"sub", (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks");
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolA, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolA, (String)"true", (String)ORG_RESOURCE_ID);
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolB, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolB, (String)"false", (String)ORG_RESOURCE_ID);
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolC, (int)1, (String)"https://test-issuer-a.com", (String)providerId, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolC, (String)"true", (String)ORG_RESOURCE_ID);
        String authenticateRequest = this.getAuthenticateRequest(String.format("%s,%s", poolB, poolC), token);
        SaslAuthenticationException exception = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> saslServer.evaluateResponse(authenticateRequest.getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((Object)exception.errorInfo().errorMessage(), (Object)"Invalid format found for pool id extension: pool-b,pool-c");
    }

    @Test
    public void testUnionOfPoolsDisabled_ExplicitProvidedPoolsFromDifferentProviders_Fails() throws Exception {
        String providerA = "op-a";
        String providerB = "op-b";
        String poolA = "pool-a";
        String poolB = "pool-b";
        String poolC = "pool-c";
        PublicJsonWebKey key = this.generateKey("key-12345");
        String token = this.generateToken(key, "https://test-issuer-a.com", "123456789");
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        OAuthBearerSaslServer saslServer = new OAuthBearerSaslServer((CallbackHandler)callbackHandler);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)new JsonWebKeySet(new JsonWebKey[]{key}));
        JwtTestUtils.updateIdentityProvider((KeyValueStore)this.authCache, (String)ORG_RESOURCE_ID, (String)providerA, (String)"sub", (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks");
        JwtTestUtils.updateIdentityProvider((KeyValueStore)this.authCache, (String)ORG_RESOURCE_ID, (String)providerB, (String)"sub", (String)"https://test-issuer-b.com", (String)"https://test-issuer-b.com/json.jwks");
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolA, (int)1, (String)"https://test-issuer-a.com", (String)providerA, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolA, (String)"true", (String)ORG_RESOURCE_ID);
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolB, (int)1, (String)"https://test-issuer-a.com", (String)providerA, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolB, (String)"false", (String)ORG_RESOURCE_ID);
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)poolC, (int)1, (String)"https://test-issuer-a.com", (String)providerB, (String)"https://test-issuer-a.com/json.jwks", (String)"sub", (String)poolC, (String)"true", (String)ORG_RESOURCE_ID);
        String authenticateRequest = this.getAuthenticateRequest(String.format("%s,%s,%s", poolA, poolB, poolC), token);
        SaslAuthenticationException exception = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> saslServer.evaluateResponse(authenticateRequest.getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((Object)exception.errorInfo().errorMessage(), (Object)"Invalid format found for pool id extension: pool-a,pool-b,pool-c");
    }

    private String getAuthenticateRequest(String poolId, String token) {
        if (poolId != null) {
            return String.format("n,,\u0001%s=%s\u0001%s=%s\u0001auth=Bearer %s\u0001\u0001", "logicalCluster", LKC_ID, "identityPoolId", poolId, token);
        }
        return String.format("n,,\u0001%s=%s\u0001auth=Bearer %s\u0001\u0001", "logicalCluster", LKC_ID, token);
    }

    private PublicJsonWebKey generateKey(String keyId) throws NoSuchAlgorithmException, JoseException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        PublicJsonWebKey rsaJsonWebKey = PublicJsonWebKey.Factory.newPublicJwk((Key)keyPair.getPublic());
        rsaJsonWebKey.setPrivateKey(keyPair.getPrivate());
        rsaJsonWebKey.setKeyId(keyId);
        return rsaJsonWebKey;
    }

    private String generateToken(PublicJsonWebKey key, String issuer, String subject) throws JoseException {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(issuer);
        claims.setExpirationTimeMinutesInTheFuture(60.0f);
        claims.setGeneratedJwtId();
        claims.setIssuedAtToNow();
        claims.setSubject(subject);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)key.getPrivateKey());
        jws.setKeyIdHeaderValue(key.getKeyId());
        jws.setAlgorithmHeaderValue("RS256");
        return jws.getCompactSerialization();
    }
}

