/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.server.metrics.ClientTopicMetricsManager;
import org.apache.kafka.server.quota.SensorAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformClientTopicMetricsManager
implements ClientTopicMetricsManager {
    private static final String CLIENT_ID_TAG = "client-id";
    private static final String GROUP = "ClientBrokerTopicMetrics";
    private static final String KEY_DELIMITER = ":";
    private static final String TOPIC_TAG = "topic";
    public static final String CLIENT_BYTES_IN_METRIC_NAME = "ClientBytesIn";
    public static final String CLIENT_BYTES_OUT_METRIC_NAME = "ClientBytesOut";
    public static final String CLIENT_RECORDS_IN_METRIC_NAME = "ClientRecordsIn";
    public static final String CLIENT_RECORDS_OUT_METRIC_NAME = "ClientRecordsOut";
    private final Map<String, SensorGroup> clientTopicSensors = new ConcurrentHashMap<String, SensorGroup>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Logger LOG = LoggerFactory.getLogger(PlatformClientTopicMetricsManager.class);
    private long maxClientTopicMetrics;
    private Metrics metrics = new Metrics();
    private final ScheduledThreadPoolExecutor expiredSensorCleanupTaskScheduler;
    private SensorAccess sensorAccess;
    private long sensorExpiryTimeSec;

    public PlatformClientTopicMetricsManager() {
        this.maxClientTopicMetrics = ConfluentConfigs.CLIENT_TOPIC_MAX_METRICS_COUNT_DEFAULT;
        this.sensorExpiryTimeSec = ConfluentConfigs.CLIENT_TOPIC_METRICS_EXPIRY_SEC_DEFAULT;
        this.expiredSensorCleanupTaskScheduler = new ScheduledThreadPoolExecutor(1);
        this.expiredSensorCleanupTaskScheduler.setThreadFactory(runnable -> KafkaThread.daemon((String)"ClientTopicMetricsManager-ExpiredSensorCleanupTaskThread", (Runnable)runnable));
        this.expiredSensorCleanupTaskScheduler.scheduleAtFixedRate(new ExpiredSensorCleanupTask(), 30L, 30L, TimeUnit.SECONDS);
        LOG.info("Initialized BrokerClientTopicMetricsManager with maxClientTopicConnections:{}, sensorExpiryTimeMs:{}", (Object)this.maxClientTopicMetrics, (Object)this.sensorExpiryTimeSec);
        this.sensorAccess = new SensorAccess((ReadWriteLock)this.lock, this.metrics);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        if (configs == null) {
            throw new IllegalArgumentException("Configs map cannot be null");
        }
        if (!configs.containsKey("metrics") || !(configs.get("metrics") instanceof Metrics)) {
            throw new IllegalArgumentException("Invalid or missing Metrics configuration");
        }
        this.metrics = (Metrics)configs.get("metrics");
        if (configs.containsKey("client-topic-metrics-max-count") && configs.get("client-topic-metrics-max-count") instanceof Long) {
            this.maxClientTopicMetrics = (Long)configs.get("client-topic-metrics-max-count");
        }
        if (configs.containsKey("client-topic-metrics-expiry-sec") && configs.get("client-topic-metrics-expiry-sec") instanceof Long) {
            this.sensorExpiryTimeSec = (Long)configs.get("client-topic-metrics-expiry-sec");
        }
        this.sensorAccess = new SensorAccess((ReadWriteLock)this.lock, this.metrics);
    }

    @Override
    public void recordMetricsIn(String clientId, String topic, long bytesIn, long messagesIn) {
        if (clientId != null && topic != null) {
            this.recordMetrics(clientId, topic, bytesIn, 0L, messagesIn, 0L, Role.PRODUCER);
        }
    }

    @Override
    public void recordMetricsOut(String clientId, String topic, long bytesOut, Supplier<Long> messagesOut) {
        if (clientId != null && topic != null) {
            this.recordMetrics(clientId, topic, 0L, bytesOut, 0L, messagesOut.get(), Role.CONSUMER);
        }
    }

    private void recordMetrics(String clientId, String topic, long bytesIn, long bytesOut, long messagesIn, long messagesOut, Role role) {
        String key = PlatformClientTopicMetricsManager.buildKey(clientId, topic, role);
        try {
            SensorGroup sensorGroup = this.clientTopicSensors.computeIfAbsent(key, k -> {
                if ((long)this.clientTopicSensors.size() >= this.maxClientTopicMetrics) {
                    LOG.debug("Quota violation detected while handling metrics for {}:{}", (Object)clientId, (Object)topic);
                    return null;
                }
                return this.getSensorGroup(clientId, topic, role);
            });
            if (sensorGroup == null) {
                LOG.debug("Could not find sensor group for {}:{}", (Object)clientId, (Object)topic);
                return;
            }
            PlatformClientTopicMetricsManager.recordIfValid(sensorGroup.bytesSensor, bytesIn, "bytesIn", clientId, topic);
            PlatformClientTopicMetricsManager.recordIfValid(sensorGroup.bytesSensor, bytesOut, "bytesOut", clientId, topic);
            PlatformClientTopicMetricsManager.recordIfValid(sensorGroup.recordsSensor, messagesIn, "messagesIn", clientId, topic);
            PlatformClientTopicMetricsManager.recordIfValid(sensorGroup.recordsSensor, messagesOut, "messagesOut", clientId, topic);
        }
        catch (Exception e) {
            LOG.debug("Exception raised while trying to record value for {}:{}", new Object[]{clientId, topic, e});
        }
    }

    private static boolean isValidSensor(Sensor sensor) {
        return sensor != null && !sensor.hasExpired();
    }

    private SensorGroup getSensorGroup(String clientId, String topic, Role role) {
        Map<String, String> tags = this.getTags(clientId, topic);
        String byteMetricName = role == Role.PRODUCER ? CLIENT_BYTES_IN_METRIC_NAME : CLIENT_BYTES_OUT_METRIC_NAME;
        String recordMetricName = role == Role.PRODUCER ? CLIENT_RECORDS_IN_METRIC_NAME : CLIENT_RECORDS_OUT_METRIC_NAME;
        Sensor clientBytesSensor = this.getSensor(byteMetricName, tags, this.sensorExpiryTimeSec, "Count client bytes");
        Sensor clientRecordsSensor = this.getSensor(recordMetricName, tags, this.sensorExpiryTimeSec, "Count client records");
        return new SensorGroup(clientBytesSensor, clientRecordsSensor);
    }

    private Sensor getSensor(String name, Map<String, String> tags, Long expiryTime, String description) {
        String sensorName = this.getSensorName(name, tags);
        MetricName metricName = this.metrics.metricName(name, GROUP, description, tags);
        return this.sensorAccess.getOrCreate(sensorName, expiryTime.longValue(), sensor -> sensor.add(metricName, (MeasurableStat)new CumulativeSum()));
    }

    private Map<String, String> getTags(String clientId, String topic) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(CLIENT_ID_TAG, clientId);
        tags.put(TOPIC_TAG, topic);
        return tags;
    }

    public String getSensorName(String metricName, Map<String, String> metricTags) {
        StringBuilder builder = new StringBuilder(metricName).append("Sensor");
        if (metricTags != null && !metricTags.isEmpty()) {
            metricTags.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> builder.append(KEY_DELIMITER).append((String)entry.getKey()).append("-").append((String)entry.getValue()));
        }
        return builder.toString();
    }

    @Override
    public void close() {
        this.expiredSensorCleanupTaskScheduler.shutdown();
        try {
            if (!this.expiredSensorCleanupTaskScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.expiredSensorCleanupTaskScheduler.shutdownNow();
            }
            LOG.info("Shutting down scheduler");
        }
        catch (InterruptedException e) {
            this.expiredSensorCleanupTaskScheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        LOG.info("Shutting down BrokerClientTopicMetrics sensor...");
        this.clientTopicSensors.values().forEach(sensorGroup -> {
            if (sensorGroup.bytesSensor != null) {
                this.metrics.removeSensor(sensorGroup.bytesSensor.name());
                LOG.info("Removed sensor {}", (Object)sensorGroup.bytesSensor.name());
            }
            if (sensorGroup.recordsSensor != null) {
                this.metrics.removeSensor(sensorGroup.recordsSensor.name());
                LOG.info("Removed sensor {}", (Object)sensorGroup.recordsSensor.name());
            }
        });
        this.clientTopicSensors.clear();
        LOG.info("All sensors and metrics have been removed successfully.");
    }

    public Map<String, SensorGroup> getSensorMap() {
        return this.clientTopicSensors;
    }

    public boolean isSchedulerShutdown() {
        return this.expiredSensorCleanupTaskScheduler.isShutdown();
    }

    public static String buildKey(String clientId, String topic, Role role) {
        return String.join((CharSequence)KEY_DELIMITER, clientId, topic, role.name());
    }

    private static void recordIfValid(Sensor sensor, double value, String metricType, String clientId, String topic) {
        if (!PlatformClientTopicMetricsManager.isValidSensor(sensor)) {
            LOG.debug("Could not record {} since sensor is not valid. {}:{}", new Object[]{metricType, clientId, topic});
        } else if (value > 0.0) {
            sensor.record(value);
        }
    }

    class ExpiredSensorCleanupTask
    implements Runnable {
        ExpiredSensorCleanupTask() {
        }

        @Override
        public void run() {
            try {
                StringBuilder logMessage = new StringBuilder("Expired sensors found: ");
                PlatformClientTopicMetricsManager.this.clientTopicSensors.entrySet().removeIf(entry -> {
                    boolean expired;
                    SensorGroup sensorGroup = (SensorGroup)entry.getValue();
                    boolean bl = expired = sensorGroup.bytesSensor.hasExpired() || sensorGroup.recordsSensor.hasExpired();
                    if (expired) {
                        logMessage.append(String.format("[%s, %s], ", sensorGroup.bytesSensor.name(), sensorGroup.recordsSensor.name()));
                    }
                    return expired;
                });
                if (logMessage.length() > "Expired sensors found: ".length()) {
                    LOG.info(logMessage.toString());
                }
            }
            catch (Exception e) {
                LOG.debug("ExpiredSensorCleanupTask encountered an error: ", (Throwable)e);
            }
        }
    }

    public static enum Role {
        CONSUMER,
        PRODUCER;

    }

    public static class SensorGroup {
        Sensor bytesSensor;
        Sensor recordsSensor;

        public SensorGroup(Sensor bytesSensor, Sensor recordsSensor) {
            this.bytesSensor = bytesSensor;
            this.recordsSensor = recordsSensor;
        }
    }
}

