/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import java.util.Collection;
import java.util.Objects;

public class IpFilteringValue
extends AuthValue {
    private final Collection<String> cidrs;

    @JsonCreator
    public IpFilteringValue(@JsonProperty(value="CIDRs") Collection<String> cidrs) {
        this.cidrs = Objects.requireNonNull(cidrs, "CIDRs cannot be null");
    }

    @JsonProperty
    public Collection<String> cidrs() {
        return this.cidrs;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.IP_FILTERING;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IpFilteringValue that = (IpFilteringValue)o;
        return Objects.equals(this.cidrs, that.cidrs);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.cidrs);
    }

    public String toString() {
        return "IpFilteringValue{CIDRs=" + String.valueOf(this.cidrs) + "}";
    }
}

