/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.authorizer.ResourcePattern;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class RoleBindingValue
extends AuthValue {
    private final Set<ResourcePattern> resources;

    @JsonCreator
    public RoleBindingValue(@JsonProperty(value="resources") Collection<ResourcePattern> resources) {
        this.resources = resources == null ? Collections.emptySet() : new HashSet<ResourcePattern>(resources);
    }

    @JsonProperty
    public Collection<ResourcePattern> resources() {
        return this.resources;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.ROLE_BINDING;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleBindingValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleBindingValue that = (RoleBindingValue)o;
        return Objects.equals(this.resources, that.resources);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.resources);
    }

    public String toString() {
        return "RoleBindingValue(resources=" + String.valueOf(this.resources) + ")";
    }
}

