/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.interpreter;

import com.google.api.expr.v1alpha1.Constant;
import com.google.api.expr.v1alpha1.Expr;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import java.util.ArrayList;
import java.util.List;
import org.projectnessie.cel.common.operators.Operator;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.IteratorT;
import org.projectnessie.cel.common.types.UnknownT;
import org.projectnessie.cel.common.types.Util;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Lister;
import org.projectnessie.cel.common.types.traits.Mapper;
import org.projectnessie.cel.interpreter.EvalState;

public final class AstPruner {
    private final Expr expr;
    private final EvalState state;
    private long nextExprID;

    private AstPruner(Expr expr, EvalState state, long nextExprID) {
        this.expr = expr;
        this.state = state;
        this.nextExprID = nextExprID;
    }

    public static Expr pruneAst(Expr expr, EvalState state) {
        AstPruner pruner = new AstPruner(expr, state, 1L);
        Expr newExpr = pruner.prune(expr);
        return newExpr;
    }

    static Expr createLiteral(long id, Constant val) {
        return Expr.newBuilder().setId(id).setConstExpr(val).build();
    }

    Expr maybeCreateLiteral(long id, Val v) {
        Type t = v.type();
        switch (t.typeEnum()) {
            case Bool: {
                return AstPruner.createLiteral(id, Constant.newBuilder().setBoolValue(((Boolean)v.value()).booleanValue()).build());
            }
            case Int: {
                return AstPruner.createLiteral(id, Constant.newBuilder().setInt64Value(((Number)v.value()).longValue()).build());
            }
            case Uint: {
                return AstPruner.createLiteral(id, Constant.newBuilder().setUint64Value(((Number)v.value()).longValue()).build());
            }
            case String: {
                return AstPruner.createLiteral(id, Constant.newBuilder().setStringValue(v.value().toString()).build());
            }
            case Double: {
                return AstPruner.createLiteral(id, Constant.newBuilder().setDoubleValue(((Number)v.value()).doubleValue()).build());
            }
            case Bytes: {
                return AstPruner.createLiteral(id, Constant.newBuilder().setBytesValue(ByteString.copyFrom((byte[])((byte[])v.value()))).build());
            }
            case Null: {
                return AstPruner.createLiteral(id, Constant.newBuilder().setNullValue(NullValue.NULL_VALUE).build());
            }
        }
        if (v instanceof Lister) {
            Lister list = (Lister)v;
            int sz = (int)list.size().intValue();
            ArrayList<Expr> elemExprs = new ArrayList<Expr>(sz);
            for (int i = 0; i < sz; ++i) {
                Val elem = list.get(IntT.intOf(i));
                if (Util.isUnknownOrError(elem)) {
                    return null;
                }
                Expr elemExpr = this.maybeCreateLiteral(this.nextID(), elem);
                if (elemExpr == null) {
                    return null;
                }
                elemExprs.add(elemExpr);
            }
            return Expr.newBuilder().setId(id).setListExpr(Expr.CreateList.newBuilder().addAllElements(elemExprs).build()).build();
        }
        if (v instanceof Mapper) {
            Mapper mp = (Mapper)v;
            IteratorT it = mp.iterator();
            ArrayList<Expr.CreateStruct.Entry> entries = new ArrayList<Expr.CreateStruct.Entry>((int)mp.size().intValue());
            while (it.hasNext() == BoolT.True) {
                Val key = it.next();
                Val val = mp.get(key);
                if (Util.isUnknownOrError(key) || Util.isUnknownOrError(val)) {
                    return null;
                }
                Expr keyExpr = this.maybeCreateLiteral(this.nextID(), key);
                if (keyExpr == null) {
                    return null;
                }
                Expr valExpr = this.maybeCreateLiteral(this.nextID(), val);
                if (valExpr == null) {
                    return null;
                }
                Expr.CreateStruct.Entry entry = Expr.CreateStruct.Entry.newBuilder().setId(this.nextID()).setMapKey(keyExpr).setValue(valExpr).build();
                entries.add(entry);
            }
            return Expr.newBuilder().setId(id).setStructExpr(Expr.CreateStruct.newBuilder().addAllEntries(entries)).build();
        }
        return null;
    }

    Expr maybePruneAndOr(Expr node) {
        if (!this.existsWithUnknownValue(node.getId())) {
            return null;
        }
        Expr.Call call = node.getCallExpr();
        if (this.existsWithKnownValue(call.getArgs(0).getId())) {
            return call.getArgs(1);
        }
        if (this.existsWithKnownValue(call.getArgs(1).getId())) {
            return call.getArgs(0);
        }
        return null;
    }

    Expr maybePruneConditional(Expr node) {
        if (!this.existsWithUnknownValue(node.getId())) {
            return null;
        }
        Expr.Call call = node.getCallExpr();
        Val condVal = this.value(call.getArgs(0).getId());
        if (condVal == null || Util.isUnknownOrError(condVal)) {
            return null;
        }
        if (condVal == BoolT.True) {
            return call.getArgs(1);
        }
        return call.getArgs(2);
    }

    Expr maybePruneFunction(Expr node) {
        Expr.Call call = node.getCallExpr();
        if (call.getFunction().equals(Operator.LogicalOr.id) || call.getFunction().equals(Operator.LogicalAnd.id)) {
            return this.maybePruneAndOr(node);
        }
        if (call.getFunction().equals(Operator.Conditional.id)) {
            return this.maybePruneConditional(node);
        }
        return null;
    }

    Expr prune(Expr node) {
        Expr newNode;
        if (node == null) {
            return null;
        }
        Val val = this.value(node.getId());
        if (val != null && !Util.isUnknownOrError(val) && (newNode = this.maybeCreateLiteral(node.getId(), val)) != null) {
            return newNode;
        }
        switch (node.getExprKindCase()) {
            case SELECT_EXPR: {
                Expr.Select select = node.getSelectExpr();
                Expr operand = this.prune(select.getOperand());
                if (operand == null || operand == select.getOperand()) break;
                return Expr.newBuilder().setId(node.getId()).setSelectExpr(Expr.Select.newBuilder().setOperand(operand).setField(select.getField()).setTestOnly(select.getTestOnly())).build();
            }
            case CALL_EXPR: {
                Expr.Call call = node.getCallExpr();
                Expr newExpr = this.maybePruneFunction(node);
                if (newExpr != null) {
                    newExpr = this.prune(newExpr);
                    return newExpr;
                }
                boolean prunedCall = false;
                List args = call.getArgsList();
                ArrayList<Expr> newArgs = new ArrayList<Expr>(args.size());
                for (int i = 0; i < args.size(); ++i) {
                    Expr arg = (Expr)args.get(i);
                    newArgs.add(arg);
                    Expr newArg = this.prune(arg);
                    if (newArg == null || newArg == arg) continue;
                    prunedCall = true;
                    newArgs.set(i, newArg);
                }
                Expr.Call newCall = Expr.Call.newBuilder().setFunction(call.getFunction()).setTarget(call.getTarget()).addAllArgs(newArgs).build();
                Expr newTarget = this.prune(call.getTarget());
                if (newTarget != null && newTarget != call.getTarget()) {
                    prunedCall = true;
                    newCall = Expr.Call.newBuilder().setFunction(call.getFunction()).setTarget(newTarget).addAllArgs(newArgs).build();
                }
                if (!prunedCall) break;
                return Expr.newBuilder().setId(node.getId()).setCallExpr(newCall).build();
            }
            case LIST_EXPR: {
                Expr.CreateList list = node.getListExpr();
                List elems = list.getElementsList();
                ArrayList<Expr> newElems = new ArrayList<Expr>(elems.size());
                boolean prunedList = false;
                for (int i = 0; i < elems.size(); ++i) {
                    Expr elem = (Expr)elems.get(i);
                    newElems.add(elem);
                    Expr newElem = this.prune(elem);
                    if (newElem == null || newElem == elem) continue;
                    newElems.set(i, newElem);
                    prunedList = true;
                }
                if (!prunedList) break;
                return Expr.newBuilder().setId(node.getId()).setListExpr(Expr.CreateList.newBuilder().addAllElements(newElems)).build();
            }
            case STRUCT_EXPR: {
                boolean prunedStruct = false;
                Expr.CreateStruct struct = node.getStructExpr();
                List entries = struct.getEntriesList();
                String messageType = struct.getMessageName();
                ArrayList<Expr.CreateStruct.Entry> newEntries = new ArrayList<Expr.CreateStruct.Entry>(entries.size());
                for (int i = 0; i < entries.size(); ++i) {
                    Expr.CreateStruct.Entry entry = (Expr.CreateStruct.Entry)entries.get(i);
                    newEntries.add(entry);
                    Expr mapKey = entry.getMapKey();
                    Expr newKey = mapKey != Expr.CreateStruct.Entry.getDefaultInstance().getMapKey() ? this.prune(mapKey) : null;
                    Expr newValue = this.prune(entry.getValue());
                    if (!(newKey != null && newKey != mapKey || newValue != null && newValue != entry.getValue())) continue;
                    prunedStruct = true;
                    Expr.CreateStruct.Entry newEntry = !messageType.isEmpty() ? Expr.CreateStruct.Entry.newBuilder().setFieldKey(entry.getFieldKey()).setValue(newValue).build() : Expr.CreateStruct.Entry.newBuilder().setMapKey(newKey).setValue(newValue).build();
                    newEntries.set(i, newEntry);
                }
                if (!prunedStruct) break;
                return Expr.newBuilder().setId(node.getId()).setStructExpr(Expr.CreateStruct.newBuilder().setMessageName(messageType).addAllEntries((Iterable)entries)).build();
            }
            case COMPREHENSION_EXPR: {
                Expr.Comprehension compre = node.getComprehensionExpr();
                Expr newRange = this.prune(compre.getIterRange());
                if (newRange == null || newRange == compre.getIterRange()) break;
                return Expr.newBuilder().setId(node.getId()).setComprehensionExpr(Expr.Comprehension.newBuilder().setIterVar(compre.getIterVar()).setIterRange(newRange).setAccuVar(compre.getAccuVar()).setAccuInit(compre.getAccuInit()).setLoopCondition(compre.getLoopCondition()).setLoopStep(compre.getLoopStep()).setResult(compre.getResult())).build();
            }
        }
        return node;
    }

    Val value(long id) {
        return this.state.value(id);
    }

    boolean existsWithUnknownValue(long id) {
        Val val = this.value(id);
        return UnknownT.isUnknown(val);
    }

    boolean existsWithKnownValue(long id) {
        Val val = this.value(id);
        return val != null && !UnknownT.isUnknown(val);
    }

    long nextID() {
        while (this.state.value(this.nextExprID) != null) {
            ++this.nextExprID;
        }
        return this.nextExprID++;
    }
}

