/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.interpreter;

import com.google.api.expr.v1alpha1.CheckedExpr;
import com.google.api.expr.v1alpha1.Constant;
import com.google.api.expr.v1alpha1.Expr;
import com.google.api.expr.v1alpha1.Reference;
import com.google.api.expr.v1alpha1.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.projectnessie.cel.common.containers.Container;
import org.projectnessie.cel.common.operators.Operator;
import org.projectnessie.cel.common.types.BytesT;
import org.projectnessie.cel.common.types.DoubleT;
import org.projectnessie.cel.common.types.DurationT;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.NullT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.TimestampT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.UintT;
import org.projectnessie.cel.common.types.ref.FieldType;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeProvider;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Trait;
import org.projectnessie.cel.interpreter.AttributeFactory;
import org.projectnessie.cel.interpreter.Dispatcher;
import org.projectnessie.cel.interpreter.Interpretable;
import org.projectnessie.cel.interpreter.InterpretableDecorator;
import org.projectnessie.cel.interpreter.functions.BinaryOp;
import org.projectnessie.cel.interpreter.functions.FunctionOp;
import org.projectnessie.cel.interpreter.functions.Overload;
import org.projectnessie.cel.interpreter.functions.UnaryOp;

public interface InterpretablePlanner {
    public Interpretable plan(Expr var1);

    public static InterpretablePlanner newPlanner(Dispatcher disp, TypeProvider provider, TypeAdapter adapter, AttributeFactory attrFactory, Container cont, CheckedExpr checked, InterpretableDecorator ... decorators) {
        return new Planner(disp, provider, adapter, attrFactory, cont, checked.getReferenceMapMap(), checked.getTypeMapMap(), decorators);
    }

    public static InterpretablePlanner newUncheckedPlanner(Dispatcher disp, TypeProvider provider, TypeAdapter adapter, AttributeFactory attrFactory, Container cont, InterpretableDecorator ... decorators) {
        return new Planner(disp, provider, adapter, attrFactory, cont, new HashMap<Long, Reference>(), new HashMap<Long, Type>(), decorators);
    }

    public static final class Planner
    implements InterpretablePlanner {
        private final Dispatcher disp;
        private final TypeProvider provider;
        private final TypeAdapter adapter;
        private final AttributeFactory attrFactory;
        private final Container container;
        private final Map<Long, Reference> refMap;
        private final Map<Long, Type> typeMap;
        private final InterpretableDecorator[] decorators;

        Planner(Dispatcher disp, TypeProvider provider, TypeAdapter adapter, AttributeFactory attrFactory, Container container, Map<Long, Reference> refMap, Map<Long, Type> typeMap, InterpretableDecorator[] decorators) {
            this.disp = disp;
            this.provider = provider;
            this.adapter = adapter;
            this.attrFactory = attrFactory;
            this.container = container;
            this.refMap = refMap;
            this.typeMap = typeMap;
            this.decorators = decorators;
        }

        @Override
        public Interpretable plan(Expr expr) {
            switch (expr.getExprKindCase()) {
                case CALL_EXPR: {
                    return this.decorate(this.planCall(expr));
                }
                case IDENT_EXPR: {
                    return this.decorate(this.planIdent(expr));
                }
                case SELECT_EXPR: {
                    return this.decorate(this.planSelect(expr));
                }
                case LIST_EXPR: {
                    return this.decorate(this.planCreateList(expr));
                }
                case STRUCT_EXPR: {
                    return this.decorate(this.planCreateStruct(expr));
                }
                case COMPREHENSION_EXPR: {
                    return this.decorate(this.planComprehension(expr));
                }
                case CONST_EXPR: {
                    return this.decorate(this.planConst(expr));
                }
            }
            throw new IllegalArgumentException(String.format("unsupported expr of kind %s: '%s'", expr.getExprKindCase(), expr));
        }

        Interpretable decorate(Interpretable i) {
            for (InterpretableDecorator dec : this.decorators) {
                if ((i = dec.decorate(i)) != null) continue;
                return null;
            }
            return i;
        }

        Interpretable planIdent(Expr expr) {
            Reference identRef = this.refMap.get(expr.getId());
            if (identRef != null) {
                return this.planCheckedIdent(expr.getId(), identRef);
            }
            Expr.Ident ident = expr.getIdentExpr();
            return new Interpretable.EvalAttr(this.adapter, this.attrFactory.maybeAttribute(expr.getId(), ident.getName()));
        }

        Interpretable planCheckedIdent(long id, Reference identRef) {
            if (identRef.getValue() != Reference.getDefaultInstance().getValue()) {
                return this.plan(Expr.newBuilder().setId(id).setConstExpr(identRef.getValue()).build());
            }
            Type cType = this.typeMap.get(id);
            if (cType != null && cType.getType() != Type.getDefaultInstance()) {
                Val cVal = this.provider.findIdent(identRef.getName());
                if (cVal == null) {
                    throw new IllegalStateException(String.format("reference to undefined type: %s", identRef.getName()));
                }
                return Interpretable.newConstValue(id, cVal);
            }
            return new Interpretable.EvalAttr(this.adapter, this.attrFactory.absoluteAttribute(id, identRef.getName()));
        }

        Interpretable planSelect(Expr expr) {
            FieldType ft;
            Reference identRef = this.refMap.get(expr.getId());
            if (identRef != null) {
                return this.planCheckedIdent(expr.getId(), identRef);
            }
            Expr.Select sel = expr.getSelectExpr();
            Interpretable op = this.plan(sel.getOperand());
            FieldType fieldType = null;
            Type opType = this.typeMap.get(sel.getOperand().getId());
            if (opType != null && !opType.getMessageType().isEmpty() && (ft = this.provider.findFieldType(opType.getMessageType(), sel.getField())) != null && ft.isSet != null && ft.getFrom != null) {
                fieldType = ft;
            }
            if (sel.getTestOnly()) {
                return new Interpretable.EvalTestOnly(expr.getId(), op, StringT.stringOf(sel.getField()), fieldType);
            }
            AttributeFactory.Qualifier qual = this.attrFactory.newQualifier(opType, expr.getId(), sel.getField());
            if (qual == null) {
                return null;
            }
            if (op instanceof Interpretable.InterpretableAttribute) {
                Interpretable.InterpretableAttribute attr = (Interpretable.InterpretableAttribute)op;
                attr.addQualifier(qual);
                return attr;
            }
            Interpretable.InterpretableAttribute relAttr = this.relativeAttr(op.id(), op);
            if (relAttr == null) {
                return null;
            }
            relAttr.addQualifier(qual);
            return relAttr;
        }

        Interpretable planCall(Expr expr) {
            Expr.Call call = expr.getCallExpr();
            ResolvedFunction resolvedFunc = this.resolveFunction(expr);
            int argCount = call.getArgsCount();
            int offset = 0;
            if (resolvedFunc.target != null) {
                ++argCount;
                ++offset;
            }
            Interpretable[] args = new Interpretable[argCount];
            if (resolvedFunc.target != null) {
                Interpretable arg = this.plan(resolvedFunc.target);
                if (arg == null) {
                    return null;
                }
                args[0] = arg;
            }
            for (int i = 0; i < call.getArgsCount(); ++i) {
                Interpretable arg;
                Expr argExpr = call.getArgs(i);
                args[i + offset] = arg = this.plan(argExpr);
            }
            if (resolvedFunc.fnName.equals(Operator.LogicalAnd.id)) {
                return this.planCallLogicalAnd(expr, args);
            }
            if (resolvedFunc.fnName.equals(Operator.LogicalOr.id)) {
                return this.planCallLogicalOr(expr, args);
            }
            if (resolvedFunc.fnName.equals(Operator.Conditional.id)) {
                return this.planCallConditional(expr, args);
            }
            if (resolvedFunc.fnName.equals(Operator.Equals.id)) {
                return this.planCallEqual(expr, args);
            }
            if (resolvedFunc.fnName.equals(Operator.NotEquals.id)) {
                return this.planCallNotEqual(expr, args);
            }
            if (resolvedFunc.fnName.equals(Operator.Index.id)) {
                return this.planCallIndex(expr, args);
            }
            Overload fnDef = null;
            if (resolvedFunc.overloadId != null && resolvedFunc.overloadId.isEmpty()) {
                fnDef = this.disp.findOverload(resolvedFunc.overloadId);
            }
            if (fnDef == null) {
                fnDef = this.disp.findOverload(resolvedFunc.fnName);
            }
            switch (argCount) {
                case 0: {
                    return this.planCallZero(expr, resolvedFunc.fnName, resolvedFunc.overloadId, fnDef);
                }
                case 1: {
                    return this.planCallUnary(expr, resolvedFunc.fnName, resolvedFunc.overloadId, fnDef, args);
                }
                case 2: {
                    return this.planCallBinary(expr, resolvedFunc.fnName, resolvedFunc.overloadId, fnDef, args);
                }
            }
            return this.planCallVarArgs(expr, resolvedFunc.fnName, resolvedFunc.overloadId, fnDef, args);
        }

        Interpretable planCallZero(Expr expr, String function, String overload, Overload impl) {
            if (impl == null || impl.function == null) {
                throw new IllegalArgumentException(String.format("no such overload: %s()", function));
            }
            return new Interpretable.EvalZeroArity(expr.getId(), function, overload, impl.function);
        }

        Interpretable planCallUnary(Expr expr, String function, String overload, Overload impl, Interpretable[] args) {
            UnaryOp fn = null;
            Trait trait = null;
            if (impl != null) {
                if (impl.unary == null) {
                    throw new IllegalStateException(String.format("no such overload: %s(arg)", function));
                }
                fn = impl.unary;
                trait = impl.operandTrait;
            }
            return new Interpretable.EvalUnary(expr.getId(), function, overload, args[0], trait, fn);
        }

        Interpretable planCallBinary(Expr expr, String function, String overload, Overload impl, Interpretable ... args) {
            BinaryOp fn = null;
            Trait trait = null;
            if (impl != null) {
                if (impl.binary == null) {
                    throw new IllegalStateException(String.format("no such overload: %s(lhs, rhs)", function));
                }
                fn = impl.binary;
                trait = impl.operandTrait;
            }
            return new Interpretable.EvalBinary(expr.getId(), function, overload, args[0], args[1], trait, fn);
        }

        Interpretable planCallVarArgs(Expr expr, String function, String overload, Overload impl, Interpretable ... args) {
            FunctionOp fn = null;
            Trait trait = null;
            if (impl != null) {
                if (impl.function == null) {
                    throw new IllegalStateException(String.format("no such overload: %s(...)", function));
                }
                fn = impl.function;
                trait = impl.operandTrait;
            }
            return new Interpretable.EvalVarArgs(expr.getId(), function, overload, args, trait, fn);
        }

        Interpretable planCallEqual(Expr expr, Interpretable ... args) {
            return new Interpretable.EvalEq(expr.getId(), args[0], args[1]);
        }

        Interpretable planCallNotEqual(Expr expr, Interpretable ... args) {
            return new Interpretable.EvalNe(expr.getId(), args[0], args[1]);
        }

        Interpretable planCallLogicalAnd(Expr expr, Interpretable ... args) {
            return new Interpretable.EvalAnd(expr.getId(), args[0], args[1]);
        }

        Interpretable planCallLogicalOr(Expr expr, Interpretable ... args) {
            return new Interpretable.EvalOr(expr.getId(), args[0], args[1]);
        }

        Interpretable planCallConditional(Expr expr, Interpretable ... args) {
            AttributeFactory.Attribute fAttr;
            AttributeFactory.Attribute tAttr;
            Interpretable cond = args[0];
            Interpretable t = args[1];
            if (t instanceof Interpretable.InterpretableAttribute) {
                Interpretable.InterpretableAttribute truthyAttr = (Interpretable.InterpretableAttribute)t;
                tAttr = truthyAttr.attr();
            } else {
                tAttr = this.attrFactory.relativeAttribute(t.id(), t);
            }
            Interpretable f = args[2];
            if (f instanceof Interpretable.InterpretableAttribute) {
                Interpretable.InterpretableAttribute falsyAttr = (Interpretable.InterpretableAttribute)f;
                fAttr = falsyAttr.attr();
            } else {
                fAttr = this.attrFactory.relativeAttribute(f.id(), f);
            }
            return new Interpretable.EvalAttr(this.adapter, this.attrFactory.conditionalAttribute(expr.getId(), cond, tAttr, fAttr));
        }

        Interpretable planCallIndex(Expr expr, Interpretable ... args) {
            Interpretable op = args[0];
            Interpretable ind = args[1];
            Interpretable.InterpretableAttribute opAttr = this.relativeAttr(op.id(), op);
            if (opAttr == null) {
                return null;
            }
            Type opType = this.typeMap.get(expr.getCallExpr().getTarget().getId());
            if (ind instanceof Interpretable.InterpretableConst) {
                Interpretable.InterpretableConst indConst = (Interpretable.InterpretableConst)ind;
                AttributeFactory.Qualifier qual = this.attrFactory.newQualifier(opType, expr.getId(), indConst.value());
                if (qual == null) {
                    return null;
                }
                opAttr.addQualifier(qual);
                return opAttr;
            }
            if (ind instanceof Interpretable.InterpretableAttribute) {
                Interpretable.InterpretableAttribute indAttr = (Interpretable.InterpretableAttribute)ind;
                AttributeFactory.Qualifier qual = this.attrFactory.newQualifier(opType, expr.getId(), indAttr);
                if (qual == null) {
                    return null;
                }
                opAttr.addQualifier(qual);
                return opAttr;
            }
            Interpretable.InterpretableAttribute indQual = this.relativeAttr(expr.getId(), ind);
            if (indQual == null) {
                return null;
            }
            opAttr.addQualifier(indQual);
            return opAttr;
        }

        Interpretable planCreateList(Expr expr) {
            Expr.CreateList list = expr.getListExpr();
            Interpretable[] elems = new Interpretable[list.getElementsCount()];
            for (int i = 0; i < list.getElementsCount(); ++i) {
                Expr elem = list.getElements(i);
                Interpretable elemVal = this.plan(elem);
                if (elemVal == null) {
                    return null;
                }
                elems[i] = elemVal;
            }
            return new Interpretable.EvalList(expr.getId(), elems, this.adapter);
        }

        Interpretable planCreateStruct(Expr expr) {
            Expr.CreateStruct str = expr.getStructExpr();
            if (!str.getMessageName().isEmpty()) {
                return this.planCreateObj(expr);
            }
            List entries = str.getEntriesList();
            Interpretable[] keys = new Interpretable[entries.size()];
            Interpretable[] vals = new Interpretable[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                Expr.CreateStruct.Entry entry = (Expr.CreateStruct.Entry)entries.get(i);
                Interpretable keyVal = this.plan(entry.getMapKey());
                if (keyVal == null) {
                    return null;
                }
                keys[i] = keyVal;
                Interpretable valVal = this.plan(entry.getValue());
                if (valVal == null) {
                    return null;
                }
                vals[i] = valVal;
            }
            return new Interpretable.EvalMap(expr.getId(), keys, vals, this.adapter);
        }

        Interpretable planCreateObj(Expr expr) {
            Expr.CreateStruct obj = expr.getStructExpr();
            String typeName = this.resolveTypeName(obj.getMessageName());
            if (typeName == null) {
                throw new IllegalStateException(String.format("unknown type: %s", obj.getMessageName()));
            }
            List entries = obj.getEntriesList();
            String[] fields = new String[entries.size()];
            Interpretable[] vals = new Interpretable[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                Expr.CreateStruct.Entry entry = (Expr.CreateStruct.Entry)entries.get(i);
                fields[i] = entry.getFieldKey();
                Interpretable val = this.plan(entry.getValue());
                if (val == null) {
                    return null;
                }
                vals[i] = val;
            }
            return new Interpretable.EvalObj(expr.getId(), typeName, fields, vals, this.provider);
        }

        Interpretable planComprehension(Expr expr) {
            Expr.Comprehension fold = expr.getComprehensionExpr();
            Interpretable accu = this.plan(fold.getAccuInit());
            if (accu == null) {
                return null;
            }
            Interpretable iterRange = this.plan(fold.getIterRange());
            if (iterRange == null) {
                return null;
            }
            Interpretable cond = this.plan(fold.getLoopCondition());
            if (cond == null) {
                return null;
            }
            Interpretable step = this.plan(fold.getLoopStep());
            if (step == null) {
                return null;
            }
            Interpretable result = this.plan(fold.getResult());
            if (result == null) {
                return null;
            }
            return new Interpretable.EvalFold(expr.getId(), fold.getAccuVar(), accu, fold.getIterVar(), iterRange, cond, step, result);
        }

        Interpretable planConst(Expr expr) {
            Val val = this.constValue(expr.getConstExpr());
            if (val == null) {
                return null;
            }
            return Interpretable.newConstValue(expr.getId(), val);
        }

        Val constValue(Constant c) {
            switch (c.getConstantKindCase()) {
                case BOOL_VALUE: {
                    return Types.boolOf(c.getBoolValue());
                }
                case BYTES_VALUE: {
                    return BytesT.bytesOf(c.getBytesValue());
                }
                case DOUBLE_VALUE: {
                    return DoubleT.doubleOf(c.getDoubleValue());
                }
                case DURATION_VALUE: {
                    return DurationT.durationOf(c.getDurationValue());
                }
                case INT64_VALUE: {
                    return IntT.intOf(c.getInt64Value());
                }
                case NULL_VALUE: {
                    return NullT.NullValue;
                }
                case STRING_VALUE: {
                    return StringT.stringOf(c.getStringValue());
                }
                case TIMESTAMP_VALUE: {
                    return TimestampT.timestampOf(c.getTimestampValue());
                }
                case UINT64_VALUE: {
                    return UintT.uintOf(c.getUint64Value());
                }
            }
            throw new IllegalArgumentException(String.format("unknown constant type: '%s' of kind '%s'", c, c.getConstantKindCase()));
        }

        String resolveTypeName(String typeName) {
            for (String qualifiedTypeName : this.container.resolveCandidateNames(typeName)) {
                if (this.provider.findType(qualifiedTypeName) == null) continue;
                return qualifiedTypeName;
            }
            return null;
        }

        ResolvedFunction resolveFunction(Expr expr) {
            Expr.Call call = expr.getCallExpr();
            Expr target = call.hasTarget() ? call.getTarget() : null;
            String fnName = call.getFunction();
            Reference oRef = this.refMap.get(expr.getId());
            if (oRef != null) {
                if (oRef.getOverloadIdCount() == 1) {
                    return new ResolvedFunction(target, fnName, oRef.getOverloadId(0));
                }
                return new ResolvedFunction(target, fnName, "");
            }
            if (target == null) {
                for (String qualifiedName : this.container.resolveCandidateNames(fnName)) {
                    if (this.disp.findOverload(qualifiedName) == null) continue;
                    return new ResolvedFunction(target, qualifiedName, "");
                }
                return new ResolvedFunction(target, this.stripLeadingDot(fnName), "");
            }
            String qualifiedPrefix = this.toQualifiedName(target);
            if (qualifiedPrefix != null) {
                String maybeQualifiedName = qualifiedPrefix + "." + fnName;
                for (String qualifiedName : this.container.resolveCandidateNames(maybeQualifiedName)) {
                    if (this.disp.findOverload(qualifiedName) == null) continue;
                    return new ResolvedFunction(null, qualifiedName, "");
                }
            }
            return new ResolvedFunction(target, fnName, "");
        }

        Interpretable.InterpretableAttribute relativeAttr(long id, Interpretable eval) {
            Interpretable.InterpretableAttribute eAttr = eval instanceof Interpretable.InterpretableAttribute ? (Interpretable.InterpretableAttribute)eval : new Interpretable.EvalAttr(this.adapter, this.attrFactory.relativeAttribute(id, eval));
            Interpretable decAttr = this.decorate(eAttr);
            if (decAttr == null) {
                return null;
            }
            if (!(decAttr instanceof Interpretable.InterpretableAttribute)) {
                throw new IllegalStateException(String.format("invalid attribute decoration: %s(%s)", decAttr, decAttr.getClass().getName()));
            }
            eAttr = (Interpretable.InterpretableAttribute)decAttr;
            return eAttr;
        }

        String toQualifiedName(Expr operand) {
            if (this.refMap.containsKey(operand.getId())) {
                return "";
            }
            return Container.toQualifiedName(operand);
        }

        String stripLeadingDot(String name) {
            return name.startsWith(".") ? name.substring(1) : name;
        }

        static final class ResolvedFunction {
            final Expr target;
            final String fnName;
            final String overloadId;

            ResolvedFunction(Expr target, String fnName, String overloadId) {
                this.target = target;
                this.fnName = fnName;
                this.overloadId = overloadId;
            }
        }
    }
}

