/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.mtls;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class CertificateUtils {
    private CertificateUtils() {
    }

    public static String certToString(Certificate cert) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        try {
            if (cert instanceof X509Certificate) {
                X509Certificate x509Cert = (X509Certificate)cert;
                sb.append("subjectDN=").append(x509Cert.getSubjectX500Principal().getName()).append(",");
                sb.append("issuerDN=").append(x509Cert.getIssuerX500Principal().getName()).append(",");
                sb.append("serialNumber=").append(x509Cert.getSerialNumber().toString(16)).append(",");
                sb.append("notBefore=").append(x509Cert.getNotBefore()).append(",");
                sb.append("notAfter=").append(x509Cert.getNotAfter());
            } else if (cert == null) {
                sb.append("isNull=true");
            } else {
                sb.append("type=").append(cert.getType());
            }
        }
        catch (Exception e) {
            sb.append("error=").append(e.getMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public static String certChainToString(Certificate[] certificates) {
        StringBuilder sb = new StringBuilder();
        sb.append("Certificate chain = [");
        for (Certificate cert : certificates) {
            sb.append(CertificateUtils.certToString(cert)).append(";");
        }
        sb.append("]");
        return sb.toString();
    }
}

