/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.http.server;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.http.server.KafkaHttpServerConfig;
import io.confluent.kafka.http.server.KafkaHttpServer;
import io.confluent.rest.Application;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.RestConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaHttpServerImpl
implements KafkaHttpServer,
Reconfigurable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaHttpServerImpl.class);
    private final CountDownLatch startedLatch = new CountDownLatch(1);
    private final CountDownLatch stoppedLatch = new CountDownLatch(1);
    private final List<Application<?>> applications;
    private Throwable error;
    final ApplicationServer<KafkaHttpServerConfig> server;
    private volatile State currentState = State.NEW;

    public KafkaHttpServerImpl(List<Application<?>> applications, KafkaHttpServerConfig configuration) {
        this.applications = Collections.unmodifiableList(new ArrayList(applications));
        this.server = new ApplicationServer((RestConfig)configuration);
    }

    @VisibleForTesting
    public ApplicationServer<KafkaHttpServerConfig> getApplicationServer() {
        return this.server;
    }

    public boolean isNew() {
        return this.currentState == State.NEW;
    }

    public boolean isStarting() {
        return this.currentState == State.STARTING;
    }

    public boolean isRunning() {
        return this.currentState == State.RUNNING;
    }

    public boolean isStopping() {
        return this.currentState == State.STOPPING;
    }

    public boolean isTerminated() {
        return this.currentState == State.TERMINATED;
    }

    public boolean isFailed() {
        return this.currentState == State.FAILED;
    }

    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.error);
    }

    public synchronized void start() {
        if (!this.isNew()) {
            return;
        }
        this.transition(State.STARTING, null);
        new Thread(this::doStart, "ce-kafka-http-server-start-thread").start();
    }

    private synchronized void doStart() {
        if (!this.isStarting()) {
            return;
        }
        try {
            for (Application<?> application : this.applications) {
                this.server.registerApplication(application);
            }
            this.server.start();
            this.transition(State.RUNNING, null);
        }
        catch (Throwable error) {
            this.transition(State.FAILED, error);
        }
    }

    public synchronized void stop() {
        if (!this.isStarting() && !this.isRunning()) {
            return;
        }
        this.transition(State.STOPPING, null);
        new Thread(this::doStop, "ce-kafka-http-server-stop-thread").start();
    }

    private synchronized void doStop() {
        if (!this.isStopping()) {
            return;
        }
        try {
            this.server.stop();
            this.transition(State.TERMINATED, null);
        }
        catch (Throwable error) {
            this.transition(State.FAILED, error);
        }
    }

    public void awaitStarted() throws InterruptedException {
        this.startedLatch.await();
    }

    public boolean awaitStarted(Duration timeout) throws InterruptedException {
        return this.startedLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void awaitStopped() throws InterruptedException {
        this.stoppedLatch.await();
    }

    public boolean awaitStopped(Duration timeout) throws InterruptedException {
        return this.stoppedLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    public Set<String> reconfigurableConfigs() {
        if (!this.isRunning()) {
            return Collections.emptySet();
        }
        return this.applications.stream().filter(Reconfigurable.class::isInstance).map(Reconfigurable.class::cast).map(Reconfigurable::reconfigurableConfigs).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        if (!this.isRunning()) {
            return;
        }
        this.applications.stream().filter(Reconfigurable.class::isInstance).map(Reconfigurable.class::cast).forEach(application -> application.validateReconfiguration(configs));
    }

    public void reconfigure(Map<String, ?> configs) {
        if (!this.isRunning()) {
            return;
        }
        this.applications.stream().filter(Reconfigurable.class::isInstance).map(Reconfigurable.class::cast).forEach(application -> application.reconfigure(configs));
    }

    public void configure(Map<String, ?> configs) {
        if (!this.isRunning()) {
            return;
        }
        this.applications.stream().filter(Reconfigurable.class::isInstance).map(Reconfigurable.class::cast).forEach(application -> application.configure(configs));
    }

    public int getPrimaryPort() {
        return ((NetworkTrafficServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    private synchronized void transition(State toState, Throwable error) {
        if (!this.currentState.getOutboundStates().contains((Object)toState)) {
            StringBuilder message = new StringBuilder(String.format("KafkaHttpServer tried to transition to %s from %s.", new Object[]{toState, this.currentState}));
            if (!this.currentState.getOutboundStates().isEmpty()) {
                message.append(String.format(" Can only transition to one of %s.", this.currentState.getOutboundStates()));
            }
            IllegalStateException exception = new IllegalStateException(message.toString());
            logger.warn(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        State fromState = this.currentState;
        this.currentState = toState;
        if (toState == State.FAILED) {
            this.error = error;
        }
        if (fromState == State.STARTING) {
            this.startedLatch.countDown();
        }
        if (toState == State.TERMINATED || toState == State.FAILED) {
            this.stoppedLatch.countDown();
        }
        StringBuilder message = new StringBuilder(String.format("KafkaHttpServer transitioned from %s to %s.", new Object[]{fromState, toState}));
        if (error != null) {
            message.append(String.format(": %s.", error.getMessage()));
        } else {
            message.append('.');
        }
        if (toState == State.FAILED) {
            logger.warn(message.toString(), error);
        } else {
            logger.info(message.toString());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum State {
        NEW{

            @Override
            EnumSet<State> getOutboundStates() {
                return EnumSet.of(STARTING);
            }
        }
        ,
        STARTING{

            @Override
            EnumSet<State> getOutboundStates() {
                return EnumSet.of(RUNNING, STOPPING, TERMINATED, FAILED);
            }
        }
        ,
        RUNNING{

            @Override
            EnumSet<State> getOutboundStates() {
                return EnumSet.of(STOPPING, TERMINATED, FAILED);
            }
        }
        ,
        STOPPING{

            @Override
            EnumSet<State> getOutboundStates() {
                return EnumSet.of(TERMINATED, FAILED);
            }
        }
        ,
        TERMINATED{

            @Override
            EnumSet<State> getOutboundStates() {
                return EnumSet.noneOf(State.class);
            }
        }
        ,
        FAILED{

            @Override
            EnumSet<State> getOutboundStates() {
                return EnumSet.noneOf(State.class);
            }
        };


        abstract EnumSet<State> getOutboundStates();
    }
}

