/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.quota;

import java.util.EnumMap;
import org.apache.kafka.server.quota.ClientQuotaType;

public class MultiTenantQuotaConfig {
    static final double UNLIMITED_THROUGHPUT_QUOTA = 9.223372036854776E18;
    static final double UNLIMITED_REQUEST_QUOTA = 2.147483647E9;
    static final double UNLIMITED_CONTROLLER_RATE_QUOTA = 2.147483647E9;
    static final double UNLIMITED_PRODUCER_ID_QUOTA = 2.147483647E9;
    static final double UNLIMITED_LINK_REQUEST_QUOTA = 2.147483647E9;
    public static final MultiTenantQuotaConfig UNLIMITED_QUOTA = new MultiTenantQuotaConfig(9.223372036854776E18, 9.223372036854776E18, 2.147483647E9, 2.147483647E9, 2.147483647E9, 2.147483647E9);
    private final EnumMap<ClientQuotaType, Double> quotas = new EnumMap(ClientQuotaType.class);

    public MultiTenantQuotaConfig(Long produceQuota, Long fetchQuota, Double requestQuota, Double controllerQuota, Double producerIdQuota, Double linkRequestQuota, MultiTenantQuotaConfig defaultQuota) {
        this(produceQuota == null ? defaultQuota.quota(ClientQuotaType.PRODUCE) : (double)produceQuota.longValue(), fetchQuota == null ? defaultQuota.quota(ClientQuotaType.FETCH) : (double)fetchQuota.longValue(), requestQuota == null ? defaultQuota.quota(ClientQuotaType.REQUEST) : requestQuota.doubleValue(), controllerQuota == null ? defaultQuota.quota(ClientQuotaType.CONTROLLER_MUTATION) : controllerQuota.doubleValue(), producerIdQuota == null ? defaultQuota.quota(ClientQuotaType.PRODUCER_ID) : producerIdQuota.doubleValue(), linkRequestQuota == null ? defaultQuota.quota(ClientQuotaType.LINK_REQUEST) : linkRequestQuota.doubleValue());
    }

    public Long equalQuotaPerBrokerOrUnlimited(ClientQuotaType quotaType, int numBrokers, Long quotaIfNoBrokers) {
        if (numBrokers <= 0) {
            return quotaIfNoBrokers;
        }
        Double quota = this.hasQuotaLimit(quotaType) ? this.quota(quotaType) / (double)numBrokers : UNLIMITED_QUOTA.quota(quotaType);
        return Math.max(1L, quota.longValue());
    }

    MultiTenantQuotaConfig(double produceQuota, double fetchQuota, double requestQuota, double controllerMutationQuota, double producerIdQuota, double linkRequestQuota) {
        if (produceQuota <= 0.0 || fetchQuota <= 0.0 || requestQuota <= 0.0 || controllerMutationQuota <= 0.0 || producerIdQuota <= 0.0 || linkRequestQuota <= 0.0) {
            throw new IllegalArgumentException(String.format("Invalid quota produce=%f fetch=%f request=%f controller=%f linkRequest=%f", produceQuota, fetchQuota, requestQuota, controllerMutationQuota, linkRequestQuota));
        }
        this.quotas.put(ClientQuotaType.PRODUCE, produceQuota);
        this.quotas.put(ClientQuotaType.FETCH, fetchQuota);
        this.quotas.put(ClientQuotaType.REQUEST, requestQuota);
        this.quotas.put(ClientQuotaType.CONTROLLER_MUTATION, controllerMutationQuota);
        this.quotas.put(ClientQuotaType.PRODUCER_ID, producerIdQuota);
        this.quotas.put(ClientQuotaType.LINK_REQUEST, linkRequestQuota);
    }

    public MultiTenantQuotaConfig withQuota(ClientQuotaType quotaType, double quotaValue) {
        EnumMap<ClientQuotaType, Double> newQuotas = new EnumMap<ClientQuotaType, Double>(this.quotas);
        newQuotas.put(quotaType, quotaValue);
        return new MultiTenantQuotaConfig(newQuotas.get((Object)ClientQuotaType.PRODUCE), newQuotas.get((Object)ClientQuotaType.FETCH), newQuotas.get((Object)ClientQuotaType.REQUEST), newQuotas.get((Object)ClientQuotaType.CONTROLLER_MUTATION), newQuotas.get((Object)ClientQuotaType.PRODUCER_ID), newQuotas.get((Object)ClientQuotaType.LINK_REQUEST));
    }

    public boolean hasQuotaLimit(ClientQuotaType quotaType) {
        return this.quota(quotaType) != UNLIMITED_QUOTA.quota(quotaType);
    }

    public double quota(ClientQuotaType quotaType) {
        return this.quotas.get((Object)quotaType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTenantQuotaConfig that = (MultiTenantQuotaConfig)o;
        return this.quotas.equals((Object)that.quotas);
    }

    public int hashCode() {
        return this.quotas.hashCode();
    }

    public String toString() {
        return "MultiTenantQuotaConfig(quotas=" + String.valueOf(this.quotas) + ")";
    }
}

