/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Optional;
import kafka.controller.DataBalanceManager;
import kafka.controller.NoOpDataBalanceManager;
import kafka.server.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

public final class DataBalanceManager$ {
    public static final DataBalanceManager$ MODULE$ = new DataBalanceManager$();
    private static final Logger log = LoggerFactory.getLogger(DataBalanceManager.class);

    private Logger log() {
        return log;
    }

    public DataBalanceManager apply(KafkaConfig kafkaConfig) {
        DataBalanceManager dataBalanceManager;
        String dataBalancerClassName = (String)Option$.MODULE$.apply(kafkaConfig.getString("confluent.balancer.class")).filter((Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0<String> & Serializable)() -> "io.confluent.databalancer.SbcDataBalanceManager");
        this.log().info("DataBalancer: attempting startup with " + dataBalancerClassName);
        try {
            Optional interBrokerEndpointOpt = Optional.empty();
            dataBalanceManager = (DataBalanceManager)Class.forName(dataBalancerClassName).getConstructor(KafkaConfig.class, Optional.class).newInstance(kafkaConfig, interBrokerEndpointOpt);
        }
        catch (ClassNotFoundException e) {
            this.log().error("DataBalancer: Unable to load data balancer class " + dataBalancerClassName);
            dataBalanceManager = new NoOpDataBalanceManager(dataBalancerClassName, e);
        }
        catch (Exception e) {
            this.log().error("DataBalancer: Data balancer class load of " + dataBalancerClassName + " failed: ", e);
            dataBalanceManager = new NoOpDataBalanceManager(dataBalancerClassName, e);
        }
        return dataBalanceManager;
    }

    private DataBalanceManager$() {
    }
}

