/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.Kafka$;
import kafka.common.TenantHelpers;
import kafka.controller.PartitionSLOMetrics;
import org.apache.kafka.common.Uuid;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class PartitionSLOMetrics$ {
    public static final PartitionSLOMetrics$ MODULE$ = new PartitionSLOMetrics$();
    private static final HashMap<String, PartitionSLOMetrics> partitionMetricsMap = HashMap$.MODULE$.empty();
    private static int brokerId = 0;
    private static final String globalPartitionMetricsKey = "global_" + Uuid.randomUuid().toString();
    private static boolean isActiveController = false;
    private static boolean isMultiTenantCluster = false;
    private static final String TenantPartitionAvailabilitySLOMetric = "TenantPartitionAvailability";
    private static final String GlobalPartitionAvailabilityMetric = "PartitionAvailability";
    private static final String GlobalUnderMinIsrPartitionCountMetric = "GlobalUnderMinIsrPartitionCount";
    private static final String GlobalPartitionCountMetric = "GlobalPartitionCount";
    private static final String GlobalOfflinePartitionsCount = "OfflinePartitionsCount";

    private HashMap<String, PartitionSLOMetrics> partitionMetricsMap() {
        return partitionMetricsMap;
    }

    private int brokerId() {
        return brokerId;
    }

    private void brokerId_$eq(int x$1) {
        brokerId = x$1;
    }

    private String globalPartitionMetricsKey() {
        return globalPartitionMetricsKey;
    }

    public boolean isActiveController() {
        return isActiveController;
    }

    public void isActiveController_$eq(boolean x$1) {
        isActiveController = x$1;
    }

    public boolean isMultiTenantCluster() {
        return isMultiTenantCluster;
    }

    public void isMultiTenantCluster_$eq(boolean x$1) {
        isMultiTenantCluster = x$1;
    }

    public String TenantPartitionAvailabilitySLOMetric() {
        return TenantPartitionAvailabilitySLOMetric;
    }

    public String GlobalPartitionAvailabilityMetric() {
        return GlobalPartitionAvailabilityMetric;
    }

    public String GlobalUnderMinIsrPartitionCountMetric() {
        return GlobalUnderMinIsrPartitionCountMetric;
    }

    public String GlobalPartitionCountMetric() {
        return GlobalPartitionCountMetric;
    }

    public String GlobalOfflinePartitionsCount() {
        return GlobalOfflinePartitionsCount;
    }

    public HashMap<String, PartitionSLOMetrics> getPartitionMetricsMap() {
        return this.partitionMetricsMap();
    }

    public Option<PartitionSLOMetrics> getPartitionMetrics(String key) {
        return this.partitionMetricsMap().get(key);
    }

    public PartitionSLOMetrics apply(boolean perTenantMetrics, Map<String, String> tags) {
        PartitionSLOMetrics metricsInstance = new PartitionSLOMetrics(perTenantMetrics, tags);
        metricsInstance.createMetrics();
        return metricsInstance;
    }

    public void onControllerChange(int broker, boolean activeController, boolean multiTenant) {
        this.isActiveController_$eq(activeController);
        this.isMultiTenantCluster_$eq(multiTenant);
        this.brokerId_$eq(broker);
        Kafka$.MODULE$.info((Function0<String> & Serializable)() -> "Partition SLO metrics processing controller change event for the broker " + MODULE$.brokerId() + " with flags [isActiveController: " + MODULE$.isActiveController() + ", isMultiTenant: " + MODULE$.isMultiTenantCluster() + "]");
        if (this.isActiveController()) {
            this.getOrCreateMetrics(this.globalPartitionMetricsKey(), false);
            return;
        }
        Kafka$.MODULE$.info((Function0<String> & Serializable)() -> "Unregistering the Partition SLO metrics from the broker " + MODULE$.brokerId());
        this.partitionMetricsMap().foreach((Function1<Tuple2, Object> & Serializable)p -> {
            PartitionSLOMetrics$.$anonfun$onControllerChange$3(p);
            return BoxedUnit.UNIT;
        });
        this.partitionMetricsMap().clear();
    }

    public void updateGlobalPartitionMetrics(int partitionCount, int offlineCount, int underMinIsrCount) {
        Option<PartitionSLOMetrics> tm = this.partitionMetricsMap().get(this.globalPartitionMetricsKey());
        if (tm.isDefined()) {
            tm.get().update(partitionCount, offlineCount, underMinIsrCount);
            return;
        }
    }

    public void updateTenantPartitionMetrics(String topic, int partitionCount, int offlinePartitionCount, int underMinIsrPartitionCount) {
        this.getTenantPartitionMetrics(topic).foreach((Function1<PartitionSLOMetrics, Object> & Serializable)tm -> {
            tm.update(partitionCount, offlinePartitionCount, underMinIsrPartitionCount);
            return BoxedUnit.UNIT;
        });
    }

    public void updateTenantPartitionCount(String topic, int count) {
        this.getTenantPartitionMetrics(topic).foreach((Function1<PartitionSLOMetrics, Object> & Serializable)tm -> {
            tm.updatePartitionCountIncremental(count);
            return BoxedUnit.UNIT;
        });
    }

    public void updateTenantOfflinePartitionCount(String topic, int count) {
        this.getTenantPartitionMetrics(topic).foreach((Function1<PartitionSLOMetrics, Object> & Serializable)tm -> {
            tm.updateOfflinePartitionCountIncremental(count);
            return BoxedUnit.UNIT;
        });
    }

    public void updateTenantUnderMinIsrCount(String topic, int count) {
        this.getTenantPartitionMetrics(topic).foreach((Function1<PartitionSLOMetrics, Object> & Serializable)tm -> {
            tm.updateUnderMinIsrCountIncremental(count);
            return BoxedUnit.UNIT;
        });
    }

    private Option<PartitionSLOMetrics> getTenantPartitionMetrics(String topic) {
        Option<String> tenantName = Option$.MODULE$.apply(TenantHelpers.extractTenantPrefix(topic, false));
        if (this.isMultiTenantCluster() && this.isActiveController() && tenantName.isDefined()) {
            return Option$.MODULE$.apply(this.getOrCreateMetrics(tenantName.get(), this.getOrCreateMetrics$default$2()));
        }
        return None$.MODULE$;
    }

    private PartitionSLOMetrics getOrCreateMetrics(String name, boolean perTenantMetrics) {
        return this.partitionMetricsMap().getOrElseUpdate(name, (Function0<PartitionSLOMetrics> & Serializable)() -> MODULE$.apply(perTenantMetrics, (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("tenant"), name)}))));
    }

    private boolean getOrCreateMetrics$default$2() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$onControllerChange$3(Tuple2 p) {
        ((PartitionSLOMetrics)p._2()).removeMetrics();
    }

    private PartitionSLOMetrics$() {
    }
}

