/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import io.confluent.kafka.availability.FilesWrapper;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kafka.log.LogManager$;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.server.util.FileLock;
import scala.Function1;
import scala.collection.SeqOps;

public final class KafkaRaftManager$ {
    public static final KafkaRaftManager$ MODULE$ = new KafkaRaftManager$();

    public File kafka$raft$KafkaRaftManager$$createLogDirectory(File logDir, String logDirName) {
        String logDirPath = logDir.getAbsolutePath();
        File dir = new File(logDirPath, logDirName);
        FilesWrapper.createDirectories(dir.toPath(), new FileAttribute[0]);
        return dir;
    }

    public FileLock kafka$raft$KafkaRaftManager$$lockDataDir(File dataDir) {
        FileLock lock = new FileLock(new File(dataDir, LogManager$.MODULE$.LockFileName()));
        if (!lock.tryLock()) {
            throw new KafkaException("Failed to acquire lock on file .lock in " + lock.file().getParent() + ". A Kafka instance in another process or thread is using this directory.");
        }
        return lock;
    }

    public boolean kafka$raft$KafkaRaftManager$$hasDifferentLogDir(KafkaConfig config) {
        return !((SeqOps)config.logDirs().map((Function1<String, Path> & Serializable)x$1 -> Paths.get(x$1, new String[0]).toAbsolutePath())).contains(Paths.get(config.metadataLogDir(), new String[0]).toAbsolutePath());
    }

    private KafkaRaftManager$() {
    }
}

