/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kafka.restore.db.PartitionRestoreContext;
import kafka.restore.messages.MessageResponse;
import kafka.restore.snapshot.FtpsStateForRestore;
import kafka.restore.statemachine.StateTransitionLog;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.api.Transition;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreFiniteStateMachine
implements FiniteStateMachine {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreFiniteStateMachine.class);
    private State currentState;
    private final Set<Transition<Event>> transitions;
    private final Map<String, Object> metadata;
    private final PartitionRestoreContext partitionRestoreCtx;
    private final TopicPartition tp;
    private final FtpsStateForRestore ftpsForRestore;
    private static final Set<State> STATES = State.allStates();
    private static final State END_STATE = State.LOG_START_OFFSET_RESTORED;
    private final List<StateTransitionLog> stateTransitionLogs = new ArrayList<StateTransitionLog>();

    public RestoreFiniteStateMachine(PartitionRestoreContext ctx, Set<Transition<Event>> transitions) {
        this(ctx, transitions, null);
    }

    public RestoreFiniteStateMachine(PartitionRestoreContext ctx, Set<Transition<Event>> transitions, FtpsStateForRestore ftpsForRestore) {
        this.currentState = State.START;
        this.metadata = new HashMap<String, Object>();
        this.partitionRestoreCtx = ctx;
        this.transitions = transitions;
        this.tp = new TopicPartition(ctx.topic, ctx.partitionConfig.getPartition());
        this.ftpsForRestore = ftpsForRestore;
    }

    @Override
    public Object getMetadata(String key) {
        switch (key) {
            case "topic": {
                return this.partitionRestoreCtx.topic;
            }
            case "partition": {
                return this.partitionRestoreCtx.partitionConfig.getPartition();
            }
            case "partition_leader": {
                return this.partitionRestoreCtx.partitionConfig.getLeader();
            }
            case "partition_replicas": {
                return this.partitionRestoreCtx.partitionConfig.getReplicas();
            }
            case "restore_from_timestamp": {
                return this.partitionRestoreCtx.timeStampRestoreFrom;
            }
            case "revert_compaction_since_timestamp": {
                return this.partitionRestoreCtx.revertCompactionSinceTimestamp;
            }
            case "partition_restore_context": {
                return this.partitionRestoreCtx;
            }
            case "state_transition_logs": {
                return this.stateTransitionLogs;
            }
            case "ftps_for_restore": {
                return this.ftpsForRestore;
            }
        }
        return this.metadata.getOrDefault(key, null);
    }

    @Override
    public void addMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    @Override
    public Set<State> states() {
        return STATES;
    }

    @Override
    public State currentState() {
        return this.currentState;
    }

    @Override
    public Set<Transition<Event>> transitions() {
        return this.transitions;
    }

    @Override
    public synchronized State fire(Event event) {
        if (event == null) {
            LOGGER.warn("Null event fired, FSM state unchanged");
            return this.currentState;
        }
        MessageResponse response = (MessageResponse)event.getData("message_response");
        TopicPartition responseTopicPartition = new TopicPartition(response.getTopic(), response.getPartition());
        if (!this.tp.equals(responseTopicPartition)) {
            LOGGER.warn(String.format("[%s]: wrong StateMachine to handle this response %s, FSM state unchanged", this.tp, response));
            return this.currentState;
        }
        LOGGER.debug(String.format("[%s]: handling %s", this.tp, event));
        switch (response.getStatusCode()) {
            case OK: {
                this.currentState = this.handleEvent(event);
                break;
            }
            default: {
                LOGGER.error(String.format("[%s]: Permanent error, mark the partition as failed, response status: %s, result: %s", new Object[]{this.tp, response.getStatusCode(), response.getResult()}));
                this.currentState = State.FAILED;
                this.partitionRestoreCtx.status = PartitionRestoreContext.RestoreStatus.FAILED;
            }
        }
        return this.currentState;
    }

    private State handleEvent(Event event) {
        boolean handled = false;
        for (Transition<Event> transition2 : this.transitions) {
            if (handled || !this.currentState.equals(transition2.getSourceState()) || !STATES.contains(transition2.getTargetState())) continue;
            try {
                handled = transition2.handleEvent(this, event);
                if (handled) {
                    LOGGER.info(String.format("[%s]: %s -> %s by %s", this.tp, this.currentState, transition2.getTargetState(), transition2.getName()));
                    StateTransitionLog stateTransitionLog = new StateTransitionLog(this.currentState, null);
                    this.stateTransitionLogs.add(stateTransitionLog);
                    stateTransitionLog.to = transition2.getTargetState();
                    this.currentState = transition2.getTargetState();
                    if (this.currentState == END_STATE) {
                        this.partitionRestoreCtx.status = PartitionRestoreContext.RestoreStatus.COMPLETED;
                        continue;
                    }
                    this.partitionRestoreCtx.status = PartitionRestoreContext.RestoreStatus.IN_PROGRESS;
                    continue;
                }
                LOGGER.info(String.format("[%s]: %s skipped", this.tp, transition2.getName()));
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception caught during transition handling, transit to failed.", e);
                this.currentState = State.FAILED;
                this.partitionRestoreCtx.status = PartitionRestoreContext.RestoreStatus.FAILED;
                handled = true;
                break;
            }
        }
        if (!handled) {
            LOGGER.warn(String.format("[%s]: No transition found to handle %s, FSM state unchanged", this.tp, event));
        }
        return this.currentState;
    }

    @Override
    public void transitToState(State state) {
        this.currentState = state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String topic = this.partitionRestoreCtx.topic;
        int partition = this.partitionRestoreCtx.partitionConfig.getPartition();
        sb.append(topic + "-" + partition).append(": ").append(this.currentState);
        return sb.toString();
    }

    @Override
    public void cleanup() {
        long restoreSegmentStateMapSize = 0L;
        if (this.getMetadata("restore_segment_map_size") != null) {
            restoreSegmentStateMapSize = ((Integer)this.getMetadata("restore_segment_map_size")).intValue();
        }
        LOGGER.info(String.format("[%s]: cleanup segment state map, which has %s segments", this.tp, restoreSegmentStateMapSize));
        this.metadata.remove("restore_segment_map");
        if (this.getMetadata("ftps_for_restore") != null) {
            this.metadata.remove("ftps_for_restore");
        }
    }
}

