/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.multitenant.ClusterLinkPrincipal;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientSensors;
import kafka.server.ClusterLinkQuotaRecordListener;
import kafka.server.ClusterLinkQuotas$;
import kafka.server.ClusterLinkReplicaQuota;
import kafka.server.ClusterLinkReplicationConfig;
import kafka.server.ClusterLinkReplicationQuotaManager$;
import kafka.server.ClusterLinkTenantContext;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.quota.QuotaType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t-t!\u0002\u0014(\u0011\u0003ac!\u0002\u0018(\u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039d\u0001\u0002\u0018(\u0001aB\u0001\"R\u0002\u0003\u0006\u0004%IA\u0012\u0005\t\u0015\u000e\u0011\t\u0011)A\u0005\u000f\"I1j\u0001BC\u0002\u0013\u0005q\u0005\u0014\u0005\t!\u000e\u0011\t\u0011)A\u0005\u001b\"A\u0011k\u0001BC\u0002\u0013%!\u000b\u0003\u0005`\u0007\t\u0005\t\u0015!\u0003T\u0011!\u00017A!b\u0001\n\u0013\t\u0007\u0002C4\u0004\u0005\u0003\u0005\u000b\u0011\u00022\t\u000bY\u001aA\u0011\u00015\t\u000f9\u001c!\u0019!C!_\"1qo\u0001Q\u0001\nADq\u0001_\u0002C\u0002\u0013%\u0011\u0010\u0003\u0004~\u0007\u0001\u0006IA\u001f\u0005\b}\u000e\u0011\r\u0011\"\u0003\u0000\u0011!\t9a\u0001Q\u0001\n\u0005\u0005\u0001bBA\u0005\u0007\u0011%\u00111\u0002\u0005\t\u0003\u001b\u0019A\u0011A\u0014\u0002\u0010!A\u0011qC\u0002\u0005\u0002\u001d\nI\u0002\u0003\u0005\u0002$\r!\taJA\u0013\u0011\u001d\t9e\u0001C\u0005\u0003\u0013Bq!! \u0004\t\u0013\ty\bC\u0004\u0002\"\u000e!I!a)\t\u000f\u0005m6\u0001\"\u0011\u0002>\"9\u0011\u0011[\u0002\u0005B\u0005M\u0007bBAq\u0007\u0011\u0005\u00131\u001d\u0005\b\u0003O\u001cA\u0011BAu\u0011\u001d\u0011\tb\u0001C\u0001\u0005'AqA!\b\u0004\t\u0003\u0012y\u0002C\u0004\u0003&\r!\tEa\n\t\u000f\t%2\u0001\"\u0001\u0003,!9!QG\u0002\u0005\u0002\t\u001d\u0002b\u0002B\u001c\u0007\u0011\u0005!\u0011\b\u0005\n\u0005w\u0019!\u0019!C\u0001\u0005{A\u0001B!\u001b\u0004A\u0003%!qH\u0001#\u00072,8\u000f^3s\u0019&t7NU3qY&\u001c\u0017\r^5p]F+x\u000e^1NC:\fw-\u001a:\u000b\u0005!J\u0013AB:feZ,'OC\u0001+\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!L\u0001\u000e\u0003\u001d\u0012!e\u00117vgR,'\u000fT5oWJ+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u00148CA\u00011!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001L\n\u0006\u0007AJtH\u0011\t\u0003uuj\u0011a\u000f\u0006\u0003y%\nQ!\u001e;jYNL!AP\u001e\u0003\u000f1{wmZ5oOB\u0011Q\u0006Q\u0005\u0003\u0003\u001e\u0012qc\u00117vgR,'\u000fT5oWJ+\u0007\u000f\\5dCF+x\u000e^1\u0011\u00055\u001a\u0015B\u0001#(\u0005y!\u0015n]6Vg\u0006<WMQ1tK\u0012$\u0006N]8ui2,G*[:uK:,'/A\u000bmS:\\'+\u001a9mS\u000e\fG/[8o\u0007>tg-[4\u0016\u0003\u001d\u0003\"!\f%\n\u0005%;#\u0001H\"mkN$XM\u001d'j].\u0014V\r\u001d7jG\u0006$\u0018n\u001c8D_:4\u0017nZ\u0001\u0017Y&t7NU3qY&\u001c\u0017\r^5p]\u000e{gNZ5hA\u0005\u0019\u0002O]8ek\u000e,\u0017+^8uC6\u000bg.Y4feV\tQ\n\u0005\u0002.\u001d&\u0011qj\n\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'/\u0001\u000bqe>$WoY3Rk>$\u0018-T1oC\u001e,'\u000fI\u0001\b[\u0016$(/[2t+\u0005\u0019\u0006C\u0001+^\u001b\u0005)&BA)W\u0015\t9\u0006,\u0001\u0004d_6lwN\u001c\u0006\u0003UeS!AW.\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0016aA8sO&\u0011a,\u0016\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016,\u0012A\u0019\t\u0003G\u0016l\u0011\u0001\u001a\u0006\u0003yYK!A\u001a3\u0003\tQKW.Z\u0001\u0006i&lW\r\t\u000b\u0006S*\\G.\u001c\t\u0003[\rAQ!\u0012\u0007A\u0002\u001dCQa\u0013\u0007A\u00025CQ!\u0015\u0007A\u0002MCQ\u0001\u0019\u0007A\u0002\t\f\u0011\"];pi\u0006$\u0016\u0010]3\u0016\u0003A\u0004\"!];\u000e\u0003IT!a\u001d;\u0002\u000bE,x\u000e^1\u000b\u0005!B\u0016B\u0001<s\u0005%\tVo\u001c;b)f\u0004X-\u0001\u0006rk>$\u0018\rV=qK\u0002\n1C]3qY&\u001c\u0017-U;pi\u0006l\u0015M\\1hKJ,\u0012A\u001f\t\u0003[mL!\u0001`\u0014\u0003/I+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u0014\u0018\u0001\u0006:fa2L7-Y)v_R\fW*\u00198bO\u0016\u0014\b%\u0001\u0010uK:\fg\u000e^)v_R\fw\n]:FeJ|'oQ8v]R\u001cVM\\:peV\u0011\u0011\u0011\u0001\t\u0004)\u0006\r\u0011bAA\u0003+\n11+\u001a8t_J\fq\u0004^3oC:$\u0018+^8uC>\u00038/\u0012:s_J\u001cu.\u001e8u'\u0016t7o\u001c:!\u0003\u0011\u001a'/Z1uKR+g.\u00198u#V|G/Y(qg\u0016\u0013(o\u001c:D_VtGoU3og>\u0014HCAA\u0001\u0003\u0001:W\r\u001e+f]\u0006tG/U;pi\u0006|\u0005o]#se>\u00148i\\;oiR{G/\u00197\u0015\u0005\u0005E\u0001cA\u0019\u0002\u0014%\u0019\u0011Q\u0003\u001a\u0003\r\u0011{WO\u00197f\u0003):W\r\u001e+f]\u0006tG/U;pi\u0006|\u0005o]#se>\u00148i\\;oiR{G/\u00197NKR\u0014\u0018n\u0019(b[\u0016,\"!a\u0007\u0011\t\u0005u\u0011qD\u0007\u0002-&\u0019\u0011\u0011\u0005,\u0003\u00155+GO]5d\u001d\u0006lW-\u0001\u0010hKRdunY1m!J|G-^2f#V|G/Y'fiJL7MT1nKR!\u00111DA\u0014\u0011\u001d\tIC\u0006a\u0001\u0003W\tq\"];pi\u0006lU\r\u001e:jGR\u000bwm\u001d\t\t\u0003[\tY$!\u0011\u0002B9!\u0011qFA\u001c!\r\t\tDM\u0007\u0003\u0003gQ1!!\u000e,\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\b\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\ti$a\u0010\u0003\u00075\u000b\u0007OC\u0002\u0002:I\u0002B!!\f\u0002D%!\u0011QIA \u0005\u0019\u0019FO]5oO\u0006\u0011r-\u001a;UK:\fg\u000e^)v_R\fWj\u001c3f)\u0011\tY%!\u001f\u0011\t\u00055\u00131\u000f\b\u0005\u0003\u001f\niG\u0004\u0003\u0002R\u0005\u001dd\u0002BA*\u0003GrA!!\u0016\u0002b9!\u0011qKA0\u001d\u0011\tI&!\u0018\u000f\t\u0005E\u00121L\u0005\u00029&\u0011!lW\u0005\u0003UeK!a\u0016-\n\u0007\u0005\u0015d+\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003S\nY'A\u0005j]R,'O\\1mg*\u0019\u0011Q\r,\n\t\u0005=\u0014\u0011O\u0001\u0011\u0007>tg\r\\;f]R\u001cuN\u001c4jONTA!!\u001b\u0002l%!\u0011QOA<\u0005Q\u0019E.^:uKJd\u0015N\\6Rk>$\u0018-T8eK*!\u0011qNA9\u0011\u001d\tYh\u0006a\u0001\u0003\u0003\na\u0001^3oC:$\u0018AF5t\u00072,8\u000f^3s\u0019&t7\u000e\u0015:j]\u000eL\u0007/\u00197\u0015\t\u0005\u0005\u0015q\u0011\t\u0004c\u0005\r\u0015bAACe\t9!i\\8mK\u0006t\u0007bBAE1\u0001\u0007\u00111R\u0001\naJLgnY5qC2\u0004B!!$\u0002\u001e6\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0006nk2$\u0018\u000e^3oC:$(b\u0001\u0016\u0002\u0016*!\u0011qSAM\u0003%\u0019wN\u001c4mk\u0016tGO\u0003\u0002\u0002\u001c\u0006\u0011\u0011n\\\u0005\u0005\u0003?\u000byI\u0001\u000bNk2$\u0018\u000eV3oC:$\bK]5oG&\u0004\u0018\r\\\u0001\u0015G2,8\u000f^3s\u0019&t7\u000e\u0015:j]\u000eL\u0007/\u00197\u0015\t\u0005\u0015\u0016\u0011\u0017\t\u0006c\u0005\u001d\u00161V\u0005\u0004\u0003S\u0013$AB(qi&|g\u000e\u0005\u0003\u0002\u000e\u00065\u0016\u0002BAX\u0003\u001f\u0013Ac\u00117vgR,'\u000fT5oWB\u0013\u0018N\\2ja\u0006d\u0007bBAZ3\u0001\u0007\u0011QW\u0001\u0012Y&t7\u000eV3oC:$8i\u001c8uKb$\bcA\u0017\u00028&\u0019\u0011\u0011X\u0014\u00031\rcWo\u001d;fe2Kgn\u001b+f]\u0006tGoQ8oi\u0016DH/\u0001\u0004sK\u000e|'\u000f\u001a\u000b\u0007\u0003\u007f\u000b)-a2\u0011\u0007E\n\t-C\u0002\u0002DJ\u0012A!\u00168ji\"9\u00111\u0017\u000eA\u0002\u0005U\u0006bBAe5\u0001\u0007\u00111Z\u0001\u0006m\u0006dW/\u001a\t\u0004c\u00055\u0017bAAhe\t!Aj\u001c8h\u0003-I7\u000f\u00165s_R$H.\u001a3\u0015\r\u0005\u0005\u0015Q[Al\u0011\u001d\t\u0019l\u0007a\u0001\u0003kCq!!7\u001c\u0001\u0004\tY.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005u\u0011Q\\\u0005\u0004\u0003?4&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010SN\fVo\u001c;b\u000bb\u001cW-\u001a3fIR!\u0011\u0011QAs\u0011\u001d\t\u0019\f\ba\u0001\u0003k\u000b\u0011eY1mY^KG\u000f['fiJL7-\u0012=jgR\u001cXI\u001d:pe\"\u000bg\u000e\u001a7j]\u001e,B!a;\u0002rR1\u0011Q\u001eB\u0002\u0005\u001b\u0001B!a<\u0002r2\u0001AaBAz;\t\u0007\u0011Q\u001f\u0002\u0002)F!\u0011q_A\u007f!\r\t\u0014\u0011`\u0005\u0004\u0003w\u0014$a\u0002(pi\"Lgn\u001a\t\u0004c\u0005}\u0018b\u0001B\u0001e\t\u0019\u0011I\\=\t\u000f\t\u0015Q\u00041\u0001\u0003\b\u0005!1-\u00197m!\u0015\t$\u0011BAw\u0013\r\u0011YA\r\u0002\n\rVt7\r^5p]BBqAa\u0004\u001e\u0001\u0004\u00119!A\u0006feJ|'OU3tk2$\u0018!E4fiRC'o\u001c;uY\u0016$\u0016.\\3NgR!!Q\u0003B\u000e!\r\t$qC\u0005\u0004\u00053\u0011$aA%oi\"9\u00111\u0017\u0010A\u0002\u0005U\u0016A\u00055b]\u0012dW\rR5tWN\u0003\u0018mY3M_^$B!a0\u0003\"!9!1E\u0010A\u0002\u0005-\u0017\u0001G2baB,G-U;pi\u0006LeNQ=uKN\u0004VM]*fG\u0006A\u0002.\u00198eY\u0016$\u0015n]6Ta\u0006\u001cWMU3d_Z,'/\u001a3\u0015\u0005\u0005}\u0016aC;qI\u0006$X-U;pi\u0006$B!a0\u0003.!11/\ta\u0001\u0005_\u00012\u0001\u0016B\u0019\u0013\r\u0011\u0019$\u0016\u0002\u0006#V|G/Y\u0001\u0014[\u0006\u00148N\u0011:pW\u0016\u0014H\u000b\u001b:piRdW\rZ\u0001\u0014O\u0016$(I]8lKJ\fVo\u001c;b\u0019&l\u0017\u000e^\u000b\u0003\u0003#\t\u0001\u0004\\1tiNKwM\\1mY\u0016$\u0017+^8uC>\u0003HOU3g+\t\u0011y\u0004\u0005\u0004\u0003B\tM#qK\u0007\u0003\u0005\u0007RAA!\u0012\u0003H\u00051\u0011\r^8nS\u000eTAA!\u0013\u0003L\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\t5#qJ\u0001\u0005kRLGN\u0003\u0002\u0003R\u0005!!.\u0019<b\u0013\u0011\u0011)Fa\u0011\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004bA!\u0017\u0003\\\t}SB\u0001B&\u0013\u0011\u0011iFa\u0013\u0003\u0011=\u0003H/[8oC2\u0004BA!\u0019\u0003h5\u0011!1\r\u0006\u0005\u0005K\u0012y%\u0001\u0003mC:<\u0017\u0002BAh\u0005G\n\u0011\u0004\\1tiNKwM\\1mY\u0016$\u0017+^8uC>\u0003HOU3gA\u0001")
public class ClusterLinkReplicationQuotaManager
implements Logging,
ClusterLinkReplicaQuota,
DiskUsageBasedThrottleListener {
    private final ClusterLinkReplicationConfig kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig;
    private final ClientQuotaManager produceQuotaManager;
    private final Metrics kafka$server$ClusterLinkReplicationQuotaManager$$metrics;
    private final Time time;
    private final QuotaType quotaType;
    private final ReplicationQuotaManager kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager;
    private final Sensor tenantQuotaOpsErrorCountSensor;
    private final AtomicReference<Optional<Long>> lastSignalledQuotaOptRef;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkReplicationQuotaManager clusterLinkReplicationQuotaManager = this;
        synchronized (clusterLinkReplicationQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkReplicationConfig kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig() {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig;
    }

    public ClientQuotaManager produceQuotaManager() {
        return this.produceQuotaManager;
    }

    public Metrics kafka$server$ClusterLinkReplicationQuotaManager$$metrics() {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$metrics;
    }

    private Time time() {
        return this.time;
    }

    @Override
    public QuotaType quotaType() {
        return this.quotaType;
    }

    public ReplicationQuotaManager kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager() {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager;
    }

    private Sensor tenantQuotaOpsErrorCountSensor() {
        return this.tenantQuotaOpsErrorCountSensor;
    }

    private Sensor createTenantQuotaOpsErrorCountSensor() {
        Sensor sensor = this.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().sensor("tenant-quota-ops-errors-count-sensor");
        MetricName errorCountMetricName = this.getTenantQuotaOpsErrorCountTotalMetricName();
        MetricName errorRateMetricName = this.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metricName("tenant-quota-ops-errors-count-rate", this.quotaType().toString(), "The rate of tenant quota recording/check/... errors.");
        sensor.add(errorCountMetricName, new CumulativeSum());
        sensor.add(errorRateMetricName, new Rate());
        return sensor;
    }

    public double getTenantQuotaOpsErrorCountTotal() {
        return BoxesRunTime.unboxToDouble(this.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metric(this.getTenantQuotaOpsErrorCountTotalMetricName()).metricValue());
    }

    public MetricName getTenantQuotaOpsErrorCountTotalMetricName() {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metricName("tenant-quota-ops-errors-count-total", this.quotaType().toString(), "The tenant quota recording/check/... error count.");
    }

    public MetricName getLocalProduceQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metricName("local-produce-tokens", this.quotaType().toString(), "Tracking remaining tokens in the token bucket per user/client-id for all produce except cluster linking", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    public ConfluentConfigs.ClusterLinkQuotaMode kafka$server$ClusterLinkReplicationQuotaManager$$getTenantQuotaMode(String tenant) {
        ConfluentConfigs.ClusterLinkQuotaMode defaultClusterLinkQuotaMode = this.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkQuotaMode().apply();
        return (ConfluentConfigs.ClusterLinkQuotaMode)((Object)((MapOps)this.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkQuotaModePerTenantOverrides().apply()).getOrElse(tenant, (Function0<ConfluentConfigs.ClusterLinkQuotaMode> & Serializable)() -> defaultClusterLinkQuotaMode));
    }

    public boolean kafka$server$ClusterLinkReplicationQuotaManager$$isClusterLinkPrincipal(MultiTenantPrincipal principal) {
        return principal instanceof ClusterLinkPrincipal;
    }

    private Option<ClusterLinkPrincipal> clusterLinkPrincipal(ClusterLinkTenantContext linkTenantContext) {
        return ClusterLinkQuotas$.MODULE$.clusterLinkReplicationQuotaPrincipal(this.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig(), linkTenantContext, (Function1<String, ConfluentConfigs.ClusterLinkQuotaMode> & Serializable)tenant -> this.kafka$server$ClusterLinkReplicationQuotaManager$$getTenantQuotaMode((String)tenant));
    }

    @Override
    public void record(ClusterLinkTenantContext linkTenantContext, long value) {
        Option<ClusterLinkPrincipal> option = this.clusterLinkPrincipal(linkTenantContext);
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterLinkPrincipal p = (ClusterLinkPrincipal)some.value();
            this.kafka$server$ClusterLinkReplicationQuotaManager$$callWithMetricExistsErrorHandling(() -> this.produceQuotaManager().maybeRecordAndGetThrottleTimeMs(ClusterLinkQuotas$.MODULE$.session(p), ClusterLinkQuotas$.MODULE$.ClusterLinkClientId(), value, this.time().milliseconds()), () -> {});
            return;
        }
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().record(value);
    }

    @Override
    public boolean isThrottled(ClusterLinkTenantContext linkTenantContext, TopicPartition topicPartition) {
        Option<ClusterLinkPrincipal> option = this.clusterLinkPrincipal(linkTenantContext);
        if (option instanceof Some) {
            return true;
        }
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().isThrottled(topicPartition);
    }

    @Override
    public boolean isQuotaExceeded(ClusterLinkTenantContext linkTenantContext) {
        Option<ClusterLinkPrincipal> option = this.clusterLinkPrincipal(linkTenantContext);
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterLinkPrincipal p = (ClusterLinkPrincipal)some.value();
            return BoxesRunTime.unboxToBoolean(this.kafka$server$ClusterLinkReplicationQuotaManager$$callWithMetricExistsErrorHandling(() -> this.produceQuotaManager().getThrottleTimeMs(ClusterLinkQuotas$.MODULE$.session(p), ClusterLinkQuotas$.MODULE$.ClusterLinkClientId(), this.time().milliseconds()) > 0, () -> true));
        }
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().isQuotaExceeded();
    }

    public <T> T kafka$server$ClusterLinkReplicationQuotaManager$$callWithMetricExistsErrorHandling(Function0<T> call, Function0<T> errorResult) {
        T t;
        try {
            t = call.apply();
        }
        catch (IllegalArgumentException e) {
            this.tenantQuotaOpsErrorCountSensor().record();
            this.debug((Function0<String> & Serializable)() -> "Error making call due to:", (Function0<Throwable>)(Function0<IllegalArgumentException> & Serializable)() -> e);
            t = errorResult.apply();
        }
        return t;
    }

    public int getThrottleTimeMs(ClusterLinkTenantContext linkTenantContext) {
        Option<ClusterLinkPrincipal> option = this.clusterLinkPrincipal(linkTenantContext);
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterLinkPrincipal p = (ClusterLinkPrincipal)some.value();
            return this.produceQuotaManager().getThrottleTimeMs(ClusterLinkQuotas$.MODULE$.session(p), ClusterLinkQuotas$.MODULE$.ClusterLinkClientId(), this.time().milliseconds());
        }
        throw new UnsupportedOperationException("Should not reach here in normal flow");
    }

    @Override
    public void handleDiskSpaceLow(long cappedQuotaInBytesPerSec) {
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().handleDiskSpaceLow(cappedQuotaInBytesPerSec);
    }

    @Override
    public void handleDiskSpaceRecovered() {
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().handleDiskSpaceRecovered();
    }

    public void updateQuota(Quota quota) {
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().updateQuota(quota);
    }

    public void markBrokerThrottled() {
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().markBrokerThrottled();
    }

    public double getBrokerQuotaLimit() {
        return this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().getBrokerQuotaLimit();
    }

    @Override
    public AtomicReference<Optional<Long>> lastSignalledQuotaOptRef() {
        return this.lastSignalledQuotaOptRef;
    }

    public ClusterLinkReplicationQuotaManager(ClusterLinkReplicationConfig linkReplicationConfig, ClientQuotaManager produceQuotaManager, Metrics metrics, Time time) {
        this.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig = linkReplicationConfig;
        this.produceQuotaManager = produceQuotaManager;
        this.kafka$server$ClusterLinkReplicationQuotaManager$$metrics = metrics;
        this.time = time;
        Logging.$init$(this);
        this.quotaType = QuotaType.CLUSTER_LINK_REPLICATION;
        this.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager = new ReplicationQuotaManager(linkReplicationConfig.replicationQuotaManagerConfig(), metrics, QuotaType.CLUSTER_LINK_REPLICATION, time);
        this.tenantQuotaOpsErrorCountSensor = this.createTenantQuotaOpsErrorCountSensor();
        produceQuotaManager.setLinkQuotaRecordListener(new ClusterLinkQuotaRecordListener(this){
            private final /* synthetic */ ClusterLinkReplicationQuotaManager $outer;

            public void maybeRecordWhenClientQuotasDisabled(Session session, String clientId, double value, long timeMs) {
                if (this.isBrokerLevelTotalInboundLinkQuota()) {
                    this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().record((long)value);
                    return;
                }
            }

            public void maybeRecord(ClientSensors clientSensors, double value, long timeMs) {
                if (this.isBrokerLevelTotalInboundLinkQuota()) {
                    this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$replicaQuotaManager().record((long)value);
                    return;
                }
                Option<MultiTenantPrincipal> principal = this.getPrincipal(clientSensors);
                if (principal.nonEmpty() && this.isTenantLevelTotalInboundLinkQuota(principal.get())) {
                    this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$callWithMetricExistsErrorHandling(() -> {
                        if ($this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$isClusterLinkPrincipal((MultiTenantPrincipal)principal.get())) {
                            this.linkUsageSensor((MultiTenantPrincipal)principal.get(), clientSensors).record(value, timeMs, false);
                            return;
                        }
                        this.localProduceQuotaSensor(clientSensors).record(value, timeMs, false);
                    }, () -> {});
                    return;
                }
            }

            public void updateQuotaMetricConfig(Map<String, String> tags, MetricConfig config) {
                KafkaMetric localProduceQuotaMetric = this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metrics().get(this.$outer.getLocalProduceQuotaMetricName(tags));
                if (localProduceQuotaMetric != null) {
                    localProduceQuotaMetric.config(config);
                    return;
                }
            }

            public int adjustedThrottleTimeMs(int throttleTimeMs, ClientSensors clientSensors, long timeMs) {
                KafkaMetric clientMetric;
                Option<MultiTenantPrincipal> principal = this.getPrincipal(clientSensors);
                if (principal.nonEmpty() && !this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$isClusterLinkPrincipal(principal.get()) && this.isTenantLevelTotalInboundLinkQuota(principal.get()) && (clientMetric = this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metrics().get(this.linkClientRateMetricName(this.tenantMetricTags(principal.get())))) != null && BoxesRunTime.unboxToDouble(clientMetric.metricValue()) > 0.0) {
                    double clUsage = BoxesRunTime.unboxToDouble(clientMetric.metricValue());
                    return BoxesRunTime.unboxToInt(this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$callWithMetricExistsErrorHandling(() -> {
                        Sensor quotaSensor = this.localProduceQuotaSensor(clientSensors);
                        int adjustedThrottleTimeMs = $this.$outer.produceQuotaManager().computeThrottleTimeMs(quotaSensor, timeMs, $this.$outer.produceQuotaManager().quotaMaxThrottleTimeMs());
                        $this.$outer.debug((Function0<String> & Serializable)() -> "Adjusting throttleTimeMs=" + throttleTimeMs + " with adjustedThrottleTimeMs=" + adjustedThrottleTimeMs + " using all produce except cl quota sensor, clUsage=" + clUsage + " with tags " + clientSensors.metricTags());
                        return Math.min(throttleTimeMs, adjustedThrottleTimeMs);
                    }, () -> throttleTimeMs));
                }
                return throttleTimeMs;
            }

            private Sensor localProduceQuotaSensor(ClientSensors clientSensors) {
                return clientSensors.sensorAccessor().getOrCreateWithParent(this.getLocalProduceQuotaSensorName(clientSensors.metricTags()), ClientQuotaManager$.MODULE$.InactiveSensorExpirationTimeSeconds(), OptionConverters$.MODULE$.toJava(this.getOrCreateLocalProduceParentQuotaSensor(clientSensors)), sensor -> this.registerLocalProduceQuotaMetrics(clientSensors.metricTags(), (Sensor)sensor));
            }

            private Option<Sensor> getOrCreateLocalProduceParentQuotaSensor(ClientSensors clientSensors) {
                Option option;
                Map<String, String> parentQuotaMetricTags = clientSensors.parentMetricTags();
                if (parentQuotaMetricTags.isEmpty()) {
                    option = None$.MODULE$;
                } else {
                    this.$outer.debug((Function0<String> & Serializable)() -> "Creating parent quota sensor with tags " + parentQuotaMetricTags);
                    option = new Some<Sensor>(clientSensors.sensorAccessor().getOrCreate(this.getLocalProduceQuotaSensorName(parentQuotaMetricTags), ClientQuotaManager$.MODULE$.InactiveSensorExpirationTimeSeconds(), sensor -> this.registerLocalProduceQuotaMetrics(parentQuotaMetricTags, (Sensor)sensor)));
                }
                None$ parentQuotaSensor = option;
                return parentQuotaSensor;
            }

            public void registerLocalProduceQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
                sensor.add(this.$outer.getLocalProduceQuotaMetricName(metricTags), new TokenBucket(TimeUnit.SECONDS, ClientQuotaManager$.MODULE$.MAX_TOKEN_BUCKET_THROTTLE_TIME_MS()), this.$outer.produceQuotaManager().getQuotaMetricConfig(metricTags));
            }

            private Sensor linkUsageSensor(MultiTenantPrincipal principal, ClientSensors clientSensors) {
                Map<String, String> metricTags = this.tenantMetricTags(principal);
                return clientSensors.sensorAccessor().getOrCreate(this.getLinkUsageSensorName(metricTags), ClientQuotaManager$.MODULE$.InactiveSensorExpirationTimeSeconds(), sensor -> sensor.add(this.linkClientRateMetricName(metricTags), new Rate(), $this.$outer.produceQuotaManager().getRateMetricConfig()));
            }

            private String getLocalProduceQuotaSensorName(Map<String, String> metricTags) {
                return this.$outer.quotaType() + "-localproduce-" + ClientQuotaManager$.MODULE$.metricTagsToSensorSuffix(metricTags);
            }

            private String getLinkUsageSensorName(Map<String, String> metricTags) {
                return this.$outer.quotaType() + "-usage-" + ClientQuotaManager$.MODULE$.metricTagsToSensorSuffix(metricTags);
            }

            private MetricName linkClientRateMetricName(Map<String, String> tenantMetricTags) {
                return this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$metrics().metricName("link-byte-rate", this.$outer.quotaType().toString(), "Tracking cluster linking byte-rate per tenant", CollectionConverters$.MODULE$.MapHasAsJava(tenantMetricTags).asJava());
            }

            private Map<String, String> tenantMetricTags(MultiTenantPrincipal principal) {
                return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("tenant"), principal.tenantMetadata().tenantName)}));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean isBrokerLevelTotalInboundLinkQuota() {
                if (!this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkEnable().apply$mcZ$sp()) return false;
                if (this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkTenantQuotaEnable().apply$mcZ$sp()) return false;
                ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkQuotaMode().apply();
                ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode2 = ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND;
                if (clusterLinkQuotaMode != null) {
                    if (!((Object)((Object)clusterLinkQuotaMode)).equals((Object)((Object)clusterLinkQuotaMode2))) return false;
                    return true;
                }
                if (clusterLinkQuotaMode2 == null) return true;
                return false;
            }

            private Option<MultiTenantPrincipal> getPrincipal(ClientSensors clientSensors) {
                return clientSensors.principalOpt().filter((Function1<KafkaPrincipal, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean($anon$1.$anonfun$getPrincipal$1(x$1))).map((Function1<KafkaPrincipal, MultiTenantPrincipal> & Serializable)x$2 -> (MultiTenantPrincipal)x$2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean isTenantLevelTotalInboundLinkQuota(MultiTenantPrincipal principal) {
                if (!this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkEnable().apply$mcZ$sp()) return false;
                if (!this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$linkReplicationConfig().clusterLinkTenantQuotaEnable().apply$mcZ$sp()) return false;
                ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = this.$outer.kafka$server$ClusterLinkReplicationQuotaManager$$getTenantQuotaMode(principal.tenantMetadata().tenantName);
                ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode2 = ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND;
                if (clusterLinkQuotaMode != null) {
                    if (!((Object)((Object)clusterLinkQuotaMode)).equals((Object)((Object)clusterLinkQuotaMode2))) return false;
                    return true;
                }
                if (clusterLinkQuotaMode2 == null) return true;
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$getPrincipal$1(KafkaPrincipal x$1) {
                return x$1 instanceof MultiTenantPrincipal;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$adjustedThrottleTimeMs$1(kafka.server.ClusterLinkReplicationQuotaManager$$anon$1 kafka.server.ClientSensors long int double ), $anonfun$adjustedThrottleTimeMs$2(int int double kafka.server.ClientSensors ), $anonfun$adjustedThrottleTimeMs$3(int ), $anonfun$getOrCreateLocalProduceParentQuotaSensor$1(scala.collection.immutable.Map ), $anonfun$getPrincipal$1$adapted(org.apache.kafka.common.security.auth.KafkaPrincipal ), $anonfun$getPrincipal$2(org.apache.kafka.common.security.auth.KafkaPrincipal ), $anonfun$maybeRecord$1(kafka.server.ClusterLinkReplicationQuotaManager$$anon$1 scala.Option kafka.server.ClientSensors double long ), $anonfun$maybeRecord$2()}, serializedLambda);
            }
        });
        this.lastSignalledQuotaOptRef = new AtomicReference(Optional.empty());
    }
}

