/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.multitenant.ClusterLinkPrincipal;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ClientSensors;
import kafka.server.ClusterLinkQuotas$;
import kafka.server.ClusterLinkRequestQuotaManagerConfig;
import kafka.server.ClusterLinkTenantContext;
import kafka.server.ClusterLinkTenantRequestQuota;
import kafka.server.LinkRequestQuotaUsageType;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.QuotaType;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001\u0002\u000b\u0016\u0001iA\u0001B\t\u0001\u0003\u0006\u0004%Ia\t\u0005\tO\u0001\u0011\t\u0011)A\u0005I!A\u0001\u0006\u0001BC\u0002\u0013%\u0011\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u0003+\u0011%9\u0004A!A!\u0002\u0013Ad\b\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0003A\u0011!q\u0005A!A!\u0002\u0013\t\u0005\u0002C(\u0001\u0005\u000b\u0007I\u0011\u0002)\t\u0011q\u0003!\u0011!Q\u0001\nEC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\u0006E\u0002!\ta\u0019\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006m\u0002!\te\u001e\u0005\u0007w\u0002!\t!\u0006?\t\u0011\u0005\u0005\u0001\u0001\"\u0001\u0016\u0003\u0007Aq!a\n\u0001\t\u0003\nI\u0003C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!i\u0011Q\f\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002`y\u0012ad\u00117vgR,'\u000fT5oWJ+\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:\u000b\u0005Y9\u0012AB:feZ,'OC\u0001\u0019\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u000e !\taR$D\u0001\u0016\u0013\tqRC\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\bC\u0001\u000f!\u0013\t\tSCA\u000fDYV\u001cH/\u001a:MS:\\G+\u001a8b]R\u0014V-];fgR\fVo\u001c;b\u0003\r\u0019gmZ\u000b\u0002IA\u0011A$J\u0005\u0003MU\u0011Ae\u00117vgR,'\u000fT5oWJ+\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:D_:4\u0017nZ\u0001\u0005G\u001a<\u0007%A\u0004nKR\u0014\u0018nY:\u0016\u0003)\u0002\"a\u000b\u001b\u000e\u00031R!\u0001K\u0017\u000b\u00059z\u0013AB2p[6|gN\u0003\u0002\u0019a)\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0013\t)DFA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nA\u0001^5nKB\u0011\u0011\bP\u0007\u0002u)\u00111(L\u0001\u0006kRLGn]\u0005\u0003{i\u0012A\u0001V5nK&\u0011q'H\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb,\u0012!\u0011\t\u0003\u0005.s!aQ%\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019K\u0012A\u0002\u001fs_>$hHC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQu)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00196\u0013aa\u0015;sS:<'B\u0001&H\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u0014G2LWM\u001c;Rk>$\u0018mQ1mY\n\f7m[\u000b\u0002#B\u0019!kU+\u000e\u0003\u001dK!\u0001V$\u0003\r=\u0003H/[8o!\t1&,D\u0001X\u0015\tA\u0016,A\u0003rk>$\u0018M\u0003\u0002\u0017_%\u00111l\u0016\u0002\u0014\u00072LWM\u001c;Rk>$\u0018mQ1mY\n\f7m[\u0001\u0015G2LWM\u001c;Rk>$\u0018mQ1mY\n\f7m\u001b\u0011\u0002)\u0005\u001cG/\u001b<f)\u0016t\u0017M\u001c;t\u001b\u0006t\u0017mZ3s!\r\u00116k\u0018\t\u00039\u0001L!!Y\u000b\u0003)\u0005\u001bG/\u001b<f)\u0016t\u0017M\u001c;t\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q9A-\u001a4hQ&T\u0007C\u0001\u000f\u0001\u0011\u0015\u00113\u00021\u0001%\u0011\u0015A3\u00021\u0001+\u0011\u001594\u00021\u00019\u0011\u0015y4\u00021\u0001B\u0011\u0015y5\u00021\u0001R\u0011\u0015i6\u00021\u0001_\u0003Q\u0019G.[3oiJ\u000bG/Z'fiJL7MT1nKR\u0011Q.\u001d\t\u0003]>l\u0011!L\u0005\u0003a6\u0012!\"T3ue&\u001cg*Y7f\u0011\u0015\u0011H\u00021\u0001t\u0003=\tXo\u001c;b\u001b\u0016$(/[2UC\u001e\u001c\b\u0003\u0002\"u\u0003\u0006K!!^'\u0003\u00075\u000b\u0007/A\nhKR\u0014%o\\6feF+x\u000e^1MS6LG/F\u0001y!\t\u0011\u00160\u0003\u0002{\u000f\n1Ai\\;cY\u0016\fAC]3rk\u0016\u001cH/U;pi\u0006\u001cXI\\1cY\u0016$W#A?\u0011\u0005Is\u0018BA@H\u0005\u001d\u0011un\u001c7fC:\fAc\u00197vgR,'\u000fT5oWB\u0013\u0018N\\2ja\u0006dG\u0003BA\u0003\u0003;\u0001BAU*\u0002\bA!\u0011\u0011BA\r\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011aC7vYRLG/\u001a8b]RT1\u0001GA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0013\r|gN\u001a7vK:$(BAA\f\u0003\tIw.\u0003\u0003\u0002\u001c\u0005-!\u0001F\"mkN$XM\u001d'j].\u0004&/\u001b8dSB\fG\u000eC\u0004\u0002 =\u0001\r!!\t\u0002#1Lgn\u001b+f]\u0006tGoQ8oi\u0016DH\u000fE\u0002\u001d\u0003GI1!!\n\u0016\u0005a\u0019E.^:uKJd\u0015N\\6UK:\fg\u000e^\"p]R,\u0007\u0010^\u0001\u0007e\u0016\u001cwN\u001d3\u0015\u0011\u0005-\u0012\u0011GA\u001a\u0003{\u00012AUA\u0017\u0013\r\tyc\u0012\u0002\u0005+:LG\u000fC\u0004\u0002 A\u0001\r!!\t\t\u000f\u0005U\u0002\u00031\u0001\u00028\u00059a/\u00197vK:\u001b\bc\u0001*\u0002:%\u0019\u00111H$\u0003\t1{gn\u001a\u0005\b\u0003\u007f\u0001\u0002\u0019AA!\u0003%)8/Y4f)f\u0004X\rE\u0002\u001d\u0003\u0007J1!!\u0012\u0016\u0005ea\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-V:bO\u0016$\u0016\u0010]3\u0002\u001f%\u001c\u0018+^8uC\u0016C8-Z3eK\u0012$2!`A&\u0011\u001d\ty\"\u0005a\u0001\u0003C\t\u0011cZ3u)\"\u0014x\u000e\u001e;mKRKW.Z't)\u0019\t\t&a\u0016\u0002ZA\u0019!+a\u0015\n\u0007\u0005UsIA\u0002J]RDq!a\b\u0013\u0001\u0004\t\t\u0003C\u0004\u0002\\I\u0001\r!a\u000e\u0002\u000bY\fG.^3\u0002\u0015M,\b/\u001a:%i&lW-F\u00019\u0001")
public class ClusterLinkRequestQuotaManager
extends ClientQuotaManager
implements ClusterLinkTenantRequestQuota {
    private final ClusterLinkRequestQuotaManagerConfig cfg;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> clientQuotaCallback;

    private /* synthetic */ Time super$time() {
        return super.time();
    }

    private ClusterLinkRequestQuotaManagerConfig cfg() {
        return this.cfg;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", QuotaType.CLUSTER_LINK_REQUEST.toString(), "Tracking request-time per tenant", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public double getBrokerQuotaLimit() {
        if (this.requestQuotasEnabled()) {
            return this.cfg().clusterLinkRequestQuotaCapacity().apply$mcI$sp();
        }
        return Double.MAX_VALUE;
    }

    public boolean requestQuotasEnabled() {
        return this.quotasEnabled() && this.cfg().clusterLinkEnable().apply$mcZ$sp() && this.cfg().clusterLinkTenantQuotaEnable().apply$mcZ$sp();
    }

    public Option<ClusterLinkPrincipal> clusterLinkPrincipal(ClusterLinkTenantContext linkTenantContext) {
        return ClusterLinkQuotas$.MODULE$.clusterLinkRequestQuotaPrincipal(this.cfg(), linkTenantContext);
    }

    @Override
    public void record(ClusterLinkTenantContext linkTenantContext, long valueNs, LinkRequestQuotaUsageType usageType) {
        if (this.requestQuotasEnabled()) {
            double timeInPercentage = ClientRequestQuotaManager.nanosToPercentage(valueNs);
            this.clusterLinkPrincipal(linkTenantContext).foreach((Function1<ClusterLinkPrincipal, Object> & Serializable)p -> BoxesRunTime.boxToInteger(ClusterLinkRequestQuotaManager.$anonfun$record$1(this, timeInPercentage, p)));
            return;
        }
    }

    @Override
    public boolean isQuotaExceeded(ClusterLinkTenantContext linkTenantContext) {
        return this.getThrottleTimeMs(linkTenantContext, super.time().milliseconds()) > 0;
    }

    @Override
    public int getThrottleTimeMs(ClusterLinkTenantContext linkTenantContext, long value) {
        if (this.requestQuotasEnabled()) {
            return BoxesRunTime.unboxToInt(this.clusterLinkPrincipal(linkTenantContext).map((Function1<ClusterLinkPrincipal, Object> & Serializable)p -> BoxesRunTime.boxToInteger(this.getThrottleTimeMs(ClusterLinkQuotas$.MODULE$.session(p), ClusterLinkQuotas$.MODULE$.ClusterLinkClientId(), this.super$time().milliseconds()))).getOrElse(() -> 0));
        }
        return 0;
    }

    public static final /* synthetic */ int $anonfun$record$1(ClusterLinkRequestQuotaManager $this, double timeInPercentage$1, ClusterLinkPrincipal p) {
        ClientSensors clientSensors = $this.getOrCreateQuotaSensors(ClusterLinkQuotas$.MODULE$.session(p), ClusterLinkQuotas$.MODULE$.ClusterLinkClientId());
        return $this.recordAndGetThrottleTimeMs(clientSensors, timeInPercentage$1, $this.super$time().milliseconds());
    }

    public ClusterLinkRequestQuotaManager(ClusterLinkRequestQuotaManagerConfig cfg, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> clientQuotaCallback, Option<ActiveTenantsManager> activeTenantsManager) {
        this.cfg = cfg;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(cfg.clientQuotaManagerConfig(), metrics, QuotaType.CLUSTER_LINK_REQUEST, time, threadNamePrefix, clientQuotaCallback, activeTenantsManager);
        super.updateClientQuotaMaxThrottleTimeMs(TimeUnit.SECONDS.toMillis(cfg.clientQuotaManagerConfig().quotaWindowSizeSeconds));
    }
}

