/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.function.BiConsumer;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\t%g\u0001\u0002\f\u0018\u0001qA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011!I\u0005A!b\u0001\n\u0003Q\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bY\u0003A\u0011A,\t\u000by\u0003A\u0011A0\t\u000by\u0004A\u0011A@\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_AqA!\u0013\u0001\t\u0013\u0011Y\u0005C\u0004\u0003\\\u0001!IA!\u0018\t\u000f\t-\u0004\u0001\"\u0003\u0003n!9!1\u0011\u0001\u0005\n\t\u0015\u0005b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{\u0013AbQ8oM&<\u0007*\u001a7qKJT!\u0001G\r\u0002\rM,'O^3s\u0015\u0005Q\u0012!B6bM.\f7\u0001A\n\u0004\u0001u\u0019\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%O5\tQE\u0003\u0002'3\u0005)Q\u000f^5mg&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u00035iW\r^1eCR\f7)Y2iKB\u00111\u0006L\u0007\u0002/%\u0011Qf\u0006\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\r\r|gNZ5h!\tY\u0003'\u0003\u00022/\tY1*\u00194lC\u000e{gNZ5h\u0003A\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00025o5\tQG\u0003\u00027/\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u00029k\t\u00012i\u001c8gS\u001e\u0014V\r]8tSR|'/_\u0001\u0012C2$XM]\"p]\u001aLw\rU8mS\u000eL\bc\u0001\u0010<{%\u0011Ah\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y:U\"A \u000b\u0005\u0001\u000b\u0015A\u00029pY&\u001c\u0017P\u0003\u0002\u0019\u0005*\u0011!d\u0011\u0006\u0003\t\u0016\u000ba!\u00199bG\",'\"\u0001$\u0002\u0007=\u0014x-\u0003\u0002I\u007f\t\t\u0012\t\u001c;fe\u000e{gNZ5h!>d\u0017nY=\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM]\u000b\u0002\u0017B\u0011AJ\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f^\tA\u0001\\5oW&\u0011\u0011KT\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0002T)\nYA*\u001b8l\u001b\u0006t\u0017mZ3s\u0015\t\tf*A\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u00071fS6\fX/\u0011\u0005-\u0002\u0001\"B\u0015\b\u0001\u0004Q\u0003\"\u0002\u0018\b\u0001\u0004y\u0003\"\u0002\u001a\b\u0001\u0004\u0019\u0004\"B\u001d\b\u0001\u0004Q\u0004\"B%\b\u0001\u0004Y\u0015AC1mY\u000e{gNZ5hgR\u0011\u0001M\u001e\t\u0005C\u001aD7/D\u0001c\u0015\t\u0019G-A\u0004nkR\f'\r\\3\u000b\u0005\u0015|\u0012AC2pY2,7\r^5p]&\u0011qM\u0019\u0002\u0004\u001b\u0006\u0004\bCA5q\u001d\tQg\u000e\u0005\u0002l?5\tAN\u0003\u0002n7\u00051AH]8pizJ!a\\\u0010\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_~\u0001\"A\b;\n\u0005U|\"aA!os\")a\u0006\u0003a\u0001oB\u0011\u0001\u0010`\u0007\u0002s*\u0011aF\u001f\u0006\u0003w\n\u000baaY8n[>t\u0017BA?z\u00059\t%m\u001d;sC\u000e$8i\u001c8gS\u001e\fA\u0004[1oI2,G)Z:de&\u0014WmQ8oM&<7OU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\u0002\u00055\u0011Q\u0005\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001>\u0002\u000f5,7o]1hK&!\u00111BA\u0003\u0005m!Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z:q_:\u001cX\rR1uC\"9\u0011qB\u0005A\u0002\u0005E\u0011a\u0002:fcV,7\u000f\u001e\t\u0005\u0003'\tyB\u0004\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\"G\u0001\b]\u0016$xo\u001c:l\u0013\u0011\ti\"a\u0006\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u0011\u0011EA\u0012\u0005\u001d\u0011V-];fgRTA!!\b\u0002\u0018!9\u0011qE\u0005A\u0002\u0005%\u0012AC1vi\"DU\r\u001c9feB\u00191&a\u000b\n\u0007\u00055rC\u0001\u0006BkRD\u0007*\u001a7qKJ\fq\u0002Z3tGJL'-Z\"p]\u001aLwm\u001d\u000b\u000b\u0003g\t\u0019&a\u001f\u0002\u0006\u0006e\u0005CBA\u001b\u0003\u007f\t)E\u0004\u0003\u00028\u0005mbbA6\u0002:%\t\u0001%C\u0002\u0002>}\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002B\u0005\r#\u0001\u0002'jgRT1!!\u0010 !\u0011\t9%!\u0014\u000f\t\u0005\r\u0011\u0011J\u0005\u0005\u0003\u0017\n)!A\u000eEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003\u001f\n\tFA\u000bEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001cX\u000f\u001c;\u000b\t\u0005-\u0013Q\u0001\u0005\b\u0003+R\u0001\u0019AA,\u0003U\u0011Xm]8ve\u000e,Gk\\\"p]\u001aLwMT1nKN\u0004b!!\u000e\u0002@\u0005e\u0003\u0003BA.\u0003krA!!\u0018\u0002r9!\u0011qLA8\u001d\u0011\t\t'!\u001c\u000f\t\u0005\r\u00141\u000e\b\u0005\u0003K\nIGD\u0002l\u0003OJ\u0011AR\u0005\u0003\t\u0016K!AG\"\n\u0005m\u0014\u0015bAA\u0004u&!\u00111OA\u0003\u0003i!Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z9vKN$H)\u0019;b\u0013\u0011\t9(!\u001f\u0003/\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm]8ve\u000e,'\u0002BA:\u0003\u000bAq!! \u000b\u0001\u0004\ty(A\bj]\u000edW\u000fZ3Ts:|g._7t!\rq\u0012\u0011Q\u0005\u0004\u0003\u0007{\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u000fS\u0001\u0019AAE\u0003%\u0001(/\u001b8dSB\fG\u000e\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\t\u0005,H\u000f\u001b\u0006\u0004\u0003'S\u0018\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005]\u0015Q\u0012\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0011\u001d\tYJ\u0003a\u0001\u0003\u007f\nA#\u001b8dYV$W\rR8dk6,g\u000e^1uS>t\u0017AF2sK\u0006$Xm\u0012:pkB\u001cuN\u001c4jO\u0016sGO]=\u0015\u0015\u0005\u0005\u0016\u0011WAc\u00033\fY\u000e\u0006\u0004\u0002$\u0006%\u0016Q\u0016\t\u0005\u0003\u000f\n)+\u0003\u0003\u0002(\u0006E#!\b#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:SKN|WO]2f%\u0016\u001cX\u000f\u001c;\t\r\u0005-6\u00021\u0001i\u0003\u0011q\u0017-\\3\t\r\u0005=6\u00021\u0001t\u0003\u00151\u0018\r\\;f\u0011\u001d\t\u0019l\u0003a\u0001\u0003k\u000b1b\u001a:pkB\u001cuN\u001c4jOB!\u0011qWAa\u001b\t\tIL\u0003\u0003\u0002<\u0006u\u0016!B4s_V\u0004(bAA`\u0005\u0006Y1m\\8sI&t\u0017\r^8s\u0013\u0011\t\u0019-!/\u0003\u0017\u001d\u0013x.\u001e9D_:4\u0017n\u001a\u0005\b\u0003\u000f\\\u0001\u0019AAe\u0003)9'o\\;q!J|\u0007o\u001d\t\u0005\u0003\u0017\f).\u0004\u0002\u0002N*!\u0011qZAi\u0003\u0011)H/\u001b7\u000b\u0005\u0005M\u0017\u0001\u00026bm\u0006LA!a6\u0002N\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005u4\u00021\u0001\u0002\u0000!9\u00111T\u0006A\u0002\u0005}\u0014AF2sK\u0006$X\rV8qS\u000e\u001cuN\u001c4jO\u0016sGO]=\u0015\u0015\u0005\u0005\u0018q]A\u0000\u0005\u0007\u0011)\u0001\u0006\u0004\u0002$\u0006\r\u0018Q\u001d\u0005\u0007\u0003Wc\u0001\u0019\u00015\t\r\u0005=F\u00021\u0001t\u0011\u001d\tI\u000f\u0004a\u0001\u0003W\f\u0011\u0002\\8h\u0007>tg-[4\u0011\t\u00055\u00181`\u0007\u0003\u0003_TA!!=\u0002t\u0006\u0019An\\4\u000b\t\u0005U\u0018q_\u0001\nS:$XM\u001d8bYNT1!!?C\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!@\u0002p\nIAj\\4D_:4\u0017n\u001a\u0005\b\u0005\u0003a\u0001\u0019AAe\u0003)!x\u000e]5d!J|\u0007o\u001d\u0005\b\u0003{b\u0001\u0019AA@\u0011\u001d\tY\n\u0004a\u0001\u0003\u007f\n!CZ5mi\u0016\u0014Hk\u001c9jG\u000e{gNZ5hgR1!1\u0002B\f\u0005C\u0001R!\u0019B\u0007\u0005#I1Aa\u0004c\u0005\u0019\u0011UO\u001a4feB)aDa\u0005ig&\u0019!QC\u0010\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011I\"\u0004a\u0001\u00057\tqaY8oM&<7\u000f\u0005\u0004\u0003\u001e\t}\u0001n]\u0007\u0002I&\u0011q\r\u001a\u0005\b\u0005Gi\u0001\u0019\u0001B\u0013\u0003-\u0019wN\u001c4jO:\u000bW.Z:\u0011\tyY$q\u0005\t\u0006\u0005;\u0011I\u0003[\u0005\u0004\u0005W!'aA*fi\u0006!b/\u00197jI\u0006$XmQ8oM&<\u0007k\u001c7jGf$\u0002B!\r\u00038\t\u0005#q\t\t\u0004=\tM\u0012b\u0001B\u001b?\t!QK\\5u\u0011\u001d\u0011ID\u0004a\u0001\u0005w\t\u0001B]3t_V\u00148-\u001a\t\u0004q\nu\u0012b\u0001B s\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0007b\u0002B\"\u001d\u0001\u0007!QI\u0001\u0011G>tg-[4F]R\u0014\u0018.Z:NCB\u0004bA!\b\u0003 !D\u0007bBAD\u001d\u0001\u0007\u0011\u0011R\u0001\u0018GJ,\u0017\r^3Ce>\\WM]\"p]\u001aLw-\u00128uef$\u0002B!\u0014\u0003T\t]#\u0011\f\u000b\u0007\u0003G\u0013yE!\u0015\t\r\u0005-v\u00021\u0001i\u0011\u0019\tyk\u0004a\u0001g\"9!QK\bA\u0002\u0005}\u0014a\u00049fe\n\u0013xn[3s\u0007>tg-[4\t\u000f\u0005ut\u00021\u0001\u0002\u0000!9\u00111T\bA\u0002\u0005}\u0014\u0001H2sK\u0006$Xm\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u000b:$(/\u001f\u000b\u0007\u0005?\u0012)G!\u001b\u0015\r\u0005\r&\u0011\rB2\u0011\u0019\tY\u000b\u0005a\u0001Q\"1\u0011q\u0016\tA\u0002MDqAa\u001a\u0011\u0001\u0004\u00119#A\ffqBd\u0017nY5uYf\u001cV\r^\"p]\u001aLwmS3zg\")a\u0006\u0005a\u0001o\u0006q1m\u001c8gS\u001e\u001c\u0016P\\8os6\u001cH\u0003\u0003B8\u0005o\u0012IHa \u0011\r\u0005U\u0012q\bB9!\u0011\t9Ea\u001d\n\t\tU\u0014\u0011\u000b\u0002\u0017\t\u0016\u001c8M]5cK\u000e{gNZ5hgNKhn\u001c8z[\"1\u00111V\tA\u0002!DqAa\u001f\u0012\u0001\u0004\u0011i(\u0001\u0005ts:|g._7t!\u0015\t)$a\u0010i\u0011\u001d\u0011\t)\u0005a\u0001\u0003\u007f\n1\"[:TK:\u001c\u0018\u000e^5wK\u0006q!M]8lKJ\u001c\u0016P\\8os6\u001cH\u0003\u0002B?\u0005\u000fCa!a+\u0013\u0001\u0004A\u0017a\u00052s_.,'\u000fR8dk6,g\u000e^1uS>tGc\u00015\u0003\u000e\"1\u00111V\nA\u0002!\f!cY8oM&<'+Z:q_:\u001cX\rV=qKR!!1\u0013BT!\u0011\u0011)J!)\u000f\t\t]%QT\u0007\u0003\u00053S1Aa'{\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002BP\u00053\u000bq\u0003R3tGJL'-Z\"p]\u001aLwm\u001d*fgB|gn]3\n\t\t\r&Q\u0015\u0002\u000b\u0007>tg-[4UsB,'\u0002\u0002BP\u00053CqA!+\u0015\u0001\u0004\u0011Y+\u0001\u0006d_:4\u0017n\u001a+za\u0016\u0004BAH\u001e\u0003.B!!q\u0016B[\u001d\rA(\u0011W\u0005\u0004\u0005gK\u0018!C\"p]\u001aLw\rR3g\u0013\u0011\u00119L!/\u0003\tQK\b/\u001a\u0006\u0004\u0005gK\u0018A\u0006:fg>,(oY3OC6,Gk\u001c\"s_.,'/\u00133\u0015\t\t}&Q\u0019\t\u0004=\t\u0005\u0017b\u0001Bb?\t\u0019\u0011J\u001c;\t\r\t\u001dW\u00031\u0001i\u00031\u0011Xm]8ve\u000e,g*Y7f\u0001")
public class ConfigHelper
implements Logging {
    private final MetadataCache metadataCache;
    private final KafkaConfig config;
    private final ConfigRepository configRepository;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final ClusterLinkFactory.LinkManager clusterLinkManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConfigHelper configHelper = this;
        synchronized (configHelper) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public scala.collection.mutable.Map<String, Object> allConfigs(AbstractConfig config) {
        return (scala.collection.mutable.Map)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(config.originals()).asScala().filter((Function1<Tuple2, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(ConfigHelper.$anonfun$allConfigs$1(x$1)))).$plus$plus(CollectionConverters$.MODULE$.MapHasAsScala(config.nonInternalValues()).asScala());
    }

    public DescribeConfigsResponseData handleDescribeConfigsRequest(RequestChannel.Request request, AuthHelper authHelper) {
        DescribeConfigsRequest describeConfigsRequest = (DescribeConfigsRequest)request.body(ClassTag$.MODULE$.apply(DescribeConfigsRequest.class));
        Tuple2 tuple2 = CollectionConverters$.MODULE$.ListHasAsScala(describeConfigsRequest.data().resources()).asScala().partition((Function1<DescribeConfigsRequestData.DescribeConfigsResource, Object> & Serializable)resource -> BoxesRunTime.boxToBoolean(ConfigHelper.$anonfun$handleDescribeConfigsRequest$1(authHelper, request, resource)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Buffer authorizedResources = (Buffer)tuple2._1();
        Buffer unauthorizedResources = (Buffer)tuple2._2();
        Tuple2<Buffer, Buffer> tuple22 = new Tuple2<Buffer, Buffer>(authorizedResources, unauthorizedResources);
        Buffer authorizedResources2 = tuple22._1();
        Buffer unauthorizedResources2 = tuple22._2();
        List<DescribeConfigsResponseData.DescribeConfigsResult> authorizedConfigs = this.describeConfigs(authorizedResources2.toList(), describeConfigsRequest.data().includeSynonyms(), request.session().principal, describeConfigsRequest.data().includeDocumentation());
        Buffer unauthorizedConfigs = (Buffer)unauthorizedResources2.map((Function1<DescribeConfigsRequestData.DescribeConfigsResource, DescribeConfigsResponseData.DescribeConfigsResult> & Serializable)resource -> {
            Errors errors;
            ConfigResource.Type type = ConfigResource.Type.forId(resource.resourceType());
            if (((Object)((Object)ConfigResource.Type.BROKER)).equals((Object)type) ? true : (((Object)((Object)ConfigResource.Type.BROKER_LOGGER)).equals((Object)type) ? true : (((Object)((Object)ConfigResource.Type.CLUSTER_LINK)).equals((Object)type) ? true : ((Object)((Object)ConfigResource.Type.CLIENT_METRICS)).equals((Object)type)))) {
                errors = Errors.CLUSTER_AUTHORIZATION_FAILED;
            } else if (((Object)((Object)ConfigResource.Type.TOPIC)).equals((Object)type)) {
                errors = Errors.TOPIC_AUTHORIZATION_FAILED;
            } else if (((Object)((Object)ConfigResource.Type.GROUP)).equals((Object)type)) {
                errors = Errors.GROUP_AUTHORIZATION_FAILED;
            } else {
                throw new InvalidRequestException("Unexpected resource type " + type + " for resource " + resource.resourceName());
            }
            Errors error = errors;
            return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(error.code()).setErrorMessage(error.message()).setConfigs(Collections.emptyList()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
        });
        return new DescribeConfigsResponseData().setResults(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)authorizedConfigs.$plus$plus((IterableOnce)unauthorizedConfigs)).asJava());
    }

    public List<DescribeConfigsResponseData.DescribeConfigsResult> describeConfigs(List<DescribeConfigsRequestData.DescribeConfigsResource> resourceToConfigNames, boolean includeSynonyms, KafkaPrincipal principal, boolean includeDocumentation) {
        scala.collection.mutable.Map defaultTopicConfigCache = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        return resourceToConfigNames.map((Function1<DescribeConfigsRequestData.DescribeConfigsResource, DescribeConfigsResponseData.DescribeConfigsResult> & Serializable)resource -> {
            DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult;
            try {
                DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult2;
                ConfigResource.Type type = ConfigResource.Type.forId(resource.resourceType());
                if (((Object)((Object)ConfigResource.Type.TOPIC)).equals((Object)type)) {
                    Some some;
                    TopicType orgApacheKafkaCommonTopicType;
                    String topic = resource.resourceName();
                    Topic.validate(topic);
                    Option<TopicType> option = $this.metadataCache.getTopicType(topic);
                    if (option instanceof Some && (orgApacheKafkaCommonTopicType = (TopicType)((Object)((Object)(some = (Some)option).value()))) != null) {
                        DescribeConfigsResponseData.DescribeConfigsResult responseConfig;
                        DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult3;
                        TopicType topicType = orgApacheKafkaCommonTopicType;
                        Properties topicProps = $this.configRepository.topicConfig(topic);
                        org.apache.kafka.metadata.TopicType orgApacheKafkaMetadataTopicType = org.apache.kafka.metadata.TopicType.forId(topicType.id());
                        if (topicProps.isEmpty()) {
                            Object object = !defaultTopicConfigCache.contains(topicType) ? defaultTopicConfigCache.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicType), this.computeTopicConfigResponse$1(topicType, topicProps, orgApacheKafkaMetadataTopicType, includeSynonyms, includeDocumentation, (DescribeConfigsRequestData.DescribeConfigsResource)resource))) : BoxedUnit.UNIT;
                            describeConfigsResult3 = ((DescribeConfigsResponseData.DescribeConfigsResult)defaultTopicConfigCache.apply(topicType)).duplicate();
                        } else {
                            describeConfigsResult3 = this.computeTopicConfigResponse$1(topicType, topicProps, orgApacheKafkaMetadataTopicType, includeSynonyms, includeDocumentation, (DescribeConfigsRequestData.DescribeConfigsResource)resource);
                        }
                        describeConfigsResult2 = responseConfig = describeConfigsResult3;
                    } else {
                        describeConfigsResult2 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setConfigs(Collections.emptyList());
                    }
                } else if (((Object)((Object)ConfigResource.Type.BROKER)).equals((Object)type)) {
                    if (resource.resourceName() == null || resource.resourceName().isEmpty()) {
                        describeConfigsResult2 = this.createResponseConfig$1($this.config.dynamicConfig().currentDynamicDefaultConfigs(), (Function2<String, Object, DescribeConfigsResponseData.DescribeConfigsResourceResult> & Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, includeDocumentation, (String)name, value), (DescribeConfigsRequestData.DescribeConfigsResource)resource);
                    } else {
                        if (this.resourceNameToBrokerId(resource.resourceName()) != $this.config.brokerId()) throw new InvalidRequestException("Unexpected broker id, expected " + $this.config.brokerId() + " or empty string, but received " + resource.resourceName());
                        describeConfigsResult2 = this.createResponseConfig$1(this.allConfigs($this.config), (Function2<String, Object, DescribeConfigsResponseData.DescribeConfigsResourceResult> & Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, includeDocumentation, (String)name, value), (DescribeConfigsRequestData.DescribeConfigsResource)resource);
                    }
                } else if (((Object)((Object)ConfigResource.Type.BROKER_LOGGER)).equals((Object)type)) {
                    if (resource.resourceName() == null || resource.resourceName().isEmpty()) {
                        throw new InvalidRequestException("Broker id must not be empty");
                    }
                    if (this.resourceNameToBrokerId(resource.resourceName()) != $this.config.brokerId()) {
                        throw new InvalidRequestException("Unexpected broker id, expected " + $this.config.brokerId() + " but received " + resource.resourceName());
                    }
                    ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId(resource.resourceType()), resource.resourceName());
                    this.validateConfigPolicy(configResource, (Map)scala.collection.Map$.MODULE$.empty(), principal);
                    describeConfigsResult2 = this.createResponseConfig$1(Log4jController$.MODULE$.loggers(), (Function2<String, Object, DescribeConfigsResponseData.DescribeConfigsResourceResult> & Serializable)(name, value) -> new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName((String)name).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava(package$.MODULE$.List().empty()).asJava()), (DescribeConfigsRequestData.DescribeConfigsResource)resource);
                } else if (((Object)((Object)ConfigResource.Type.CLUSTER_LINK)).equals((Object)type)) {
                    if (this.clusterLinkManager() == null) {
                        throw new UnsupportedVersionException("Cannot describe CLUSTER_LINK resources in this version of the software.");
                    }
                    String linkName = resource.resourceName();
                    if (linkName == null || linkName.isEmpty()) {
                        throw new InvalidRequestException("Cluster link name must not be empty");
                    }
                    Uuid linkId = this.clusterLinkManager().resolveLinkIdOrThrow(linkName);
                    this.clusterLinkManager().ensureClusterLinkExists(linkId);
                    ConfigRepository configRepository = $this.configRepository;
                    if (!(configRepository instanceof KRaftMetadataCache)) {
                        throw new IllegalStateException("Unsupported config repository type");
                    }
                    Properties persistentProps = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
                    String errorMessage = "Cluster link configs could not be decoded for link '" + linkName + "', 'PasswordConfig may be misconfigured on some brokers. Configure all brokers with the same encoder secret and reconfigure link by providing the full link config.";
                    try {
                        scala.collection.mutable.Set<Object> explicitlySetConfigKeys = CollectionConverters$.MODULE$.SetHasAsScala(persistentProps.keySet()).asScala();
                        this.debug((Function0<String> & Serializable)() -> "Explicitly set config keys " + explicitlySetConfigKeys + ".");
                        ClusterLinkConfig config = (ClusterLinkConfig)this.clusterLinkManager().linkConfigFromPersistentProps(linkName, persistentProps, false).getOrElse((Function0<Nothing$> & Serializable)() -> {
                            throw new InvalidConfigurationException(errorMessage);
                        });
                        describeConfigsResult2 = this.createResponseConfig$1(this.allConfigs(config), (Function2<String, Object, DescribeConfigsResponseData.DescribeConfigsResourceResult> & Serializable)(name, value) -> this.createClusterLinkConfigEntry((Set<String>)explicitlySetConfigKeys, config, (String)name, value), (DescribeConfigsRequestData.DescribeConfigsResource)resource);
                    }
                    catch (ConfigException configException) {
                        throw new InvalidConfigurationException(errorMessage);
                    }
                } else if (((Object)((Object)ConfigResource.Type.CLIENT_METRICS)).equals((Object)type)) {
                    String subscriptionName = resource.resourceName();
                    if (subscriptionName == null || subscriptionName.isEmpty()) {
                        throw new InvalidRequestException("Client metrics subscription name must not be empty");
                    }
                    Properties entityProps = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, subscriptionName));
                    ListBuffer configEntries = new ListBuffer();
                    entityProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> configEntries.$plus$eq(new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name.toString()).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.CLIENT_METRICS_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava(package$.MODULE$.List().empty()).asJava()))));
                    describeConfigsResult2 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(configEntries).asJava());
                } else {
                    if (!((Object)((Object)ConfigResource.Type.GROUP)).equals((Object)type)) throw new InvalidRequestException("Unsupported resource type: " + type);
                    String group = resource.resourceName();
                    if (group == null || group.isEmpty()) {
                        throw new InvalidRequestException("Group name must not be empty");
                    }
                    Properties groupProps = $this.configRepository.groupConfig(group);
                    GroupConfig groupConfig = GroupConfig.fromProps($this.config.groupCoordinatorConfig().extractGroupConfigMap($this.config.shareGroupConfig()), groupProps);
                    describeConfigsResult2 = this.createResponseConfig$1(this.allConfigs(groupConfig), (Function2<String, Object, DescribeConfigsResponseData.DescribeConfigsResourceResult> & Serializable)(name, value) -> this.createGroupConfigEntry(groupConfig, groupProps, includeSynonyms, includeDocumentation, (String)name, value), (DescribeConfigsRequestData.DescribeConfigsResource)resource);
                }
                DescribeConfigsResponseData.DescribeConfigsResult configResult = describeConfigsResult2;
                describeConfigsResult = configResult.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                return describeConfigsResult;
            }
            catch (Throwable e) {
                String message = "Error processing describe configs request for resource " + resource;
                if (e instanceof ApiException) {
                    this.info((Function0<String> & Serializable)() -> message, (Function0<Throwable> & Serializable)() -> e);
                } else {
                    this.error((Function0<String> & Serializable)() -> message, (Function0<Throwable> & Serializable)() -> e);
                }
                ApiError err = ApiError.fromThrowable(e);
                describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(resource.resourceName()).setResourceType(resource.resourceType()).setErrorMessage(err.message()).setErrorCode(err.error().code()).setConfigs(Collections.emptyList());
            }
            return describeConfigsResult;
        });
    }

    public DescribeConfigsResponseData.DescribeConfigsResourceResult createGroupConfigEntry(GroupConfig groupConfig, Properties groupProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List list;
        List<String> allNames = this.brokerSynonyms(name);
        Option<ConfigDef.Type> configEntryType = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(GroupConfig.configType(name)));
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString(value, (ConfigDef.Type)((Object)configEntryType.orNull($less$colon$less$.MODULE$.refl())));
        List<DescribeConfigsResponseData.DescribeConfigsSynonym> list2 = this.configSynonyms(name, allNames, isSensitive);
        if (!groupProps.containsKey(name)) {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id());
            list = (List)list2.$plus$colon(describeConfigsSynonym);
        } else {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.GROUP_CONFIG.id());
            list = (List)list2.$plus$colon(describeConfigsSynonym);
        }
        List allSynonyms = list;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? groupConfig.documentationOf(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava(synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    public DescribeConfigsResponseData.DescribeConfigsResourceResult createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List list;
        Option<ConfigDef.Type> configEntryType = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(LogConfig.configType(name)));
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString(value, (ConfigDef.Type)((Object)configEntryType.orNull($less$colon$less$.MODULE$.refl())));
        List list2 = (List)Option$.MODULE$.apply(ServerTopicConfigSynonyms.TOPIC_CONFIG_SYNONYMS.get(name)).map((Function1<String, List> & Serializable)s -> this.configSynonyms((String)s, this.brokerSynonyms((String)s), isSensitive)).getOrElse((Function0<List> & Serializable)() -> package$.MODULE$.List().empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG.id());
            list = (List)list2.$plus$colon(describeConfigsSynonym);
        }
        List allSynonyms = list;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? logConfig.documentationOf(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava(synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    public Buffer<Tuple2<String, Object>> filterTopicConfigs(Map<String, Object> configs, Option<Set<String>> configNames) {
        return ((IterableOnceOps)configs.filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ConfigHelper.$anonfun$filterTopicConfigs$1(configNames, x0$1)))).toBuffer();
    }

    public void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap, KafkaPrincipal principal) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy;
        if (option instanceof Some) {
            Some some = (Some)option;
            AlterConfigPolicy policy = (AlterConfigPolicy)some.value();
            policy.validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), CollectionConverters$.MODULE$.MapHasAsJava(configEntriesMap).asJava(), principal));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        String string;
        Object object;
        List<String> allNames = this.brokerSynonyms(name);
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        String valueAsString = isSensitive ? null : ((object = value) instanceof String ? (string = (String)object) : ConfigDef.convertToString(value, (ConfigDef.Type)((Object)configEntryType.orNull($less$colon$less$.MODULE$.refl()))));
        Object allSynonyms = this.configSynonyms(name, allNames, isSensitive).filter((Function1<DescribeConfigsResponseData.DescribeConfigsSynonym, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(ConfigHelper.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$6)));
        Object synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        byte source = ((List)allSynonyms).isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)((AbstractIterable)allSynonyms).head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains(name);
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? this.brokerDocumentation(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(readOnly).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava(synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createClusterLinkConfigEntry(Set<String> explicitlySetConfigKeys, AbstractConfig config, String name, Object value) {
        ConfigDef.Type configEntryType = config.typeOf(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(Option$.MODULE$.apply(configEntryType));
        String valueAsString = isSensitive || value == null ? null : (value instanceof String ? value.toString() : ConfigDef.convertToString(value, configEntryType));
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(explicitlySetConfigKeys.contains(name) ? DescribeConfigsResponse.ConfigSource.CLUSTER_LINK_CONFIG.id() : DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id()).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava(package$.MODULE$.List().empty()).asJava());
    }

    private List<DescribeConfigsResponseData.DescribeConfigsSynonym> configSynonyms(String name, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config.dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        synonyms.foreach((Function1<String, Object> & Serializable)synonym -> {
            ConfigHelper.maybeAddSynonym$1(synonym, dynamicConfig.currentDynamicBrokerConfigValue(synonym), DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1<String, Object> & Serializable)synonym -> {
            ConfigHelper.maybeAddSynonym$1(synonym, dynamicConfig.currentDynamicDefaultConfigValue(synonym), DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1<String, Object> & Serializable)synonym -> {
            ConfigHelper.maybeAddSynonym$1(synonym, dynamicConfig.staticBrokerConfigs().get(synonym), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1<String, Object> & Serializable)synonym -> {
            ConfigHelper.maybeAddSynonym$1(synonym, dynamicConfig.staticDefaultConfigs().get(synonym), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((IterableOnceOps)allSynonyms.dropWhile((Function1<DescribeConfigsResponseData.DescribeConfigsSynonym, Object> & Serializable)s -> BoxesRunTime.boxToBoolean(ConfigHelper.$anonfun$configSynonyms$6(name, s)))).toList();
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private String brokerDocumentation(String name) {
        return this.config.documentationOf(name);
    }

    private DescribeConfigsResponse.ConfigType configResponseType(Option<ConfigDef.Type> configType) {
        if (configType.isEmpty()) {
            return DescribeConfigsResponse.ConfigType.UNKNOWN;
        }
        ConfigDef.Type type = configType.get();
        if (((Object)((Object)ConfigDef.Type.BOOLEAN)).equals((Object)type)) {
            return DescribeConfigsResponse.ConfigType.BOOLEAN;
        }
        if (((Object)((Object)ConfigDef.Type.STRING)).equals((Object)type)) {
            return DescribeConfigsResponse.ConfigType.STRING;
        }
        if (((Object)((Object)ConfigDef.Type.INT)).equals((Object)type)) {
            return DescribeConfigsResponse.ConfigType.INT;
        }
        if (((Object)((Object)ConfigDef.Type.SHORT)).equals((Object)type)) {
            return DescribeConfigsResponse.ConfigType.SHORT;
        }
        if (((Object)((Object)ConfigDef.Type.LONG)).equals((Object)type)) {
            return DescribeConfigsResponse.ConfigType.LONG;
        }
        if (((Object)((Object)ConfigDef.Type.DOUBLE)).equals((Object)type)) {
            return DescribeConfigsResponse.ConfigType.DOUBLE;
        }
        if (((Object)((Object)ConfigDef.Type.LIST)).equals((Object)type)) {
            return DescribeConfigsResponse.ConfigType.LIST;
        }
        if (((Object)((Object)ConfigDef.Type.CLASS)).equals((Object)type)) {
            return DescribeConfigsResponse.ConfigType.CLASS;
        }
        if (((Object)((Object)ConfigDef.Type.PASSWORD)).equals((Object)type)) {
            return DescribeConfigsResponse.ConfigType.PASSWORD;
        }
        return DescribeConfigsResponse.ConfigType.UNKNOWN;
    }

    private int resourceNameToBrokerId(String resourceName) {
        int n;
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(resourceName));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException("Broker id must be an integer, but it is: " + resourceName);
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$allConfigs$1(Tuple2 x$1) {
        return x$1._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeConfigsRequest$1(AuthHelper authHelper$1, RequestChannel.Request request$1, DescribeConfigsRequestData.DescribeConfigsResource resource) {
        ConfigResource.Type type = ConfigResource.Type.forId(resource.resourceType());
        if (((Object)((Object)ConfigResource.Type.BROKER)).equals((Object)type) ? true : (((Object)((Object)ConfigResource.Type.BROKER_LOGGER)).equals((Object)type) ? true : (((Object)((Object)ConfigResource.Type.CLUSTER_LINK)).equals((Object)type) ? true : ((Object)((Object)ConfigResource.Type.CLIENT_METRICS)).equals((Object)type)))) {
            return authHelper$1.authorize(request$1.context(), AclOperation.DESCRIBE_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", authHelper$1.authorize$default$5(), authHelper$1.authorize$default$6(), authHelper$1.authorize$default$7());
        }
        if (((Object)((Object)ConfigResource.Type.TOPIC)).equals((Object)type)) {
            return authHelper$1.authorize(request$1.context(), AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, resource.resourceName(), authHelper$1.authorize$default$5(), authHelper$1.authorize$default$6(), authHelper$1.authorize$default$7());
        }
        if (((Object)((Object)ConfigResource.Type.GROUP)).equals((Object)type)) {
            return authHelper$1.authorize(request$1.context(), AclOperation.DESCRIBE_CONFIGS, ResourceType.GROUP, resource.resourceName(), authHelper$1.authorize$default$5(), authHelper$1.authorize$default$6(), authHelper$1.authorize$default$7());
        }
        throw new InvalidRequestException("Unexpected resource type " + type + " for resource " + resource.resourceName());
    }

    private final DescribeConfigsResponseData.DescribeConfigsResult createResponseConfig$1(Map configs, Function2 createConfigEntry, DescribeConfigsRequestData.DescribeConfigsResource resource$1) {
        Buffer configEntries = (Buffer)this.filterTopicConfigs(configs, Option$.MODULE$.apply(resource$1.configurationKeys()).filterNot((Function1<java.util.List<String>, Object>)(Function1<java.util.List, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.isEmpty())).map((Function1<java.util.List, scala.collection.immutable.Set> & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala().toSet())).map((Function1<Tuple2, DescribeConfigsResponseData.DescribeConfigsResourceResult> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Object value = tuple2._2();
                return (DescribeConfigsResponseData.DescribeConfigsResourceResult)createConfigEntry.apply(name, value);
            }
            throw new MatchError(tuple2);
        });
        return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(configEntries).asJava());
    }

    private final DescribeConfigsResponseData.DescribeConfigsResult computeTopicConfigResponse$1(TopicType x3$1, Properties topicProps$1, org.apache.kafka.metadata.TopicType orgApacheKafkaMetadataTopicType$1, boolean includeSynonyms$1, boolean includeDocumentation$1, DescribeConfigsRequestData.DescribeConfigsResource resource$1) {
        LogConfig logConfig = LogConfig.fromProps(this.config.extractLogConfigMap(x3$1), topicProps$1, orgApacheKafkaMetadataTopicType$1);
        return this.createResponseConfig$1(this.allConfigs(logConfig), (Function2<String, Object, DescribeConfigsResponseData.DescribeConfigsResourceResult> & Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps$1, includeSynonyms$1, includeDocumentation$1, (String)name, value), resource$1);
    }

    public static final /* synthetic */ boolean $anonfun$filterTopicConfigs$1(Option configNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String configName = (String)tuple2._1();
            boolean recordInterceptorCheck = !configName.equals("confluent.append.record.interceptor.classes");
            boolean schemaRegistryUrlCheck = !configName.equals("confluent.schema.registry.url");
            boolean schemaValidatorSamplesPerMinCheck = !configName.equals("confluent.schema.validator.samples.per.min");
            boolean schemaValidatorInterceptorClassCheck = !configName.equals("confluent.schema.validator.interceptor.class");
            boolean multitenantSchemaValidationEnabledCheck = !configName.equals("confluent.schema.validator.multitenant.enable");
            boolean basicAuthCredentialsSourceCheck = !configName.equals("confluent.basic.auth.credentials.source");
            boolean userInfoCheck = !configName.equals("confluent.basic.auth.user.info");
            boolean bearerAuthCredentialsCheck = !configName.equals("confluent.bearer.auth.credentials.source");
            boolean bearerAuthTokenCheck = !configName.equals("confluent.bearer.auth.token");
            boolean bearerAuthIssuerEndpoint = !configName.equals("confluent.bearer.auth.issuer.endpoint.url");
            boolean bearerAuthClientId = !configName.equals("confluent.bearer.auth.client.id");
            boolean bearerAuthClientSecret = !configName.equals("confluent.bearer.auth.client.secret");
            boolean bearerAssertionClaimIss = !configName.equals("confluent.bearer.assertion.claim.iss");
            boolean bearerAssertionClaimSub = !configName.equals("confluent.bearer.assertion.claim.sub");
            boolean bearerAssertionClaimAud = !configName.equals("confluent.bearer.assertion.claim.aud");
            boolean bearerAssertionClaimJtiInclude = !configName.equals("confluent.bearer.assertion.claim.jti.include");
            boolean bearerAssertionClaimNbfInclude = !configName.equals("confluent.bearer.assertion.claim.nbf.include");
            boolean bearerAssertionClaimExpMinutes = !configName.equals("confluent.bearer.assertion.claim.exp.minutes");
            boolean bearerAssertionPrivateKeyFile = !configName.equals("confluent.bearer.assertion.private.key.file");
            boolean bearerAssertionPrivateKeyPassphrase = !configName.equals("confluent.bearer.assertion.private.key.passphrase");
            boolean bearerAssertionFile = !configName.equals("confluent.bearer.assertion.file");
            boolean bearerAssertionTemplateFile = !configName.equals("confluent.bearer.assertion.template.file");
            boolean bearerAuthClientScope = !configName.equals("confluent.bearer.auth.scope");
            boolean bearerAuthClientScopeClaim = !configName.equals("confluent.bearer.auth.scope.claim.name");
            boolean bearerAuthClientSubClaim = !configName.equals("confluent.bearer.auth.sub.claim.name");
            boolean bearerAuthLogicalCluster = !configName.equals("confluent.bearer.auth.logical.cluster");
            boolean bearerAuthIdentityPool = !configName.equals("confluent.bearer.auth.identity.pool.id");
            boolean bearerAuthBufferExpirySecond = !configName.equals("confluent.bearer.auth.cache.expiry.buffer.seconds");
            boolean sslProtocolCheck = !configName.equals("confluent.ssl.protocol");
            boolean sslKeystoreTypeCheck = !configName.equals("confluent.ssl.keystore.type");
            boolean sslKeystoreLocationCheck = !configName.equals("confluent.ssl.keystore.location");
            boolean sslKeystorePasswordCheck = !configName.equals("confluent.ssl.keystore.password");
            boolean sslKeyPasswordCheck = !configName.equals("confluent.ssl.key.password");
            boolean sslTruststoreTypeCheck = !configName.equals("confluent.ssl.truststore.type");
            boolean sslTruststoreLocationCheck = !configName.equals("confluent.ssl.truststore.location");
            boolean sslTruststorePasswordCheck = !configName.equals("confluent.ssl.truststore.password");
            return basicAuthCredentialsSourceCheck && userInfoCheck && bearerAuthCredentialsCheck && bearerAuthTokenCheck && bearerAuthIssuerEndpoint && bearerAuthClientId && bearerAuthClientSecret && bearerAuthClientScope && bearerAuthClientScopeClaim && bearerAuthClientSubClaim && bearerAuthLogicalCluster && bearerAuthIdentityPool && bearerAuthBufferExpirySecond && bearerAssertionClaimIss && bearerAssertionClaimSub && bearerAssertionClaimAud && bearerAssertionClaimJtiInclude && bearerAssertionClaimNbfInclude && bearerAssertionPrivateKeyFile && bearerAssertionPrivateKeyPassphrase && bearerAssertionFile && bearerAssertionTemplateFile && bearerAssertionClaimExpMinutes && recordInterceptorCheck && schemaRegistryUrlCheck && schemaValidatorSamplesPerMinCheck && schemaValidatorInterceptorClassCheck && multitenantSchemaValidationEnabledCheck && sslProtocolCheck && sslKeystoreTypeCheck && sslKeystoreLocationCheck && sslKeystorePasswordCheck && sslKeyPasswordCheck && sslTruststoreTypeCheck && sslTruststoreLocationCheck && sslTruststorePasswordCheck && configNames$1.forall((Function1<Set, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.contains(configName)));
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponseData.DescribeConfigsSynonym x$6) {
        return perBrokerConfig$1 || x$6.source() == DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG.id();
    }

    private static final void maybeAddSynonym$1(String synonymName, Option synonymValue, DescribeConfigsResponse.ConfigSource source, boolean isSensitive$2, Buffer allSynonyms$1) {
        synonymValue.map((Function1<String, Buffer> & Serializable)value -> {
            String configValue = isSensitive$2 ? null : value;
            return (Buffer)allSynonyms$1.$plus$eq(new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(synonymName).setValue(configValue).setSource(source.id()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$1, DescribeConfigsResponseData.DescribeConfigsSynonym s) {
        String string = s.name();
        String string2 = name$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public ConfigHelper(MetadataCache metadataCache, KafkaConfig config, ConfigRepository configRepository, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkFactory.LinkManager clusterLinkManager) {
        this.metadataCache = metadataCache;
        this.config = config;
        this.configRepository = configRepository;
        this.alterConfigPolicy = alterConfigPolicy;
        this.clusterLinkManager = clusterLinkManager;
        Logging.$init$(this);
    }
}

