/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.server.purgatory.DelayedOperation;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005m3A\u0001C\u0005\u0001\u001d!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!)\u0005A!A!\u0002\u00131\u0005\"\u0002'\u0001\t\u0003i\u0005\"B*\u0001\t\u0003\"\u0006\"\u0002-\u0001\t\u0003J\u0006\"\u0002.\u0001\t\u0003J&!\u0004#fY\u0006LX\r\u001a$viV\u0014XM\u0003\u0002\u000b\u0017\u000511/\u001a:wKJT\u0011\u0001D\u0001\u0006W\u000647.Y\u0002\u0001+\tyAhE\u0002\u0001!q\u0001\"!\u0005\u000e\u000e\u0003IQ!a\u0005\u000b\u0002\u0013A,(oZ1u_JL(B\u0001\u0006\u0016\u0015\taaC\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<\u0017BA\u000e\u0013\u0005A!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000e\u0005\u0002\u001eA5\taD\u0003\u0002 \u0017\u0005)Q\u000f^5mg&\u0011\u0011E\b\u0002\b\u0019><w-\u001b8h\u0003%!\u0018.\\3pkRl5\u000f\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0003M_:<\u0017a\u00024viV\u0014Xm\u001d\t\u0004W9\u0002T\"\u0001\u0017\u000b\u00055*\u0013AC2pY2,7\r^5p]&\u0011q\u0006\f\u0002\u0004'\u0016\f\bcA\u00199u5\t!G\u0003\u00024i\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005U2\u0014\u0001B;uS2T\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:e\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u0005mbD\u0002\u0001\u0003\u0006{\u0001\u0011\rA\u0010\u0002\u0002)F\u0011qH\u0011\t\u0003I\u0001K!!Q\u0013\u0003\u000f9{G\u000f[5oOB\u0011AeQ\u0005\u0003\t\u0016\u00121!\u00118z\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0002%\u000f&K!\u0001S\u0013\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001\u0013K\u0013\tYUE\u0001\u0003V]&$\u0018A\u0002\u001fj]&$h\b\u0006\u0003O!F\u0013\u0006cA(\u0001u5\t\u0011\u0002C\u0003#\t\u0001\u00071\u0005C\u0003*\t\u0001\u0007!\u0006C\u0003F\t\u0001\u0007a)A\u0006uef\u001cu.\u001c9mKR,G#A+\u0011\u0005\u00112\u0016BA,&\u0005\u001d\u0011un\u001c7fC:\f!b\u001c8D_6\u0004H.\u001a;f)\u0005I\u0015\u0001D8o\u000bb\u0004\u0018N]1uS>t\u0007")
public class DelayedFuture<T>
extends DelayedOperation
implements Logging {
    private final long timeoutMs;
    private final Seq<CompletableFuture<T>> futures;
    private final Function0<BoxedUnit> responseCallback;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DelayedFuture delayedFuture = this;
        synchronized (delayedFuture) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public boolean tryComplete() {
        this.trace((Function0<String> & Serializable)() -> "Trying to complete operation for " + $this.futures.size() + " futures");
        int pending = this.futures.count((Function1<CompletableFuture, Object> & Serializable)future -> BoxesRunTime.boxToBoolean(DelayedFuture.$anonfun$tryComplete$2(future)));
        if (pending == 0) {
            this.trace((Function0<String> & Serializable)() -> "All futures have been completed or have errors, completing the delayed operation");
            return this.forceComplete();
        }
        this.trace((Function0<String> & Serializable)() -> pending + " future still pending, not completing the delayed operation");
        return false;
    }

    @Override
    public void onComplete() {
        Seq pendingFutures = (Seq)this.futures.filterNot((Function1<CompletableFuture, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isDone()));
        this.trace((Function0<String> & Serializable)() -> "Completing operation for " + $this.futures.size() + " futures, expired " + pendingFutures.size());
        pendingFutures.foreach((Function1<CompletableFuture, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.completeExceptionally(new TimeoutException("Request has been timed out after " + this.timeoutMs + " ms"))));
        this.responseCallback.apply$mcV$sp();
    }

    @Override
    public void onExpiration() {
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$2(CompletableFuture future) {
        return !future.isDone();
    }

    public DelayedFuture(long timeoutMs, Seq<CompletableFuture<T>> futures, Function0<BoxedUnit> responseCallback) {
        this.timeoutMs = timeoutMs;
        this.futures = futures;
        this.responseCallback = responseCallback;
        super(timeoutMs);
        Logging.$init$(this);
    }
}

