/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.ConfigHandler;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.Logging;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000554A!\u0003\u0006\u0001\u001f!A\u0001\u0005\u0001BC\u0002\u0013%\u0011\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003#\u0011!1\u0003A!A!\u0002\u00139\u0003\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011A\u0016\t\u0011i\u0002!\u0011!Q\u0001\n1BQa\u000f\u0001\u0005\u0002qBQ!\u0011\u0001\u0005\u0002\tCQA\u0017\u0001\u0005\u0002m\u0013!\u0003V8qS\u000e\u001cuN\u001c4jO\"\u000bg\u000e\u001a7fe*\u00111\u0002D\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00035\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001!YQ\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001815\t!\"\u0003\u0002\u001a\u0015\ti1i\u001c8gS\u001eD\u0015M\u001c3mKJ\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0007\u0002\u000bU$\u0018\u000e\\:\n\u0005}a\"a\u0002'pO\u001eLgnZ\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005\u0011\u0003CA\f$\u0013\t!#B\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\n1b[1gW\u0006\u001cuN\u001c4jOB\u0011q\u0003K\u0005\u0003S)\u00111bS1gW\u0006\u001cuN\u001c4jO\u00061\u0011/^8uCN,\u0012\u0001\f\t\u0003[]r!AL\u001b\u000f\u0005=\"dB\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011aGC\u0001\r#V|G/\u0019$bGR|'/_\u0005\u0003qe\u0012Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(B\u0001\u001c\u000b\u0003\u001d\tXo\u001c;bg\u0002\na\u0001P5oSRtD\u0003B\u001f?\u007f\u0001\u0003\"a\u0006\u0001\t\u000b\u00012\u0001\u0019\u0001\u0012\t\u000b\u00192\u0001\u0019A\u0014\t\u000b)2\u0001\u0019\u0001\u0017\u0002)A\u0014xnY3tg\u000e{gNZ5h\u0007\"\fgnZ3t)\r\u0019e\t\u0015\t\u0003#\u0011K!!\u0012\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u000f\u001e\u0001\r\u0001S\u0001\u0006i>\u0004\u0018n\u0019\t\u0003\u00136s!AS&\u0011\u0005A\u0012\u0012B\u0001'\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051\u0013\u0002\"B)\b\u0001\u0004\u0011\u0016a\u0003;pa&\u001c7i\u001c8gS\u001e\u0004\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\tU$\u0018\u000e\u001c\u0006\u0002/\u0006!!.\u0019<b\u0013\tIFK\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001\u0004]1sg\u0016$\u0006N]8ui2,G\rU1si&$\u0018n\u001c8t)\u0011a\u0006.[6\u0011\u0007u\u0013WM\u0004\u0002_A:\u0011\u0001gX\u0005\u0002'%\u0011\u0011ME\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019GMA\u0002TKFT!!\u0019\n\u0011\u0005E1\u0017BA4\u0013\u0005\rIe\u000e\u001e\u0005\u0006#\"\u0001\rA\u0015\u0005\u0006U\"\u0001\r!Z\u0001\tEJ|7.\u001a:JI\")A\u000e\u0003a\u0001\u0011\u0006!\u0001O]8q\u0001")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicConfigHandler topicConfigHandler = this;
        synchronized (topicConfigHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        this.replicaManager().updateTopicConfig(topic, topicConfig);
        this.updateThrottledList$1("leader.replication.throttled.replicas", this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1("follower.replication.throttled.replicas", this.quotas().follower(), topicConfig, topic);
    }

    public scala.collection.immutable.Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator.ensureValidString(prop, configValue);
        String string = configValue;
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (!"".equals(string)) break;
                return Nil$.MODULE$;
            }
            case 42: {
                if (!"*".equals(string)) break;
                return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(ReplicationQuotaManager.ALL_REPLICAS).asScala().map((Function1<Integer, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(x$2)))).toSeq();
            }
            case 3387192: {
                if (!"none".equals(string)) break;
                return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(ReplicationQuotaManager.NO_REPLICAS).asScala().map((Function1<Integer, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(x$1)))).toSeq();
            }
        }
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(configValue.trim().split(",")), (Function1<String, String[]> & Serializable)x$3 -> x$3.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1<String[], Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(TopicConfigHandler.$anonfun$parseThrottledPartitions$4(brokerId, x$4)))), (Function1<String[], Object> & Serializable)x$5 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$5[0]))), ClassTag$.MODULE$.Int())));
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(topicConfig$1.getProperty(prop)))) {
            scala.collection.immutable.Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions.map((Function1<Object, Integer> & Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1))).asJava());
            this.debug((Function0<String> & Serializable)() -> "Setting " + prop + " on broker " + $this.kafkaConfig.brokerId() + " for topic: " + topic$1 + " and partitions " + partitions);
            return;
        }
        quotaManager.removeThrottle(topic$1);
        this.debug((Function0<String> & Serializable)() -> "Removing " + prop + " from broker " + $this.kafkaConfig.brokerId() + " for topic " + topic$1);
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$4(int brokerId$1, String[] x$4) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4[1])) == brokerId$1;
    }

    public TopicConfigHandler(ReplicaManager replicaManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas) {
        this.replicaManager = replicaManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        Logging.$init$(this);
    }
}

