/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.server.FetchConnectionsMode$;
import kafka.server.FetchConnectionsMode$Combined$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.TopicConfigSyncIncludeValidator$;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.ServerConfigs;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkConfig$ {
    public static final ClusterLinkConfig$ MODULE$ = new ClusterLinkConfig$();
    private static final String LinkModeProp = "link.mode";
    private static final String LinkModeDoc = "Mode that indicates if this cluster is configured to be the source or destination of the cluster link. Valid values are " + ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ClusterLinkConfig.LinkMode.values()), (Function1<ClusterLinkConfig.LinkMode, String> & Serializable)x$16 -> x$16.name(), ClassTag$.MODULE$.apply(String.class)) + ".";
    private static final String ConnectionModeProp = "connection.mode";
    private static final String ConnectionModeDoc = "Connection mode that indicates if outbound connections are established by this cluster for the cluster link. Valid values are " + ConnectionMode$.MODULE$.values().map((Function1<Product, String> & Serializable)x$17 -> ((ConnectionMode)((Object)x$17)).name()) + ". By default, destination cluster creates outbound connections and source cluster accepts inbound connections. Connection and security configuration should be provided for the cluster that establishes outbound connections. Security configuration to establish local connections should also be provided with prefix 'local.' for source clusters with connection mode " + ConnectionMode$Outbound$.MODULE$.name() + ".";
    private static final String LocalPrefix = "local.";
    private static final String LocalListenerNameProp = "local.listener.name";
    private static final String LocalListenerNameDoc = "Name of the local listener on the source cluster used for local cluster link connection requests. Cluster link connections are added to this listener if '" + MODULE$.LinkModeProp() + "=" + ClusterLinkConfig.LinkMode.SOURCE.name() + "' and '" + MODULE$.ConnectionModeProp() + "=" + ConnectionMode$Outbound$.MODULE$.name() + "'. Security configuration options for creating local connections on this listener should be configured with the prefix '" + MODULE$.LocalPrefix() + "'. By default, the listener on which the source link was created will be used as the local listener.";
    private static final String ReverseConnectionSetupTimeoutMsProp = "reverse.connection.setup.timeout.ms";
    private static final String ReverseConnectionSetupTimeoutMsDoc = "Timeout in milliseconds to wait for response of reverse connection requests for source initiated links. This limits the amount of time before a retry when brokers fail or are restarted.";
    private static final String RemoteLinkConnectionModeProp = "remote.link.connection.mode";
    private static final String RemoteLinkConnectionModeDoc = "Connection mode used by the remote link of a bi-directional link";
    private static final String FetcherThreadPoolModeProp = "fetcher.thread.pool.mode";
    private static final String FetcherThreadPoolModeDoc = KafkaConfig$.MODULE$.ClusterLinkFetcherThreadPoolModeDoc() + " If the property is not configured at link level then the broker property `" + KafkaConfig$.MODULE$.ClusterLinkFetcherThreadPoolModeProp() + "` will be used instead.";
    private static final String NumClusterLinkFetchersProp = "num.cluster.link.fetchers";
    private static final String NumClusterLinkFetchersDoc = "Number of fetchers used to replicate messages from source brokers in cluster links. This is the maximum number of connections between each broker pair. If '" + MODULE$.FetcherThreadPoolModeProp() + "=" + ClusterLinkConfig.FetcherThreadPoolMode.LINK + "', this is the maximum number of fetcher threads for the link, if '" + MODULE$.FetcherThreadPoolModeProp() + "=" + ClusterLinkConfig.FetcherThreadPoolMode.ENDPOINT + "', this is the maximum number of fetcher threads for connections between each broker pair.";
    private static final String RetryTimeoutMsProp = "cluster.link.retry.timeout.ms";
    private static final String RetryTimeoutMsDoc = "The number of milliseconds after which failures are no longer retried and partitions are marked as failed. If the source topic is deleted and recreated within this timeout, the link may contain records from the old as well as the new topic.";
    private static final String ClusterLinkPausedProp = "cluster.link.paused";
    private static final String ClusterLinkPausedDoc = "Whether all activity over the cluster link is paused.";
    private static final String ClusterLinkPrefixProp = "cluster.link.prefix";
    private static final String ClusterLinkPrefixDoc = "The prefix value that will be applied to the name of the resources created by the cluster link. Some examples are mirror topic name and consumer group id. Topics that begin with '_confluent' will not be mirrored.";
    private static final String ConsumerOffsetSyncEnableProp = "consumer.offset.sync.enable";
    private static final String ConsumerOffsetSyncEnableDoc = "Whether or not to migrate consumer offsets from the source cluster.";
    private static final String ConsumerGroupPrefixEnableProp = "consumer.group.prefix.enable";
    private static final String ConsumerGroupPrefixEnableDoc = "Whether to apply the cluster link prefix to consumer groups.";
    private static final String ConsumerOffsetSyncMsProp = "consumer.offset.sync.ms";
    private static final String ConsumerOffsetSyncMsDoc = "How often to sync consumer offsets.";
    private static final String ConsumerOffsetGroupFiltersProp = "consumer.offset.group.filters";
    private static final String ConsumerOffsetGroupFiltersDoc = "JSON to denote the list of consumer groups to be migrated.";
    private static final String AclSyncEnableProp = "acl.sync.enable";
    private static final String AclSyncEnableDoc = "Whether or not to migrate ACLs";
    private static final String AclFiltersProp = "acl.filters";
    private static final String AclFiltersDoc = "JSON to denote the list of ACLs to be migrated.";
    private static final String AclSyncMsProp = "acl.sync.ms";
    private static final String AclSyncMsDoc = "How often to refresh the ACLs.";
    private static final String TopicConfigSyncIncludeProp = "topic.config.sync.include";
    private static final String TopicConfigSyncIncludeDoc = "The list of topic configs to sync from the source topic.";
    private static final String TopicConfigSyncMsProp = "topic.config.sync.ms";
    private static final String TopicConfigSyncMsDoc = "How often to refresh the topic configs.";
    private static final String AutoMirroringEnableProp = "auto.create.mirror.topics.enable";
    private static final String AutoMirroringEnableDoc = "Whether or not to automatically create mirror topics";
    private static final String TopicFiltersProp = "auto.create.mirror.topics.filters";
    private static final String TopicFiltersDoc = "JSON to denote the list of source topics to automatically create mirror topics from";
    private static final String MirrorStartOffsetSpecProp = "mirror.start.offset.spec";
    private static final String MirrorStartOffsetSpecDoc = "Start offset spec that determines the offset from which mirroring starts for new topics. The value may be \"earliest\", \"latest\" or a timestamp in ISO8601 format \"YYYY-MM-DDTHH:mm:SS.sss\". By default, mirroring starts from the earliest available offset.";
    private static final String MaxMessageSizeProp = "max.message.size";
    private static final String MaxMessageSizeDoc = "The largest record batch size allowed by Kafka (after compression if compression is enabled). If this is increased and there are consumers older than 0.10.2, the consumers' fetch size must also be increased so that they can fetch record batches this large. In the latest message format version, records are always grouped into batches for efficiency. In previous message format versions, uncompressed records are not grouped into batches and this limit only applies to a single record in that case. The setting on the cluster link defines the largest record batch size that may be replicated from the source cluster. If larger records are found on a source partition, the mirror topic will be moved to failed state. Note that the maximum configured for the source topic is not applied during cluster link replication, but the setting is sync'ed to the mirror topic to ensure that the same config applies after failover. Default value is unlimited.";
    private static final String AvailabilityCheckMsProp = "availability.check.ms";
    private static final String AvailabilityCheckMsDoc = "How often to send a request to source cluster to check source cluster availability.";
    private static final String AvailabilityCheckConsecutiveFailureThresholdProp = "availability.check.consecutive.failure.threshold";
    private static final String AvailabilityCheckConsecutiveFailureThresholdDoc = "The upper-bound of the consecutive failures beyond which the availability checker will report the link as unavailable.";
    private static final String LinkFetcherFlowControlProp = "link.fetcher.flow.control";
    private static final String LinkFetcherFlowControlDoc = "The flow control approach used by cluster linking fetcher";
    private static final String LinkFetcherMaxLaggingPartitionsProp = "link.fetcher.max.lagging.partitions";
    private static final String LinkFetcherMaxLaggingPartitionsDoc = "Maximum number of lagging partitions. The limit is enforced periodically by the fetcher. If set to -1, the limit is not enforced.";
    private static final String LinkFetcherLaggingPartitionMsProp = "link.fetcher.lagging.partition.ms";
    private static final String LinkFetcherLaggingPartitionMsDoc = "When a partition last caught up time is more than this time, the partition is considered a lagging partition.";
    private static final String LinkFetcherEnforceMaxLaggingPartitionMsProp = "link.fetcher.enforce.max.lagging.partitions.ms";
    private static final String LinkFetcherEnforceMaxLaggingPartitionMsDoc = "The periodic interval where link fetcher will run periodic tasks like enforcing the limit on number of lagging partitions.";
    private static final String LinkFetcherDegradedPartitionMonitorMsProp = "link.fetcher.degraded.partition.monitor.ms";
    private static final String LinkFetcherDegradedPartitionMonitorMsDoc = "The periodic interval at which link fetcher verifies the status of degraded partitions.";
    private static final String ClientsMaxIdleMsProp = "clients.max.idle.ms";
    private static final String ClientsMaxIdleMsDoc = "The interval in milliseconds after which idle cluster link clients and associated threads are closed.";
    private static final String LinkFetcherAutoTuneEnableProp = "link.fetcher.auto.tune.num.fetchers.enable";
    private static final String LinkFetcherAutoTuneEnableDoc = "If true, enable auto tuning number of cluster link fetchers.";
    private static final String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp = "link.fetcher.auto.tune.decrease.throughput.threshold.bytes";
    private static final String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc = "If the cluster link throughput is below this value and there is no lagging partition, auto tuning will reduce the number of cluster link fetchers";
    private static final String LinkFetcherAutoTuneIncreaseThroughputPercentageProp = "link.fetcher.auto.tune.increase.throughput.percentage";
    private static final String LinkFetcherAutoTuneIncreaseThroughputPercentageDoc = "After increasing the number of cluster link fetchers, auto tuning expects the throughput to increase at least this percentage before further increases the number of cluster link fetchers.";
    private static final String LinkFetcherAutoTuneMaxConnectionPercentageProp = "link.fetcher.auto.tune.max.connection.percentage";
    private static final String LinkFetcherAutoTuneMaxConnectionPercentageDoc = "When the active number of cluster link connections exceeds this percentage of maximum allowed cluster link connections, auto tuning will stop increasing the number of cluster link fetchers.";
    private static final String ReplicaSocketReceiveBufferBytesDoc = "The socket receive buffer size for cluster linking connections. The receive buffer size will be limited by a defined maximum value. If set to -1, the kernel will auto tune the receive buffer size up to a defined maximum value.";
    private static final String BootstrapServersOverrideProp = "bootstrap.servers.override";
    private static final String BootstrapServersOverrideDoc = "A list of overridden bootstrap servers to use for establishing the initial connection to the Kafka cluster if present instead of bootstrap.servers provided by the customer.";
    private static final String AllowTruncationBelowHWMProp = "allow.truncation.below.high.watermark";
    private static final String AllowTruncationBelowHWMDoc = "If true, allow cluster link to truncate the mirror topic partitions below high watermark.";
    private static final Set<String> ReplicationProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.AllowTruncationBelowHWMProp(), MODULE$.NumClusterLinkFetchersProp(), MODULE$.FetcherThreadPoolModeProp(), MODULE$.RetryTimeoutMsProp(), MODULE$.LinkFetcherFlowControlProp(), MODULE$.LinkFetcherMaxLaggingPartitionsProp(), MODULE$.LinkFetcherLaggingPartitionMsProp(), MODULE$.MaxMessageSizeProp(), "replica.socket.timeout.ms", "replica.socket.receive.buffer.bytes", "replica.fetch.max.bytes", "replica.fetch.wait.max.ms", "replica.fetch.backoff.ms", "confluent.replica.fetch.backoff.max.ms", "replica.fetch.min.bytes", "replica.fetch.response.max.bytes", "confluent.replica.fetch.connections.mode"}));
    private static final int MaxMessageSizeUnlimited = Integer.MAX_VALUE;
    private static final Set<String> PeriodicTaskProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.ConsumerOffsetSyncEnableProp(), MODULE$.ConsumerOffsetSyncMsProp(), MODULE$.ConsumerOffsetGroupFiltersProp(), MODULE$.AclSyncEnableProp(), MODULE$.AclFiltersProp(), MODULE$.AclSyncMsProp(), MODULE$.TopicConfigSyncMsProp(), MODULE$.AutoMirroringEnableProp(), MODULE$.TopicFiltersProp(), MODULE$.AvailabilityCheckMsProp(), MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), MODULE$.LinkFetcherEnforceMaxLaggingPartitionMsProp(), MODULE$.LinkFetcherDegradedPartitionMonitorMsProp(), MODULE$.ClientsMaxIdleMsProp(), MODULE$.LinkFetcherAutoTuneEnableProp(), MODULE$.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp(), MODULE$.LinkFetcherAutoTuneIncreaseThroughputPercentageProp(), MODULE$.LinkFetcherAutoTuneMaxConnectionPercentageProp()}));
    private static final Set<String> NonReconfigurableProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.LinkModeProp(), MODULE$.ConnectionModeProp(), MODULE$.ClusterLinkPrefixProp(), MODULE$.ConsumerGroupPrefixEnableProp(), MODULE$.RemoteLinkConnectionModeProp()}));
    private static final Set<String> SslKeystoreConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.keystore.password", "ssl.key.password", "ssl.keystore.type", "ssl.keystore.certificate.chain", "ssl.keystore.key"}));
    private static final Set<String> SslTruststoreConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.truststore.location", "ssl.truststore.password", "ssl.truststore.type", "ssl.truststore.certificates"}));
    private static final Set<String> ProviderConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.provider", "security.providers"}));
    private static final Set<String> kafka$server$link$ClusterLinkConfig$$RetentionConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.ms", "retention.bytes"}));
    private static final ConfigDef configDef = MODULE$.createClusterLinkConfigDef();

    public String LinkModeProp() {
        return LinkModeProp;
    }

    public String LinkModeDoc() {
        return LinkModeDoc;
    }

    public String ConnectionModeProp() {
        return ConnectionModeProp;
    }

    public String ConnectionModeDoc() {
        return ConnectionModeDoc;
    }

    public String LocalPrefix() {
        return LocalPrefix;
    }

    public String LocalListenerNameProp() {
        return LocalListenerNameProp;
    }

    public String LocalListenerNameDoc() {
        return LocalListenerNameDoc;
    }

    public String ReverseConnectionSetupTimeoutMsProp() {
        return ReverseConnectionSetupTimeoutMsProp;
    }

    public String ReverseConnectionSetupTimeoutMsDoc() {
        return ReverseConnectionSetupTimeoutMsDoc;
    }

    public String RemoteLinkConnectionModeProp() {
        return RemoteLinkConnectionModeProp;
    }

    public String RemoteLinkConnectionModeDoc() {
        return RemoteLinkConnectionModeDoc;
    }

    public String FetcherThreadPoolModeProp() {
        return FetcherThreadPoolModeProp;
    }

    public String FetcherThreadPoolModeDoc() {
        return FetcherThreadPoolModeDoc;
    }

    public String NumClusterLinkFetchersProp() {
        return NumClusterLinkFetchersProp;
    }

    public String NumClusterLinkFetchersDoc() {
        return NumClusterLinkFetchersDoc;
    }

    public String RetryTimeoutMsProp() {
        return RetryTimeoutMsProp;
    }

    public String RetryTimeoutMsDoc() {
        return RetryTimeoutMsDoc;
    }

    public String ClusterLinkPausedProp() {
        return ClusterLinkPausedProp;
    }

    public String ClusterLinkPausedDoc() {
        return ClusterLinkPausedDoc;
    }

    public String ClusterLinkPrefixProp() {
        return ClusterLinkPrefixProp;
    }

    public String ClusterLinkPrefixDoc() {
        return ClusterLinkPrefixDoc;
    }

    public String ConsumerOffsetSyncEnableProp() {
        return ConsumerOffsetSyncEnableProp;
    }

    public String ConsumerOffsetSyncEnableDoc() {
        return ConsumerOffsetSyncEnableDoc;
    }

    public String ConsumerGroupPrefixEnableProp() {
        return ConsumerGroupPrefixEnableProp;
    }

    public String ConsumerGroupPrefixEnableDoc() {
        return ConsumerGroupPrefixEnableDoc;
    }

    public String ConsumerOffsetSyncMsProp() {
        return ConsumerOffsetSyncMsProp;
    }

    public String ConsumerOffsetSyncMsDoc() {
        return ConsumerOffsetSyncMsDoc;
    }

    public String ConsumerOffsetGroupFiltersProp() {
        return ConsumerOffsetGroupFiltersProp;
    }

    public String ConsumerOffsetGroupFiltersDoc() {
        return ConsumerOffsetGroupFiltersDoc;
    }

    public String AclSyncEnableProp() {
        return AclSyncEnableProp;
    }

    public String AclSyncEnableDoc() {
        return AclSyncEnableDoc;
    }

    public String AclFiltersProp() {
        return AclFiltersProp;
    }

    public String AclFiltersDoc() {
        return AclFiltersDoc;
    }

    public String AclSyncMsProp() {
        return AclSyncMsProp;
    }

    public String AclSyncMsDoc() {
        return AclSyncMsDoc;
    }

    public String TopicConfigSyncIncludeProp() {
        return TopicConfigSyncIncludeProp;
    }

    public String TopicConfigSyncIncludeDoc() {
        return TopicConfigSyncIncludeDoc;
    }

    public String TopicConfigSyncMsProp() {
        return TopicConfigSyncMsProp;
    }

    public String TopicConfigSyncMsDoc() {
        return TopicConfigSyncMsDoc;
    }

    public String AutoMirroringEnableProp() {
        return AutoMirroringEnableProp;
    }

    public String AutoMirroringEnableDoc() {
        return AutoMirroringEnableDoc;
    }

    public String TopicFiltersProp() {
        return TopicFiltersProp;
    }

    public String TopicFiltersDoc() {
        return TopicFiltersDoc;
    }

    public String MirrorStartOffsetSpecProp() {
        return MirrorStartOffsetSpecProp;
    }

    public String MirrorStartOffsetSpecDoc() {
        return MirrorStartOffsetSpecDoc;
    }

    public String MaxMessageSizeProp() {
        return MaxMessageSizeProp;
    }

    public String MaxMessageSizeDoc() {
        return MaxMessageSizeDoc;
    }

    public String AvailabilityCheckMsProp() {
        return AvailabilityCheckMsProp;
    }

    public String AvailabilityCheckMsDoc() {
        return AvailabilityCheckMsDoc;
    }

    public String AvailabilityCheckConsecutiveFailureThresholdProp() {
        return AvailabilityCheckConsecutiveFailureThresholdProp;
    }

    public String AvailabilityCheckConsecutiveFailureThresholdDoc() {
        return AvailabilityCheckConsecutiveFailureThresholdDoc;
    }

    public String LinkFetcherFlowControlProp() {
        return LinkFetcherFlowControlProp;
    }

    public String LinkFetcherFlowControlDoc() {
        return LinkFetcherFlowControlDoc;
    }

    public String LinkFetcherMaxLaggingPartitionsProp() {
        return LinkFetcherMaxLaggingPartitionsProp;
    }

    public String LinkFetcherMaxLaggingPartitionsDoc() {
        return LinkFetcherMaxLaggingPartitionsDoc;
    }

    public String LinkFetcherLaggingPartitionMsProp() {
        return LinkFetcherLaggingPartitionMsProp;
    }

    public String LinkFetcherLaggingPartitionMsDoc() {
        return LinkFetcherLaggingPartitionMsDoc;
    }

    public String LinkFetcherEnforceMaxLaggingPartitionMsProp() {
        return LinkFetcherEnforceMaxLaggingPartitionMsProp;
    }

    public String LinkFetcherEnforceMaxLaggingPartitionMsDoc() {
        return LinkFetcherEnforceMaxLaggingPartitionMsDoc;
    }

    public String LinkFetcherDegradedPartitionMonitorMsProp() {
        return LinkFetcherDegradedPartitionMonitorMsProp;
    }

    public String LinkFetcherDegradedPartitionMonitorMsDoc() {
        return LinkFetcherDegradedPartitionMonitorMsDoc;
    }

    public String ClientsMaxIdleMsProp() {
        return ClientsMaxIdleMsProp;
    }

    public String ClientsMaxIdleMsDoc() {
        return ClientsMaxIdleMsDoc;
    }

    public String LinkFetcherAutoTuneEnableProp() {
        return LinkFetcherAutoTuneEnableProp;
    }

    public String LinkFetcherAutoTuneEnableDoc() {
        return LinkFetcherAutoTuneEnableDoc;
    }

    public String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp() {
        return LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp;
    }

    public String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc() {
        return LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc;
    }

    public String LinkFetcherAutoTuneIncreaseThroughputPercentageProp() {
        return LinkFetcherAutoTuneIncreaseThroughputPercentageProp;
    }

    public String LinkFetcherAutoTuneIncreaseThroughputPercentageDoc() {
        return LinkFetcherAutoTuneIncreaseThroughputPercentageDoc;
    }

    public String LinkFetcherAutoTuneMaxConnectionPercentageProp() {
        return LinkFetcherAutoTuneMaxConnectionPercentageProp;
    }

    public String LinkFetcherAutoTuneMaxConnectionPercentageDoc() {
        return LinkFetcherAutoTuneMaxConnectionPercentageDoc;
    }

    public String ReplicaSocketReceiveBufferBytesDoc() {
        return ReplicaSocketReceiveBufferBytesDoc;
    }

    public String BootstrapServersOverrideProp() {
        return BootstrapServersOverrideProp;
    }

    public String BootstrapServersOverrideDoc() {
        return BootstrapServersOverrideDoc;
    }

    public String AllowTruncationBelowHWMProp() {
        return AllowTruncationBelowHWMProp;
    }

    public String AllowTruncationBelowHWMDoc() {
        return AllowTruncationBelowHWMDoc;
    }

    public Set<String> ReplicationProps() {
        return ReplicationProps;
    }

    public int MaxMessageSizeUnlimited() {
        return MaxMessageSizeUnlimited;
    }

    public Set<String> PeriodicTaskProps() {
        return PeriodicTaskProps;
    }

    public Set<String> NonReconfigurableProps() {
        return NonReconfigurableProps;
    }

    public Set<String> SslKeystoreConfigs() {
        return SslKeystoreConfigs;
    }

    public Set<String> SslTruststoreConfigs() {
        return SslTruststoreConfigs;
    }

    public Set<String> ProviderConfigs() {
        return ProviderConfigs;
    }

    public Set<String> kafka$server$link$ClusterLinkConfig$$RetentionConfigs() {
        return kafka$server$link$ClusterLinkConfig$$RetentionConfigs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean needsConnectionResetOnUpdate(String configName) {
        if (!this.configKeys().contains(configName)) return true;
        if (configName.startsWith(this.LocalPrefix())) return true;
        String string = configName;
        String string2 = "security.protocol";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        if (configName.startsWith("ssl.")) return true;
        if (!configName.startsWith("sasl.")) return false;
        return true;
    }

    public void main(String[] args) {
        Predef$.MODULE$.println(this.configDef().toHtml());
    }

    public ConfigDef configDef() {
        return configDef;
    }

    private ConfigDef createClusterLinkConfigDef() {
        ConfigDef configDef = new ConfigDef().define(this.LinkModeProp(), ConfigDef.Type.STRING, (Object)ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault().name(), ConfigDef.ValidString.in((String[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ClusterLinkConfig.LinkMode.values()), (Function1<ClusterLinkConfig.LinkMode, String> & Serializable)x$18 -> x$18.name(), ClassTag$.MODULE$.apply(String.class))), ClassTag$.MODULE$.apply(String.class))), ConfigDef.Importance.LOW, this.LinkModeDoc()).define(this.ConnectionModeProp(), ConfigDef.Type.STRING, null, ConfigDef.ValidString.in((String[])((IterableOnceOps)((SeqOps)ConnectionMode$.MODULE$.values().map((Function1<Product, String> & Serializable)x$19 -> ((ConnectionMode)((Object)x$19)).name())).$colon$plus(null)).toArray(ClassTag$.MODULE$.apply(String.class))), ConfigDef.Importance.LOW, this.ConnectionModeDoc()).define(this.LocalListenerNameProp(), ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, this.LocalListenerNameDoc()).define(this.ReverseConnectionSetupTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.ReverseConnectionSetupTimeoutMs()), ConfigDef.Range.between(Predef$.MODULE$.int2Integer(1000), Predef$.MODULE$.int2Integer(Integer.MAX_VALUE)), ConfigDef.Importance.LOW, this.ReverseConnectionSetupTimeoutMsDoc()).define(this.NumClusterLinkFetchersProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.NumClusterLinkFetchers()), ConfigDef.Importance.LOW, this.NumClusterLinkFetchersDoc()).define(this.FetcherThreadPoolModeProp(), ConfigDef.Type.STRING, ClusterLinkConfigDefaults$.MODULE$.FetcherThreadPoolModeDefault().name(), ConfigDef.Importance.LOW, this.FetcherThreadPoolModeDoc()).define(this.ClusterLinkPausedProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean(false), ConfigDef.Importance.LOW, this.ClusterLinkPausedDoc()).define(this.ClusterLinkPrefixProp(), ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, this.ClusterLinkPrefixDoc()).define(this.ConsumerOffsetSyncEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean(false), ConfigDef.Importance.LOW, this.ConsumerOffsetSyncEnableDoc()).define(this.ConsumerGroupPrefixEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean(ClusterLinkConfigDefaults$.MODULE$.ConsumerGroupPrefixEnableDefault()), ConfigDef.Importance.LOW, this.ConsumerGroupPrefixEnableDoc()).define(this.ConsumerOffsetSyncMsProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.OffsetSyncMsDefault()), ConfigDef.Importance.LOW, this.ConsumerOffsetSyncMsDoc()).define(this.ConsumerOffsetGroupFiltersProp(), ConfigDef.Type.STRING, (Object)"", ClusterLinkFilterJson$.MODULE$.GROUP_VALIDATOR(), ConfigDef.Importance.LOW, this.ConsumerOffsetGroupFiltersDoc()).define(this.RetryTimeoutMsProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.RetryTimeoutMs()), ConfigDef.Importance.MEDIUM, this.RetryTimeoutMsDoc()).define(this.AclSyncEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean(false), ConfigDef.Importance.LOW, this.AclSyncEnableDoc()).define(this.AclFiltersProp(), ConfigDef.Type.STRING, (Object)"", AclJson$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, this.AclFiltersDoc()).define(this.AclSyncMsProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.AclSyncMsDefault()), ConfigDef.Importance.LOW, this.AclSyncMsDoc()).define(this.TopicConfigSyncIncludeProp(), ConfigDef.Type.LIST, ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault(), TopicConfigSyncIncludeValidator$.MODULE$.ConfigDefValidator(), ConfigDef.Importance.LOW, this.TopicConfigSyncIncludeDoc()).define(this.TopicConfigSyncMsProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncMsDefault()), ConfigDef.Importance.LOW, this.TopicConfigSyncMsDoc()).define(this.AutoMirroringEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean(false), ConfigDef.Importance.LOW, this.AutoMirroringEnableDoc()).define(this.TopicFiltersProp(), ConfigDef.Type.STRING, (Object)"", ClusterLinkFilterJson$.MODULE$.TOPIC_VALIDATOR(), ConfigDef.Importance.LOW, this.TopicFiltersDoc()).define(this.MirrorStartOffsetSpecProp(), ConfigDef.Type.STRING, ClusterLinkConfigDefaults$.MODULE$.MirrorStartOffsetSpec(), ConfigDef.Importance.LOW, this.MirrorStartOffsetSpecDoc()).define(this.MaxMessageSizeProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(this.MaxMessageSizeUnlimited()), ConfigDef.Importance.LOW, this.MaxMessageSizeDoc()).define(this.AvailabilityCheckMsProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckMsDefault()), ConfigDef.Importance.LOW, this.AvailabilityCheckMsDoc()).define(this.AvailabilityCheckConsecutiveFailureThresholdProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdDefault()), ConfigDef.Importance.LOW, this.AvailabilityCheckConsecutiveFailureThresholdProp()).define("bootstrap.servers", ConfigDef.Type.LIST, Collections.emptyList(), new ConfigDef.NonNullValidator(), ConfigDef.Importance.HIGH, "A list of host/port pairs used to establish the initial connection to the Kafka cluster. Clients use this list to bootstrap and discover the full set of Kafka brokers. While the order of servers in the list does not matter, we recommend including more than one server to ensure resilience if any servers are down. This list does not need to contain the entire set of brokers, as Kafka clients automatically manage and update connections to the cluster efficiently. This list must be in the form <code>host1:port1,host2:port2,...</code>.").defineInternal(this.BootstrapServersOverrideProp(), ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, this.BootstrapServersOverrideDoc()).define("client.dns.lookup", ConfigDef.Type.STRING, (Object)ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ConfigDef.ValidString.in(ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()), ConfigDef.Importance.MEDIUM, "Controls how the client uses DNS lookups. If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established. After a disconnection, the next IP is used. Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however). If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names. After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.").define("security.protocol", ConfigDef.Type.STRING, "PLAINTEXT", ConfigDef.Importance.MEDIUM, "Protocol used to communicate with brokers.").define("replica.socket.timeout.ms", ConfigDef.Type.INT, BoxesRunTime.boxToInteger(30000), ConfigDef.Importance.LOW, "replica.socket.timeout.ms").define("request.timeout.ms", ConfigDef.Type.INT, BoxesRunTime.boxToInteger(30000), ConfigDef.Importance.LOW, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").define("connections.max.idle.ms", ConfigDef.Type.LONG, BoxesRunTime.boxToLong(ClusterLinkConfigDefaults$.MODULE$.ConnectionsMaxIdleMs()), ConfigDef.Importance.LOW, "Idle connections timeout: the server socket processor threads close the connections that idle more than this").define("socket.connection.setup.timeout.ms", ConfigDef.Type.LONG, BoxesRunTime.boxToLong(ServerConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS), ConfigDef.Importance.LOW, "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>socket.connection.setup.timeout.max.ms</code> value.").define("socket.connection.setup.timeout.max.ms", ConfigDef.Type.LONG, BoxesRunTime.boxToLong(ServerConfigs.SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS), ConfigDef.Importance.LOW, "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>socket.connection.setup.timeout.max.ms</code> value.").define("replica.socket.receive.buffer.bytes", ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.ReplicaSocketReceiveBufferBytes()), ConfigDef.Importance.LOW, this.ReplicaSocketReceiveBufferBytesDoc()).define("replica.fetch.max.bytes", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchMaxBytes()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The number of bytes of messages to attempt to fetch for each partition. This is not an absolute maximum, if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).").define("replica.fetch.wait.max.ms", ConfigDef.Type.INT, BoxesRunTime.boxToInteger(500), ConfigDef.Importance.LOW, "The maximum wait time for each fetcher request issued by follower replicas. This value should always be less than the replica.lag.time.max.ms at all times to prevent frequent shrinking of ISR for low throughput topics").define("replica.fetch.backoff.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger(1000), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The base amount of time to wait when fetch partition error occurs. The backoff increases exponentially for each consecutive failure up to replica.fetch.backoff.ms").define("confluent.replica.fetch.backoff.max.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger(1000), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, "The maximum amount of time in milliseconds to wait when fetch partition fails repeatedly. If provided, the backoff will increase exponentially for each consecutive failure, up to this maximum.").define("replica.fetch.min.bytes", ConfigDef.Type.INT, BoxesRunTime.boxToInteger(1), ConfigDef.Importance.LOW, "Minimum bytes expected for each fetch response. If not enough bytes, wait up to <code>replica.fetch.wait.max.ms</code> (broker config).").define("replica.fetch.response.max.bytes", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchResponseMaxBytes()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "Maximum bytes expected for the entire fetch response. Records are fetched in batches, and if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. As such, this is not an absolute maximum. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).").define("retry.backoff.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong(ClusterLinkConfigDefaults$.MODULE$.RetryBackoffMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios. This value is the initial backoff value and will increase exponentially for each failed request, up to the <code>retry.backoff.max.ms</code> value.").define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong(ClusterLinkConfigDefaults$.MODULE$.ReconnectBackoffMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>reconnect.backoff.max.ms</code> value.").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong(ClusterLinkConfigDefaults$.MODULE$.ReconnectBackoffMaxMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.").define("metadata.max.age.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.MetadataMaxAgeMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.").define("metadata.recovery.strategy", ConfigDef.Type.STRING, (Object)ClusterLinkConfigDefaults$.MODULE$.MetadataRecoveryStrategyDefault().name, ConfigDef.CaseInsensitiveValidString.in(MetadataRecoveryStrategy.REBOOTSTRAP.name, MetadataRecoveryStrategy.NONE.name), ConfigDef.Importance.LOW, "Controls how the client recovers when none of the brokers known to it is available. If set to <code>none</code>, the client fails. If set to <code>rebootstrap</code>, the client repeats the bootstrap process using <code>bootstrap.servers</code>. Rebootstrapping is useful when a client communicates with brokers so infrequently that the set of brokers may change entirely before the client refreshes metadata. Metadata recovery is triggered when all last-known brokers appear unavailable simultaneously. Brokers appear unavailable when disconnected and no current retry attempt is in-progress. Consider increasing <code>reconnect.backoff.ms</code> and <code>reconnect.backoff.max.ms</code> and decreasing <code>socket.connection.setup.timeout.ms</code> and <code>socket.connection.setup.timeout.max.ms</code> for the client. Rebootstrap is also triggered if connection cannot be established to any of the brokers for <code>metadata.recovery.rebootstrap.trigger.ms</code> milliseconds or if server requests rebootstrap.").define("default.api.timeout.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.DefaultApiTimeoutMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "Specifies the timeout (in milliseconds) for client APIs. This configuration is used as the default timeout for all client operations that do not specify a <code>timeout</code> parameter.").define(this.LinkFetcherMaxLaggingPartitionsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.LinkFetcherMaxLaggingPartitions()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(-1)), ConfigDef.Importance.LOW, this.LinkFetcherMaxLaggingPartitionsDoc()).define(this.LinkFetcherLaggingPartitionMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.LinkFetcherLaggingPartitionMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherLaggingPartitionMsDoc()).define(this.LinkFetcherEnforceMaxLaggingPartitionMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.LinkFetcherEnforceMaxLaggingPartitionMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherEnforceMaxLaggingPartitionMsDoc()).define(this.AllowTruncationBelowHWMProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean(ClusterLinkConfigDefaults$.MODULE$.AllowTruncationBelowHWM()), ConfigDef.Importance.LOW, this.AllowTruncationBelowHWMDoc()).define(this.LinkFetcherFlowControlProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.LinkFetcherFlowControl()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(-2)), ConfigDef.Importance.LOW, this.LinkFetcherFlowControlDoc()).defineInternal(this.LinkFetcherDegradedPartitionMonitorMsProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.LinkFetcherDegradedPartitionMonitorMs()), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherDegradedPartitionMonitorMsDoc()).defineInternal(this.RemoteLinkConnectionModeProp(), ConfigDef.Type.STRING, null, ConfigDef.ValidString.in((String[])((IterableOnceOps)((SeqOps)ConnectionMode$.MODULE$.values().map((Function1<Product, String> & Serializable)x$20 -> ((ConnectionMode)((Object)x$20)).name())).$colon$plus(null)).toArray(ClassTag$.MODULE$.apply(String.class))), ConfigDef.Importance.LOW, this.RemoteLinkConnectionModeDoc()).defineInternal("confluent.replica.fetch.connections.mode", ConfigDef.Type.STRING, FetchConnectionsMode$Combined$.MODULE$.value(), ConfigDef.ValidString.in(FetchConnectionsMode$.MODULE$.validValues()), ConfigDef.Importance.LOW, "Mode of how replicas are distributed among fetcher threads. <code>combined</code>: replicas will be added to default fetcher threads and no extra in-sync fetcher threads will be created. Fetch request connections will have combined in-sync and out-of-sync replicas.<code>isolated</code>: replicas will be added to default fetcher threads initially. When a replica becomes in-sync, it will be migrated to a new in-sync fetcher thread thus not blocked by out-of-sync replicas in a fetch request.").defineInternal(this.ClientsMaxIdleMsProp(), ConfigDef.Type.LONG, ClusterLinkConfigDefaults$.MODULE$.ClientsMaxIdleMs(), ConfigDef.Range.atLeast(Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.LOW, this.ClientsMaxIdleMsDoc()).defineInternal(this.LinkFetcherAutoTuneEnableProp(), ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean(ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneEnable()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneEnableDoc()).defineInternal(this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneDecreaseThroughputThresholdBytes()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc()).defineInternal(this.LinkFetcherAutoTuneIncreaseThroughputPercentageProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneIncreaseThroughputPercentage()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneIncreaseThroughputPercentageDoc()).defineInternal(this.LinkFetcherAutoTuneMaxConnectionPercentageProp(), ConfigDef.Type.INT, BoxesRunTime.boxToInteger(ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneMaxConnectionPercentage()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneMaxConnectionPercentageDoc()).defineInternal("confluent.client.switchover.disable", ConfigDef.Type.BOOLEAN, BoxesRunTime.boxToBoolean(true), ConfigDef.Importance.LOW, "Client configuration option that specifies if switchover should be disabled for the client even if switchover is enabled on the broker. This is an internal config used to disable client switchover in internal clients.").withClientSslSupport().withClientSaslSupport();
        return this.addLocalClientSecurityConfigs(configDef);
    }

    private ConfigDef addLocalClientSecurityConfigs(ConfigDef configDef) {
        String localDoc = "This security configuration with '" + this.LocalPrefix() + "' prefix is applied to clients connecting locally to the source cluster of a source initiated link.";
        ObjectRef<ConfigDef> newConfigDef = ObjectRef.create(configDef.define(this.LocalPrefix() + "security.protocol", ConfigDef.Type.STRING, "PLAINTEXT", ConfigDef.Importance.MEDIUM, "Protocol used to communicate with brokers." + localDoc));
        ConfigDef clientSecurityConfigs = new ConfigDef().withClientSslSupport().withClientSaslSupport();
        clientSecurityConfigs.configKeys().forEach((name, key) -> {
            newConfigDef$1.elem = ((ConfigDef)newConfigDef$1.elem).define(MODULE$.LocalPrefix() + name, key.type, key.defaultValue, key.validator, key.importance, key.documentation + " " + localDoc, key.group, key.orderInGroup, key.width, key.displayName, key.dependents, key.recommender);
        });
        return (ConfigDef)newConfigDef.elem;
    }

    public Seq<String> configNames() {
        return (Seq)CollectionConverters$.MODULE$.SetHasAsScala(this.configDef().names()).asScala().toSeq().sorted(Ordering.String$.MODULE$);
    }

    public Map<String, ConfigDef.ConfigKey> configKeys() {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.configDef().configKeys()).asScala().toMap($less$colon$less$.MODULE$.refl());
    }

    public Option<ConfigDef.Type> configType(String name) {
        return Option$.MODULE$.apply(this.configDef().configKeys().get(name)).map((Function1<ConfigDef.ConfigKey, ConfigDef.Type> & Serializable)x$21 -> x$21.type);
    }

    public ConfigDef configDefCopy() {
        return new ConfigDef(this.configDef());
    }

    public ClusterLinkConfig create(java.util.Map<?, ?> props, Option<KafkaConfig> brokerConfig, boolean validate) {
        ClusterLinkConfig clusterLinkConfig;
        try {
            Properties properties;
            ConnectionMode connectionMode;
            ClusterLinkConfig.LinkMode linkMode = (ClusterLinkConfig.LinkMode)((Object)Option$.MODULE$.apply(props.get(this.LinkModeProp())).map((Function1<Object, ClusterLinkConfig.LinkMode> & Serializable)m -> ClusterLinkConfig.LinkMode.fromString(m.toString())).getOrElse((Function0<ClusterLinkConfig.LinkMode> & Serializable)() -> ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault()));
            ConnectionMode connectionMode2 = connectionMode = props.containsKey(this.ConnectionModeProp()) ? ConnectionMode$.MODULE$.fromString(props.get(this.ConnectionModeProp()).toString()) : this.defaultConnectionMode(linkMode);
            ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
            if (!(connectionMode2 != null ? !connectionMode2.equals(connectionMode$Inbound$) : connectionMode$Inbound$ != null) && linkMode.mayActAsDestination()) {
                Properties newProps = new Properties();
                props.forEach((k, v) -> newProps.setProperty(k.toString(), v.toString()));
                newProps.setProperty("bootstrap.servers", "localhost:0");
                properties = newProps;
            } else {
                properties = props;
            }
            Properties configProps = properties;
            clusterLinkConfig = new ClusterLinkConfig(configProps, brokerConfig, validate);
        }
        catch (InvalidConfigurationException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw new InvalidConfigurationException("Invalid cluster link configs: " + e);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Invalid cluster link configs: " + e, e);
        }
        return clusterLinkConfig;
    }

    public boolean create$default$3() {
        return true;
    }

    public ClusterLinkConfig configsWithOverrides(ClusterLinkConfig clusterLinkConfig, java.util.Map<String, Object> configOverrides) {
        java.util.Map<String, Object> originalsCopy = clusterLinkConfig.originals();
        originalsCopy.putAll(configOverrides);
        return new ClusterLinkConfig(originalsCopy, clusterLinkConfig.brokerConfig(), false);
    }

    public void kafka$server$link$ClusterLinkConfig$$validateClusterLinkPrefix(String clusterLinkPrefix) {
        int maxLength = 12;
        if (clusterLinkPrefix.length() > maxLength) {
            throw new InvalidConfigurationException("Cluster link prefix exceeds maximum size of '" + maxLength + "' characters");
        }
        if (!Topic.containsValidPattern(clusterLinkPrefix)) {
            throw new InvalidConfigurationException("Cluster link prefix '" + clusterLinkPrefix + "' is illegal, valid characters: [a-zA-Z0-9._-]");
        }
    }

    public ConnectionMode defaultConnectionMode(ClusterLinkConfig.LinkMode linkMode) {
        if (linkMode.mayActAsDestination()) {
            return ConnectionMode$Outbound$.MODULE$;
        }
        return ConnectionMode$Inbound$.MODULE$;
    }

    private ClusterLinkConfig.LinkMode clusterLinkMode(java.util.Map<String, String> configs) {
        return (ClusterLinkConfig.LinkMode)((Object)Option$.MODULE$.apply(configs.get(this.LinkModeProp())).map((Function1<String, ClusterLinkConfig.LinkMode> & Serializable)linkModeStr -> ClusterLinkConfig.LinkMode.fromString(linkModeStr)).getOrElse((Function0<ClusterLinkConfig.LinkMode> & Serializable)() -> ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault()));
    }

    public ConnectionMode clusterLinkConnectionMode(java.util.Map<String, String> configs) {
        return (ConnectionMode)Option$.MODULE$.apply(configs.get(this.ConnectionModeProp())).map((Function1<String, ConnectionMode> & Serializable)mode -> ConnectionMode$.MODULE$.fromString((String)mode)).getOrElse((Function0<ConnectionMode> & Serializable)() -> MODULE$.defaultConnectionMode(MODULE$.clusterLinkMode(configs)));
    }

    public OffsetSpec offsetSpecFromString(String offsetSpecValue) {
        OffsetSpec offsetSpec;
        if (offsetSpecValue == null || offsetSpecValue.equalsIgnoreCase("earliest")) {
            return OffsetSpec.earliest();
        }
        if (offsetSpecValue.equalsIgnoreCase("latest")) {
            return OffsetSpec.latest();
        }
        try {
            offsetSpec = OffsetSpec.forTimestamp(Utils.getDateTime(offsetSpecValue));
        }
        catch (Throwable e) {
            throw new InvalidConfigurationException("Invalid config value " + this.MirrorStartOffsetSpecProp() + "=" + offsetSpecValue + " : " + e, e);
        }
        return offsetSpec;
    }

    private ClusterLinkConfig$() {
    }
}

