/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import kafka.server.link.AuthenticationErrorUnavailableLinkReason;
import kafka.server.link.BootstrapTcpConnectionFailedUnavailableLinkReason;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason;
import kafka.server.link.LinkType;
import kafka.server.link.LinkType$Cloud$;
import kafka.server.link.TimeoutUnavailableLinkReason;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnknownUnavailableLinkReason;
import kafka.server.link.UnresolvableBootstrapUnavailableLinkReason;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkConnectionChecker$
implements Logging {
    public static final ClusterLinkConnectionChecker$ MODULE$ = new ClusterLinkConnectionChecker$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkConnectionChecker$ clusterLinkConnectionChecker$ = this;
        synchronized (clusterLinkConnectionChecker$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Option<ClusterLinkConnectionCheckerResult> check(DescribeClusterResult describeClusterResult, ClusterLinkConfig config, Option<ClusterLinkFactory.LinkMetrics> linkMetrics, boolean connectionToRemoteCluster, Function0<Object> intranetConnectivityDeniedChecker, Option<String> tenantPrefix) {
        Option<ClusterLinkConnectionCheckerResult> option;
        block5: {
            KafkaFuture<String> future = describeClusterResult.clusterId();
            try {
                future.get();
                option = Option$.MODULE$.empty();
            }
            catch (Throwable ex) {
                ApiException apiException = ClusterLinkUtils$.MODULE$.apiException(ex, "Basic describeCluster check failed");
                this.warn((Function0<String> & Serializable)() -> "Failed to contact remote cluster with exception " + ex + " and api exception " + apiException);
                if (apiException instanceof AuthenticationException) {
                    option = Option$.MODULE$.apply(new ClusterLinkConnectionCheckerResult(ex, new AuthenticationErrorUnavailableLinkReason(config)));
                    break block5;
                }
                if (apiException instanceof AuthorizationException) {
                    option = Option$.MODULE$.apply(new ClusterLinkConnectionCheckerResult(ex, new InvalidBootstrapInternalEndpointUnavailableLinkReason(config)));
                    break block5;
                }
                UnavailableLinkReason reason = this.checkBasicNetworking(config, intranetConnectivityDeniedChecker, tenantPrefix);
                ClusterLinkError clusterLinkError = reason.clusterLinkError();
                ClusterLinkError clusterLinkError2 = ClusterLinkError.UNKNOWN;
                if (!(clusterLinkError != null ? !((Object)((Object)clusterLinkError)).equals((Object)clusterLinkError2) : clusterLinkError2 != null) && apiException instanceof TimeoutException) {
                    option = this.isSecuritySettingsMissingForCloudLink(config, linkMetrics, connectionToRemoteCluster) ? Option$.MODULE$.apply(new ClusterLinkConnectionCheckerResult(ex, new AuthenticationErrorUnavailableLinkReason(config))) : Option$.MODULE$.apply(new ClusterLinkConnectionCheckerResult(ex, new TimeoutUnavailableLinkReason(config)));
                    break block5;
                }
                option = Option$.MODULE$.apply(new ClusterLinkConnectionCheckerResult(ex, reason));
            }
        }
        return option;
    }

    public DescribeClusterResult doBasicDescribeCluster(ClusterLinkBatchAdmin admin) {
        return admin.describeCluster();
    }

    public boolean isSecuritySettingsMissingForCloudLink(ClusterLinkConfig config, Option<ClusterLinkFactory.LinkMetrics> linkMetrics, boolean connectionToRemoteCluster) {
        boolean isCloudLink;
        Some some;
        ClusterLinkFactory.LinkMetrics clusterLinkMetrics;
        Option<ClusterLinkFactory.LinkMetrics> option = linkMetrics;
        if (option instanceof Some && (clusterLinkMetrics = (ClusterLinkFactory.LinkMetrics)(some = (Some)option).value()) instanceof ClusterLinkMetrics) {
            ClusterLinkMetrics clusterLinkMetrics2 = (ClusterLinkMetrics)clusterLinkMetrics;
            LinkType linkType = clusterLinkMetrics2.linkType();
            LinkType$Cloud$ linkType$Cloud$ = LinkType$Cloud$.MODULE$;
            v1 = !(linkType != null ? !linkType.equals(linkType$Cloud$) : linkType$Cloud$ != null);
        } else {
            v1 = isCloudLink = false;
        }
        return isCloudLink && connectionToRemoteCluster && (this.isSecurityConfigNull(config, "security.protocol", this.isSecurityConfigNull$default$3()) || this.isSecurityConfigNull(config, "sasl.mechanism", this.isSecurityConfigNull$default$3()) || this.isSecurityConfigNull(config, "sasl.jaas.config", true));
    }

    private boolean isSecurityConfigNull(ClusterLinkConfig config, String securityConfig, boolean isPasswordConfig) {
        boolean configIsNull;
        boolean bl = configIsNull = securityConfig == null;
        if (!configIsNull) {
            String configValue;
            String string = configValue = isPasswordConfig ? config.getPassword(securityConfig).value() : config.getString(securityConfig);
            String string2 = "null";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        return configIsNull;
    }

    private boolean isSecurityConfigNull$default$3() {
        return false;
    }

    private UnavailableLinkReason checkBasicNetworking(ClusterLinkConfig config, Function0<Object> intranetConnectivityDeniedChecker, Option<String> tenantPrefix) {
        Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>> tuple2 = this.checkAddresses(config, intranetConnectivityDeniedChecker, tenantPrefix);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option<UnavailableLinkReason> dnsErr = tuple2._1();
        List<InetSocketAddress> validatedAddresses = tuple2._2();
        Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>> tuple22 = new Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>>(dnsErr, validatedAddresses);
        Option<UnavailableLinkReason> dnsErr2 = tuple22._1();
        List<InetSocketAddress> validatedAddresses2 = tuple22._2();
        return (UnavailableLinkReason)dnsErr2.getOrElse((Function0<UnavailableLinkReason> & Serializable)() -> (UnavailableLinkReason)MODULE$.checkTcpConnection(validatedAddresses2, config).getOrElse((Function0<UnknownUnavailableLinkReason> & Serializable)() -> new UnknownUnavailableLinkReason(config)));
    }

    public Option<UnavailableLinkReason> checkTcpConnection(List<InetSocketAddress> validatedAddresses, ClusterLinkConfig config) {
        Option option;
        try {
            this.tryTcpConnectionToBootstrapServers(validatedAddresses);
            option = None$.MODULE$;
        }
        catch (ConnectException ex) {
            this.warn((Function0<String> & Serializable)() -> "Failed to connect to endpoint " + ex);
            option = Option$.MODULE$.apply(new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (SocketTimeoutException ex) {
            this.warn((Function0<String> & Serializable)() -> "Failed to connect to endpoint " + ex);
            option = Option$.MODULE$.apply(new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (BindException ex) {
            this.warn((Function0<String> & Serializable)() -> "Failed to bind to endpoint " + ex);
            option = Option$.MODULE$.apply(new BootstrapTcpConnectionFailedUnavailableLinkReason(config));
        }
        catch (Throwable ex) {
            this.warn((Function0<String> & Serializable)() -> "Failed to connect to endpoint with unknown exception " + ex);
            option = Option$.MODULE$.apply(new UnknownUnavailableLinkReason(config));
        }
        return option;
    }

    public Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>> checkAddresses(ClusterLinkConfig config, Function0<Object> intranetConnectivityDeniedChecker, Option<String> tenantPrefix) {
        List<InetSocketAddress> list;
        List<String> bootstrapServers = config.bootstrapServersToConnect(intranetConnectivityDeniedChecker);
        this.debug((Function0<String> & Serializable)() -> "Bootstrap servers to connect are " + bootstrapServers);
        String dnsLookupConfig = config.getString("client.dns.lookup");
        ClientDnsLookup dnsLookup = dnsLookupConfig == null ? ClientDnsLookup.USE_ALL_DNS_IPS : ClientDnsLookup.forConfig(dnsLookupConfig);
        ArrayList invalidAddresses = new ArrayList();
        try {
            list = ClientUtils.parseAndValidateAddresses(bootstrapServers, dnsLookup);
        }
        catch (ConfigException ex) {
            this.warn((Function0<String> & Serializable)() -> "Failed to validate DNS " + ex);
            return new Tuple2<Option<UnresolvableBootstrapUnavailableLinkReason>, Object>(Option$.MODULE$.apply(new UnresolvableBootstrapUnavailableLinkReason(config)), null);
        }
        catch (Throwable ex) {
            this.warn((Function0<String> & Serializable)() -> "Failed to validate DNS with an unknown exception " + ex);
            return new Tuple2<Option<UnknownUnavailableLinkReason>, Object>(Option$.MODULE$.apply(new UnknownUnavailableLinkReason(config)), null);
        }
        List<InetSocketAddress> validatedAddresses = list;
        CollectionConverters$.MODULE$.ListHasAsScala(validatedAddresses).asScala().foreach((Function1<InetSocketAddress, Object> & Serializable)inetSocketAddress -> {
            if (tenantPrefix.isDefined() && ClusterLinkUtils$.MODULE$.isInternalNetworkOrPort((InetSocketAddress)inetSocketAddress)) {
                return BoxesRunTime.boxToBoolean(invalidAddresses.add(inetSocketAddress));
            }
            return BoxedUnit.UNIT;
        });
        if (!invalidAddresses.isEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Invalid bootstrap addresses or ports that cannot be used for cluster links on Confluent Cloud: " + invalidAddresses);
            return new Tuple2<Option<InvalidBootstrapInternalEndpointUnavailableLinkReason>, Object>(Option$.MODULE$.apply(new InvalidBootstrapInternalEndpointUnavailableLinkReason(config)), null);
        }
        return new Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>>(None$.MODULE$, validatedAddresses);
    }

    private void tryTcpConnectionToBootstrapServers(List<InetSocketAddress> validatedAddresses) {
        CollectionConverters$.MODULE$.ListHasAsScala(validatedAddresses).asScala().withFilter((Function1<InetSocketAddress, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(ClusterLinkConnectionChecker$.$anonfun$tryTcpConnectionToBootstrapServers$1(check$ifrefutable$1))).foreach((Function1<InetSocketAddress, Object> & Serializable)endpoint -> {
            ClusterLinkConnectionChecker$.$anonfun$tryTcpConnectionToBootstrapServers$2(endpoint);
            return BoxedUnit.UNIT;
        });
    }

    public int tcpConnectionTimeoutsMs() {
        return 5000;
    }

    public static final /* synthetic */ boolean $anonfun$tryTcpConnectionToBootstrapServers$1(InetSocketAddress check$ifrefutable$1) {
        InetSocketAddress inetSocketAddress = check$ifrefutable$1;
        return inetSocketAddress != null;
    }

    public static final /* synthetic */ void $anonfun$tryTcpConnectionToBootstrapServers$2(InetSocketAddress endpoint) {
        try (Socket clientSocket = new Socket();){
            clientSocket.connect(endpoint, MODULE$.tcpConnectionTimeoutsMs());
        }
    }

    private ClusterLinkConnectionChecker$() {
    }
}

