/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.BlockingSend;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkAsyncLeaderEndPoint;
import kafka.server.link.ClusterLinkAsyncSender;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFetchThrottleListener;
import kafka.server.link.ClusterLinkFollowerFetchThrottler;
import kafka.server.link.ClusterLinkLeaderEndPoint;
import kafka.server.link.ClusterLinkLeaderRequestBuilder;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkLeaderEndPoint$ {
    public static final ClusterLinkLeaderEndPoint$ MODULE$ = new ClusterLinkLeaderEndPoint$();

    public boolean isReadyForFetchForPartition(Partition partition, ClusterLinkMetrics clusterLinkMetrics, Integer linkFetcherFlowControl, boolean updateLagSensor) {
        boolean lagExceeded;
        if (Predef$.MODULE$.Integer2int(linkFetcherFlowControl) >= 0 && (lagExceeded = partition.leaderLogIfLocal().exists((Function1<AbstractLog, Object> & Serializable)log -> BoxesRunTime.boxToBoolean(ClusterLinkLeaderEndPoint$.$anonfun$isReadyForFetchForPartition$1(linkFetcherFlowControl, log))))) {
            if (updateLagSensor) {
                clusterLinkMetrics.destinationLagLinkFetcherThrottleSensor().record();
            }
            return false;
        }
        if (BoxesRunTime.equalsNumObject(linkFetcherFlowControl, BoxesRunTime.boxToInteger(-2))) {
            return !partition.isUnderReplicated();
        }
        return !partition.isUnderMinIsr();
    }

    public ClusterLinkLeaderEndPoint apply(LogContext logContext, Time time, BlockingSend blockingSender, ClusterLinkNetworkClient clusterLinkClient, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkFetchThrottleListener fetchThrottleListener, ReplicaManager replicaManager, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics) {
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, blockingSender.brokerEndPoint().id());
        ClusterLinkLeaderRequestBuilder requestBuilder = new ClusterLinkLeaderRequestBuilder(clusterLinkConfig, time);
        ClusterLinkFollowerFetchThrottler throttler = new ClusterLinkFollowerFetchThrottler();
        throttler.addThrottleListeners(fetchThrottleListener);
        return new ClusterLinkLeaderEndPoint(logContext.logPrefix(), blockingSender, clusterLinkClient, fetchSessionHandler, requestBuilder, throttler, brokerConfig, clusterLinkConfig, replicaManager, quota, clusterLinkMetrics);
    }

    public ClusterLinkAsyncLeaderEndPoint createAsyncLeaderEndpoint(LogContext logContext, Time time, ClusterLinkAsyncSender asyncSender, ClusterLinkNetworkClient clusterLinkClient, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkFetchThrottleListener fetchThrottleListener, ReplicaManager replicaManager, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics) {
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, asyncSender.brokerEndPoint().id());
        ClusterLinkLeaderRequestBuilder requestBuilder = new ClusterLinkLeaderRequestBuilder(clusterLinkConfig, time);
        ClusterLinkFollowerFetchThrottler throttler = new ClusterLinkFollowerFetchThrottler();
        throttler.addThrottleListeners(fetchThrottleListener);
        return new ClusterLinkAsyncLeaderEndPoint(logContext.logPrefix(), asyncSender, clusterLinkClient, fetchSessionHandler, requestBuilder, (FollowerThrottler)throttler, brokerConfig, clusterLinkConfig, replicaManager, quota, clusterLinkMetrics);
    }

    public static final /* synthetic */ boolean $anonfun$isReadyForFetchForPartition$1(Integer linkFetcherFlowControl$1, AbstractLog log) {
        return log.logEndOffset() - log.highWatermark() > (long)Predef$.MODULE$.Integer2int(linkFetcherFlowControl$1);
    }

    private ClusterLinkLeaderEndPoint$() {
    }
}

