/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.RequestChannel;
import kafka.server.KafkaConfig;
import kafka.server.RequestHandlerHelper;
import kafka.server.SwitchoverPair;
import kafka.server.SwitchoverState;
import kafka.server.SwitchoverState$;
import kafka.server.SwitchoverState$Ignore$;
import kafka.server.SwitchoverState$Primary$;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkInfo;
import kafka.server.link.ClusterLinkSwitchoverManager$;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.security.authorizer.AclEntry;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tea\u0001B\u0015+\u0001EB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\")q\u000b\u0001C\u00011\"9A\f\u0001b\u0001\n\u0013i\u0006BB6\u0001A\u0003%a\fC\u0004m\u0001\t\u0007I\u0011B7\t\rI\u0004\u0001\u0015!\u0003o\u0011\u001d\u0019\bA1A\u0005\nQDa! \u0001!\u0002\u0013)\bb\u0002@\u0001\u0001\u0004%I\u0001\u001e\u0005\t\u007f\u0002\u0001\r\u0011\"\u0003\u0002\u0002!9\u0011Q\u0002\u0001!B\u0013)\b\"CA\f\u0001\u0001\u0007I\u0011BA\r\u0011%\tY\u0004\u0001a\u0001\n\u0013\ti\u0004\u0003\u0005\u0002B\u0001\u0001\u000b\u0015BA\u000e\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002v\u0001!\t%a\u001e\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAE\u0001\u0011%\u00111\u0012\u0005\b\u00037\u0003A\u0011BAO\u0011\u001d\t9\u000b\u0001C\u0005\u0003SCq!a,\u0001\t\u0013\t\tlB\u0004\u0002B*B\t!a1\u0007\r%R\u0003\u0012AAc\u0011\u00199&\u0004\"\u0001\u0002H\"I\u0011\u0011\u001a\u000eC\u0002\u0013\u0005\u00111\u001a\u0005\t\u0003'T\u0002\u0015!\u0003\u0002N\"9\u0011Q\u001b\u000e\u0005\u0002\u0005]gABAn5\u0011\ti\u000eC\u0005\u0002\b~\u0011\t\u0011)A\u0005\u000f\"Q\u0011q\\\u0010\u0003\u0002\u0003\u0006I!!\u0014\t\r]{B\u0011AAq\u0011%\tYo\bb\u0001\n\u0013\ti\u000f\u0003\u0005\u0002z~\u0001\u000b\u0011BAx\u0011\u0019aw\u0004\"\u0001\u0002|\"9!\u0011A\u0010\u0005\u0002\t\r\u0001b\u0002B\u0005?\u0011%!1\u0002\u0005\b\u0005#yB\u0011\u0002B\n\u0005q\u0019E.^:uKJd\u0015N\\6To&$8\r[8wKJl\u0015M\\1hKJT!a\u000b\u0017\u0002\t1Lgn\u001b\u0006\u0003[9\naa]3sm\u0016\u0014(\"A\u0018\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\r\u001dA!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0019\te.\u001f*fMB\u0011\u0011(\u0010\b\u0003umj\u0011AK\u0005\u0003y)\n!c\u00117vgR,'\u000fT5oW\u001a\u000b7\r^8ss&\u0011ah\u0010\u0002\u0012'^LGo\u00195pm\u0016\u0014X*\u00198bO\u0016\u0014(B\u0001\u001f+!\t\tE)D\u0001C\u0015\t\u0019e&A\u0003vi&d7/\u0003\u0002F\u0005\n9Aj\\4hS:<\u0017\u0001\u00042s_.,'oQ8oM&<\u0007C\u0001%J\u001b\u0005a\u0013B\u0001&-\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001d1|7-\u00197DYV\u001cH/\u001a:JIB\u0011Q\n\u0016\b\u0003\u001dJ\u0003\"a\u0014\u001b\u000e\u0003AS!!\u0015\u0019\u0002\rq\u0012xn\u001c;?\u0013\t\u0019F'\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u0013aa\u0015;sS:<'BA*5\u0003\u0019a\u0014N\\5u}Q\u0019\u0011LW.\u0011\u0005i\u0002\u0001\"\u0002$\u0004\u0001\u00049\u0005\"B&\u0004\u0001\u0004a\u0015aD:xSR\u001c\u0007n\u001c<fe2Kgn[:\u0016\u0003y\u0003Ba\u00184MQ6\t\u0001M\u0003\u0002bE\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\r$\u0017\u0001B;uS2T\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hA\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005iJ\u0017B\u00016+\u0005=\u0019E.^:uKJd\u0015N\\6J]\u001a|\u0017\u0001E:xSR\u001c\u0007n\u001c<fe2Kgn[:!\u0003=\u0019x/\u001b;dQ>4XM\u001d)bSJ\u001cX#\u00018\u0011\t}3Gj\u001c\t\u0003\u0011BL!!\u001d\u0017\u0003\u001dM;\u0018\u000e^2i_Z,'\u000fU1je\u0006\u00012o^5uG\"|g/\u001a:QC&\u00148\u000fI\u0001\u001cG>tGO]8m!2\fg.Z*xSR\u001c\u0007n\u001c<feB\u000b\u0017N]:\u0016\u0003U\u00042A^>p\u001b\u00059(B\u0001=z\u0003%IW.\\;uC\ndWM\u0003\u0002{i\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005q<(aA*fi\u0006a2m\u001c8ue>d\u0007\u000b\\1oKN;\u0018\u000e^2i_Z,'\u000fU1jeN\u0004\u0013!G8wKJ\u0014\u0018\u000e\u001a3f]N;\u0018\u000e^2i_Z,'\u000fU1jeN\fQd\u001c<feJLG\rZ3o'^LGo\u00195pm\u0016\u0014\b+Y5sg~#S-\u001d\u000b\u0005\u0003\u0007\tI\u0001E\u00024\u0003\u000bI1!a\u00025\u0005\u0011)f.\u001b;\t\u0011\u0005-1\"!AA\u0002U\f1\u0001\u001f\u00132\u0003iyg/\u001a:sS\u0012$WM\\*xSR\u001c\u0007n\u001c<feB\u000b\u0017N]:!Q\ra\u0011\u0011\u0003\t\u0004g\u0005M\u0011bAA\u000bi\tAao\u001c7bi&dW-\u0001\u000fto&$8\r[8wKJ$\u0015n]1cY\u0016$\u0007K]5oG&\u0004\u0018\r\\:\u0016\u0005\u0005m\u0001\u0003\u0002<|\u0003;\u0001B!a\b\u000285\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0003bkRD'\u0002BA\u0014\u0003S\t\u0001b]3dkJLG/\u001f\u0006\u0005\u0003W\ti#\u0001\u0004d_6lwN\u001c\u0006\u0004_\u0005=\"\u0002BA\u0019\u0003g\ta!\u00199bG\",'BAA\u001b\u0003\ry'oZ\u0005\u0005\u0003s\t\tC\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002AM<\u0018\u000e^2i_Z,'\u000fR5tC\ndW\r\u001a)sS:\u001c\u0017\u000e]1mg~#S-\u001d\u000b\u0005\u0003\u0007\ty\u0004C\u0005\u0002\f9\t\t\u00111\u0001\u0002\u001c\u0005i2o^5uG\"|g/\u001a:ESN\f'\r\\3e!JLgnY5qC2\u001c\b\u0005K\u0002\u0010\u0003#\t!\"\u001b8ji&\fG.\u001b>f)\t\t\u0019!A\u000bnCf\u0014W-\u00138uKJ\u001cW\r\u001d;SKF,Xm\u001d;\u0015\r\u00055\u00131KA6!\r\u0019\u0014qJ\u0005\u0004\u0003#\"$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003+\n\u0002\u0019AA,\u0003\u001d\u0011X-];fgR\u0004B!!\u0017\u0002f9!\u00111LA1\u001b\t\tiFC\u0002\u0002`9\nqA\\3uo>\u00148.\u0003\u0003\u0002d\u0005u\u0013A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003O\nIGA\u0004SKF,Xm\u001d;\u000b\t\u0005\r\u0014Q\f\u0005\b\u0003[\n\u0002\u0019AA8\u00035\u0011X-];fgRDU\r\u001c9feB\u0019\u0001*!\u001d\n\u0007\u0005MDF\u0001\u000bSKF,Xm\u001d;IC:$G.\u001a:IK2\u0004XM]\u0001#kB$\u0017\r^3To&$8\r[8wKJ\u0004\u0016-\u001b:G_J\u001cE.^:uKJd\u0015N\\6\u0015\t\u0005\r\u0011\u0011\u0010\u0005\u0006WI\u0001\r\u0001[\u0001#e\u0016lwN^3To&$8\r[8wKJ\u0004\u0016-\u001b:G_J\u001cE.^:uKJd\u0015N\\6\u0015\t\u0005\r\u0011q\u0010\u0005\u0006WM\u0001\r\u0001[\u0001\u001akB$\u0017\r^3To&$8\r[8wKJ|e/\u001a:sS\u0012,7\u000f\u0006\u0003\u0002N\u0005\u0015\u0005BBAD)\u0001\u0007q)\u0001\u0004d_:4\u0017nZ\u0001\u0019G2LWM\u001c;To&$8\r[8wKJ$\u0015n]1cY\u0016$GCBA'\u0003\u001b\u000b9\nC\u0004\u0002\u0010V\u0001\r!!%\u0002+\u0005,H\u000f[3oi&\u001c\u0017\r^5p]\u000e{g\u000e^3yiB!\u0011qDAJ\u0013\u0011\t)*!\t\u0003+\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u000e{g\u000e^3yi\"9\u0011\u0011T\u000bA\u0002\u0005u\u0011!\u00039sS:\u001c\u0017\u000e]1m\u0003\u0001\u001ax/\u001b;dQ>4XM\u001d)bSJ<\u0016\u000e\u001e5M_\u000e\fGnU3d_:$\u0017M]=\u0015\t\u0005}\u0015Q\u0015\t\u0005g\u0005\u0005v.C\u0002\u0002$R\u0012aa\u00149uS>t\u0007bBAM-\u0001\u0007\u0011QD\u0001\u000fg^LGo\u00195pm\u0016\u0014H*\u001b8l)\u0011\tY+!,\u0011\tM\n\t\u000b\u001b\u0005\b\u00033;\u0002\u0019AA\u000f\u0003uawnY1m\u0003:$'+Z7pi\u0016\u001cv/\u001b;dQ>4XM]*uCR,G\u0003BAZ\u0003\u007f\u0003raMA[\u0003s\u000bI,C\u0002\u00028R\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001%\u0002<&\u0019\u0011Q\u0018\u0017\u0003\u001fM;\u0018\u000e^2i_Z,'o\u0015;bi\u0016DQa\u000b\rA\u0002!\fAd\u00117vgR,'\u000fT5oWN;\u0018\u000e^2i_Z,'/T1oC\u001e,'\u000f\u0005\u0002;5M\u0011!D\r\u000b\u0003\u0003\u0007\fq%T5o\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiZ+'o]5p]\u001a{'OU3c_>$8\u000f\u001e:baV\u0011\u0011Q\u001a\t\u0004g\u0005=\u0017bAAii\t\u0019\u0011J\u001c;\u0002Q5Kg.T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e,feNLwN\u001c$peJ+'m\\8ugR\u0014\u0018\r\u001d\u0011\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tG\u0003BA\u0002\u00033Da!a\"\u001f\u0001\u00049%AG*xSR\u001c\u0007n\u001c<feB\u000b\u0017N]\"p]\u001aLw\rU1sg\u0016\u00148cA\u00103\u0001\u0006Ya-Y5m\u001f:,%O]8s)\u0019\t\u0019/a:\u0002jB\u0019\u0011Q]\u0010\u000e\u0003iAa!a\"#\u0001\u00049\u0005bBApE\u0001\u0007\u0011QJ\u0001\fY&t7NT1nK.+\u00170\u0006\u0002\u0002pB!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002v\u0012\fA\u0001\\1oO&\u0019Q+a=\u0002\u00191Lgn\u001b(b[\u0016\\U-\u001f\u0011\u0015\u0005\u0005u\b\u0003B'\u0002\u0000>L!\u0001 ,\u0002%\u0011L7/\u00192mK\u0012\u0004&/\u001b8dSB\fGn\u001d\u000b\u0005\u0005\u000b\u00119\u0001E\u0003N\u0003\u007f\fi\u0002C\u0004\u0002`\u001a\u0002\r!!\u0014\u0002\u001dM<\u0018\u000e^2i_Z,'\u000fU1jeR!\u0011q\u0014B\u0007\u0011\u0019\u0011ya\na\u0001\u0019\u0006\u00191\u000f\u001e:\u0002\u0015\u0019\f\u0017\u000e\\(s/\u0006\u0014h\u000e\u0006\u0003\u0002\u0004\tU\u0001B\u0002B\fQ\u0001\u0007A*\u0001\u0007feJ|'/T3tg\u0006<W\r")
public class ClusterLinkSwitchoverManager
implements ClusterLinkFactory.SwitchoverManager,
Logging {
    private final KafkaConfig brokerConfig;
    private final String localClusterId;
    private final ConcurrentHashMap<String, ClusterLinkInfo> switchoverLinks;
    private final ConcurrentHashMap<String, SwitchoverPair> switchoverPairs;
    private final Set<SwitchoverPair> controlPlaneSwitchoverPairs;
    private volatile Set<SwitchoverPair> overriddenSwitchoverPairs;
    private volatile Set<KafkaPrincipal> switchoverDisabledPrincipals;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateReconfiguration(KafkaConfig config) {
        ClusterLinkSwitchoverManager$.MODULE$.validateReconfiguration(config);
    }

    public static int MinMetadataRequestVersionForRebootstrap() {
        return ClusterLinkSwitchoverManager$.MODULE$.MinMetadataRequestVersionForRebootstrap();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkSwitchoverManager clusterLinkSwitchoverManager = this;
        synchronized (clusterLinkSwitchoverManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ConcurrentHashMap<String, ClusterLinkInfo> switchoverLinks() {
        return this.switchoverLinks;
    }

    private ConcurrentHashMap<String, SwitchoverPair> switchoverPairs() {
        return this.switchoverPairs;
    }

    private Set<SwitchoverPair> controlPlaneSwitchoverPairs() {
        return this.controlPlaneSwitchoverPairs;
    }

    private Set<SwitchoverPair> overriddenSwitchoverPairs() {
        return this.overriddenSwitchoverPairs;
    }

    private void overriddenSwitchoverPairs_$eq(Set<SwitchoverPair> x$1) {
        this.overriddenSwitchoverPairs = x$1;
    }

    private Set<KafkaPrincipal> switchoverDisabledPrincipals() {
        return this.switchoverDisabledPrincipals;
    }

    private void switchoverDisabledPrincipals_$eq(Set<KafkaPrincipal> x$1) {
        this.switchoverDisabledPrincipals = x$1;
    }

    private void initialize() {
        this.debug((Function0<String> & Serializable)() -> "Created ClusterLinkSwitchoverManager with local cluster id " + $this.localClusterId + " switchoverEnabled? " + $this.brokerConfig.clusterLinkEnableSwitchover());
        this.updateSwitchoverOverrides(this.brokerConfig);
    }

    @Override
    public boolean maybeInterceptRequest(RequestChannel.Request request, RequestHandlerHelper requestHelper) {
        boolean bl;
        block9: {
            this.trace((Function0<String> & Serializable)() -> "maybeInterceptRequest from client " + request$1.context().principal + " clientId=" + request.context().clientId() + " apiKey=" + request.context().apiKey());
            try {
                if (!this.brokerConfig.clusterLinkEnableSwitchoverForListener(request.context().listenerName) || this.clientSwitchoverDisabled(request.context().authenticationContext, request.context().principal) || this.switchoverLink(request.context().principal).isEmpty()) {
                    return false;
                }
                ApiKeys apiKeys = request.context().apiKey();
                if (((Object)((Object)ApiKeys.API_VERSIONS)).equals((Object)apiKeys)) {
                    bl = false;
                    break block9;
                }
                if (((Object)((Object)ApiKeys.METADATA)).equals((Object)apiKeys) && request.context().apiVersion() >= ClusterLinkSwitchoverManager$.MODULE$.MinMetadataRequestVersionForRebootstrap()) {
                    Option<SwitchoverPair> option = this.switchoverPairWithLocalSecondary(request.context().principal);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        SwitchoverPair switchoverPair = (SwitchoverPair)some.value();
                        this.debug((Function0<String> & Serializable)() -> "Requesting rebootstrap to route client to the remote cluster " + switchoverPair.primaryClusterId() + " for client principal=" + request$1.context().principal + " clientId=" + request.context().clientId() + " since local cluster " + switchoverPair.secondaryClusterId() + " is no longer the primary.");
                        requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse> & Serializable)throttleTimeMs -> ClusterLinkSwitchoverManager.$anonfun$maybeInterceptRequest$3(request, BoxesRunTime.unboxToInt(throttleTimeMs)));
                        bl = true;
                        break block9;
                    }
                    if (None$.MODULE$.equals(option)) {
                        bl = false;
                        break block9;
                    }
                    throw new MatchError(option);
                }
                Option<SwitchoverPair> option = this.switchoverPairWithLocalSecondary(request.context().principal);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SwitchoverPair switchoverPair = (SwitchoverPair)some.value();
                    this.debug((Function0<String> & Serializable)() -> "Closing connection to route client to the remote cluster " + switchoverPair.primaryClusterId() + " for client principal=" + request$1.context().principal + " clientId=" + request.context().clientId() + " since local cluster " + switchoverPair.secondaryClusterId() + " is no longer the primary.");
                    requestHelper.closeConnectionForSwitchover(request);
                    bl = true;
                    break block9;
                }
                if (None$.MODULE$.equals(option)) {
                    bl = false;
                    break block9;
                }
                throw new MatchError(option);
            }
            catch (Throwable e) {
                this.error((Function0<String> & Serializable)() -> "Unexpected exception when processing request " + request.context().apiKey() + " from " + request$1.context().principal, (Function0<Throwable> & Serializable)() -> e);
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void updateSwitchoverPairForClusterLink(ClusterLinkInfo link) {
        this.debug((Function0<String> & Serializable)() -> "Update switchover pair for cluster link " + link.clusterLinkData().linkName() + " localCluster " + link.localLogicalClusterId() + " remoteCluster " + link.clusterLinkData().clusterId());
        ClusterLinkData linkData = link.clusterLinkData();
        String localClusterId = link.localLogicalClusterId();
        String remoteClusterId = (String)link.clusterLinkData().clusterId().getOrElse((Function0<String> & Serializable)() -> "");
        Option<SwitchoverPair> switchoverPair = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(this.switchoverPairs().get(localClusterId)).filter((Function1<SwitchoverPair, Object> & Serializable)state -> BoxesRunTime.boxToBoolean(ClusterLinkSwitchoverManager.$anonfun$updateSwitchoverPairForClusterLink$3(localClusterId, remoteClusterId, state)))).find((Function1<SwitchoverPair, Object> & Serializable)state -> BoxesRunTime.boxToBoolean(ClusterLinkSwitchoverManager.$anonfun$updateSwitchoverPairForClusterLink$4(linkData, state)));
        if (!link.updateSwitchoverPair(switchoverPair)) {
            return;
        }
        if (switchoverPair.isEmpty()) {
            if (Option$.MODULE$.apply(this.switchoverLinks().get(localClusterId)).map((Function1<ClusterLinkInfo, ClusterLinkData> & Serializable)x$1 -> x$1.clusterLinkData()).contains(linkData)) {
                this.info((Function0<String> & Serializable)() -> "Switchover pair for cluster link '" + link.clusterLinkData().linkName() + "' has been removed");
                v0 = this.switchoverLinks().remove(localClusterId);
            } else {
                v0 = BoxedUnit.UNIT;
            }
            return;
        }
        switchoverPair.foreach((Function1<SwitchoverPair, Object> & Serializable)linkSwitchoverPair -> {
            this.info((Function0<String> & Serializable)() -> "Switchover pair for cluster link '" + link.clusterLinkData().linkName() + "' is " + linkSwitchoverPair);
            ClusterLinkInfo oldLink = this.switchoverLinks().put(localClusterId, link);
            if (oldLink != null) {
                String string = oldLink.clusterLinkData().linkName();
                String string2 = link.clusterLinkData().linkName();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.error((Function0<String> & Serializable)() -> "Switchover link for local cluster '" + localClusterId + "' has been changed from '" + oldLink.clusterLinkData().linkName() + "' to '" + link.clusterLinkData().linkName() + "''");
                    return BoxesRunTime.boxToBoolean(oldLink.updateSwitchoverPair(None$.MODULE$));
                }
            }
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void removeSwitchoverPairForClusterLink(ClusterLinkInfo link) {
        link.updateSwitchoverPair(None$.MODULE$);
        String localCluster = link.localLogicalClusterId();
        boolean isSwitchoverLink = Option$.MODULE$.apply(this.switchoverLinks().get(localCluster)).map((Function1<ClusterLinkInfo, String> & Serializable)x$2 -> x$2.clusterLinkData().linkName()).contains(link.clusterLinkData().linkName());
        if (isSwitchoverLink) {
            this.switchoverLinks().remove(localCluster);
            return;
        }
    }

    @Override
    public boolean updateSwitchoverOverrides(KafkaConfig config) {
        Set<SwitchoverPair> overriddenPairs;
        Set<KafkaPrincipal> switchoverDisabledClients;
        SwitchoverPairConfigParser switchoverParser = new SwitchoverPairConfigParser(config, false);
        Set<KafkaPrincipal> set = switchoverDisabledClients = switchoverParser.disabledPrincipals(false);
        Set<KafkaPrincipal> set2 = this.switchoverDisabledPrincipals();
        if (set == null ? set2 != null : !set.equals(set2)) {
            this.info((Function0<String> & Serializable)() -> "Disabling switchover for clients with principals " + switchoverDisabledClients);
            this.switchoverDisabledPrincipals_$eq(switchoverDisabledClients);
        }
        Set<SwitchoverPair> set3 = overriddenPairs = switchoverParser.switchoverPairs();
        Set<SwitchoverPair> set4 = this.overriddenSwitchoverPairs();
        if (!(set3 != null ? !set3.equals(set4) : set4 != null)) {
            this.debug((Function0<String> & Serializable)() -> "No switchover override changes to process");
            return false;
        }
        this.overriddenSwitchoverPairs_$eq(overriddenPairs);
        this.info((Function0<String> & Serializable)() -> "Processing new switchover pair overrides: " + this.overriddenSwitchoverPairs());
        this.overriddenSwitchoverPairs().foreach((Function1<SwitchoverPair, SwitchoverPair> & Serializable)pair -> {
            this.controlPlaneSwitchoverPairs().find((Function1<SwitchoverPair, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.containsCluster(pair.primaryClusterId()))).foreach((Function1<Object, SwitchoverPair> & Serializable)x$1 -> this.switchoverPairs().remove(x$1));
            this.controlPlaneSwitchoverPairs().find((Function1<SwitchoverPair, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.containsCluster(pair.secondaryClusterId()))).foreach((Function1<Object, SwitchoverPair> & Serializable)x$1 -> this.switchoverPairs().remove(x$1));
            this.switchoverPairs().put(pair.primaryClusterId(), (SwitchoverPair)pair);
            return this.switchoverPairs().put(pair.secondaryClusterId(), (SwitchoverPair)pair);
        });
        ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(this.switchoverPairs().keySet()).asScala().filterNot((Function1<String, Object> & Serializable)clusterId -> BoxesRunTime.boxToBoolean(ClusterLinkSwitchoverManager.$anonfun$updateSwitchoverOverrides$9(this, clusterId)))).foreach((Function1<String, SwitchoverPair> & Serializable)clusterId -> {
            Option option = this.controlPlaneSwitchoverPairs().find((Function1<SwitchoverPair, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.containsCluster(clusterId)));
            if (option instanceof Some) {
                Some some = (Some)option;
                SwitchoverPair pair = (SwitchoverPair)some.value();
                this.switchoverPairs().put(pair.primaryClusterId(), pair);
                return this.switchoverPairs().put(pair.secondaryClusterId(), pair);
            }
            if (None$.MODULE$.equals(option)) {
                return this.switchoverPairs().remove(clusterId);
            }
            throw new MatchError(option);
        });
        return true;
    }

    private boolean clientSwitchoverDisabled(AuthenticationContext authenticationContext, KafkaPrincipal principal) {
        if (authenticationContext.disableSwitchover()) {
            return true;
        }
        return this.switchoverDisabledPrincipals().contains(AclEntry.WILDCARD_PRINCIPAL) || this.switchoverDisabledPrincipals().contains(principal);
    }

    private Option<SwitchoverPair> switchoverPairWithLocalSecondary(KafkaPrincipal principal) {
        SwitchoverState remoteServerState;
        SwitchoverState localServerState;
        ClusterLinkInfo linkInfo;
        block8: {
            block7: {
                Option<ClusterLinkInfo> link = this.switchoverLink(principal);
                if (link.isEmpty()) {
                    this.debug((Function0<String> & Serializable)() -> "Not processing switchover state for client principal=" + principal.getName() + " because switchover link is not configured.");
                    return None$.MODULE$;
                }
                linkInfo = link.get();
                Tuple2<SwitchoverState, SwitchoverState> tuple2 = this.localAndRemoteSwitchoverState(linkInfo);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                SwitchoverState localServerState2 = tuple2._1();
                SwitchoverState remoteServerState2 = tuple2._2();
                Tuple2<SwitchoverState, SwitchoverState> tuple22 = new Tuple2<SwitchoverState, SwitchoverState>(localServerState2, remoteServerState2);
                localServerState = tuple22._1();
                remoteServerState = tuple22._2();
                SwitchoverState switchoverState = localServerState;
                SwitchoverState$Ignore$ switchoverState$Ignore$ = SwitchoverState$Ignore$.MODULE$;
                if (!(switchoverState == null ? switchoverState$Ignore$ != null : !switchoverState.equals(switchoverState$Ignore$))) break block7;
                SwitchoverState switchoverState2 = remoteServerState;
                SwitchoverState$Ignore$ switchoverState$Ignore$2 = SwitchoverState$Ignore$.MODULE$;
                if (switchoverState2 != null ? !switchoverState2.equals(switchoverState$Ignore$2) : switchoverState$Ignore$2 != null) break block8;
            }
            this.trace((Function0<String> & Serializable)() -> "Not processing switchover state for client principal=" + principal.getName() + " because switchover states not available.");
            return None$.MODULE$;
        }
        SwitchoverState switchoverState = localServerState;
        SwitchoverState$Primary$ switchoverState$Primary$ = SwitchoverState$Primary$.MODULE$;
        if (!(switchoverState != null ? !switchoverState.equals(switchoverState$Primary$) : switchoverState$Primary$ != null)) {
            this.trace((Function0<String> & Serializable)() -> "Local cluster is the primary cluster, requests will be processed by the local cluster for client principal=" + principal.getName() + ".");
            return None$.MODULE$;
        }
        SwitchoverState switchoverState3 = remoteServerState;
        SwitchoverState$Primary$ switchoverState$Primary$2 = SwitchoverState$Primary$.MODULE$;
        if (switchoverState3 == null ? switchoverState$Primary$2 != null : !switchoverState3.equals(switchoverState$Primary$2)) {
            this.debug((Function0<String> & Serializable)() -> "No primary cluster configured for switchover pair " + linkInfo.switchoverPair() + ", requests will be processed by the local cluster for client principal=" + principal.getName() + ".");
            return None$.MODULE$;
        }
        return new Some<SwitchoverPair>(linkInfo.switchoverPair());
    }

    private Option<ClusterLinkInfo> switchoverLink(KafkaPrincipal principal) {
        String string;
        KafkaPrincipal kafkaPrincipal = principal;
        if (kafkaPrincipal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)kafkaPrincipal;
            string = multiTenantPrincipal.tenantMetadata().clusterId;
        } else {
            string = this.localClusterId;
        }
        String localClusterId = string;
        return Option$.MODULE$.apply(this.switchoverLinks().get(localClusterId));
    }

    private Tuple2<SwitchoverState, SwitchoverState> localAndRemoteSwitchoverState(ClusterLinkInfo link) {
        SwitchoverPair switchoverPair = link.switchoverPair();
        SwitchoverState switchoverState = link.localSwitchoverState();
        SwitchoverState$Primary$ switchoverState$Primary$ = SwitchoverState$Primary$.MODULE$;
        if (!(switchoverState != null ? !switchoverState.equals(switchoverState$Primary$) : switchoverState$Primary$ != null)) {
            return new Tuple2<SwitchoverState, SwitchoverState>(switchoverPair.primaryClusterState(), switchoverPair.secondaryClusterState());
        }
        return new Tuple2<SwitchoverState, SwitchoverState>(switchoverPair.secondaryClusterState(), switchoverPair.primaryClusterState());
    }

    public static final /* synthetic */ AbstractResponse $anonfun$maybeInterceptRequest$3(RequestChannel.Request request$1, int throttleTimeMs) {
        AbstractResponse response = ((MetadataRequest)request$1.body(ClassTag$.MODULE$.apply(MetadataRequest.class))).getErrorResponse(0, Errors.REBOOTSTRAP_REQUIRED.exception());
        response.maybeSetThrottleTimeMs(throttleTimeMs);
        return response;
    }

    public static final /* synthetic */ boolean $anonfun$updateSwitchoverPairForClusterLink$3(String localClusterId$1, String remoteClusterId$1, SwitchoverPair state) {
        return BoxesRunTime.equals(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{state.primaryClusterId(), state.secondaryClusterId()})), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{localClusterId$1, remoteClusterId$1})));
    }

    public static final /* synthetic */ boolean $anonfun$updateSwitchoverPairForClusterLink$4(ClusterLinkData linkData$1, SwitchoverPair state) {
        String string = linkData$1.tenantPrefix().getOrElse((Function0<String> & Serializable)() -> "") + state.unprefixedLinkName();
        String string2 = linkData$1.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateSwitchoverOverrides$9(ClusterLinkSwitchoverManager $this, String clusterId) {
        return $this.overriddenSwitchoverPairs().exists((Function1<SwitchoverPair, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.containsCluster(clusterId)));
    }

    public ClusterLinkSwitchoverManager(KafkaConfig brokerConfig, String localClusterId) {
        this.brokerConfig = brokerConfig;
        this.localClusterId = localClusterId;
        Logging.$init$(this);
        this.switchoverLinks = new ConcurrentHashMap();
        this.switchoverPairs = new ConcurrentHashMap();
        this.controlPlaneSwitchoverPairs = Predef$.MODULE$.Set().empty();
        this.overriddenSwitchoverPairs = Predef$.MODULE$.Set().empty();
        this.switchoverDisabledPrincipals = Predef$.MODULE$.Set().empty();
        this.logIdent_$eq("[" + this.getClass().getSimpleName() + "-broker-" + brokerConfig.brokerId() + "] ");
        this.initialize();
    }

    private static class SwitchoverPairConfigParser
    implements Logging {
        private final KafkaConfig config;
        private final boolean failOnError;
        private final String linkNameKey;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            SwitchoverPairConfigParser switchoverPairConfigParser = this;
            synchronized (switchoverPairConfigParser) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        private String linkNameKey() {
            return this.linkNameKey;
        }

        public Set<SwitchoverPair> switchoverPairs() {
            Buffer pairs = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.config.clusterLinkSwitchoverStates()).asScala().flatMap((Function1<String, Option> & Serializable)pairStr -> this.switchoverPair((String)pairStr));
            Map pairsByCluster = (Map)Map$.MODULE$.empty();
            pairs.foreach((Function1<SwitchoverPair, Object> & Serializable)pair -> {
                if (pairsByCluster.contains(pair.primaryClusterId())) {
                    this.failOrWarn("Ignoring switchover pair " + pair + " because another pair " + pairsByCluster.apply(pair.primaryClusterId()) + " already exists with the cluster id " + pair.primaryClusterId());
                    return BoxedUnit.UNIT;
                }
                if (pairsByCluster.contains(pair.secondaryClusterId())) {
                    this.failOrWarn("Ignoring switchover pair " + pair + " because another pair " + pairsByCluster.apply(pair.secondaryClusterId()) + " already exists with the cluster id " + pair.secondaryClusterId());
                    return BoxedUnit.UNIT;
                }
                pairsByCluster.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(pair.primaryClusterId()), pair));
                return pairsByCluster.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(pair.secondaryClusterId()), pair));
            });
            return pairsByCluster.values().toSet();
        }

        public Set<KafkaPrincipal> disabledPrincipals(boolean failOnError) {
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.config.clusterLinkSwitchoverDisabledClients()).asScala().flatMap((Function1<String, Option> & Serializable)user -> {
                Option option;
                try {
                    option = new Some<KafkaPrincipal>(SecurityUtils.parseKafkaPrincipal(user));
                }
                catch (IllegalArgumentException e) {
                    this.failOrWarn(e.getMessage());
                    option = None$.MODULE$;
                }
                return option;
            })).toSet();
        }

        private Option<SwitchoverPair> switchoverPair(String str) {
            if (str.trim().isEmpty()) {
                return None$.MODULE$;
            }
            scala.collection.immutable.Map switchoverMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(str.split(":")), (Function1<String, String[]> & Serializable)x$8 -> x$8.split("=", 2), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1<String[], Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(SwitchoverPairConfigParser.$anonfun$switchoverPair$2(x$9)))), (Function1<String[], Tuple2> & Serializable)a -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a[0].trim().toLowerCase(Locale.ROOT)), a[1].trim()), ClassTag$.MODULE$.apply(Tuple2.class))), 3)).toMap($less$colon$less$.MODULE$.refl());
            if (switchoverMap.size() < 3) {
                this.failOrWarn("Invalid switchover pair '" + str + "', at least three entries expected");
                return None$.MODULE$;
            }
            if (!switchoverMap.contains(SwitchoverState$Primary$.MODULE$.name()) || ((String)switchoverMap.apply(SwitchoverState$Primary$.MODULE$.name())).isEmpty()) {
                this.failOrWarn("Invalid switchover pair '" + str + "', primary cluster not provided");
                return None$.MODULE$;
            }
            if (!switchoverMap.contains(this.linkNameKey()) || ((String)switchoverMap.apply(this.linkNameKey())).isEmpty()) {
                this.failOrWarn("Invalid switchover pair '" + str + "', cluster link not provided");
                return None$.MODULE$;
            }
            String linkName = (String)switchoverMap.apply(this.linkNameKey());
            String primaryClusterId = (String)switchoverMap.apply(SwitchoverState$Primary$.MODULE$.name());
            scala.collection.immutable.Map secondary = (scala.collection.immutable.Map)switchoverMap.filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(SwitchoverPairConfigParser.$anonfun$switchoverPair$4(this, x0$1)));
            SwitchoverState secondaryState = SwitchoverState$.MODULE$.fromString((String)((Tuple2)secondary.head())._1());
            String secondaryClusterId = (String)((Tuple2)secondary.head())._2();
            if (secondaryClusterId.isEmpty()) {
                this.failOrWarn("Invalid switchover pair '" + str + "', secondary cluster id not provided");
                return None$.MODULE$;
            }
            SwitchoverState switchoverState = secondaryState;
            SwitchoverState$Ignore$ switchoverState$Ignore$ = SwitchoverState$Ignore$.MODULE$;
            if (!(switchoverState != null ? !switchoverState.equals(switchoverState$Ignore$) : switchoverState$Ignore$ != null)) {
                this.failOrWarn("Invalid switchover pair '" + str + "', secondary state is not supported");
                return None$.MODULE$;
            }
            String string = primaryClusterId;
            String string2 = secondaryClusterId;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.failOrWarn("Ignoring switchover pair " + str + " because primary and secondary clusters are the same");
                return None$.MODULE$;
            }
            return new Some<SwitchoverPair>(new SwitchoverPair(primaryClusterId, SwitchoverState$Primary$.MODULE$, secondaryClusterId, secondaryState, linkName));
        }

        private void failOrWarn(String errorMessage) {
            if (this.failOnError) {
                throw new InvalidConfigurationException(errorMessage);
            }
            this.warn((Function0<String> & Serializable)() -> errorMessage);
        }

        public static final /* synthetic */ boolean $anonfun$switchoverPair$2(String[] x$9) {
            return x$9.length == 2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final /* synthetic */ boolean $anonfun$switchoverPair$4(SwitchoverPairConfigParser $this, Tuple2 x0$1) {
            String key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError(tuple2);
            String string = key = (String)tuple2._1();
            String string2 = SwitchoverState$Primary$.MODULE$.name();
            if (string == null) {
                if (string2 == null) return false;
            } else if (string.equals(string2)) return false;
            String string3 = key;
            String string4 = $this.linkNameKey();
            if (string3 == null) {
                if (string4 == null) return false;
                return true;
            } else if (string3.equals(string4)) return false;
            return true;
        }

        public SwitchoverPairConfigParser(KafkaConfig config, boolean failOnError) {
            this.config = config;
            this.failOnError = failOnError;
            Logging.$init$(this);
            this.linkNameKey = "link";
        }
    }
}

