/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;

public class KRaftSnapshotMetrics
implements AutoCloseable {
    public static final String METRIC_GROUP_NAME = "raft-backup-metrics";
    public static final String METRIC_UPLOAD_LAG_NAME = "metadata-upload-lag-ms";
    public static final String METRIC_ERROR_NAME = "metadata-error";
    public static final String METRIC_PUT_LATENCY_PREFIX = "put-latency-ms";
    public static final String METRIC_DELETE_LATENCY_PREFIX = "delete-latency-ms";
    public static final String METRIC_50_PERCENTILE_SUFFIX = "-50-percentile";
    public static final String METRIC_90_PERCENTILE_SUFFIX = "-90-percentile";
    public static final String METRIC_99_PERCENTILE_SUFFIX = "-99-percentile";
    public static final String METRIC_SNAPSHOT_FILE_ON_DISK_CORRUPTION = "snapshot-file-on-disk-corruption";
    public static final String METRIC_SNAPSHOT_FILE_ON_NETWORK_CORRUPTION = "snapshot-file-on-network-corruption";
    public static final String METRIC_SNAPSHOT_UPLOADED = "snapshot-uploaded";
    private final Metrics metrics;
    private volatile long lastUploadMs = -1L;
    private MetricName uploadLag;
    private volatile boolean hasError;
    private MetricName error;
    private Sensor putLatency;
    private Sensor deleteLatency;
    private Sensor snapshotFileOnDiskCorruption;
    private Sensor snapshotFileOnNetworkCorruption;
    private Sensor kraftSnapshotUploaded;

    public KRaftSnapshotMetrics(Metrics metrics) {
        this.metrics = metrics;
        this.addUploadLagMetric();
        this.addErrorMetric();
        this.putLatency = this.addLatencyPercentileSensors(METRIC_PUT_LATENCY_PREFIX, CallType.PUT);
        this.deleteLatency = this.addLatencyPercentileSensors(METRIC_DELETE_LATENCY_PREFIX, CallType.DELETE);
        this.addOnDiskCorruptionSensor();
        this.addOnNetworkCorruptionSensor();
        this.addSnapshotUploadedSensor();
    }

    private void addUploadLagMetric() {
        this.uploadLag = this.metrics.metricName(METRIC_UPLOAD_LAG_NAME, METRIC_GROUP_NAME, "The amount of time in milliseconds, since last upload");
        this.metrics.addMetric(this.uploadLag, (mConfig, currentTimeMs) -> this.lastUploadMs == -1L ? -1.0 : (double)(currentTimeMs - this.lastUploadMs));
    }

    private void addErrorMetric() {
        this.error = this.metrics.metricName(METRIC_ERROR_NAME, METRIC_GROUP_NAME, "The health of KRaft snapshot manager");
        this.metrics.addMetric(this.error, (mConfig, currentTimeMs) -> this.hasError ? 1.0 : 0.0);
    }

    private Sensor addLatencyPercentileSensors(String metricPrefix, CallType callType) {
        double maxLatencyMs = 30000.0;
        int totalBucketSizeInBytes = (int)maxLatencyMs * 4;
        Sensor sensor = this.metrics.sensor(METRIC_PUT_LATENCY_PREFIX);
        MetricName latency50PercentileName = this.metrics.metricName(metricPrefix + METRIC_50_PERCENTILE_SUFFIX, METRIC_GROUP_NAME, String.format("The 50-Percentile latency for %s calls in ms", callType.name()), Collections.emptyMap());
        MetricName latency90PercentileName = this.metrics.metricName(metricPrefix + METRIC_90_PERCENTILE_SUFFIX, METRIC_GROUP_NAME, String.format("The 90-Percentile latency for %s calls in ms", callType.name()), Collections.emptyMap());
        MetricName latency99PercentileName = this.metrics.metricName(metricPrefix + METRIC_99_PERCENTILE_SUFFIX, METRIC_GROUP_NAME, String.format("The 99-Percentile latency for %s calls in ms", callType.name()), Collections.emptyMap());
        Percentile latency50Percentile = new Percentile(latency50PercentileName, 50.0);
        Percentile latency90Percentile = new Percentile(latency90PercentileName, 90.0);
        Percentile latency99Percentile = new Percentile(latency99PercentileName, 99.0);
        Percentiles latencyPercentiles = new Percentiles(totalBucketSizeInBytes, maxLatencyMs, Percentiles.BucketSizing.CONSTANT, latency50Percentile, latency90Percentile, latency99Percentile);
        sensor.add(latencyPercentiles);
        return sensor;
    }

    private void addOnDiskCorruptionSensor() {
        this.snapshotFileOnDiskCorruption = this.metrics.sensor(METRIC_SNAPSHOT_FILE_ON_DISK_CORRUPTION);
        MetricName snapshotFileOnDiskCorruptionMetricName = this.metrics.metricName(METRIC_SNAPSHOT_FILE_ON_DISK_CORRUPTION, METRIC_GROUP_NAME, "The total number of on-disk corruptions for KRaft Snapshot file");
        this.snapshotFileOnDiskCorruption.add(snapshotFileOnDiskCorruptionMetricName, new CumulativeCount());
    }

    private void addOnNetworkCorruptionSensor() {
        this.snapshotFileOnNetworkCorruption = this.metrics.sensor(METRIC_SNAPSHOT_FILE_ON_NETWORK_CORRUPTION);
        MetricName snapshotFileNetworkCorruptionMetricName = this.metrics.metricName(METRIC_SNAPSHOT_FILE_ON_NETWORK_CORRUPTION, METRIC_GROUP_NAME, "The total number of network corruptions for KRaft Snapshot file");
        this.snapshotFileOnNetworkCorruption.add(snapshotFileNetworkCorruptionMetricName, new CumulativeCount());
    }

    private void addSnapshotUploadedSensor() {
        this.kraftSnapshotUploaded = this.metrics.sensor(METRIC_SNAPSHOT_UPLOADED);
        MetricName kraftSnapshotUploadCountTotalMetricName = this.metrics.metricName(METRIC_SNAPSHOT_UPLOADED, METRIC_GROUP_NAME, "The total number of successful Kraft snapshot uploads");
        this.kraftSnapshotUploaded.add(kraftSnapshotUploadCountTotalMetricName, new CumulativeCount());
    }

    public void updateLastUploadMs(long timeMs) {
        this.lastUploadMs = timeMs;
    }

    public Sensor putLatencySensor() {
        return this.putLatency;
    }

    public Sensor deleteLatencySensor() {
        return this.deleteLatency;
    }

    public void updateError(boolean errorValue) {
        this.hasError = errorValue;
    }

    public void incrementOnDiskCorruption() {
        this.snapshotFileOnDiskCorruption.record();
    }

    public void incrementOnNetworkCorruption() {
        this.snapshotFileOnNetworkCorruption.record();
    }

    public void incrementKraftSnapshotSuccessfulUploadCount() {
        this.kraftSnapshotUploaded.record();
    }

    @Override
    public void close() throws Exception {
        Arrays.asList(this.uploadLag, this.error).forEach(this.metrics::removeMetric);
        Arrays.asList(this.putLatency.name(), this.deleteLatency.name()).forEach(this.metrics::removeSensor);
        Arrays.asList(this.snapshotFileOnDiskCorruption.name(), this.snapshotFileOnNetworkCorruption.name(), this.kraftSnapshotUploaded.name()).forEach(this.metrics::removeSensor);
    }

    private static enum CallType {
        PUT,
        DELETE;

    }
}

