/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;

public class TierPartitionStateFactory {
    private final boolean tierFeatureEnabled;
    private final boolean tierChecksumFeatureEnabled;
    private final boolean tierCleanerFeatureEnabled;
    private final List<Pattern> tierCleanerExcludedTopicPatterns = new ArrayList<Pattern>();
    private final TierPartitionStateCleanupConfig tierCleanupConfig;
    private final boolean tierPartitionStateSnapshotFeatureFlag;
    private final int brokerId;

    public TierPartitionStateFactory(boolean tierFeatureEnabled, boolean tierChecksumFeatureEnabled, boolean tierCleanerFeatureEnabled, TierPartitionStateCleanupConfig tierCleanupConfig, boolean tierPartitionStateSnapshotFeatureFlag, int brokerId) {
        this(tierFeatureEnabled, tierChecksumFeatureEnabled, tierCleanerFeatureEnabled, Collections.emptyList(), tierCleanupConfig, tierPartitionStateSnapshotFeatureFlag, brokerId);
    }

    public TierPartitionStateFactory(boolean tierFeatureEnabled, boolean tierChecksumFeatureEnabled, boolean tierCleanerFeatureEnabled, List<String> tierCleanerExcludedTopics, TierPartitionStateCleanupConfig tierCleanupConfig, boolean tierPartitionStateSnapshotFeatureFlag, int brokerId) {
        this.tierFeatureEnabled = tierFeatureEnabled;
        this.tierChecksumFeatureEnabled = tierChecksumFeatureEnabled;
        this.tierCleanerFeatureEnabled = tierCleanerFeatureEnabled;
        for (String excludedTopicRegex : tierCleanerExcludedTopics) {
            this.tierCleanerExcludedTopicPatterns.add(Pattern.compile(excludedTopicRegex));
        }
        this.tierCleanupConfig = tierCleanupConfig;
        this.tierPartitionStateSnapshotFeatureFlag = tierPartitionStateSnapshotFeatureFlag;
        this.brokerId = brokerId;
    }

    public TierPartitionState initState(File stateDir, TopicPartition topicPartition, LogConfig config, LogDirFailureChannel logDirFailureChannel, Scheduler scheduler, Time time) throws IOException {
        boolean enableTiering = this.mayEnableTiering(topicPartition, config);
        return new FileTierPartitionState(stateDir, logDirFailureChannel, topicPartition, enableTiering, scheduler, this.tierChecksumFeatureEnabled, this.tierCleanerFeatureEnabled, time, this.tierCleanupConfig, this.tierPartitionStateSnapshotFeatureFlag, this.brokerId);
    }

    public TierPartitionState initState(File stateDir, TopicPartition topicPartition, LogConfig config, LogDirFailureChannel logDirFailureChannel, Scheduler scheduler, Boolean tierChecksumState, Time time) throws IOException {
        boolean enableTiering = this.mayEnableTiering(topicPartition, config);
        return new FileTierPartitionState(stateDir, logDirFailureChannel, topicPartition, enableTiering, scheduler, tierChecksumState, this.tierCleanerFeatureEnabled, time, this.tierCleanupConfig, this.tierPartitionStateSnapshotFeatureFlag, this.brokerId);
    }

    private boolean isExcludedFromTierCleaning(String topicName) {
        for (Pattern excludedTopicPattern : this.tierCleanerExcludedTopicPatterns) {
            if (!excludedTopicPattern.matcher(topicName).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean mayEnableTierCleaning(TopicPartition topicPartition, LogConfig config) {
        return this.tierCleanerFeatureEnabled && config.confluentLogConfig().tierCleanerEnable && !this.isExcludedFromTierCleaning(topicPartition.topic());
    }

    public boolean mayEnableTiering(TopicPartition topicPartition, LogConfig config) {
        boolean mayEnable;
        boolean bl = mayEnable = this.tierFeatureEnabled && config.confluentLogConfig().tierEnable() && !Topic.isInternal(topicPartition.topic()) && (!config.compact() || this.mayEnableTierCleaning(topicPartition, config));
        if (mayEnable && config.compact() && !this.tierCleanerFeatureEnabled) {
            throw new IllegalStateException("Tier cleaning is being incorrectly enabled.");
        }
        return mayEnable;
    }
}

